"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.lastValueFrom = exports.firstValueFrom = void 0;
const operators_1 = require("rxjs/operators");
function firstValueFrom(source) {
    // we can't use SafeSubscriber the same way that RxJS 7 does, so instead we
    return source.pipe(operators_1.first()).toPromise();
}
exports.firstValueFrom = firstValueFrom;
function lastValueFrom(source) {
    return source.pipe(operators_1.last()).toPromise();
}
exports.lastValueFrom = lastValueFrom;
