/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PathStatementRequest;
import software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequest;
import software.amazon.awssdk.services.ec2.model.ThroughResourcesStatementRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessScopePathRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessScopePathRequest> {
    private static final SdkField<PathStatementRequest> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(AccessScopePathRequest.getter(AccessScopePathRequest::source)).setter(AccessScopePathRequest.setter(Builder::source)).constructor(PathStatementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").unmarshallLocationName("Source").build()}).build();
    private static final SdkField<PathStatementRequest> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(AccessScopePathRequest.getter(AccessScopePathRequest::destination)).setter(AccessScopePathRequest.setter(Builder::destination)).constructor(PathStatementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").unmarshallLocationName("Destination").build()}).build();
    private static final SdkField<List<ThroughResourcesStatementRequest>> THROUGH_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThroughResources").getter(AccessScopePathRequest.getter(AccessScopePathRequest::throughResources)).setter(AccessScopePathRequest.setter(Builder::throughResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughResource").unmarshallLocationName("ThroughResource").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThroughResourcesStatementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, DESTINATION_FIELD, THROUGH_RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final PathStatementRequest source;
    private final PathStatementRequest destination;
    private final List<ThroughResourcesStatementRequest> throughResources;

    private AccessScopePathRequest(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.throughResources = builder.throughResources;
    }

    public final PathStatementRequest source() {
        return this.source;
    }

    public final PathStatementRequest destination() {
        return this.destination;
    }

    public final boolean hasThroughResources() {
        return this.throughResources != null && !(this.throughResources instanceof SdkAutoConstructList);
    }

    public final List<ThroughResourcesStatementRequest> throughResources() {
        return this.throughResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThroughResources() ? this.throughResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopePathRequest)) {
            return false;
        }
        AccessScopePathRequest other = (AccessScopePathRequest)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && this.hasThroughResources() == other.hasThroughResources() && Objects.equals(this.throughResources(), other.throughResources());
    }

    public final String toString() {
        return ToString.builder((String)"AccessScopePathRequest").add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("ThroughResources", this.hasThroughResources() ? this.throughResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ThroughResources": {
                return Optional.ofNullable(clazz.cast(this.throughResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessScopePathRequest, T> g) {
        return obj -> g.apply((AccessScopePathRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PathStatementRequest source;
        private PathStatementRequest destination;
        private List<ThroughResourcesStatementRequest> throughResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScopePathRequest model) {
            this.source(model.source);
            this.destination(model.destination);
            this.throughResources(model.throughResources);
        }

        public final PathStatementRequest.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(PathStatementRequest.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(PathStatementRequest source) {
            this.source = source;
            return this;
        }

        public final PathStatementRequest.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(PathStatementRequest.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(PathStatementRequest destination) {
            this.destination = destination;
            return this;
        }

        public final List<ThroughResourcesStatementRequest.Builder> getThroughResources() {
            List<ThroughResourcesStatementRequest.Builder> result = ThroughResourcesStatementRequestListCopier.copyToBuilder(this.throughResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThroughResources(Collection<ThroughResourcesStatementRequest.BuilderImpl> throughResources) {
            this.throughResources = ThroughResourcesStatementRequestListCopier.copyFromBuilder(throughResources);
        }

        @Override
        public final Builder throughResources(Collection<ThroughResourcesStatementRequest> throughResources) {
            this.throughResources = ThroughResourcesStatementRequestListCopier.copy(throughResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(ThroughResourcesStatementRequest ... throughResources) {
            this.throughResources(Arrays.asList(throughResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throughResources(Consumer<ThroughResourcesStatementRequest.Builder> ... throughResources) {
            this.throughResources(Stream.of(throughResources).map(c -> (ThroughResourcesStatementRequest)((ThroughResourcesStatementRequest.Builder)ThroughResourcesStatementRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccessScopePathRequest build() {
            return new AccessScopePathRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessScopePathRequest> {
        public Builder source(PathStatementRequest var1);

        default public Builder source(Consumer<PathStatementRequest.Builder> source) {
            return this.source((PathStatementRequest)((PathStatementRequest.Builder)PathStatementRequest.builder().applyMutation(source)).build());
        }

        public Builder destination(PathStatementRequest var1);

        default public Builder destination(Consumer<PathStatementRequest.Builder> destination) {
            return this.destination((PathStatementRequest)((PathStatementRequest.Builder)PathStatementRequest.builder().applyMutation(destination)).build());
        }

        public Builder throughResources(Collection<ThroughResourcesStatementRequest> var1);

        public Builder throughResources(ThroughResourcesStatementRequest ... var1);

        public Builder throughResources(Consumer<ThroughResourcesStatementRequest.Builder> ... var1);
    }
}

