/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.AddressAttribute;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;

public class DescribeAddressesAttributeIterable
implements SdkIterable<DescribeAddressesAttributeResponse> {
    private final Ec2Client client;
    private final DescribeAddressesAttributeRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAddressesAttributeIterable(Ec2Client client, DescribeAddressesAttributeRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAddressesAttributeResponseFetcher();
    }

    public Iterator<DescribeAddressesAttributeResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AddressAttribute> addresses() {
        Function<DescribeAddressesAttributeResponse, Iterator> getIterator = response -> {
            if (response != null && response.addresses() != null) {
                return response.addresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAddressesAttributeResponseFetcher
    implements SyncPageFetcher<DescribeAddressesAttributeResponse> {
        private DescribeAddressesAttributeResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressesAttributeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAddressesAttributeResponse nextPage(DescribeAddressesAttributeResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressesAttributeIterable.this.client.describeAddressesAttribute(DescribeAddressesAttributeIterable.this.firstRequest);
            }
            return DescribeAddressesAttributeIterable.this.client.describeAddressesAttribute((DescribeAddressesAttributeRequest)((Object)DescribeAddressesAttributeIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

