/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;

public class DescribeScheduledInstancesIterable
implements SdkIterable<DescribeScheduledInstancesResponse> {
    private final Ec2Client client;
    private final DescribeScheduledInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScheduledInstancesIterable(Ec2Client client, DescribeScheduledInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScheduledInstancesResponseFetcher();
    }

    public Iterator<DescribeScheduledInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledInstance> scheduledInstanceSet() {
        Function<DescribeScheduledInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledInstanceSet() != null) {
                return response.scheduledInstanceSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeScheduledInstancesResponseFetcher
    implements SyncPageFetcher<DescribeScheduledInstancesResponse> {
        private DescribeScheduledInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScheduledInstancesResponse nextPage(DescribeScheduledInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledInstancesIterable.this.client.describeScheduledInstances(DescribeScheduledInstancesIterable.this.firstRequest);
            }
            return DescribeScheduledInstancesIterable.this.client.describeScheduledInstances((DescribeScheduledInstancesRequest)((Object)DescribeScheduledInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

