/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.combination;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.neuralsearch.processor.combination.ArithmeticMeanScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.GeometricMeanScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.HarmonicMeanScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationUtil;

public class ScoreCombinationFactory {
    private static final ScoreCombinationUtil scoreCombinationUtil = new ScoreCombinationUtil();
    public static final ScoreCombinationTechnique DEFAULT_METHOD = new ArithmeticMeanScoreCombinationTechnique(Map.of(), scoreCombinationUtil);
    private final Map<String, Function<Map<String, Object>, ScoreCombinationTechnique>> scoreCombinationMethodsMap = Map.of("arithmetic_mean", params -> new ArithmeticMeanScoreCombinationTechnique((Map<String, Object>)params, scoreCombinationUtil), "harmonic_mean", params -> new HarmonicMeanScoreCombinationTechnique((Map<String, Object>)params, scoreCombinationUtil), "geometric_mean", params -> new GeometricMeanScoreCombinationTechnique((Map<String, Object>)params, scoreCombinationUtil));

    public ScoreCombinationTechnique createCombination(String technique) {
        return this.createCombination(technique, Map.of());
    }

    public ScoreCombinationTechnique createCombination(String technique, Map<String, Object> params) {
        return Optional.ofNullable(this.scoreCombinationMethodsMap.get(technique)).orElseThrow(() -> new IllegalArgumentException("provided combination technique is not supported")).apply(params);
    }
}

