/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opensearch.transport.NodeDisconnectedException;
import org.opensearch.transport.NodeNotConnectedException;

public class RetryUtil {
    private static final int MAX_RETRY = 3;
    private static final List<Class<? extends Throwable>> RETRYABLE_EXCEPTIONS = ImmutableList.of(NodeNotConnectedException.class, NodeDisconnectedException.class);

    public static boolean shouldRetry(Exception e, int retryTime) {
        boolean hasRetryException = RETRYABLE_EXCEPTIONS.stream().anyMatch(x -> ExceptionUtils.indexOfThrowable((Throwable)e, (Class)x) != -1);
        return hasRetryException && retryTime < 3;
    }
}

