/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.store.rca.HighHeapUsageClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.HotNodeClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.FieldDataCacheClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.QueueRejectionClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.ShardRequestCacheClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.HotShardClusterRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.ClusterTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.NodeTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.CpuUtilDimensionTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.HeapAllocRateTemperatureRca;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.dimension.ShardSizeDimensionTemperatureRca;

public class SQLiteQueryUtils {
    private static final Set<String> clusterLevelRCA;
    private static final Set<String> temperatureProfileRCASet;
    public static final Set<String> temperatureProfileDimensionRCASet;
    public static final String ALL_TEMPERATURE_DIMENSIONS = "AllTemperatureDimensions";

    public static List<String> getClusterLevelRca() {
        return ImmutableList.copyOf(clusterLevelRCA);
    }

    public static boolean isClusterLevelRca(String rca) {
        if (rca == null) {
            return false;
        }
        return clusterLevelRCA.contains(rca);
    }

    public static SelectJoinStep<Record> buildRcaQuery(DSLContext ctx, String rca) {
        SelectJoinStep rcaQuery = ctx.select(new SelectFieldOrAsterisk[0]).from("RCA");
        rcaQuery.where(DSL.field((String)ResourceFlowUnit.ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getName(), String.class).equal((Object)rca)).orderBy((OrderField)ResourceFlowUnit.ResourceFlowUnitFieldValue.TIMESTAMP_FIELD.getField().desc());
        return rcaQuery;
    }

    public static SelectJoinStep<Record> buildSummaryQuery(DSLContext ctx, String tableName, int foreignKey, Field<Integer> foreignKeyField) {
        SelectJoinStep summaryQuery = ctx.select(new SelectFieldOrAsterisk[0]).from(tableName);
        summaryQuery.where(foreignKeyField.equal((Object)foreignKey));
        return summaryQuery;
    }

    public static String getPrimaryKeyColumnName(String tableName) {
        return tableName + "_ID";
    }

    public static List<String> getTemperatureProfileRcas() {
        return ImmutableList.copyOf(temperatureProfileRCASet);
    }

    public static boolean isTemperatureProfileRca(String rca) {
        if (rca == null) {
            return false;
        }
        return temperatureProfileRCASet.contains(rca);
    }

    static {
        HashSet<String> rcaSet = new HashSet<String>();
        rcaSet.add(ClusterTemperatureRca.TABLE_NAME);
        rcaSet.add(HighHeapUsageClusterRca.RCA_TABLE_NAME);
        rcaSet.add(HotNodeClusterRca.RCA_TABLE_NAME);
        rcaSet.add(HotShardClusterRca.RCA_TABLE_NAME);
        rcaSet.add(QueueRejectionClusterRca.RCA_TABLE_NAME);
        rcaSet.add(FieldDataCacheClusterRca.RCA_TABLE_NAME);
        rcaSet.add(ShardRequestCacheClusterRca.RCA_TABLE_NAME);
        clusterLevelRCA = Collections.unmodifiableSet(rcaSet);
        HashSet<String> temperatureDimensions = new HashSet<String>();
        temperatureDimensions.add(CpuUtilDimensionTemperatureRca.class.getSimpleName());
        temperatureDimensions.add(HeapAllocRateTemperatureRca.class.getSimpleName());
        temperatureDimensions.add(ShardSizeDimensionTemperatureRca.class.getSimpleName());
        temperatureProfileDimensionRCASet = Collections.unmodifiableSet(temperatureDimensions);
        HashSet<String> tempProfileRcaSet = new HashSet<String>();
        tempProfileRcaSet.addAll(temperatureProfileDimensionRCASet);
        tempProfileRcaSet.add(ALL_TEMPERATURE_DIMENSIONS);
        tempProfileRcaSet.add(NodeTemperatureRca.TABLE_NAME);
        tempProfileRcaSet.add(ClusterTemperatureRca.TABLE_NAME);
        temperatureProfileRCASet = Collections.unmodifiableSet(tempProfileRcaSet);
    }
}

