from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Message import *
from OCC.Core.Poly import *
from OCC.Core.TCollection import *
from OCC.Core.RWMesh import *
from OCC.Core.XCAFPrs import *
from OCC.Core.TDocStd import *
from OCC.Core.TDF import *
from OCC.Core.TColStd import *
from OCC.Core.DE import *
from OCC.Core.TopoDS import *
from OCC.Core.Graphic3d import *
from OCC.Core.XSControl import *
from OCC.Core.gp import *


class RWObj_SubMeshReason(IntEnum):
    RWObj_SubMeshReason_NewObject: int = ...
    RWObj_SubMeshReason_NewGroup: int = ...
    RWObj_SubMeshReason_NewMaterial: int = ...
    RWObj_SubMeshReason_NewSmoothGroup: int = ...

RWObj_SubMeshReason_NewObject = RWObj_SubMeshReason.RWObj_SubMeshReason_NewObject
RWObj_SubMeshReason_NewGroup = RWObj_SubMeshReason.RWObj_SubMeshReason_NewGroup
RWObj_SubMeshReason_NewMaterial = RWObj_SubMeshReason.RWObj_SubMeshReason_NewMaterial
RWObj_SubMeshReason_NewSmoothGroup = RWObj_SubMeshReason.RWObj_SubMeshReason_NewSmoothGroup

class rwobj:
    @staticmethod
    def ReadFile(theFile: str, aProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> Poly_Triangulation: ...

class RWObj_CafWriter(Standard_Transient):
    def __init__(self, theFile: str) -> None: ...
    def ChangeCoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: ...
    def CoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: ...
    def DefaultStyle(self) -> XCAFPrs_Style: ...
    @overload
    def Perform(self, theDocument: TDocStd_Document, theRootLabels: TDF_LabelSequence, theLabelFilter: TColStd_MapOfAsciiString, theFileInfo: TColStd_IndexedDataMapOfStringString, theProgress: Message_ProgressRange) -> bool: ...
    @overload
    def Perform(self, theDocument: TDocStd_Document, theFileInfo: TColStd_IndexedDataMapOfStringString, theProgress: Message_ProgressRange) -> bool: ...
    def SetCoordinateSystemConverter(self, theConverter: RWMesh_CoordinateSystemConverter) -> None: ...
    def SetDefaultStyle(self, theStyle: XCAFPrs_Style) -> None: ...

class RWObj_ConfigurationNode(DE_ConfigurationNode):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theNode: RWObj_ConfigurationNode) -> None: ...
    def BuildProvider(self) -> DE_Provider: ...
    def Copy(self) -> DE_ConfigurationNode: ...
    def GetExtensions(self) -> TColStd_ListOfAsciiString: ...
    def GetFormat(self) -> str: ...
    def GetVendor(self) -> str: ...
    def IsExportSupported(self) -> bool: ...
    def IsImportSupported(self) -> bool: ...
    def Load(self, theResource: DE_ConfigurationContext) -> bool: ...
    def Save(self) -> str: ...

class RWObj_IShapeReceiver:
    def BindNamedShape(self, theShape: TopoDS_Shape, theName: str, theMaterial: RWObj_Material, theIsRootShape: bool) -> None: ...

class RWObj_Material:
    def __init__(self) -> None: ...

class RWObj_ObjMaterialMap(RWMesh_MaterialMap):
    def __init__(self, theFile: str) -> None: ...
    def AddMaterial(self, theStyle: XCAFPrs_Style) -> str: ...
    def DefineMaterial(self, theStyle: XCAFPrs_Style, theKey: str, theName: str) -> None: ...

class RWObj_ObjWriterContext:
    def __init__(self, theName: str) -> None: ...
    def ActiveMaterial(self) -> str: ...
    def Close(self) -> bool: ...
    def FlushFace(self, theNbNodes: int) -> None: ...
    def HasNormals(self) -> bool: ...
    def HasTexCoords(self) -> bool: ...
    def IsOpened(self) -> bool: ...
    def SetNormals(self, theHasNormals: bool) -> None: ...
    def SetTexCoords(self, theHasTexCoords: bool) -> None: ...
    def WriteActiveMaterial(self, theMaterial: str) -> bool: ...
    def WriteGroup(self, theValue: str) -> bool: ...
    def WriteHeader(self, theNbNodes: int, theNbElems: int, theMatLib: str, theFileInfo: TColStd_IndexedDataMapOfStringString) -> bool: ...
    def WriteNormal(self, theValue: Graphic3d_Vec3) -> bool: ...
    def WriteQuad(self, theQuad: Graphic3d_Vec4i) -> bool: ...
    def WriteTexCoord(self, theValue: Graphic3d_Vec2) -> bool: ...
    def WriteTriangle(self, theTri: Graphic3d_Vec3i) -> bool: ...
    def WriteVertex(self, theValue: Graphic3d_Vec3) -> bool: ...

class RWObj_Provider(DE_Provider):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theNode: DE_ConfigurationNode) -> None: ...
    def GetFormat(self) -> str: ...
    def GetVendor(self) -> str: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Read(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theDocument: TDocStd_Document, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theWS: XSControl_WorkSession, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...
    @overload
    def Write(self, thePath: str, theShape: TopoDS_Shape, theProgress: Optional[Message_ProgressRange] = Message_ProgressRange()) -> bool: ...

class RWObj_Reader(Standard_Transient):
    def ExternalFiles(self) -> False: ...
    def FileComments(self) -> str: ...
    def IsSinglePrecision(self) -> bool: ...
    def MemoryLimit(self) -> int: ...
    def NbProbeElems(self) -> int: ...
    def NbProbeNodes(self) -> int: ...
    def Probe(self, theFile: str, theProgress: Message_ProgressRange) -> bool: ...
    def Read(self, theFile: str, theProgress: Message_ProgressRange) -> bool: ...
    def SetMemoryLimit(self, theMemLimit: int) -> None: ...
    def SetSinglePrecision(self, theIsSinglePrecision: bool) -> None: ...
    def SetTransformation(self, theCSConverter: RWMesh_CoordinateSystemConverter) -> None: ...
    def Transformation(self) -> RWMesh_CoordinateSystemConverter: ...

class RWObj_SubMesh:
    pass

class RWObj_CafReader(RWMesh_CafReader, RWObj_IShapeReceiver):
    def __init__(self) -> None: ...
    def IsSinglePrecision(self) -> bool: ...
    def SetSinglePrecision(self, theIsSinglePrecision: bool) -> None: ...

class RWObj_TriangulationReader(RWObj_Reader):
    def __init__(self) -> None: ...
    def GetTriangulation(self) -> Poly_Triangulation: ...
    def ResultShape(self) -> TopoDS_Shape: ...
    def SetCreateShapes(self, theToCreateShapes: bool) -> None: ...
    def SetShapeReceiver(self, theReceiver: RWObj_IShapeReceiver) -> None: ...

#classnotwrapped
class RWObj_MtlReader: ...

# harray1 classes
# harray2 classes
# hsequence classes

