/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class Home3DAttributesController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private TextureChoiceController groundTextureController;
    private TextureChoiceController skyTextureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView home3DAttributesView;
    private int groundColor;
    private EnvironmentPaint groundPaint;
    private boolean backgroundImageVisibleOnGround3D;
    private int skyColor;
    private EnvironmentPaint skyPaint;
    private int lightColor;
    private float wallsAlpha;

    public Home3DAttributesController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getGroundTextureController() {
        if (this.groundTextureController == null) {
            this.groundTextureController = new TextureChoiceController(this.preferences.getLocalizedString(Home3DAttributesController.class, "groundTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.groundTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Home3DAttributesController.this.setGroundPaint(EnvironmentPaint.TEXTURED);
                }
            });
        }
        return this.groundTextureController;
    }

    public TextureChoiceController getSkyTextureController() {
        if (this.skyTextureController == null) {
            this.skyTextureController = new TextureChoiceController(this.preferences.getLocalizedString(Home3DAttributesController.class, "skyTextureTitle", new Object[0]), false, this.preferences, this.viewFactory, this.contentManager);
            this.skyTextureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Home3DAttributesController.this.setSkyPaint(EnvironmentPaint.TEXTURED);
                }
            });
        }
        return this.skyTextureController;
    }

    @Override
    public DialogView getView() {
        if (this.home3DAttributesView == null) {
            this.home3DAttributesView = this.viewFactory.createHome3DAttributesView(this.preferences, this);
        }
        return this.home3DAttributesView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setGroundColor(homeEnvironment.getGroundColor());
        HomeTexture homeTexture = homeEnvironment.getGroundTexture();
        this.getGroundTextureController().setTexture(homeTexture);
        if (homeTexture != null) {
            this.setGroundPaint(EnvironmentPaint.TEXTURED);
        } else {
            this.setGroundPaint(EnvironmentPaint.COLORED);
        }
        this.setBackgroundImageVisibleOnGround3D(homeEnvironment.isBackgroundImageVisibleOnGround3D());
        this.setSkyColor(homeEnvironment.getSkyColor());
        HomeTexture homeTexture2 = homeEnvironment.getSkyTexture();
        this.getSkyTextureController().setTexture(homeTexture2);
        if (homeTexture2 != null) {
            this.setSkyPaint(EnvironmentPaint.TEXTURED);
        } else {
            this.setSkyPaint(EnvironmentPaint.COLORED);
        }
        this.setLightColor(homeEnvironment.getLightColor());
        this.setWallsAlpha(homeEnvironment.getWallsAlpha());
    }

    public void setGroundColor(int n) {
        if (n != this.groundColor) {
            int n2 = this.groundColor;
            this.groundColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.GROUND_COLOR.name(), n2, n);
            this.setGroundPaint(EnvironmentPaint.COLORED);
        }
    }

    public int getGroundColor() {
        return this.groundColor;
    }

    public void setGroundPaint(EnvironmentPaint environmentPaint) {
        if (environmentPaint != this.groundPaint) {
            EnvironmentPaint environmentPaint2 = this.groundPaint;
            this.groundPaint = environmentPaint;
            this.propertyChangeSupport.firePropertyChange(Property.GROUND_PAINT.name(), (Object)environmentPaint2, (Object)environmentPaint);
        }
    }

    public EnvironmentPaint getGroundPaint() {
        return this.groundPaint;
    }

    public boolean isBackgroundImageVisibleOnGround3D() {
        return this.backgroundImageVisibleOnGround3D;
    }

    public void setBackgroundImageVisibleOnGround3D(boolean bl) {
        if (this.backgroundImageVisibleOnGround3D != bl) {
            this.backgroundImageVisibleOnGround3D = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BACKGROUND_IMAGE_VISIBLE_ON_GROUND_3D.name(), !bl, bl);
        }
    }

    public void setSkyColor(int n) {
        if (n != this.skyColor) {
            int n2 = this.skyColor;
            this.skyColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.SKY_COLOR.name(), n2, n);
        }
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public void setSkyPaint(EnvironmentPaint environmentPaint) {
        if (environmentPaint != this.skyPaint) {
            EnvironmentPaint environmentPaint2 = this.skyPaint;
            this.skyPaint = environmentPaint;
            this.propertyChangeSupport.firePropertyChange(Property.SKY_PAINT.name(), (Object)environmentPaint2, (Object)environmentPaint);
        }
    }

    public EnvironmentPaint getSkyPaint() {
        return this.skyPaint;
    }

    public void setLightColor(int n) {
        if (n != this.lightColor) {
            int n2 = this.lightColor;
            this.lightColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.LIGHT_COLOR.name(), n2, n);
        }
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public void setWallsAlpha(float f) {
        if (f != this.wallsAlpha) {
            float f2 = this.wallsAlpha;
            this.wallsAlpha = f;
            this.propertyChangeSupport.firePropertyChange(Property.WALLS_ALPHA.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallsAlpha() {
        return this.wallsAlpha;
    }

    public void modify3DAttributes() {
        int n = this.getGroundColor();
        HomeTexture homeTexture = this.getGroundPaint() == EnvironmentPaint.TEXTURED ? this.getGroundTextureController().getTexture() : null;
        boolean bl = this.isBackgroundImageVisibleOnGround3D();
        int n2 = this.getSkyColor();
        HomeTexture homeTexture2 = this.getSkyPaint() == EnvironmentPaint.TEXTURED ? this.getSkyTextureController().getTexture() : null;
        int n3 = this.getLightColor();
        float f = this.getWallsAlpha();
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        int n4 = homeEnvironment.getGroundColor();
        boolean bl2 = homeEnvironment.isBackgroundImageVisibleOnGround3D();
        HomeTexture homeTexture3 = homeEnvironment.getGroundTexture();
        int n5 = homeEnvironment.getSkyColor();
        HomeTexture homeTexture4 = homeEnvironment.getSkyTexture();
        int n6 = homeEnvironment.getLightColor();
        float f2 = homeEnvironment.getWallsAlpha();
        Home3DAttributesController.doModify3DAttributes(this.home, n, homeTexture, bl, n2, homeTexture2, n3, f);
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(new Home3DAttributesModificationUndoableEdit(this.home, this.preferences, n4, homeTexture3, bl2, n5, homeTexture4, n6, f2, n, homeTexture, bl, n2, homeTexture2, n3, f));
        }
    }

    private static void doModify3DAttributes(Home home, int n, HomeTexture homeTexture, boolean bl, int n2, HomeTexture homeTexture2, int n3, float f) {
        HomeEnvironment homeEnvironment = home.getEnvironment();
        homeEnvironment.setGroundColor(n);
        homeEnvironment.setGroundTexture(homeTexture);
        homeEnvironment.setBackgroundImageVisibleOnGround3D(bl);
        homeEnvironment.setSkyColor(n2);
        homeEnvironment.setSkyTexture(homeTexture2);
        homeEnvironment.setLightColor(n3);
        homeEnvironment.setWallsAlpha(f);
    }

    private static class Home3DAttributesModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final int oldGroundColor;
        private final HomeTexture oldGroundTexture;
        private final boolean oldBackgroundImageVisibleOnGround3D;
        private final int oldSkyColor;
        private final HomeTexture oldSkyTexture;
        private final int oldLightColor;
        private final float oldWallsAlpha;
        private final int groundColor;
        private final HomeTexture groundTexture;
        private final boolean backgroundImageVisibleOnGround3D;
        private final int skyColor;
        private final HomeTexture skyTexture;
        private final int lightColor;
        private final float wallsAlpha;

        private Home3DAttributesModificationUndoableEdit(Home home, UserPreferences userPreferences, int n, HomeTexture homeTexture, boolean bl, int n2, HomeTexture homeTexture2, int n3, float f, int n4, HomeTexture homeTexture3, boolean bl2, int n5, HomeTexture homeTexture4, int n6, float f2) {
            super(userPreferences, Home3DAttributesController.class, "undoModify3DAttributesName");
            this.home = home;
            this.oldGroundColor = n;
            this.oldGroundTexture = homeTexture;
            this.oldBackgroundImageVisibleOnGround3D = bl;
            this.oldSkyColor = n2;
            this.oldSkyTexture = homeTexture2;
            this.oldLightColor = n3;
            this.oldWallsAlpha = f;
            this.groundColor = n4;
            this.groundTexture = homeTexture3;
            this.backgroundImageVisibleOnGround3D = bl2;
            this.skyColor = n5;
            this.skyTexture = homeTexture4;
            this.lightColor = n6;
            this.wallsAlpha = f2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            Home3DAttributesController.doModify3DAttributes(this.home, this.oldGroundColor, this.oldGroundTexture, this.oldBackgroundImageVisibleOnGround3D, this.oldSkyColor, this.oldSkyTexture, this.oldLightColor, this.oldWallsAlpha);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            Home3DAttributesController.doModify3DAttributes(this.home, this.groundColor, this.groundTexture, this.backgroundImageVisibleOnGround3D, this.skyColor, this.skyTexture, this.lightColor, this.wallsAlpha);
        }
    }

    public static enum EnvironmentPaint {
        COLORED,
        TEXTURED;

    }

    public static enum Property {
        GROUND_COLOR,
        GROUND_PAINT,
        BACKGROUND_IMAGE_VISIBLE_ON_GROUND_3D,
        SKY_COLOR,
        SKY_PAINT,
        LIGHT_COLOR,
        WALLS_ALPHA,
        WALLS_TOP_COLOR;

    }
}

