/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.IndexingOption;
import com.dickimawbooks.texparserlib.latex.glossaries.InternalGetGroupTitle;
import com.dickimawbooks.texparserlib.latex.glossaries.PrintUnsrtGlossarySkipEntry;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class PrintUnsrtGlossary
extends ControlSequence {
    private GlossariesSty sty;

    public PrintUnsrtGlossary(GlossariesSty glossariesSty) {
        this("printunsrtglossary", glossariesSty);
    }

    public PrintUnsrtGlossary(String string, GlossariesSty glossariesSty) {
        super(string);
        this.sty = glossariesSty;
    }

    @Override
    public Object clone() {
        return new PrintUnsrtGlossary(this.getName(), this.sty);
    }

    protected void initHooks(TeXParser teXParser) throws IOException {
        teXParser.putControlSequence(true, new InternalGetGroupTitle("@gls@getgrouptitle", this.sty.isKnownField("group")));
        teXParser.putControlSequence(true, new TextualContentCommand("@gls@currentlettergroup", ""));
        teXParser.putControlSequence(true, new GenericCommand(true, "glscurrententrylevel", null, new UserNumber(-1)));
        teXParser.putControlSequence(true, new TextualContentCommand("glscurrentrootentry", ""));
        teXParser.putControlSequence(true, new TextualContentCommand("glscurrenttoplevelentry", ""));
    }

    protected void initProcess(GlsLabel glsLabel, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        TeXBoolean teXBoolean = TeXParserUtils.toBoolean("ifglsxtrprintglossflatten", teXParser);
        int n = TeXParserUtils.toInt(teXParser.getControlSequence("@glsxtr@leveloffset"), teXParser, teXObjectList);
        int n2 = teXBoolean.booleanValue() ? n : glossaryEntry.getLevel() + n;
        teXParser.putControlSequence(true, new GenericCommand(true, "glscurrententrylevel", null, new UserNumber(n2)));
        if (n2 == 0) {
            teXParser.putControlSequence(true, new TextualContentCommand("glscurrenttoplevelentry", glossaryEntry.getLabel()));
        }
        if (teXBoolean.booleanValue() || glossaryEntry.getLevel() == 0) {
            teXParser.putControlSequence(true, new TextualContentCommand("glscurrentrootentry", glossaryEntry.getLabel()));
        }
        teXParser.putControlSequence(true, new AtFirstOfOne("glsxtr@process"));
        teXParser.putControlSequence(true, new PrintUnsrtGlossarySkipEntry());
        ControlSequence controlSequence = teXParser.getListener().getControlSequence("printunsrtglossaryentryprocesshook");
        if (!(controlSequence instanceof AtGobble)) {
            TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
            teXObjectList2.add(controlSequence);
            teXObjectList2.add(glsLabel);
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Cloneable cloneable;
        boolean bl = this.popModifier(teXParser, teXObjectList, 42) == 42;
        teXParser.startGroup();
        KeyValList keyValList = this.sty.popOptKeyValList(teXObjectList);
        if (bl) {
            cloneable = this.popArg(teXParser, teXObjectList);
            if (teXParser == teXObjectList || teXObjectList == null) {
                cloneable.process(teXParser);
            } else {
                cloneable.process(teXParser, teXObjectList);
            }
        }
        cloneable = this.sty.initPrintGloss(IndexingOption.UNSRT, keyValList, teXObjectList);
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(teXParserListener.getControlSequence("glossarysection"));
        teXObjectList2.add(teXParserListener.getOther(91));
        teXObjectList2.add(teXParserListener.getControlSequence("glossarytoctitle"));
        teXObjectList2.add(teXParserListener.getOther(93));
        teXObjectList2.add(teXParserListener.getControlSequence("glossarytitle"));
        teXObjectList2.add(teXParserListener.getControlSequence("glossarypreamble"));
        if (!((Vector)cloneable).isEmpty()) {
            this.initHooks(teXParser);
            TeXObjectList teXObjectList3 = teXParserListener.createStack();
            ControlSequence controlSequence = new GenericCommand(true, "@glsxtr@doglossary", null, teXObjectList3);
            teXParser.putControlSequence(true, controlSequence);
            teXObjectList3.add(new TeXCsRef("begin"));
            teXObjectList3.add(teXParserListener.createGroup("theglossary"));
            teXObjectList3.add(new TeXCsRef("glossaryheader"));
            Iterator iterator = ((Vector)cloneable).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                GlsLabel glsLabel = new GlsLabel("glscurrententrylabel", string, this.sty.getEntry(string));
                teXParser.putControlSequence(true, glsLabel);
                this.initProcess(glsLabel, teXParser, teXObjectList);
                controlSequence = teXParser.getControlSequence("glsxtr@process");
                if (!(controlSequence instanceof AtFirstOfOne)) continue;
                TeXBoolean teXBoolean = TeXParserUtils.toBoolean("ifglsxtr@printgloss@groups", teXParser);
                if (teXBoolean.booleanValue()) {
                    teXParser.putControlSequence(true, new TextualContentCommand("@glsxtr@groupheading", ""));
                    TeXObjectList teXObjectList4 = teXParserListener.createStack();
                    teXObjectList4.add(teXParserListener.getControlSequence("glsxtraddgroup"));
                    teXObjectList4.add(glsLabel);
                    Group group = teXParserListener.createGroup();
                    teXObjectList4.add(group);
                    group.add(teXParserListener.getControlSequence("@glsxtr@checkgroup"));
                    group.add(glsLabel);
                    TeXParserUtils.process(teXObjectList4, teXParser, teXObjectList);
                    controlSequence = teXParserListener.getControlSequence("@glsxtr@groupheading");
                    if (!controlSequence.isEmpty()) {
                        teXObjectList3.add(TeXParserUtils.expandOnce(controlSequence, teXParser, teXObjectList));
                    }
                }
                teXObjectList3.add(teXParserListener.getControlSequence("@printunsrt@glossary@handler"));
                teXObjectList3.add(teXParserListener.createGroup(string));
            }
            teXObjectList3.add(new TeXCsRef("end"));
            teXObjectList3.add(teXParserListener.createGroup("theglossary"));
            teXObjectList2.add(new TeXCsRef("printunsrtglossarypredoglossary"));
            teXObjectList2.add(new TeXCsRef("@glsxtr@doglossary"));
        }
        teXObjectList2.add(new TeXCsRef("glossarypostamble"));
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        teXParser.endGroup();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

