// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from MK64F12.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && mk64f12

// MK64F12 NXP Microcontroller
//
//	Copyright 2016-2018 NXP SPDX-License-Identifier: BSD-3-Clause
package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "MK64F12"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Enhanced direct memory access controller
	IRQ_DMA0 = 0

	// Enhanced direct memory access controller
	IRQ_DMA1 = 1

	// Enhanced direct memory access controller
	IRQ_DMA2 = 2

	// Enhanced direct memory access controller
	IRQ_DMA3 = 3

	// Enhanced direct memory access controller
	IRQ_DMA4 = 4

	// Enhanced direct memory access controller
	IRQ_DMA5 = 5

	// Enhanced direct memory access controller
	IRQ_DMA6 = 6

	// Enhanced direct memory access controller
	IRQ_DMA7 = 7

	// Enhanced direct memory access controller
	IRQ_DMA8 = 8

	// Enhanced direct memory access controller
	IRQ_DMA9 = 9

	// Enhanced direct memory access controller
	IRQ_DMA10 = 10

	// Enhanced direct memory access controller
	IRQ_DMA11 = 11

	// Enhanced direct memory access controller
	IRQ_DMA12 = 12

	// Enhanced direct memory access controller
	IRQ_DMA13 = 13

	// Enhanced direct memory access controller
	IRQ_DMA14 = 14

	// Enhanced direct memory access controller
	IRQ_DMA15 = 15

	// Enhanced direct memory access controller
	IRQ_DMA_Error = 16

	// Core Platform Miscellaneous Control Module
	IRQ_MCM = 17

	// Flash Memory Interface
	IRQ_FTFE = 18

	// Flash Memory Interface
	IRQ_Read_Collision = 19

	// Power Management Controller
	IRQ_LVD_LVW = 20

	// Low leakage wakeup unit
	IRQ_LLWU = 21

	// Generation 2008 Watchdog Timer // External Watchdog Monitor
	IRQ_WDOG_EWM = 22

	// Random Number Generator Accelerator
	IRQ_RNG = 23

	// Inter-Integrated Circuit
	IRQ_I2C0 = 24

	// Inter-Integrated Circuit
	IRQ_I2C1 = 25

	// Serial Peripheral Interface
	IRQ_SPI0 = 26

	// Serial Peripheral Interface
	IRQ_SPI1 = 27

	// Inter-IC Sound / Synchronous Audio Interface
	IRQ_I2S0_Tx = 28

	// Inter-IC Sound / Synchronous Audio Interface
	IRQ_I2S0_Rx = 29

	// Serial Communication Interface
	IRQ_UART0_LON = 30

	// Serial Communication Interface
	IRQ_UART0_RX_TX = 31

	// Serial Communication Interface
	IRQ_UART0_ERR = 32

	// Serial Communication Interface
	IRQ_UART1_RX_TX = 33

	// Serial Communication Interface
	IRQ_UART1_ERR = 34

	// Serial Communication Interface
	IRQ_UART2_RX_TX = 35

	// Serial Communication Interface
	IRQ_UART2_ERR = 36

	// Serial Communication Interface
	IRQ_UART3_RX_TX = 37

	// Serial Communication Interface
	IRQ_UART3_ERR = 38

	// Analog-to-Digital Converter
	IRQ_ADC0 = 39

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP0 = 40

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP1 = 41

	// FlexTimer Module
	IRQ_FTM0 = 42

	// FlexTimer Module
	IRQ_FTM1 = 43

	// FlexTimer Module
	IRQ_FTM2 = 44

	// Carrier Modulator Transmitter
	IRQ_CMT = 45

	// Secure Real Time Clock
	IRQ_RTC = 46

	// Secure Real Time Clock
	IRQ_RTC_Seconds = 47

	// Periodic Interrupt Timer
	IRQ_PIT0 = 48

	// Periodic Interrupt Timer
	IRQ_PIT1 = 49

	// Periodic Interrupt Timer
	IRQ_PIT2 = 50

	// Periodic Interrupt Timer
	IRQ_PIT3 = 51

	// Programmable Delay Block
	IRQ_PDB0 = 52

	// Universal Serial Bus, OTG Capable Controller
	IRQ_USB0 = 53

	// USB Device Charger Detection module
	IRQ_USBDCD = 54

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC0 = 56

	// Low Power Timer
	IRQ_LPTMR0 = 58

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTA = 59

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTB = 60

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTC = 61

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTD = 62

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTE = 63

	// Serial Peripheral Interface
	IRQ_SPI2 = 65

	// Serial Communication Interface
	IRQ_UART4_RX_TX = 66

	// Serial Communication Interface
	IRQ_UART4_ERR = 67

	// Serial Communication Interface
	IRQ_UART5_RX_TX = 68

	// Serial Communication Interface
	IRQ_UART5_ERR = 69

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP2 = 70

	// FlexTimer Module
	IRQ_FTM3 = 71

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC1 = 72

	// Analog-to-Digital Converter
	IRQ_ADC1 = 73

	// Inter-Integrated Circuit
	IRQ_I2C2 = 74

	// Flex Controller Area Network module
	IRQ_CAN0_ORed_Message_buffer = 75

	// Flex Controller Area Network module
	IRQ_CAN0_Bus_Off = 76

	// Flex Controller Area Network module
	IRQ_CAN0_Error = 77

	// Flex Controller Area Network module
	IRQ_CAN0_Tx_Warning = 78

	// Flex Controller Area Network module
	IRQ_CAN0_Rx_Warning = 79

	// Flex Controller Area Network module
	IRQ_CAN0_Wake_Up = 80

	// Secured Digital Host Controller
	IRQ_SDHC = 81

	// Ethernet MAC-NET Core
	IRQ_ENET_1588_Timer = 82

	// Ethernet MAC-NET Core
	IRQ_ENET_Transmit = 83

	// Ethernet MAC-NET Core
	IRQ_ENET_Receive = 84

	// Ethernet MAC-NET Core
	IRQ_ENET_Error = 85

	// Highest interrupt number on this device.
	IRQ_max = 85
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export DMA0_IRQHandler
func interruptDMA0() {
	callHandlers(IRQ_DMA0)
}

//export DMA1_IRQHandler
func interruptDMA1() {
	callHandlers(IRQ_DMA1)
}

//export DMA2_IRQHandler
func interruptDMA2() {
	callHandlers(IRQ_DMA2)
}

//export DMA3_IRQHandler
func interruptDMA3() {
	callHandlers(IRQ_DMA3)
}

//export DMA4_IRQHandler
func interruptDMA4() {
	callHandlers(IRQ_DMA4)
}

//export DMA5_IRQHandler
func interruptDMA5() {
	callHandlers(IRQ_DMA5)
}

//export DMA6_IRQHandler
func interruptDMA6() {
	callHandlers(IRQ_DMA6)
}

//export DMA7_IRQHandler
func interruptDMA7() {
	callHandlers(IRQ_DMA7)
}

//export DMA8_IRQHandler
func interruptDMA8() {
	callHandlers(IRQ_DMA8)
}

//export DMA9_IRQHandler
func interruptDMA9() {
	callHandlers(IRQ_DMA9)
}

//export DMA10_IRQHandler
func interruptDMA10() {
	callHandlers(IRQ_DMA10)
}

//export DMA11_IRQHandler
func interruptDMA11() {
	callHandlers(IRQ_DMA11)
}

//export DMA12_IRQHandler
func interruptDMA12() {
	callHandlers(IRQ_DMA12)
}

//export DMA13_IRQHandler
func interruptDMA13() {
	callHandlers(IRQ_DMA13)
}

//export DMA14_IRQHandler
func interruptDMA14() {
	callHandlers(IRQ_DMA14)
}

//export DMA15_IRQHandler
func interruptDMA15() {
	callHandlers(IRQ_DMA15)
}

//export DMA_Error_IRQHandler
func interruptDMA_Error() {
	callHandlers(IRQ_DMA_Error)
}

//export MCM_IRQHandler
func interruptMCM() {
	callHandlers(IRQ_MCM)
}

//export FTFE_IRQHandler
func interruptFTFE() {
	callHandlers(IRQ_FTFE)
}

//export Read_Collision_IRQHandler
func interruptRead_Collision() {
	callHandlers(IRQ_Read_Collision)
}

//export LVD_LVW_IRQHandler
func interruptLVD_LVW() {
	callHandlers(IRQ_LVD_LVW)
}

//export LLWU_IRQHandler
func interruptLLWU() {
	callHandlers(IRQ_LLWU)
}

//export WDOG_EWM_IRQHandler
func interruptWDOG_EWM() {
	callHandlers(IRQ_WDOG_EWM)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export I2S0_Tx_IRQHandler
func interruptI2S0_Tx() {
	callHandlers(IRQ_I2S0_Tx)
}

//export I2S0_Rx_IRQHandler
func interruptI2S0_Rx() {
	callHandlers(IRQ_I2S0_Rx)
}

//export UART0_LON_IRQHandler
func interruptUART0_LON() {
	callHandlers(IRQ_UART0_LON)
}

//export UART0_RX_TX_IRQHandler
func interruptUART0_RX_TX() {
	callHandlers(IRQ_UART0_RX_TX)
}

//export UART0_ERR_IRQHandler
func interruptUART0_ERR() {
	callHandlers(IRQ_UART0_ERR)
}

//export UART1_RX_TX_IRQHandler
func interruptUART1_RX_TX() {
	callHandlers(IRQ_UART1_RX_TX)
}

//export UART1_ERR_IRQHandler
func interruptUART1_ERR() {
	callHandlers(IRQ_UART1_ERR)
}

//export UART2_RX_TX_IRQHandler
func interruptUART2_RX_TX() {
	callHandlers(IRQ_UART2_RX_TX)
}

//export UART2_ERR_IRQHandler
func interruptUART2_ERR() {
	callHandlers(IRQ_UART2_ERR)
}

//export UART3_RX_TX_IRQHandler
func interruptUART3_RX_TX() {
	callHandlers(IRQ_UART3_RX_TX)
}

//export UART3_ERR_IRQHandler
func interruptUART3_ERR() {
	callHandlers(IRQ_UART3_ERR)
}

//export ADC0_IRQHandler
func interruptADC0() {
	callHandlers(IRQ_ADC0)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export CMP1_IRQHandler
func interruptCMP1() {
	callHandlers(IRQ_CMP1)
}

//export FTM0_IRQHandler
func interruptFTM0() {
	callHandlers(IRQ_FTM0)
}

//export FTM1_IRQHandler
func interruptFTM1() {
	callHandlers(IRQ_FTM1)
}

//export FTM2_IRQHandler
func interruptFTM2() {
	callHandlers(IRQ_FTM2)
}

//export CMT_IRQHandler
func interruptCMT() {
	callHandlers(IRQ_CMT)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTC_Seconds_IRQHandler
func interruptRTC_Seconds() {
	callHandlers(IRQ_RTC_Seconds)
}

//export PIT0_IRQHandler
func interruptPIT0() {
	callHandlers(IRQ_PIT0)
}

//export PIT1_IRQHandler
func interruptPIT1() {
	callHandlers(IRQ_PIT1)
}

//export PIT2_IRQHandler
func interruptPIT2() {
	callHandlers(IRQ_PIT2)
}

//export PIT3_IRQHandler
func interruptPIT3() {
	callHandlers(IRQ_PIT3)
}

//export PDB0_IRQHandler
func interruptPDB0() {
	callHandlers(IRQ_PDB0)
}

//export USB0_IRQHandler
func interruptUSB0() {
	callHandlers(IRQ_USB0)
}

//export USBDCD_IRQHandler
func interruptUSBDCD() {
	callHandlers(IRQ_USBDCD)
}

//export DAC0_IRQHandler
func interruptDAC0() {
	callHandlers(IRQ_DAC0)
}

//export LPTMR0_IRQHandler
func interruptLPTMR0() {
	callHandlers(IRQ_LPTMR0)
}

//export PORTA_IRQHandler
func interruptPORTA() {
	callHandlers(IRQ_PORTA)
}

//export PORTB_IRQHandler
func interruptPORTB() {
	callHandlers(IRQ_PORTB)
}

//export PORTC_IRQHandler
func interruptPORTC() {
	callHandlers(IRQ_PORTC)
}

//export PORTD_IRQHandler
func interruptPORTD() {
	callHandlers(IRQ_PORTD)
}

//export PORTE_IRQHandler
func interruptPORTE() {
	callHandlers(IRQ_PORTE)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export UART4_RX_TX_IRQHandler
func interruptUART4_RX_TX() {
	callHandlers(IRQ_UART4_RX_TX)
}

//export UART4_ERR_IRQHandler
func interruptUART4_ERR() {
	callHandlers(IRQ_UART4_ERR)
}

//export UART5_RX_TX_IRQHandler
func interruptUART5_RX_TX() {
	callHandlers(IRQ_UART5_RX_TX)
}

//export UART5_ERR_IRQHandler
func interruptUART5_ERR() {
	callHandlers(IRQ_UART5_ERR)
}

//export CMP2_IRQHandler
func interruptCMP2() {
	callHandlers(IRQ_CMP2)
}

//export FTM3_IRQHandler
func interruptFTM3() {
	callHandlers(IRQ_FTM3)
}

//export DAC1_IRQHandler
func interruptDAC1() {
	callHandlers(IRQ_DAC1)
}

//export ADC1_IRQHandler
func interruptADC1() {
	callHandlers(IRQ_ADC1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export CAN0_ORed_Message_buffer_IRQHandler
func interruptCAN0_ORed_Message_buffer() {
	callHandlers(IRQ_CAN0_ORed_Message_buffer)
}

//export CAN0_Bus_Off_IRQHandler
func interruptCAN0_Bus_Off() {
	callHandlers(IRQ_CAN0_Bus_Off)
}

//export CAN0_Error_IRQHandler
func interruptCAN0_Error() {
	callHandlers(IRQ_CAN0_Error)
}

//export CAN0_Tx_Warning_IRQHandler
func interruptCAN0_Tx_Warning() {
	callHandlers(IRQ_CAN0_Tx_Warning)
}

//export CAN0_Rx_Warning_IRQHandler
func interruptCAN0_Rx_Warning() {
	callHandlers(IRQ_CAN0_Rx_Warning)
}

//export CAN0_Wake_Up_IRQHandler
func interruptCAN0_Wake_Up() {
	callHandlers(IRQ_CAN0_Wake_Up)
}

//export SDHC_IRQHandler
func interruptSDHC() {
	callHandlers(IRQ_SDHC)
}

//export ENET_1588_Timer_IRQHandler
func interruptENET_1588_Timer() {
	callHandlers(IRQ_ENET_1588_Timer)
}

//export ENET_Transmit_IRQHandler
func interruptENET_Transmit() {
	callHandlers(IRQ_ENET_Transmit)
}

//export ENET_Receive_IRQHandler
func interruptENET_Receive() {
	callHandlers(IRQ_ENET_Receive)
}

//export ENET_Error_IRQHandler
func interruptENET_Error() {
	callHandlers(IRQ_ENET_Error)
}

// Peripherals.
var (
	// Flash configuration field
	FTFE_FlashConfig = (*FTFE_FlashConfig_Type)(unsafe.Pointer(uintptr(0x400)))

	// AIPS-Lite Bridge
	AIPS0 = (*AIPS_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// AIPS-Lite Bridge
	AIPS1 = (*AIPS_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Crossbar switch
	AXBS = (*AXBS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Enhanced direct memory access controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// FlexBus external bus interface
	FB = (*FB_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Memory protection unit
	SYSMPU = (*SYSMPU_Type)(unsafe.Pointer(uintptr(0x4000d000)))

	// Flash Memory Controller
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Flash Memory Interface
	FTFE = (*FTFE_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA channel multiplexor
	DMAMUX = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Flex Controller Area Network module
	CAN0 = (*CAN0_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Random Number Generator Accelerator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x40029000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Serial Peripheral Interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x400ac000)))

	// Inter-IC Sound / Synchronous Audio Interface
	I2S0 = (*I2S0_Type)(unsafe.Pointer(uintptr(0x4002f000)))

	// Cyclic Redundancy Check
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40032000)))

	// USB Device Charger Detection module
	USBDCD = (*USBDCD_Type)(unsafe.Pointer(uintptr(0x40035000)))

	// Programmable Delay Block
	PDB0 = (*PDB0_Type)(unsafe.Pointer(uintptr(0x40036000)))

	// Periodic Interrupt Timer
	PIT = (*PIT_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// FlexTimer Module
	FTM0 = (*FTM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// FlexTimer Module
	FTM1 = (*FTM_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// FlexTimer Module
	FTM2 = (*FTM_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// FlexTimer Module
	FTM3 = (*FTM_Type)(unsafe.Pointer(uintptr(0x400b9000)))

	// Analog-to-Digital Converter
	ADC0 = (*ADC_Type)(unsafe.Pointer(uintptr(0x4003b000)))

	// Analog-to-Digital Converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x400bb000)))

	// Secure Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003d000)))

	// VBAT register file
	RFVBAT = (*RFVBAT_Type)(unsafe.Pointer(uintptr(0x4003e000)))

	// Low Power Timer
	LPTMR0 = (*LPTMR0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// System register file
	RFSYS = (*RFSYS_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// System Integration Module
	SIM = (*SIM_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Pin Control and Interrupts
	PORTA = (*PORT_Type)(unsafe.Pointer(uintptr(0x40049000)))

	// Pin Control and Interrupts
	PORTB = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004a000)))

	// Pin Control and Interrupts
	PORTC = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004b000)))

	// Pin Control and Interrupts
	PORTD = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// Pin Control and Interrupts
	PORTE = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004d000)))

	// Generation 2008 Watchdog Timer
	WDOG = (*WDOG_Type)(unsafe.Pointer(uintptr(0x40052000)))

	// External Watchdog Monitor
	EWM = (*EWM_Type)(unsafe.Pointer(uintptr(0x40061000)))

	// Carrier Modulator Transmitter
	CMT = (*CMT_Type)(unsafe.Pointer(uintptr(0x40062000)))

	// Multipurpose Clock Generator module
	MCG = (*MCG_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Oscillator
	OSC = (*OSC_Type)(unsafe.Pointer(uintptr(0x40065000)))

	// Inter-Integrated Circuit
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40066000)))

	// Inter-Integrated Circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40067000)))

	// Inter-Integrated Circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400e6000)))

	// Serial Communication Interface
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006a000)))

	// Serial Communication Interface
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006b000)))

	// Serial Communication Interface
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Serial Communication Interface
	UART3 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006d000)))

	// Serial Communication Interface
	UART4 = (*UART_Type)(unsafe.Pointer(uintptr(0x400ea000)))

	// Serial Communication Interface
	UART5 = (*UART_Type)(unsafe.Pointer(uintptr(0x400eb000)))

	// Universal Serial Bus, OTG Capable Controller
	USB0 = (*USB0_Type)(unsafe.Pointer(uintptr(0x40072000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP0 = (*CMP_Type)(unsafe.Pointer(uintptr(0x40073000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP1 = (*CMP_Type)(unsafe.Pointer(uintptr(0x40073008)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP2 = (*CMP_Type)(unsafe.Pointer(uintptr(0x40073010)))

	// Voltage Reference
	VREF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// Low leakage wakeup unit
	LLWU = (*LLWU_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x4007d000)))

	// System Mode Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x4007e000)))

	// Reset Control Module
	RCM = (*RCM_Type)(unsafe.Pointer(uintptr(0x4007f000)))

	// Secured Digital Host Controller
	SDHC = (*SDHC_Type)(unsafe.Pointer(uintptr(0x400b1000)))

	// Ethernet MAC-NET Core
	ENET = (*ENET_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// 12-Bit Digital-to-Analog Converter
	DAC0 = (*DAC_Type)(unsafe.Pointer(uintptr(0x400cc000)))

	// 12-Bit Digital-to-Analog Converter
	DAC1 = (*DAC_Type)(unsafe.Pointer(uintptr(0x400cd000)))

	// General Purpose Input/Output
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff000)))

	// General Purpose Input/Output
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff040)))

	// General Purpose Input/Output
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff080)))

	// General Purpose Input/Output
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff0c0)))

	// General Purpose Input/Output
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff100)))

	// System Control Block
	SystemControl = (*SystemControl_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Core Platform Miscellaneous Control Module
	MCM = (*MCM_Type)(unsafe.Pointer(uintptr(0xe0080000)))

	// Memory Mapped Cryptographic Acceleration Unit (MMCAU)
	CAU = (*CAU_Type)(unsafe.Pointer(uintptr(0xe0081000)))
)

// Flash configuration field
type FTFE_FlashConfig_Type struct {
	BACKKEY3 volatile.Register8 // 0x0
	BACKKEY2 volatile.Register8 // 0x1
	BACKKEY1 volatile.Register8 // 0x2
	BACKKEY0 volatile.Register8 // 0x3
	BACKKEY7 volatile.Register8 // 0x4
	BACKKEY6 volatile.Register8 // 0x5
	BACKKEY5 volatile.Register8 // 0x6
	BACKKEY4 volatile.Register8 // 0x7
	FPROT3   volatile.Register8 // 0x8
	FPROT2   volatile.Register8 // 0x9
	FPROT1   volatile.Register8 // 0xA
	FPROT0   volatile.Register8 // 0xB
	FSEC     volatile.Register8 // 0xC
	FOPT     volatile.Register8 // 0xD
	FEPROT   volatile.Register8 // 0xE
	FDPROT   volatile.Register8 // 0xF
}

// FTFE_FlashConfig.BACKKEY3: Backdoor Comparison Key 3.
func (o *FTFE_FlashConfig_Type) SetBACKKEY3(value uint8) {
	volatile.StoreUint8(&o.BACKKEY3.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY3() uint8 {
	return volatile.LoadUint8(&o.BACKKEY3.Reg)
}

// FTFE_FlashConfig.BACKKEY2: Backdoor Comparison Key 2.
func (o *FTFE_FlashConfig_Type) SetBACKKEY2(value uint8) {
	volatile.StoreUint8(&o.BACKKEY2.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY2() uint8 {
	return volatile.LoadUint8(&o.BACKKEY2.Reg)
}

// FTFE_FlashConfig.BACKKEY1: Backdoor Comparison Key 1.
func (o *FTFE_FlashConfig_Type) SetBACKKEY1(value uint8) {
	volatile.StoreUint8(&o.BACKKEY1.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY1() uint8 {
	return volatile.LoadUint8(&o.BACKKEY1.Reg)
}

// FTFE_FlashConfig.BACKKEY0: Backdoor Comparison Key 0.
func (o *FTFE_FlashConfig_Type) SetBACKKEY0(value uint8) {
	volatile.StoreUint8(&o.BACKKEY0.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY0() uint8 {
	return volatile.LoadUint8(&o.BACKKEY0.Reg)
}

// FTFE_FlashConfig.BACKKEY7: Backdoor Comparison Key 7.
func (o *FTFE_FlashConfig_Type) SetBACKKEY7(value uint8) {
	volatile.StoreUint8(&o.BACKKEY7.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY7() uint8 {
	return volatile.LoadUint8(&o.BACKKEY7.Reg)
}

// FTFE_FlashConfig.BACKKEY6: Backdoor Comparison Key 6.
func (o *FTFE_FlashConfig_Type) SetBACKKEY6(value uint8) {
	volatile.StoreUint8(&o.BACKKEY6.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY6() uint8 {
	return volatile.LoadUint8(&o.BACKKEY6.Reg)
}

// FTFE_FlashConfig.BACKKEY5: Backdoor Comparison Key 5.
func (o *FTFE_FlashConfig_Type) SetBACKKEY5(value uint8) {
	volatile.StoreUint8(&o.BACKKEY5.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY5() uint8 {
	return volatile.LoadUint8(&o.BACKKEY5.Reg)
}

// FTFE_FlashConfig.BACKKEY4: Backdoor Comparison Key 4.
func (o *FTFE_FlashConfig_Type) SetBACKKEY4(value uint8) {
	volatile.StoreUint8(&o.BACKKEY4.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetBACKKEY4() uint8 {
	return volatile.LoadUint8(&o.BACKKEY4.Reg)
}

// FTFE_FlashConfig.FPROT3: Non-volatile P-Flash Protection 1 - Low Register
func (o *FTFE_FlashConfig_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFE_FlashConfig.FPROT2: Non-volatile P-Flash Protection 1 - High Register
func (o *FTFE_FlashConfig_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFE_FlashConfig.FPROT1: Non-volatile P-Flash Protection 0 - Low Register
func (o *FTFE_FlashConfig_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFE_FlashConfig.FPROT0: Non-volatile P-Flash Protection 0 - High Register
func (o *FTFE_FlashConfig_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFE_FlashConfig.FSEC: Non-volatile Flash Security Register
func (o *FTFE_FlashConfig_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFE_FlashConfig_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFE_FlashConfig_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFE_FlashConfig_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFE_FlashConfig_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFE_FlashConfig_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFE_FlashConfig_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFE_FlashConfig_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFE_FlashConfig.FOPT: Non-volatile Flash Option Register
func (o *FTFE_FlashConfig_Type) SetFOPT_LPBOOT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x1)|value)
}
func (o *FTFE_FlashConfig_Type) GetFOPT_LPBOOT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg) & 0x1
}
func (o *FTFE_FlashConfig_Type) SetFOPT_EZPORT_DIS(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x2)|value<<1)
}
func (o *FTFE_FlashConfig_Type) GetFOPT_EZPORT_DIS() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x2) >> 1
}

// FTFE_FlashConfig.FEPROT: Non-volatile EERAM Protection Register
func (o *FTFE_FlashConfig_Type) SetFEPROT(value uint8) {
	volatile.StoreUint8(&o.FEPROT.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFEPROT() uint8 {
	return volatile.LoadUint8(&o.FEPROT.Reg)
}

// FTFE_FlashConfig.FDPROT: Non-volatile D-Flash Protection Register
func (o *FTFE_FlashConfig_Type) SetFDPROT(value uint8) {
	volatile.StoreUint8(&o.FDPROT.Reg, value)
}
func (o *FTFE_FlashConfig_Type) GetFDPROT() uint8 {
	return volatile.LoadUint8(&o.FDPROT.Reg)
}

// AIPS-Lite Bridge
type AIPS_Type struct {
	MPRA  volatile.Register32 // 0x0
	_     [28]byte
	PACRA volatile.Register32 // 0x20
	PACRB volatile.Register32 // 0x24
	PACRC volatile.Register32 // 0x28
	PACRD volatile.Register32 // 0x2C
	_     [16]byte
	PACRE volatile.Register32 // 0x40
	PACRF volatile.Register32 // 0x44
	PACRG volatile.Register32 // 0x48
	PACRH volatile.Register32 // 0x4C
	PACRI volatile.Register32 // 0x50
	PACRJ volatile.Register32 // 0x54
	PACRK volatile.Register32 // 0x58
	PACRL volatile.Register32 // 0x5C
	PACRM volatile.Register32 // 0x60
	PACRN volatile.Register32 // 0x64
	PACRO volatile.Register32 // 0x68
	PACRP volatile.Register32 // 0x6C
	_     [16]byte
	PACRU volatile.Register32 // 0x80
}

// AIPS.MPRA: Master Privilege Register A
func (o *AIPS_Type) SetMPRA_MPL5(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetMPRA_MPL5() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetMPRA_MTW5(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetMPRA_MTW5() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetMPRA_MTR5(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetMPRA_MTR5() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetMPRA_MPL4(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetMPRA_MPL4() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetMPRA_MTW4(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetMPRA_MTW4() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetMPRA_MTR4(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetMPRA_MTR4() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetMPRA_MPL3(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetMPRA_MPL3() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetMPRA_MTW3(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetMPRA_MTW3() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetMPRA_MTR3(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetMPRA_MTR3() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetMPRA_MPL2(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetMPRA_MPL2() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetMPRA_MTW2(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetMPRA_MTW2() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetMPRA_MTR2(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetMPRA_MTR2() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetMPRA_MPL1(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetMPRA_MPL1() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetMPRA_MTW1(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetMPRA_MTW1() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetMPRA_MTR1(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetMPRA_MTR1() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetMPRA_MPL0(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetMPRA_MPL0() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetMPRA_MTW0(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetMPRA_MTW0() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetMPRA_MTR0(value uint32) {
	volatile.StoreUint32(&o.MPRA.Reg, volatile.LoadUint32(&o.MPRA.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetMPRA_MTR0() uint32 {
	return (volatile.LoadUint32(&o.MPRA.Reg) & 0x40000000) >> 30
}

// AIPS.PACRA: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRA_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRA_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRA.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRA_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRA_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRA_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRA_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRA_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRA_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRA_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRA_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRA_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRA_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRA_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRA_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRA_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRA_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRA_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRA_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRA_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRA_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRA_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRA_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRA_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRA_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRA_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRA_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRA_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRA_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRA_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRA_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRA_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRA_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRA_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRA_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRA_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRA_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRA_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRA_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRA_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRA_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRA_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRA_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRA_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRA_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRA_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRA_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRA_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRA.Reg, volatile.LoadUint32(&o.PACRA.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRA_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRA.Reg) & 0x40000000) >> 30
}

// AIPS.PACRB: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRB_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRB_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRB.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRB_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRB_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRB_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRB_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRB_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRB_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRB_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRB_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRB_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRB_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRB_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRB_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRB_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRB_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRB_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRB_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRB_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRB_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRB_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRB_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRB_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRB_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRB_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRB_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRB_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRB_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRB_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRB_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRB_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRB_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRB_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRB_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRB_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRB_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRB_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRB_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRB_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRB_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRB_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRB_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRB_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRB_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRB_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRB_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRB_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRB.Reg, volatile.LoadUint32(&o.PACRB.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRB_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRB.Reg) & 0x40000000) >> 30
}

// AIPS.PACRC: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRC_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRC_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRC.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRC_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRC_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRC_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRC_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRC_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRC_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRC_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRC_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRC_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRC_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRC_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRC_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRC_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRC_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRC_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRC_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRC_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRC_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRC_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRC_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRC_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRC_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRC_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRC_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRC_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRC_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRC_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRC_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRC_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRC_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRC_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRC_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRC_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRC_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRC_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRC_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRC_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRC_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRC_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRC_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRC_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRC_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRC_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRC_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRC_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRC.Reg, volatile.LoadUint32(&o.PACRC.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRC_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRC.Reg) & 0x40000000) >> 30
}

// AIPS.PACRD: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRD_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRD_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRD.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRD_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRD_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRD_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRD_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRD_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRD_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRD_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRD_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRD_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRD_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRD_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRD_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRD_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRD_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRD_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRD_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRD_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRD_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRD_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRD_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRD_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRD_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRD_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRD_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRD_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRD_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRD_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRD_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRD_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRD_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRD_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRD_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRD_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRD_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRD_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRD_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRD_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRD_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRD_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRD_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRD_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRD_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRD_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRD_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRD_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRD.Reg, volatile.LoadUint32(&o.PACRD.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRD_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRD.Reg) & 0x40000000) >> 30
}

// AIPS.PACRE: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRE_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRE_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRE.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRE_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRE_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRE_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRE_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRE_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRE_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRE_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRE_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRE_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRE_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRE_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRE_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRE_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRE_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRE_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRE_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRE_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRE_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRE_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRE_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRE_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRE_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRE_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRE_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRE_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRE_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRE_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRE_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRE_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRE_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRE_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRE_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRE_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRE_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRE_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRE_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRE_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRE_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRE_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRE_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRE_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRE_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRE_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRE_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRE_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRE.Reg, volatile.LoadUint32(&o.PACRE.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRE_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRE.Reg) & 0x40000000) >> 30
}

// AIPS.PACRF: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRF_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRF_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRF.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRF_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRF_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRF_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRF_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRF_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRF_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRF_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRF_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRF_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRF_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRF_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRF_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRF_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRF_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRF_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRF_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRF_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRF_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRF_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRF_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRF_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRF_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRF_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRF_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRF_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRF_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRF_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRF_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRF_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRF_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRF_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRF_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRF_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRF_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRF_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRF_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRF_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRF_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRF_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRF_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRF_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRF_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRF_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRF_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRF_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRF.Reg, volatile.LoadUint32(&o.PACRF.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRF_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRF.Reg) & 0x40000000) >> 30
}

// AIPS.PACRG: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRG_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRG_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRG.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRG_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRG_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRG_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRG_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRG_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRG_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRG_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRG_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRG_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRG_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRG_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRG_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRG_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRG_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRG_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRG_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRG_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRG_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRG_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRG_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRG_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRG_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRG_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRG_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRG_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRG_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRG_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRG_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRG_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRG_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRG_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRG_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRG_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRG_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRG_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRG_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRG_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRG_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRG_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRG_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRG_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRG_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRG_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRG_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRG_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRG.Reg, volatile.LoadUint32(&o.PACRG.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRG_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRG.Reg) & 0x40000000) >> 30
}

// AIPS.PACRH: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRH_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRH_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRH.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRH_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRH_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRH_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRH_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRH_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRH_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRH_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRH_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRH_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRH_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRH_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRH_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRH_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRH_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRH_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRH_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRH_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRH_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRH_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRH_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRH_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRH_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRH_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRH_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRH_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRH_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRH_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRH_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRH_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRH_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRH_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRH_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRH_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRH_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRH_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRH_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRH_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRH_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRH_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRH_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRH_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRH_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRH_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRH_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRH_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRH.Reg, volatile.LoadUint32(&o.PACRH.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRH_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRH.Reg) & 0x40000000) >> 30
}

// AIPS.PACRI: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRI_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRI_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRI.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRI_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRI_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRI_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRI_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRI_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRI_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRI_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRI_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRI_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRI_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRI_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRI_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRI_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRI_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRI_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRI_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRI_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRI_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRI_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRI_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRI_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRI_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRI_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRI_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRI_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRI_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRI_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRI_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRI_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRI_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRI_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRI_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRI_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRI_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRI_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRI_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRI_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRI_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRI_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRI_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRI_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRI_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRI_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRI_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRI_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRI.Reg, volatile.LoadUint32(&o.PACRI.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRI_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRI.Reg) & 0x40000000) >> 30
}

// AIPS.PACRJ: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRJ_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRJ_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRJ.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRJ_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRJ_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRJ_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRJ_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRJ_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRJ_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRJ_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRJ_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRJ_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRJ_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRJ_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRJ_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRJ_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRJ_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRJ_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRJ_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRJ_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRJ_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRJ_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRJ_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRJ_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRJ_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRJ_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRJ_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRJ_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRJ_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRJ_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRJ_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRJ_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRJ_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRJ_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRJ_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRJ_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRJ_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRJ_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRJ_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRJ_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRJ_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRJ_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRJ_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRJ_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRJ_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRJ_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRJ_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRJ_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRJ.Reg, volatile.LoadUint32(&o.PACRJ.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRJ_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRJ.Reg) & 0x40000000) >> 30
}

// AIPS.PACRK: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRK_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRK_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRK.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRK_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRK_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRK_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRK_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRK_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRK_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRK_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRK_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRK_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRK_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRK_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRK_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRK_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRK_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRK_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRK_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRK_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRK_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRK_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRK_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRK_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRK_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRK_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRK_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRK_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRK_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRK_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRK_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRK_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRK_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRK_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRK_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRK_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRK_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRK_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRK_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRK_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRK_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRK_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRK_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRK_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRK_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRK_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRK_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRK_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRK.Reg, volatile.LoadUint32(&o.PACRK.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRK_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRK.Reg) & 0x40000000) >> 30
}

// AIPS.PACRL: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRL_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRL_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRL.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRL_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRL_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRL_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRL_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRL_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRL_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRL_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRL_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRL_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRL_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRL_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRL_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRL_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRL_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRL_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRL_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRL_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRL_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRL_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRL_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRL_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRL_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRL_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRL_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRL_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRL_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRL_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRL_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRL_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRL_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRL_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRL_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRL_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRL_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRL_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRL_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRL_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRL_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRL_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRL_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRL_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRL_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRL_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRL_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRL_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRL.Reg, volatile.LoadUint32(&o.PACRL.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRL_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRL.Reg) & 0x40000000) >> 30
}

// AIPS.PACRM: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRM_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRM_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRM.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRM_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRM_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRM_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRM_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRM_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRM_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRM_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRM_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRM_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRM_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRM_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRM_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRM_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRM_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRM_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRM_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRM_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRM_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRM_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRM_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRM_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRM_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRM_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRM_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRM_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRM_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRM_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRM_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRM_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRM_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRM_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRM_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRM_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRM_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRM_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRM_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRM_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRM_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRM_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRM_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRM_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRM_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRM_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRM_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRM_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRM.Reg, volatile.LoadUint32(&o.PACRM.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRM_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRM.Reg) & 0x40000000) >> 30
}

// AIPS.PACRN: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRN_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRN_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRN.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRN_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRN_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRN_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRN_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRN_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRN_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRN_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRN_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRN_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRN_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRN_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRN_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRN_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRN_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRN_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRN_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRN_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRN_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRN_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRN_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRN_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRN_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRN_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRN_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRN_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRN_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRN_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRN_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRN_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRN_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRN_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRN_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRN_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRN_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRN_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRN_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRN_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRN_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRN_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRN_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRN_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRN_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRN_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRN_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRN_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRN.Reg, volatile.LoadUint32(&o.PACRN.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRN_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRN.Reg) & 0x40000000) >> 30
}

// AIPS.PACRO: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRO_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRO_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRO.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRO_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRO_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRO_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRO_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRO_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRO_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRO_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRO_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRO_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRO_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRO_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRO_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRO_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRO_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRO_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRO_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRO_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRO_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRO_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRO_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRO_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRO_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRO_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRO_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRO_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRO_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRO_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRO_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRO_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRO_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRO_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRO_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRO_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRO_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRO_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRO_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRO_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRO_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRO_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRO_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRO_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRO_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRO_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRO_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRO_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRO.Reg, volatile.LoadUint32(&o.PACRO.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRO_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRO.Reg) & 0x40000000) >> 30
}

// AIPS.PACRP: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRP_TP7(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x1)|value)
}
func (o *AIPS_Type) GetPACRP_TP7() uint32 {
	return volatile.LoadUint32(&o.PACRP.Reg) & 0x1
}
func (o *AIPS_Type) SetPACRP_WP7(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x2)|value<<1)
}
func (o *AIPS_Type) GetPACRP_WP7() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x2) >> 1
}
func (o *AIPS_Type) SetPACRP_SP7(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x4)|value<<2)
}
func (o *AIPS_Type) GetPACRP_SP7() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x4) >> 2
}
func (o *AIPS_Type) SetPACRP_TP6(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x10)|value<<4)
}
func (o *AIPS_Type) GetPACRP_TP6() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x10) >> 4
}
func (o *AIPS_Type) SetPACRP_WP6(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x20)|value<<5)
}
func (o *AIPS_Type) GetPACRP_WP6() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x20) >> 5
}
func (o *AIPS_Type) SetPACRP_SP6(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x40)|value<<6)
}
func (o *AIPS_Type) GetPACRP_SP6() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x40) >> 6
}
func (o *AIPS_Type) SetPACRP_TP5(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x100)|value<<8)
}
func (o *AIPS_Type) GetPACRP_TP5() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x100) >> 8
}
func (o *AIPS_Type) SetPACRP_WP5(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x200)|value<<9)
}
func (o *AIPS_Type) GetPACRP_WP5() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x200) >> 9
}
func (o *AIPS_Type) SetPACRP_SP5(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x400)|value<<10)
}
func (o *AIPS_Type) GetPACRP_SP5() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x400) >> 10
}
func (o *AIPS_Type) SetPACRP_TP4(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x1000)|value<<12)
}
func (o *AIPS_Type) GetPACRP_TP4() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x1000) >> 12
}
func (o *AIPS_Type) SetPACRP_WP4(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x2000)|value<<13)
}
func (o *AIPS_Type) GetPACRP_WP4() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x2000) >> 13
}
func (o *AIPS_Type) SetPACRP_SP4(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x4000)|value<<14)
}
func (o *AIPS_Type) GetPACRP_SP4() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x4000) >> 14
}
func (o *AIPS_Type) SetPACRP_TP3(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x10000)|value<<16)
}
func (o *AIPS_Type) GetPACRP_TP3() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x10000) >> 16
}
func (o *AIPS_Type) SetPACRP_WP3(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x20000)|value<<17)
}
func (o *AIPS_Type) GetPACRP_WP3() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x20000) >> 17
}
func (o *AIPS_Type) SetPACRP_SP3(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x40000)|value<<18)
}
func (o *AIPS_Type) GetPACRP_SP3() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x40000) >> 18
}
func (o *AIPS_Type) SetPACRP_TP2(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x100000)|value<<20)
}
func (o *AIPS_Type) GetPACRP_TP2() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x100000) >> 20
}
func (o *AIPS_Type) SetPACRP_WP2(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x200000)|value<<21)
}
func (o *AIPS_Type) GetPACRP_WP2() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x200000) >> 21
}
func (o *AIPS_Type) SetPACRP_SP2(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x400000)|value<<22)
}
func (o *AIPS_Type) GetPACRP_SP2() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x400000) >> 22
}
func (o *AIPS_Type) SetPACRP_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRP_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRP_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRP_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRP_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRP_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRP_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRP_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRP_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRP_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRP_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRP.Reg, volatile.LoadUint32(&o.PACRP.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRP_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRP.Reg) & 0x40000000) >> 30
}

// AIPS.PACRU: Peripheral Access Control Register
func (o *AIPS_Type) SetPACRU_TP1(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x1000000)|value<<24)
}
func (o *AIPS_Type) GetPACRU_TP1() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x1000000) >> 24
}
func (o *AIPS_Type) SetPACRU_WP1(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x2000000)|value<<25)
}
func (o *AIPS_Type) GetPACRU_WP1() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x2000000) >> 25
}
func (o *AIPS_Type) SetPACRU_SP1(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x4000000)|value<<26)
}
func (o *AIPS_Type) GetPACRU_SP1() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x4000000) >> 26
}
func (o *AIPS_Type) SetPACRU_TP0(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x10000000)|value<<28)
}
func (o *AIPS_Type) GetPACRU_TP0() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x10000000) >> 28
}
func (o *AIPS_Type) SetPACRU_WP0(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x20000000)|value<<29)
}
func (o *AIPS_Type) GetPACRU_WP0() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x20000000) >> 29
}
func (o *AIPS_Type) SetPACRU_SP0(value uint32) {
	volatile.StoreUint32(&o.PACRU.Reg, volatile.LoadUint32(&o.PACRU.Reg)&^(0x40000000)|value<<30)
}
func (o *AIPS_Type) GetPACRU_SP0() uint32 {
	return (volatile.LoadUint32(&o.PACRU.Reg) & 0x40000000) >> 30
}

// Crossbar switch
type AXBS_Type struct {
	PRS0   volatile.Register32 // 0x0
	_      [12]byte
	CRS0   volatile.Register32 // 0x10
	_      [236]byte
	PRS1   volatile.Register32 // 0x100
	_      [12]byte
	CRS1   volatile.Register32 // 0x110
	_      [236]byte
	PRS2   volatile.Register32 // 0x200
	_      [12]byte
	CRS2   volatile.Register32 // 0x210
	_      [236]byte
	PRS3   volatile.Register32 // 0x300
	_      [12]byte
	CRS3   volatile.Register32 // 0x310
	_      [236]byte
	PRS4   volatile.Register32 // 0x400
	_      [12]byte
	CRS4   volatile.Register32 // 0x410
	_      [1004]byte
	MGPCR0 volatile.Register32 // 0x800
	_      [252]byte
	MGPCR1 volatile.Register32 // 0x900
	_      [252]byte
	MGPCR2 volatile.Register32 // 0xA00
	_      [252]byte
	MGPCR3 volatile.Register32 // 0xB00
	_      [252]byte
	MGPCR4 volatile.Register32 // 0xC00
	_      [252]byte
	MGPCR5 volatile.Register32 // 0xD00
}

// AXBS.PRS0: Priority Registers Slave
func (o *AXBS_Type) SetPRS0_M0(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetPRS0_M0() uint32 {
	return volatile.LoadUint32(&o.PRS0.Reg) & 0x7
}
func (o *AXBS_Type) SetPRS0_M1(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x70)|value<<4)
}
func (o *AXBS_Type) GetPRS0_M1() uint32 {
	return (volatile.LoadUint32(&o.PRS0.Reg) & 0x70) >> 4
}
func (o *AXBS_Type) SetPRS0_M2(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x700)|value<<8)
}
func (o *AXBS_Type) GetPRS0_M2() uint32 {
	return (volatile.LoadUint32(&o.PRS0.Reg) & 0x700) >> 8
}
func (o *AXBS_Type) SetPRS0_M3(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x7000)|value<<12)
}
func (o *AXBS_Type) GetPRS0_M3() uint32 {
	return (volatile.LoadUint32(&o.PRS0.Reg) & 0x7000) >> 12
}
func (o *AXBS_Type) SetPRS0_M4(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x70000)|value<<16)
}
func (o *AXBS_Type) GetPRS0_M4() uint32 {
	return (volatile.LoadUint32(&o.PRS0.Reg) & 0x70000) >> 16
}
func (o *AXBS_Type) SetPRS0_M5(value uint32) {
	volatile.StoreUint32(&o.PRS0.Reg, volatile.LoadUint32(&o.PRS0.Reg)&^(0x700000)|value<<20)
}
func (o *AXBS_Type) GetPRS0_M5() uint32 {
	return (volatile.LoadUint32(&o.PRS0.Reg) & 0x700000) >> 20
}

// AXBS.CRS0: Control Register
func (o *AXBS_Type) SetCRS0_PARK(value uint32) {
	volatile.StoreUint32(&o.CRS0.Reg, volatile.LoadUint32(&o.CRS0.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetCRS0_PARK() uint32 {
	return volatile.LoadUint32(&o.CRS0.Reg) & 0x7
}
func (o *AXBS_Type) SetCRS0_PCTL(value uint32) {
	volatile.StoreUint32(&o.CRS0.Reg, volatile.LoadUint32(&o.CRS0.Reg)&^(0x30)|value<<4)
}
func (o *AXBS_Type) GetCRS0_PCTL() uint32 {
	return (volatile.LoadUint32(&o.CRS0.Reg) & 0x30) >> 4
}
func (o *AXBS_Type) SetCRS0_ARB(value uint32) {
	volatile.StoreUint32(&o.CRS0.Reg, volatile.LoadUint32(&o.CRS0.Reg)&^(0x300)|value<<8)
}
func (o *AXBS_Type) GetCRS0_ARB() uint32 {
	return (volatile.LoadUint32(&o.CRS0.Reg) & 0x300) >> 8
}
func (o *AXBS_Type) SetCRS0_HLP(value uint32) {
	volatile.StoreUint32(&o.CRS0.Reg, volatile.LoadUint32(&o.CRS0.Reg)&^(0x40000000)|value<<30)
}
func (o *AXBS_Type) GetCRS0_HLP() uint32 {
	return (volatile.LoadUint32(&o.CRS0.Reg) & 0x40000000) >> 30
}
func (o *AXBS_Type) SetCRS0_RO(value uint32) {
	volatile.StoreUint32(&o.CRS0.Reg, volatile.LoadUint32(&o.CRS0.Reg)&^(0x80000000)|value<<31)
}
func (o *AXBS_Type) GetCRS0_RO() uint32 {
	return (volatile.LoadUint32(&o.CRS0.Reg) & 0x80000000) >> 31
}

// AXBS.PRS1: Priority Registers Slave
func (o *AXBS_Type) SetPRS1_M0(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetPRS1_M0() uint32 {
	return volatile.LoadUint32(&o.PRS1.Reg) & 0x7
}
func (o *AXBS_Type) SetPRS1_M1(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x70)|value<<4)
}
func (o *AXBS_Type) GetPRS1_M1() uint32 {
	return (volatile.LoadUint32(&o.PRS1.Reg) & 0x70) >> 4
}
func (o *AXBS_Type) SetPRS1_M2(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x700)|value<<8)
}
func (o *AXBS_Type) GetPRS1_M2() uint32 {
	return (volatile.LoadUint32(&o.PRS1.Reg) & 0x700) >> 8
}
func (o *AXBS_Type) SetPRS1_M3(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x7000)|value<<12)
}
func (o *AXBS_Type) GetPRS1_M3() uint32 {
	return (volatile.LoadUint32(&o.PRS1.Reg) & 0x7000) >> 12
}
func (o *AXBS_Type) SetPRS1_M4(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x70000)|value<<16)
}
func (o *AXBS_Type) GetPRS1_M4() uint32 {
	return (volatile.LoadUint32(&o.PRS1.Reg) & 0x70000) >> 16
}
func (o *AXBS_Type) SetPRS1_M5(value uint32) {
	volatile.StoreUint32(&o.PRS1.Reg, volatile.LoadUint32(&o.PRS1.Reg)&^(0x700000)|value<<20)
}
func (o *AXBS_Type) GetPRS1_M5() uint32 {
	return (volatile.LoadUint32(&o.PRS1.Reg) & 0x700000) >> 20
}

// AXBS.CRS1: Control Register
func (o *AXBS_Type) SetCRS1_PARK(value uint32) {
	volatile.StoreUint32(&o.CRS1.Reg, volatile.LoadUint32(&o.CRS1.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetCRS1_PARK() uint32 {
	return volatile.LoadUint32(&o.CRS1.Reg) & 0x7
}
func (o *AXBS_Type) SetCRS1_PCTL(value uint32) {
	volatile.StoreUint32(&o.CRS1.Reg, volatile.LoadUint32(&o.CRS1.Reg)&^(0x30)|value<<4)
}
func (o *AXBS_Type) GetCRS1_PCTL() uint32 {
	return (volatile.LoadUint32(&o.CRS1.Reg) & 0x30) >> 4
}
func (o *AXBS_Type) SetCRS1_ARB(value uint32) {
	volatile.StoreUint32(&o.CRS1.Reg, volatile.LoadUint32(&o.CRS1.Reg)&^(0x300)|value<<8)
}
func (o *AXBS_Type) GetCRS1_ARB() uint32 {
	return (volatile.LoadUint32(&o.CRS1.Reg) & 0x300) >> 8
}
func (o *AXBS_Type) SetCRS1_HLP(value uint32) {
	volatile.StoreUint32(&o.CRS1.Reg, volatile.LoadUint32(&o.CRS1.Reg)&^(0x40000000)|value<<30)
}
func (o *AXBS_Type) GetCRS1_HLP() uint32 {
	return (volatile.LoadUint32(&o.CRS1.Reg) & 0x40000000) >> 30
}
func (o *AXBS_Type) SetCRS1_RO(value uint32) {
	volatile.StoreUint32(&o.CRS1.Reg, volatile.LoadUint32(&o.CRS1.Reg)&^(0x80000000)|value<<31)
}
func (o *AXBS_Type) GetCRS1_RO() uint32 {
	return (volatile.LoadUint32(&o.CRS1.Reg) & 0x80000000) >> 31
}

// AXBS.PRS2: Priority Registers Slave
func (o *AXBS_Type) SetPRS2_M0(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetPRS2_M0() uint32 {
	return volatile.LoadUint32(&o.PRS2.Reg) & 0x7
}
func (o *AXBS_Type) SetPRS2_M1(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x70)|value<<4)
}
func (o *AXBS_Type) GetPRS2_M1() uint32 {
	return (volatile.LoadUint32(&o.PRS2.Reg) & 0x70) >> 4
}
func (o *AXBS_Type) SetPRS2_M2(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x700)|value<<8)
}
func (o *AXBS_Type) GetPRS2_M2() uint32 {
	return (volatile.LoadUint32(&o.PRS2.Reg) & 0x700) >> 8
}
func (o *AXBS_Type) SetPRS2_M3(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x7000)|value<<12)
}
func (o *AXBS_Type) GetPRS2_M3() uint32 {
	return (volatile.LoadUint32(&o.PRS2.Reg) & 0x7000) >> 12
}
func (o *AXBS_Type) SetPRS2_M4(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x70000)|value<<16)
}
func (o *AXBS_Type) GetPRS2_M4() uint32 {
	return (volatile.LoadUint32(&o.PRS2.Reg) & 0x70000) >> 16
}
func (o *AXBS_Type) SetPRS2_M5(value uint32) {
	volatile.StoreUint32(&o.PRS2.Reg, volatile.LoadUint32(&o.PRS2.Reg)&^(0x700000)|value<<20)
}
func (o *AXBS_Type) GetPRS2_M5() uint32 {
	return (volatile.LoadUint32(&o.PRS2.Reg) & 0x700000) >> 20
}

// AXBS.CRS2: Control Register
func (o *AXBS_Type) SetCRS2_PARK(value uint32) {
	volatile.StoreUint32(&o.CRS2.Reg, volatile.LoadUint32(&o.CRS2.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetCRS2_PARK() uint32 {
	return volatile.LoadUint32(&o.CRS2.Reg) & 0x7
}
func (o *AXBS_Type) SetCRS2_PCTL(value uint32) {
	volatile.StoreUint32(&o.CRS2.Reg, volatile.LoadUint32(&o.CRS2.Reg)&^(0x30)|value<<4)
}
func (o *AXBS_Type) GetCRS2_PCTL() uint32 {
	return (volatile.LoadUint32(&o.CRS2.Reg) & 0x30) >> 4
}
func (o *AXBS_Type) SetCRS2_ARB(value uint32) {
	volatile.StoreUint32(&o.CRS2.Reg, volatile.LoadUint32(&o.CRS2.Reg)&^(0x300)|value<<8)
}
func (o *AXBS_Type) GetCRS2_ARB() uint32 {
	return (volatile.LoadUint32(&o.CRS2.Reg) & 0x300) >> 8
}
func (o *AXBS_Type) SetCRS2_HLP(value uint32) {
	volatile.StoreUint32(&o.CRS2.Reg, volatile.LoadUint32(&o.CRS2.Reg)&^(0x40000000)|value<<30)
}
func (o *AXBS_Type) GetCRS2_HLP() uint32 {
	return (volatile.LoadUint32(&o.CRS2.Reg) & 0x40000000) >> 30
}
func (o *AXBS_Type) SetCRS2_RO(value uint32) {
	volatile.StoreUint32(&o.CRS2.Reg, volatile.LoadUint32(&o.CRS2.Reg)&^(0x80000000)|value<<31)
}
func (o *AXBS_Type) GetCRS2_RO() uint32 {
	return (volatile.LoadUint32(&o.CRS2.Reg) & 0x80000000) >> 31
}

// AXBS.PRS3: Priority Registers Slave
func (o *AXBS_Type) SetPRS3_M0(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetPRS3_M0() uint32 {
	return volatile.LoadUint32(&o.PRS3.Reg) & 0x7
}
func (o *AXBS_Type) SetPRS3_M1(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x70)|value<<4)
}
func (o *AXBS_Type) GetPRS3_M1() uint32 {
	return (volatile.LoadUint32(&o.PRS3.Reg) & 0x70) >> 4
}
func (o *AXBS_Type) SetPRS3_M2(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x700)|value<<8)
}
func (o *AXBS_Type) GetPRS3_M2() uint32 {
	return (volatile.LoadUint32(&o.PRS3.Reg) & 0x700) >> 8
}
func (o *AXBS_Type) SetPRS3_M3(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x7000)|value<<12)
}
func (o *AXBS_Type) GetPRS3_M3() uint32 {
	return (volatile.LoadUint32(&o.PRS3.Reg) & 0x7000) >> 12
}
func (o *AXBS_Type) SetPRS3_M4(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x70000)|value<<16)
}
func (o *AXBS_Type) GetPRS3_M4() uint32 {
	return (volatile.LoadUint32(&o.PRS3.Reg) & 0x70000) >> 16
}
func (o *AXBS_Type) SetPRS3_M5(value uint32) {
	volatile.StoreUint32(&o.PRS3.Reg, volatile.LoadUint32(&o.PRS3.Reg)&^(0x700000)|value<<20)
}
func (o *AXBS_Type) GetPRS3_M5() uint32 {
	return (volatile.LoadUint32(&o.PRS3.Reg) & 0x700000) >> 20
}

// AXBS.CRS3: Control Register
func (o *AXBS_Type) SetCRS3_PARK(value uint32) {
	volatile.StoreUint32(&o.CRS3.Reg, volatile.LoadUint32(&o.CRS3.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetCRS3_PARK() uint32 {
	return volatile.LoadUint32(&o.CRS3.Reg) & 0x7
}
func (o *AXBS_Type) SetCRS3_PCTL(value uint32) {
	volatile.StoreUint32(&o.CRS3.Reg, volatile.LoadUint32(&o.CRS3.Reg)&^(0x30)|value<<4)
}
func (o *AXBS_Type) GetCRS3_PCTL() uint32 {
	return (volatile.LoadUint32(&o.CRS3.Reg) & 0x30) >> 4
}
func (o *AXBS_Type) SetCRS3_ARB(value uint32) {
	volatile.StoreUint32(&o.CRS3.Reg, volatile.LoadUint32(&o.CRS3.Reg)&^(0x300)|value<<8)
}
func (o *AXBS_Type) GetCRS3_ARB() uint32 {
	return (volatile.LoadUint32(&o.CRS3.Reg) & 0x300) >> 8
}
func (o *AXBS_Type) SetCRS3_HLP(value uint32) {
	volatile.StoreUint32(&o.CRS3.Reg, volatile.LoadUint32(&o.CRS3.Reg)&^(0x40000000)|value<<30)
}
func (o *AXBS_Type) GetCRS3_HLP() uint32 {
	return (volatile.LoadUint32(&o.CRS3.Reg) & 0x40000000) >> 30
}
func (o *AXBS_Type) SetCRS3_RO(value uint32) {
	volatile.StoreUint32(&o.CRS3.Reg, volatile.LoadUint32(&o.CRS3.Reg)&^(0x80000000)|value<<31)
}
func (o *AXBS_Type) GetCRS3_RO() uint32 {
	return (volatile.LoadUint32(&o.CRS3.Reg) & 0x80000000) >> 31
}

// AXBS.PRS4: Priority Registers Slave
func (o *AXBS_Type) SetPRS4_M0(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetPRS4_M0() uint32 {
	return volatile.LoadUint32(&o.PRS4.Reg) & 0x7
}
func (o *AXBS_Type) SetPRS4_M1(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x70)|value<<4)
}
func (o *AXBS_Type) GetPRS4_M1() uint32 {
	return (volatile.LoadUint32(&o.PRS4.Reg) & 0x70) >> 4
}
func (o *AXBS_Type) SetPRS4_M2(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x700)|value<<8)
}
func (o *AXBS_Type) GetPRS4_M2() uint32 {
	return (volatile.LoadUint32(&o.PRS4.Reg) & 0x700) >> 8
}
func (o *AXBS_Type) SetPRS4_M3(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x7000)|value<<12)
}
func (o *AXBS_Type) GetPRS4_M3() uint32 {
	return (volatile.LoadUint32(&o.PRS4.Reg) & 0x7000) >> 12
}
func (o *AXBS_Type) SetPRS4_M4(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x70000)|value<<16)
}
func (o *AXBS_Type) GetPRS4_M4() uint32 {
	return (volatile.LoadUint32(&o.PRS4.Reg) & 0x70000) >> 16
}
func (o *AXBS_Type) SetPRS4_M5(value uint32) {
	volatile.StoreUint32(&o.PRS4.Reg, volatile.LoadUint32(&o.PRS4.Reg)&^(0x700000)|value<<20)
}
func (o *AXBS_Type) GetPRS4_M5() uint32 {
	return (volatile.LoadUint32(&o.PRS4.Reg) & 0x700000) >> 20
}

// AXBS.CRS4: Control Register
func (o *AXBS_Type) SetCRS4_PARK(value uint32) {
	volatile.StoreUint32(&o.CRS4.Reg, volatile.LoadUint32(&o.CRS4.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetCRS4_PARK() uint32 {
	return volatile.LoadUint32(&o.CRS4.Reg) & 0x7
}
func (o *AXBS_Type) SetCRS4_PCTL(value uint32) {
	volatile.StoreUint32(&o.CRS4.Reg, volatile.LoadUint32(&o.CRS4.Reg)&^(0x30)|value<<4)
}
func (o *AXBS_Type) GetCRS4_PCTL() uint32 {
	return (volatile.LoadUint32(&o.CRS4.Reg) & 0x30) >> 4
}
func (o *AXBS_Type) SetCRS4_ARB(value uint32) {
	volatile.StoreUint32(&o.CRS4.Reg, volatile.LoadUint32(&o.CRS4.Reg)&^(0x300)|value<<8)
}
func (o *AXBS_Type) GetCRS4_ARB() uint32 {
	return (volatile.LoadUint32(&o.CRS4.Reg) & 0x300) >> 8
}
func (o *AXBS_Type) SetCRS4_HLP(value uint32) {
	volatile.StoreUint32(&o.CRS4.Reg, volatile.LoadUint32(&o.CRS4.Reg)&^(0x40000000)|value<<30)
}
func (o *AXBS_Type) GetCRS4_HLP() uint32 {
	return (volatile.LoadUint32(&o.CRS4.Reg) & 0x40000000) >> 30
}
func (o *AXBS_Type) SetCRS4_RO(value uint32) {
	volatile.StoreUint32(&o.CRS4.Reg, volatile.LoadUint32(&o.CRS4.Reg)&^(0x80000000)|value<<31)
}
func (o *AXBS_Type) GetCRS4_RO() uint32 {
	return (volatile.LoadUint32(&o.CRS4.Reg) & 0x80000000) >> 31
}

// AXBS.MGPCR0: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR0_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR0.Reg, volatile.LoadUint32(&o.MGPCR0.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR0_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR0.Reg) & 0x7
}

// AXBS.MGPCR1: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR1_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR1.Reg, volatile.LoadUint32(&o.MGPCR1.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR1_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR1.Reg) & 0x7
}

// AXBS.MGPCR2: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR2_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR2.Reg, volatile.LoadUint32(&o.MGPCR2.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR2_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR2.Reg) & 0x7
}

// AXBS.MGPCR3: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR3_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR3.Reg, volatile.LoadUint32(&o.MGPCR3.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR3_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR3.Reg) & 0x7
}

// AXBS.MGPCR4: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR4_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR4.Reg, volatile.LoadUint32(&o.MGPCR4.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR4_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR4.Reg) & 0x7
}

// AXBS.MGPCR5: Master General Purpose Control Register
func (o *AXBS_Type) SetMGPCR5_AULB(value uint32) {
	volatile.StoreUint32(&o.MGPCR5.Reg, volatile.LoadUint32(&o.MGPCR5.Reg)&^(0x7)|value)
}
func (o *AXBS_Type) GetMGPCR5_AULB() uint32 {
	return volatile.LoadUint32(&o.MGPCR5.Reg) & 0x7
}

// Enhanced direct memory access controller
type DMA_Type struct {
	CR                  volatile.Register32 // 0x0
	ES                  volatile.Register32 // 0x4
	_                   [4]byte
	ERQ                 volatile.Register32 // 0xC
	_                   [4]byte
	EEI                 volatile.Register32 // 0x14
	CEEI                volatile.Register8  // 0x18
	SEEI                volatile.Register8  // 0x19
	CERQ                volatile.Register8  // 0x1A
	SERQ                volatile.Register8  // 0x1B
	CDNE                volatile.Register8  // 0x1C
	SSRT                volatile.Register8  // 0x1D
	CERR                volatile.Register8  // 0x1E
	CINT                volatile.Register8  // 0x1F
	_                   [4]byte
	INT                 volatile.Register32 // 0x24
	_                   [4]byte
	ERR                 volatile.Register32 // 0x2C
	_                   [4]byte
	HRS                 volatile.Register32 // 0x34
	_                   [200]byte
	DCHPRI3             volatile.Register8 // 0x100
	DCHPRI2             volatile.Register8 // 0x101
	DCHPRI1             volatile.Register8 // 0x102
	DCHPRI0             volatile.Register8 // 0x103
	DCHPRI7             volatile.Register8 // 0x104
	DCHPRI6             volatile.Register8 // 0x105
	DCHPRI5             volatile.Register8 // 0x106
	DCHPRI4             volatile.Register8 // 0x107
	DCHPRI11            volatile.Register8 // 0x108
	DCHPRI10            volatile.Register8 // 0x109
	DCHPRI9             volatile.Register8 // 0x10A
	DCHPRI8             volatile.Register8 // 0x10B
	DCHPRI15            volatile.Register8 // 0x10C
	DCHPRI14            volatile.Register8 // 0x10D
	DCHPRI13            volatile.Register8 // 0x10E
	DCHPRI12            volatile.Register8 // 0x10F
	_                   [3824]byte
	TCD0_SADDR          volatile.Register32 // 0x1000
	TCD0_SOFF           volatile.Register16 // 0x1004
	TCD0_ATTR           volatile.Register16 // 0x1006
	TCD0_NBYTES_MLNO    volatile.Register32 // 0x1008
	TCD0_SLAST          volatile.Register32 // 0x100C
	TCD0_DADDR          volatile.Register32 // 0x1010
	TCD0_DOFF           volatile.Register16 // 0x1014
	TCD0_CITER_ELINKNO  volatile.Register16 // 0x1016
	TCD0_DLASTSGA       volatile.Register32 // 0x1018
	TCD0_CSR            volatile.Register16 // 0x101C
	TCD0_BITER_ELINKNO  volatile.Register16 // 0x101E
	TCD1_SADDR          volatile.Register32 // 0x1020
	TCD1_SOFF           volatile.Register16 // 0x1024
	TCD1_ATTR           volatile.Register16 // 0x1026
	TCD1_NBYTES_MLNO    volatile.Register32 // 0x1028
	TCD1_SLAST          volatile.Register32 // 0x102C
	TCD1_DADDR          volatile.Register32 // 0x1030
	TCD1_DOFF           volatile.Register16 // 0x1034
	TCD1_CITER_ELINKNO  volatile.Register16 // 0x1036
	TCD1_DLASTSGA       volatile.Register32 // 0x1038
	TCD1_CSR            volatile.Register16 // 0x103C
	TCD1_BITER_ELINKNO  volatile.Register16 // 0x103E
	TCD2_SADDR          volatile.Register32 // 0x1040
	TCD2_SOFF           volatile.Register16 // 0x1044
	TCD2_ATTR           volatile.Register16 // 0x1046
	TCD2_NBYTES_MLNO    volatile.Register32 // 0x1048
	TCD2_SLAST          volatile.Register32 // 0x104C
	TCD2_DADDR          volatile.Register32 // 0x1050
	TCD2_DOFF           volatile.Register16 // 0x1054
	TCD2_CITER_ELINKNO  volatile.Register16 // 0x1056
	TCD2_DLASTSGA       volatile.Register32 // 0x1058
	TCD2_CSR            volatile.Register16 // 0x105C
	TCD2_BITER_ELINKNO  volatile.Register16 // 0x105E
	TCD3_SADDR          volatile.Register32 // 0x1060
	TCD3_SOFF           volatile.Register16 // 0x1064
	TCD3_ATTR           volatile.Register16 // 0x1066
	TCD3_NBYTES_MLNO    volatile.Register32 // 0x1068
	TCD3_SLAST          volatile.Register32 // 0x106C
	TCD3_DADDR          volatile.Register32 // 0x1070
	TCD3_DOFF           volatile.Register16 // 0x1074
	TCD3_CITER_ELINKNO  volatile.Register16 // 0x1076
	TCD3_DLASTSGA       volatile.Register32 // 0x1078
	TCD3_CSR            volatile.Register16 // 0x107C
	TCD3_BITER_ELINKNO  volatile.Register16 // 0x107E
	TCD4_SADDR          volatile.Register32 // 0x1080
	TCD4_SOFF           volatile.Register16 // 0x1084
	TCD4_ATTR           volatile.Register16 // 0x1086
	TCD4_NBYTES_MLNO    volatile.Register32 // 0x1088
	TCD4_SLAST          volatile.Register32 // 0x108C
	TCD4_DADDR          volatile.Register32 // 0x1090
	TCD4_DOFF           volatile.Register16 // 0x1094
	TCD4_CITER_ELINKNO  volatile.Register16 // 0x1096
	TCD4_DLASTSGA       volatile.Register32 // 0x1098
	TCD4_CSR            volatile.Register16 // 0x109C
	TCD4_BITER_ELINKNO  volatile.Register16 // 0x109E
	TCD5_SADDR          volatile.Register32 // 0x10A0
	TCD5_SOFF           volatile.Register16 // 0x10A4
	TCD5_ATTR           volatile.Register16 // 0x10A6
	TCD5_NBYTES_MLNO    volatile.Register32 // 0x10A8
	TCD5_SLAST          volatile.Register32 // 0x10AC
	TCD5_DADDR          volatile.Register32 // 0x10B0
	TCD5_DOFF           volatile.Register16 // 0x10B4
	TCD5_CITER_ELINKNO  volatile.Register16 // 0x10B6
	TCD5_DLASTSGA       volatile.Register32 // 0x10B8
	TCD5_CSR            volatile.Register16 // 0x10BC
	TCD5_BITER_ELINKNO  volatile.Register16 // 0x10BE
	TCD6_SADDR          volatile.Register32 // 0x10C0
	TCD6_SOFF           volatile.Register16 // 0x10C4
	TCD6_ATTR           volatile.Register16 // 0x10C6
	TCD6_NBYTES_MLNO    volatile.Register32 // 0x10C8
	TCD6_SLAST          volatile.Register32 // 0x10CC
	TCD6_DADDR          volatile.Register32 // 0x10D0
	TCD6_DOFF           volatile.Register16 // 0x10D4
	TCD6_CITER_ELINKNO  volatile.Register16 // 0x10D6
	TCD6_DLASTSGA       volatile.Register32 // 0x10D8
	TCD6_CSR            volatile.Register16 // 0x10DC
	TCD6_BITER_ELINKNO  volatile.Register16 // 0x10DE
	TCD7_SADDR          volatile.Register32 // 0x10E0
	TCD7_SOFF           volatile.Register16 // 0x10E4
	TCD7_ATTR           volatile.Register16 // 0x10E6
	TCD7_NBYTES_MLNO    volatile.Register32 // 0x10E8
	TCD7_SLAST          volatile.Register32 // 0x10EC
	TCD7_DADDR          volatile.Register32 // 0x10F0
	TCD7_DOFF           volatile.Register16 // 0x10F4
	TCD7_CITER_ELINKNO  volatile.Register16 // 0x10F6
	TCD7_DLASTSGA       volatile.Register32 // 0x10F8
	TCD7_CSR            volatile.Register16 // 0x10FC
	TCD7_BITER_ELINKNO  volatile.Register16 // 0x10FE
	TCD8_SADDR          volatile.Register32 // 0x1100
	TCD8_SOFF           volatile.Register16 // 0x1104
	TCD8_ATTR           volatile.Register16 // 0x1106
	TCD8_NBYTES_MLNO    volatile.Register32 // 0x1108
	TCD8_SLAST          volatile.Register32 // 0x110C
	TCD8_DADDR          volatile.Register32 // 0x1110
	TCD8_DOFF           volatile.Register16 // 0x1114
	TCD8_CITER_ELINKNO  volatile.Register16 // 0x1116
	TCD8_DLASTSGA       volatile.Register32 // 0x1118
	TCD8_CSR            volatile.Register16 // 0x111C
	TCD8_BITER_ELINKNO  volatile.Register16 // 0x111E
	TCD9_SADDR          volatile.Register32 // 0x1120
	TCD9_SOFF           volatile.Register16 // 0x1124
	TCD9_ATTR           volatile.Register16 // 0x1126
	TCD9_NBYTES_MLNO    volatile.Register32 // 0x1128
	TCD9_SLAST          volatile.Register32 // 0x112C
	TCD9_DADDR          volatile.Register32 // 0x1130
	TCD9_DOFF           volatile.Register16 // 0x1134
	TCD9_CITER_ELINKNO  volatile.Register16 // 0x1136
	TCD9_DLASTSGA       volatile.Register32 // 0x1138
	TCD9_CSR            volatile.Register16 // 0x113C
	TCD9_BITER_ELINKNO  volatile.Register16 // 0x113E
	TCD10_SADDR         volatile.Register32 // 0x1140
	TCD10_SOFF          volatile.Register16 // 0x1144
	TCD10_ATTR          volatile.Register16 // 0x1146
	TCD10_NBYTES_MLNO   volatile.Register32 // 0x1148
	TCD10_SLAST         volatile.Register32 // 0x114C
	TCD10_DADDR         volatile.Register32 // 0x1150
	TCD10_DOFF          volatile.Register16 // 0x1154
	TCD10_CITER_ELINKNO volatile.Register16 // 0x1156
	TCD10_DLASTSGA      volatile.Register32 // 0x1158
	TCD10_CSR           volatile.Register16 // 0x115C
	TCD10_BITER_ELINKNO volatile.Register16 // 0x115E
	TCD11_SADDR         volatile.Register32 // 0x1160
	TCD11_SOFF          volatile.Register16 // 0x1164
	TCD11_ATTR          volatile.Register16 // 0x1166
	TCD11_NBYTES_MLNO   volatile.Register32 // 0x1168
	TCD11_SLAST         volatile.Register32 // 0x116C
	TCD11_DADDR         volatile.Register32 // 0x1170
	TCD11_DOFF          volatile.Register16 // 0x1174
	TCD11_CITER_ELINKNO volatile.Register16 // 0x1176
	TCD11_DLASTSGA      volatile.Register32 // 0x1178
	TCD11_CSR           volatile.Register16 // 0x117C
	TCD11_BITER_ELINKNO volatile.Register16 // 0x117E
	TCD12_SADDR         volatile.Register32 // 0x1180
	TCD12_SOFF          volatile.Register16 // 0x1184
	TCD12_ATTR          volatile.Register16 // 0x1186
	TCD12_NBYTES_MLNO   volatile.Register32 // 0x1188
	TCD12_SLAST         volatile.Register32 // 0x118C
	TCD12_DADDR         volatile.Register32 // 0x1190
	TCD12_DOFF          volatile.Register16 // 0x1194
	TCD12_CITER_ELINKNO volatile.Register16 // 0x1196
	TCD12_DLASTSGA      volatile.Register32 // 0x1198
	TCD12_CSR           volatile.Register16 // 0x119C
	TCD12_BITER_ELINKNO volatile.Register16 // 0x119E
	TCD13_SADDR         volatile.Register32 // 0x11A0
	TCD13_SOFF          volatile.Register16 // 0x11A4
	TCD13_ATTR          volatile.Register16 // 0x11A6
	TCD13_NBYTES_MLNO   volatile.Register32 // 0x11A8
	TCD13_SLAST         volatile.Register32 // 0x11AC
	TCD13_DADDR         volatile.Register32 // 0x11B0
	TCD13_DOFF          volatile.Register16 // 0x11B4
	TCD13_CITER_ELINKNO volatile.Register16 // 0x11B6
	TCD13_DLASTSGA      volatile.Register32 // 0x11B8
	TCD13_CSR           volatile.Register16 // 0x11BC
	TCD13_BITER_ELINKNO volatile.Register16 // 0x11BE
	TCD14_SADDR         volatile.Register32 // 0x11C0
	TCD14_SOFF          volatile.Register16 // 0x11C4
	TCD14_ATTR          volatile.Register16 // 0x11C6
	TCD14_NBYTES_MLNO   volatile.Register32 // 0x11C8
	TCD14_SLAST         volatile.Register32 // 0x11CC
	TCD14_DADDR         volatile.Register32 // 0x11D0
	TCD14_DOFF          volatile.Register16 // 0x11D4
	TCD14_CITER_ELINKNO volatile.Register16 // 0x11D6
	TCD14_DLASTSGA      volatile.Register32 // 0x11D8
	TCD14_CSR           volatile.Register16 // 0x11DC
	TCD14_BITER_ELINKNO volatile.Register16 // 0x11DE
	TCD15_SADDR         volatile.Register32 // 0x11E0
	TCD15_SOFF          volatile.Register16 // 0x11E4
	TCD15_ATTR          volatile.Register16 // 0x11E6
	TCD15_NBYTES_MLNO   volatile.Register32 // 0x11E8
	TCD15_SLAST         volatile.Register32 // 0x11EC
	TCD15_DADDR         volatile.Register32 // 0x11F0
	TCD15_DOFF          volatile.Register16 // 0x11F4
	TCD15_CITER_ELINKNO volatile.Register16 // 0x11F6
	TCD15_DLASTSGA      volatile.Register32 // 0x11F8
	TCD15_CSR           volatile.Register16 // 0x11FC
	TCD15_BITER_ELINKNO volatile.Register16 // 0x11FE
}

// DMA.CR: Control Register
func (o *DMA_Type) SetCR_EDBG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCR_EDBG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCR_ERCA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCR_ERCA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCR_HOE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCR_HOE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCR_HALT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCR_HALT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCR_CLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCR_CLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCR_EMLM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCR_EMLM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCR_ECX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetCR_ECX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetCR_CX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetCR_CX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}

// DMA.ES: Error Status Register
func (o *DMA_Type) SetES_DBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetES_DBE() uint32 {
	return volatile.LoadUint32(&o.ES.Reg) & 0x1
}
func (o *DMA_Type) SetES_SBE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetES_SBE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetES_SGE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetES_SGE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetES_NCE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetES_NCE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetES_DOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetES_DOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetES_DAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetES_DAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetES_SOE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetES_SOE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetES_SAE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetES_SAE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetES_ERRCHN(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetES_ERRCHN() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetES_CPE(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetES_CPE() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetES_ECX(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetES_ECX() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetES_VLD(value uint32) {
	volatile.StoreUint32(&o.ES.Reg, volatile.LoadUint32(&o.ES.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetES_VLD() uint32 {
	return (volatile.LoadUint32(&o.ES.Reg) & 0x80000000) >> 31
}

// DMA.ERQ: Enable Request Register
func (o *DMA_Type) SetERQ_ERQ0(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERQ_ERQ0() uint32 {
	return volatile.LoadUint32(&o.ERQ.Reg) & 0x1
}
func (o *DMA_Type) SetERQ_ERQ1(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERQ_ERQ1() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERQ_ERQ2(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERQ_ERQ2() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERQ_ERQ3(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERQ_ERQ3() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetERQ_ERQ4(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetERQ_ERQ4() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetERQ_ERQ5(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetERQ_ERQ5() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetERQ_ERQ6(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetERQ_ERQ6() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetERQ_ERQ7(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetERQ_ERQ7() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetERQ_ERQ8(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetERQ_ERQ8() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetERQ_ERQ9(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetERQ_ERQ9() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetERQ_ERQ10(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetERQ_ERQ10() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetERQ_ERQ11(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetERQ_ERQ11() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetERQ_ERQ12(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetERQ_ERQ12() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetERQ_ERQ13(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetERQ_ERQ13() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetERQ_ERQ14(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetERQ_ERQ14() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetERQ_ERQ15(value uint32) {
	volatile.StoreUint32(&o.ERQ.Reg, volatile.LoadUint32(&o.ERQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetERQ_ERQ15() uint32 {
	return (volatile.LoadUint32(&o.ERQ.Reg) & 0x8000) >> 15
}

// DMA.EEI: Enable Error Interrupt Register
func (o *DMA_Type) SetEEI_EEI0(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetEEI_EEI0() uint32 {
	return volatile.LoadUint32(&o.EEI.Reg) & 0x1
}
func (o *DMA_Type) SetEEI_EEI1(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetEEI_EEI1() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetEEI_EEI2(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetEEI_EEI2() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetEEI_EEI3(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetEEI_EEI3() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetEEI_EEI4(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetEEI_EEI4() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetEEI_EEI5(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetEEI_EEI5() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetEEI_EEI6(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetEEI_EEI6() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetEEI_EEI7(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetEEI_EEI7() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetEEI_EEI8(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetEEI_EEI8() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetEEI_EEI9(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetEEI_EEI9() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetEEI_EEI10(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetEEI_EEI10() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetEEI_EEI11(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetEEI_EEI11() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetEEI_EEI12(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetEEI_EEI12() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetEEI_EEI13(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetEEI_EEI13() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetEEI_EEI14(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetEEI_EEI14() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetEEI_EEI15(value uint32) {
	volatile.StoreUint32(&o.EEI.Reg, volatile.LoadUint32(&o.EEI.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetEEI_EEI15() uint32 {
	return (volatile.LoadUint32(&o.EEI.Reg) & 0x8000) >> 15
}

// DMA.CEEI: Clear Enable Error Interrupt Register
func (o *DMA_Type) SetCEEI(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCEEI() uint8 {
	return volatile.LoadUint8(&o.CEEI.Reg) & 0xf
}
func (o *DMA_Type) SetCEEI_CAEE(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCEEI_CAEE() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.CEEI.Reg, volatile.LoadUint8(&o.CEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.CEEI.Reg) & 0x80) >> 7
}

// DMA.SEEI: Set Enable Error Interrupt Register
func (o *DMA_Type) SetSEEI(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSEEI() uint8 {
	return volatile.LoadUint8(&o.SEEI.Reg) & 0xf
}
func (o *DMA_Type) SetSEEI_SAEE(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSEEI_SAEE() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSEEI_NOP(value uint8) {
	volatile.StoreUint8(&o.SEEI.Reg, volatile.LoadUint8(&o.SEEI.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSEEI_NOP() uint8 {
	return (volatile.LoadUint8(&o.SEEI.Reg) & 0x80) >> 7
}

// DMA.CERQ: Clear Enable Request Register
func (o *DMA_Type) SetCERQ(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCERQ() uint8 {
	return volatile.LoadUint8(&o.CERQ.Reg) & 0xf
}
func (o *DMA_Type) SetCERQ_CAER(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERQ_CAER() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.CERQ.Reg, volatile.LoadUint8(&o.CERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERQ.Reg) & 0x80) >> 7
}

// DMA.SERQ: Set Enable Request Register
func (o *DMA_Type) SetSERQ(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSERQ() uint8 {
	return volatile.LoadUint8(&o.SERQ.Reg) & 0xf
}
func (o *DMA_Type) SetSERQ_SAER(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSERQ_SAER() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSERQ_NOP(value uint8) {
	volatile.StoreUint8(&o.SERQ.Reg, volatile.LoadUint8(&o.SERQ.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSERQ_NOP() uint8 {
	return (volatile.LoadUint8(&o.SERQ.Reg) & 0x80) >> 7
}

// DMA.CDNE: Clear DONE Status Bit Register
func (o *DMA_Type) SetCDNE(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCDNE() uint8 {
	return volatile.LoadUint8(&o.CDNE.Reg) & 0xf
}
func (o *DMA_Type) SetCDNE_CADN(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCDNE_CADN() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCDNE_NOP(value uint8) {
	volatile.StoreUint8(&o.CDNE.Reg, volatile.LoadUint8(&o.CDNE.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCDNE_NOP() uint8 {
	return (volatile.LoadUint8(&o.CDNE.Reg) & 0x80) >> 7
}

// DMA.SSRT: Set START Bit Register
func (o *DMA_Type) SetSSRT(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetSSRT() uint8 {
	return volatile.LoadUint8(&o.SSRT.Reg) & 0xf
}
func (o *DMA_Type) SetSSRT_SAST(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetSSRT_SAST() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetSSRT_NOP(value uint8) {
	volatile.StoreUint8(&o.SSRT.Reg, volatile.LoadUint8(&o.SSRT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetSSRT_NOP() uint8 {
	return (volatile.LoadUint8(&o.SSRT.Reg) & 0x80) >> 7
}

// DMA.CERR: Clear Error Register
func (o *DMA_Type) SetCERR(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCERR() uint8 {
	return volatile.LoadUint8(&o.CERR.Reg) & 0xf
}
func (o *DMA_Type) SetCERR_CAEI(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCERR_CAEI() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCERR_NOP(value uint8) {
	volatile.StoreUint8(&o.CERR.Reg, volatile.LoadUint8(&o.CERR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCERR_NOP() uint8 {
	return (volatile.LoadUint8(&o.CERR.Reg) & 0x80) >> 7
}

// DMA.CINT: Clear Interrupt Request Register
func (o *DMA_Type) SetCINT(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetCINT() uint8 {
	return volatile.LoadUint8(&o.CINT.Reg) & 0xf
}
func (o *DMA_Type) SetCINT_CAIR(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCINT_CAIR() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCINT_NOP(value uint8) {
	volatile.StoreUint8(&o.CINT.Reg, volatile.LoadUint8(&o.CINT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCINT_NOP() uint8 {
	return (volatile.LoadUint8(&o.CINT.Reg) & 0x80) >> 7
}

// DMA.INT: Interrupt Request Register
func (o *DMA_Type) SetINT_INT0(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINT_INT0() uint32 {
	return volatile.LoadUint32(&o.INT.Reg) & 0x1
}
func (o *DMA_Type) SetINT_INT1(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINT_INT1() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINT_INT2(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetINT_INT2() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetINT_INT3(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetINT_INT3() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetINT_INT4(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetINT_INT4() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetINT_INT5(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetINT_INT5() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetINT_INT6(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetINT_INT6() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetINT_INT7(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetINT_INT7() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetINT_INT8(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetINT_INT8() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetINT_INT9(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetINT_INT9() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetINT_INT10(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetINT_INT10() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetINT_INT11(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetINT_INT11() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetINT_INT12(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetINT_INT12() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetINT_INT13(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetINT_INT13() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetINT_INT14(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetINT_INT14() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetINT_INT15(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetINT_INT15() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0x8000) >> 15
}

// DMA.ERR: Error Register
func (o *DMA_Type) SetERR_ERR0(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetERR_ERR0() uint32 {
	return volatile.LoadUint32(&o.ERR.Reg) & 0x1
}
func (o *DMA_Type) SetERR_ERR1(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetERR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetERR_ERR2(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetERR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetERR_ERR3(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetERR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetERR_ERR4(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetERR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetERR_ERR5(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetERR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetERR_ERR6(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetERR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetERR_ERR7(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetERR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetERR_ERR8(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetERR_ERR8() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetERR_ERR9(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetERR_ERR9() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetERR_ERR10(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetERR_ERR10() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetERR_ERR11(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetERR_ERR11() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetERR_ERR12(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetERR_ERR12() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetERR_ERR13(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetERR_ERR13() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetERR_ERR14(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetERR_ERR14() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetERR_ERR15(value uint32) {
	volatile.StoreUint32(&o.ERR.Reg, volatile.LoadUint32(&o.ERR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetERR_ERR15() uint32 {
	return (volatile.LoadUint32(&o.ERR.Reg) & 0x8000) >> 15
}

// DMA.HRS: Hardware Request Status Register
func (o *DMA_Type) SetHRS_HRS0(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHRS_HRS0() uint32 {
	return volatile.LoadUint32(&o.HRS.Reg) & 0x1
}
func (o *DMA_Type) SetHRS_HRS1(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetHRS_HRS1() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetHRS_HRS2(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHRS_HRS2() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHRS_HRS3(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHRS_HRS3() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHRS_HRS4(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHRS_HRS4() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHRS_HRS5(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHRS_HRS5() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHRS_HRS6(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHRS_HRS6() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHRS_HRS7(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetHRS_HRS7() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetHRS_HRS8(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHRS_HRS8() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHRS_HRS9(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHRS_HRS9() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHRS_HRS10(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHRS_HRS10() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHRS_HRS11(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHRS_HRS11() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHRS_HRS12(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetHRS_HRS12() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetHRS_HRS13(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetHRS_HRS13() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetHRS_HRS14(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetHRS_HRS14() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetHRS_HRS15(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetHRS_HRS15() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0x8000) >> 15
}

// DMA.DCHPRI3: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI3_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI3_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI3.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI3_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI3_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI3_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI3.Reg, volatile.LoadUint8(&o.DCHPRI3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI3_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI3.Reg) & 0x80) >> 7
}

// DMA.DCHPRI2: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI2_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI2_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI2.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI2_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI2_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI2_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI2.Reg, volatile.LoadUint8(&o.DCHPRI2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI2_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI2.Reg) & 0x80) >> 7
}

// DMA.DCHPRI1: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI1_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI1_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI1.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI1_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI1_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI1_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI1.Reg, volatile.LoadUint8(&o.DCHPRI1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI1_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI1.Reg) & 0x80) >> 7
}

// DMA.DCHPRI0: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI0_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI0_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI0.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI0_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI0_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI0_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI0.Reg, volatile.LoadUint8(&o.DCHPRI0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI0_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI0.Reg) & 0x80) >> 7
}

// DMA.DCHPRI7: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI7_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI7_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI7.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI7_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI7_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI7_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI7.Reg, volatile.LoadUint8(&o.DCHPRI7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI7_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI7.Reg) & 0x80) >> 7
}

// DMA.DCHPRI6: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI6_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI6_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI6.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI6_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI6_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI6_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI6.Reg, volatile.LoadUint8(&o.DCHPRI6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI6_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI6.Reg) & 0x80) >> 7
}

// DMA.DCHPRI5: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI5_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI5_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI5.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI5_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI5_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI5_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI5.Reg, volatile.LoadUint8(&o.DCHPRI5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI5_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI5.Reg) & 0x80) >> 7
}

// DMA.DCHPRI4: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI4_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI4_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI4.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI4_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI4_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI4_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI4.Reg, volatile.LoadUint8(&o.DCHPRI4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI4_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI4.Reg) & 0x80) >> 7
}

// DMA.DCHPRI11: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI11_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI11_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI11.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI11_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI11_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI11.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI11_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI11.Reg, volatile.LoadUint8(&o.DCHPRI11.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI11_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI11.Reg) & 0x80) >> 7
}

// DMA.DCHPRI10: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI10_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI10_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI10.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI10_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI10_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI10.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI10_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI10.Reg, volatile.LoadUint8(&o.DCHPRI10.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI10_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI10.Reg) & 0x80) >> 7
}

// DMA.DCHPRI9: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI9_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI9_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI9.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI9_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI9_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI9.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI9_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI9.Reg, volatile.LoadUint8(&o.DCHPRI9.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI9_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI9.Reg) & 0x80) >> 7
}

// DMA.DCHPRI8: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI8_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI8_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI8.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI8_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI8_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI8.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI8_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI8.Reg, volatile.LoadUint8(&o.DCHPRI8.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI8_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI8.Reg) & 0x80) >> 7
}

// DMA.DCHPRI15: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI15_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI15_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI15.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI15_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI15_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI15.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI15_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI15.Reg, volatile.LoadUint8(&o.DCHPRI15.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI15_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI15.Reg) & 0x80) >> 7
}

// DMA.DCHPRI14: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI14_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI14_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI14.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI14_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI14_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI14.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI14_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI14.Reg, volatile.LoadUint8(&o.DCHPRI14.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI14_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI14.Reg) & 0x80) >> 7
}

// DMA.DCHPRI13: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI13_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI13_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI13.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI13_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI13_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI13.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI13_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI13.Reg, volatile.LoadUint8(&o.DCHPRI13.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI13_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI13.Reg) & 0x80) >> 7
}

// DMA.DCHPRI12: Channel n Priority Register
func (o *DMA_Type) SetDCHPRI12_CHPRI(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetDCHPRI12_CHPRI() uint8 {
	return volatile.LoadUint8(&o.DCHPRI12.Reg) & 0xf
}
func (o *DMA_Type) SetDCHPRI12_DPA(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetDCHPRI12_DPA() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI12.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetDCHPRI12_ECP(value uint8) {
	volatile.StoreUint8(&o.DCHPRI12.Reg, volatile.LoadUint8(&o.DCHPRI12.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCHPRI12_ECP() uint8 {
	return (volatile.LoadUint8(&o.DCHPRI12.Reg) & 0x80) >> 7
}

// DMA.TCD0_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD0_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_SADDR.Reg)
}

// DMA.TCD0_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD0_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_SOFF.Reg)
}

// DMA.TCD0_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD0_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD0_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD0_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD0_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD0_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD0_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD0_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD0_ATTR.Reg, volatile.LoadUint16(&o.TCD0_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD0_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD0_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD0_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD0_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD0_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD0_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD0_NBYTES_MLNO.Reg)
}

// DMA.TCD0_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD0_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD0_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD0_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD0_SLAST.Reg)
}

// DMA.TCD0_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD0_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD0_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD0_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD0_DADDR.Reg)
}

// DMA.TCD0_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD0_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD0_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD0_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD0_DOFF.Reg)
}

// DMA.TCD0_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD0_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD0_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD0_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD0_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD0_DLASTSGA.Reg)
}

// DMA.TCD0_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD0_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD0_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD0_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD0_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD0_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD0_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD0_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD0_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD0_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD0_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD0_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD0_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD0_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD0_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD0_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD0_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD0_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD0_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD0_CSR.Reg, volatile.LoadUint16(&o.TCD0_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD0_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD0_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD0_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD0_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD0_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD0_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD0_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD1_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_SADDR.Reg)
}

// DMA.TCD1_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD1_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_SOFF.Reg)
}

// DMA.TCD1_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD1_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD1_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD1_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD1_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD1_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD1_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD1_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD1_ATTR.Reg, volatile.LoadUint16(&o.TCD1_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD1_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD1_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD1_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD1_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD1_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD1_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD1_NBYTES_MLNO.Reg)
}

// DMA.TCD1_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD1_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD1_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD1_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD1_SLAST.Reg)
}

// DMA.TCD1_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD1_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD1_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD1_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD1_DADDR.Reg)
}

// DMA.TCD1_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD1_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD1_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD1_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD1_DOFF.Reg)
}

// DMA.TCD1_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD1_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD1_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD1_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD1_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD1_DLASTSGA.Reg)
}

// DMA.TCD1_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD1_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD1_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD1_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD1_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD1_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD1_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD1_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD1_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD1_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD1_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD1_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD1_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD1_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD1_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD1_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD1_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD1_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD1_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD1_CSR.Reg, volatile.LoadUint16(&o.TCD1_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD1_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD1_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD1_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD1_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD1_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD1_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD1_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD2_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_SADDR.Reg)
}

// DMA.TCD2_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD2_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_SOFF.Reg)
}

// DMA.TCD2_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD2_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD2_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD2_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD2_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD2_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD2_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD2_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD2_ATTR.Reg, volatile.LoadUint16(&o.TCD2_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD2_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD2_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD2_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD2_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD2_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD2_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD2_NBYTES_MLNO.Reg)
}

// DMA.TCD2_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD2_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD2_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD2_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD2_SLAST.Reg)
}

// DMA.TCD2_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD2_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD2_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD2_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD2_DADDR.Reg)
}

// DMA.TCD2_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD2_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD2_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD2_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD2_DOFF.Reg)
}

// DMA.TCD2_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD2_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD2_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD2_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD2_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD2_DLASTSGA.Reg)
}

// DMA.TCD2_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD2_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD2_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD2_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD2_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD2_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD2_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD2_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD2_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD2_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD2_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD2_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD2_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD2_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD2_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD2_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD2_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD2_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD2_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD2_CSR.Reg, volatile.LoadUint16(&o.TCD2_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD2_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD2_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD2_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD2_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD2_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD2_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD2_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD3_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_SADDR.Reg)
}

// DMA.TCD3_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD3_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_SOFF.Reg)
}

// DMA.TCD3_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD3_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD3_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD3_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD3_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD3_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD3_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD3_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD3_ATTR.Reg, volatile.LoadUint16(&o.TCD3_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD3_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD3_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD3_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD3_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD3_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD3_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD3_NBYTES_MLNO.Reg)
}

// DMA.TCD3_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD3_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD3_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD3_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD3_SLAST.Reg)
}

// DMA.TCD3_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD3_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD3_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD3_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD3_DADDR.Reg)
}

// DMA.TCD3_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD3_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD3_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD3_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD3_DOFF.Reg)
}

// DMA.TCD3_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD3_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD3_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD3_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD3_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD3_DLASTSGA.Reg)
}

// DMA.TCD3_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD3_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD3_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD3_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD3_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD3_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD3_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD3_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD3_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD3_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD3_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD3_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD3_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD3_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD3_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD3_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD3_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD3_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD3_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD3_CSR.Reg, volatile.LoadUint16(&o.TCD3_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD3_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD3_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD3_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD3_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD3_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD3_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD3_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD4_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD4_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD4_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD4_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD4_SADDR.Reg)
}

// DMA.TCD4_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD4_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD4_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD4_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD4_SOFF.Reg)
}

// DMA.TCD4_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD4_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD4_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD4_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD4_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD4_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD4_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD4_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD4_ATTR.Reg, volatile.LoadUint16(&o.TCD4_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD4_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD4_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD4_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD4_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD4_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD4_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD4_NBYTES_MLNO.Reg)
}

// DMA.TCD4_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD4_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD4_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD4_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD4_SLAST.Reg)
}

// DMA.TCD4_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD4_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD4_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD4_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD4_DADDR.Reg)
}

// DMA.TCD4_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD4_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD4_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD4_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD4_DOFF.Reg)
}

// DMA.TCD4_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD4_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD4_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD4_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD4_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD4_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD4_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD4_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD4_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD4_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD4_DLASTSGA.Reg)
}

// DMA.TCD4_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD4_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD4_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD4_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD4_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD4_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD4_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD4_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD4_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD4_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD4_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD4_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD4_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD4_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD4_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD4_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD4_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD4_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD4_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD4_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD4_CSR.Reg, volatile.LoadUint16(&o.TCD4_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD4_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD4_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD4_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD4_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD4_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD4_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD4_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD4_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD4_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD4_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD5_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD5_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD5_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD5_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD5_SADDR.Reg)
}

// DMA.TCD5_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD5_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD5_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD5_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD5_SOFF.Reg)
}

// DMA.TCD5_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD5_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD5_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD5_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD5_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD5_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD5_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD5_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD5_ATTR.Reg, volatile.LoadUint16(&o.TCD5_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD5_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD5_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD5_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD5_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD5_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD5_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD5_NBYTES_MLNO.Reg)
}

// DMA.TCD5_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD5_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD5_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD5_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD5_SLAST.Reg)
}

// DMA.TCD5_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD5_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD5_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD5_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD5_DADDR.Reg)
}

// DMA.TCD5_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD5_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD5_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD5_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD5_DOFF.Reg)
}

// DMA.TCD5_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD5_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD5_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD5_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD5_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD5_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD5_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD5_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD5_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD5_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD5_DLASTSGA.Reg)
}

// DMA.TCD5_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD5_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD5_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD5_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD5_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD5_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD5_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD5_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD5_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD5_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD5_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD5_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD5_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD5_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD5_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD5_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD5_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD5_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD5_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD5_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD5_CSR.Reg, volatile.LoadUint16(&o.TCD5_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD5_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD5_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD5_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD5_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD5_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD5_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD5_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD5_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD5_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD5_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD6_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD6_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD6_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD6_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD6_SADDR.Reg)
}

// DMA.TCD6_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD6_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD6_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD6_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD6_SOFF.Reg)
}

// DMA.TCD6_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD6_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD6_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD6_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD6_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD6_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD6_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD6_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD6_ATTR.Reg, volatile.LoadUint16(&o.TCD6_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD6_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD6_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD6_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD6_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD6_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD6_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD6_NBYTES_MLNO.Reg)
}

// DMA.TCD6_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD6_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD6_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD6_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD6_SLAST.Reg)
}

// DMA.TCD6_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD6_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD6_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD6_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD6_DADDR.Reg)
}

// DMA.TCD6_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD6_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD6_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD6_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD6_DOFF.Reg)
}

// DMA.TCD6_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD6_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD6_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD6_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD6_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD6_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD6_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD6_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD6_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD6_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD6_DLASTSGA.Reg)
}

// DMA.TCD6_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD6_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD6_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD6_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD6_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD6_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD6_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD6_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD6_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD6_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD6_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD6_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD6_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD6_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD6_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD6_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD6_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD6_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD6_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD6_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD6_CSR.Reg, volatile.LoadUint16(&o.TCD6_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD6_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD6_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD6_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD6_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD6_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD6_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD6_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD6_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD6_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD6_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD7_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD7_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD7_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD7_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD7_SADDR.Reg)
}

// DMA.TCD7_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD7_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD7_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD7_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD7_SOFF.Reg)
}

// DMA.TCD7_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD7_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD7_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD7_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD7_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD7_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD7_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD7_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD7_ATTR.Reg, volatile.LoadUint16(&o.TCD7_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD7_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD7_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD7_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD7_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD7_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD7_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD7_NBYTES_MLNO.Reg)
}

// DMA.TCD7_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD7_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD7_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD7_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD7_SLAST.Reg)
}

// DMA.TCD7_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD7_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD7_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD7_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD7_DADDR.Reg)
}

// DMA.TCD7_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD7_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD7_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD7_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD7_DOFF.Reg)
}

// DMA.TCD7_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD7_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD7_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD7_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD7_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD7_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD7_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD7_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD7_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD7_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD7_DLASTSGA.Reg)
}

// DMA.TCD7_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD7_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD7_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD7_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD7_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD7_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD7_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD7_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD7_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD7_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD7_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD7_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD7_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD7_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD7_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD7_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD7_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD7_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD7_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD7_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD7_CSR.Reg, volatile.LoadUint16(&o.TCD7_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD7_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD7_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD7_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD7_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD7_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD7_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD7_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD7_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD7_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD7_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD8_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD8_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD8_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD8_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD8_SADDR.Reg)
}

// DMA.TCD8_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD8_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD8_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD8_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD8_SOFF.Reg)
}

// DMA.TCD8_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD8_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD8_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD8_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD8_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD8_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD8_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD8_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD8_ATTR.Reg, volatile.LoadUint16(&o.TCD8_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD8_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD8_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD8_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD8_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD8_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD8_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD8_NBYTES_MLNO.Reg)
}

// DMA.TCD8_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD8_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD8_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD8_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD8_SLAST.Reg)
}

// DMA.TCD8_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD8_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD8_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD8_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD8_DADDR.Reg)
}

// DMA.TCD8_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD8_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD8_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD8_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD8_DOFF.Reg)
}

// DMA.TCD8_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD8_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD8_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD8_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD8_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD8_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD8_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD8_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD8_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD8_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD8_DLASTSGA.Reg)
}

// DMA.TCD8_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD8_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD8_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD8_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD8_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD8_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD8_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD8_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD8_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD8_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD8_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD8_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD8_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD8_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD8_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD8_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD8_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD8_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD8_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD8_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD8_CSR.Reg, volatile.LoadUint16(&o.TCD8_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD8_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD8_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD8_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD8_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD8_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD8_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD8_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD8_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD8_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD8_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD9_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD9_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD9_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD9_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD9_SADDR.Reg)
}

// DMA.TCD9_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD9_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD9_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD9_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD9_SOFF.Reg)
}

// DMA.TCD9_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD9_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD9_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD9_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD9_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD9_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD9_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD9_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD9_ATTR.Reg, volatile.LoadUint16(&o.TCD9_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD9_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD9_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD9_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD9_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD9_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD9_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD9_NBYTES_MLNO.Reg)
}

// DMA.TCD9_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD9_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD9_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD9_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD9_SLAST.Reg)
}

// DMA.TCD9_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD9_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD9_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD9_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD9_DADDR.Reg)
}

// DMA.TCD9_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD9_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD9_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD9_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD9_DOFF.Reg)
}

// DMA.TCD9_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD9_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD9_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD9_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD9_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD9_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD9_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD9_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD9_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD9_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD9_DLASTSGA.Reg)
}

// DMA.TCD9_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD9_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD9_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD9_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD9_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD9_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD9_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD9_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD9_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD9_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD9_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD9_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD9_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD9_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD9_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD9_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD9_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD9_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD9_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD9_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD9_CSR.Reg, volatile.LoadUint16(&o.TCD9_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD9_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD9_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD9_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD9_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD9_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD9_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD9_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD9_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD9_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD9_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD10_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD10_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD10_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD10_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD10_SADDR.Reg)
}

// DMA.TCD10_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD10_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD10_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD10_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD10_SOFF.Reg)
}

// DMA.TCD10_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD10_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD10_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD10_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD10_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD10_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD10_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD10_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD10_ATTR.Reg, volatile.LoadUint16(&o.TCD10_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD10_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD10_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD10_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD10_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD10_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD10_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD10_NBYTES_MLNO.Reg)
}

// DMA.TCD10_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD10_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD10_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD10_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD10_SLAST.Reg)
}

// DMA.TCD10_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD10_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD10_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD10_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD10_DADDR.Reg)
}

// DMA.TCD10_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD10_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD10_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD10_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD10_DOFF.Reg)
}

// DMA.TCD10_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD10_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD10_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD10_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD10_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD10_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD10_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD10_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD10_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD10_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD10_DLASTSGA.Reg)
}

// DMA.TCD10_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD10_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD10_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD10_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD10_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD10_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD10_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD10_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD10_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD10_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD10_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD10_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD10_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD10_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD10_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD10_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD10_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD10_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD10_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD10_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD10_CSR.Reg, volatile.LoadUint16(&o.TCD10_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD10_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD10_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD10_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD10_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD10_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD10_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD10_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD10_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD10_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD10_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD11_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD11_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD11_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD11_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD11_SADDR.Reg)
}

// DMA.TCD11_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD11_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD11_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD11_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD11_SOFF.Reg)
}

// DMA.TCD11_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD11_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD11_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD11_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD11_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD11_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD11_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD11_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD11_ATTR.Reg, volatile.LoadUint16(&o.TCD11_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD11_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD11_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD11_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD11_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD11_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD11_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD11_NBYTES_MLNO.Reg)
}

// DMA.TCD11_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD11_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD11_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD11_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD11_SLAST.Reg)
}

// DMA.TCD11_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD11_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD11_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD11_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD11_DADDR.Reg)
}

// DMA.TCD11_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD11_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD11_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD11_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD11_DOFF.Reg)
}

// DMA.TCD11_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD11_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD11_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD11_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD11_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD11_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD11_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD11_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD11_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD11_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD11_DLASTSGA.Reg)
}

// DMA.TCD11_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD11_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD11_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD11_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD11_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD11_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD11_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD11_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD11_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD11_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD11_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD11_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD11_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD11_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD11_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD11_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD11_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD11_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD11_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD11_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD11_CSR.Reg, volatile.LoadUint16(&o.TCD11_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD11_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD11_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD11_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD11_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD11_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD11_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD11_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD11_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD11_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD11_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD12_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD12_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD12_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD12_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD12_SADDR.Reg)
}

// DMA.TCD12_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD12_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD12_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD12_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD12_SOFF.Reg)
}

// DMA.TCD12_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD12_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD12_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD12_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD12_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD12_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD12_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD12_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD12_ATTR.Reg, volatile.LoadUint16(&o.TCD12_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD12_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD12_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD12_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD12_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD12_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD12_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD12_NBYTES_MLNO.Reg)
}

// DMA.TCD12_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD12_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD12_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD12_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD12_SLAST.Reg)
}

// DMA.TCD12_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD12_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD12_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD12_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD12_DADDR.Reg)
}

// DMA.TCD12_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD12_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD12_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD12_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD12_DOFF.Reg)
}

// DMA.TCD12_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD12_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD12_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD12_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD12_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD12_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD12_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD12_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD12_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD12_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD12_DLASTSGA.Reg)
}

// DMA.TCD12_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD12_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD12_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD12_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD12_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD12_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD12_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD12_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD12_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD12_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD12_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD12_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD12_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD12_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD12_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD12_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD12_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD12_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD12_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD12_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD12_CSR.Reg, volatile.LoadUint16(&o.TCD12_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD12_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD12_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD12_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD12_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD12_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD12_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD12_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD12_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD12_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD12_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD13_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD13_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD13_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD13_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD13_SADDR.Reg)
}

// DMA.TCD13_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD13_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD13_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD13_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD13_SOFF.Reg)
}

// DMA.TCD13_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD13_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD13_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD13_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD13_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD13_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD13_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD13_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD13_ATTR.Reg, volatile.LoadUint16(&o.TCD13_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD13_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD13_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD13_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD13_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD13_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD13_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD13_NBYTES_MLNO.Reg)
}

// DMA.TCD13_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD13_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD13_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD13_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD13_SLAST.Reg)
}

// DMA.TCD13_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD13_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD13_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD13_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD13_DADDR.Reg)
}

// DMA.TCD13_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD13_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD13_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD13_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD13_DOFF.Reg)
}

// DMA.TCD13_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD13_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD13_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD13_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD13_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD13_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD13_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD13_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD13_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD13_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD13_DLASTSGA.Reg)
}

// DMA.TCD13_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD13_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD13_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD13_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD13_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD13_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD13_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD13_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD13_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD13_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD13_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD13_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD13_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD13_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD13_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD13_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD13_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD13_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD13_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD13_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD13_CSR.Reg, volatile.LoadUint16(&o.TCD13_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD13_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD13_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD13_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD13_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD13_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD13_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD13_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD13_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD13_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD13_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD14_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD14_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD14_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD14_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD14_SADDR.Reg)
}

// DMA.TCD14_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD14_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD14_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD14_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD14_SOFF.Reg)
}

// DMA.TCD14_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD14_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD14_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD14_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD14_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD14_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD14_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD14_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD14_ATTR.Reg, volatile.LoadUint16(&o.TCD14_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD14_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD14_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD14_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD14_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD14_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD14_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD14_NBYTES_MLNO.Reg)
}

// DMA.TCD14_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD14_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD14_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD14_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD14_SLAST.Reg)
}

// DMA.TCD14_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD14_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD14_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD14_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD14_DADDR.Reg)
}

// DMA.TCD14_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD14_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD14_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD14_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD14_DOFF.Reg)
}

// DMA.TCD14_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD14_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD14_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD14_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD14_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD14_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD14_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD14_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD14_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD14_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD14_DLASTSGA.Reg)
}

// DMA.TCD14_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD14_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD14_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD14_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD14_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD14_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD14_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD14_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD14_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD14_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD14_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD14_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD14_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD14_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD14_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD14_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD14_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD14_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD14_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD14_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD14_CSR.Reg, volatile.LoadUint16(&o.TCD14_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD14_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD14_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD14_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD14_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD14_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD14_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD14_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD14_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD14_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD14_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD15_SADDR: TCD Source Address
func (o *DMA_Type) SetTCD15_SADDR(value uint32) {
	volatile.StoreUint32(&o.TCD15_SADDR.Reg, value)
}
func (o *DMA_Type) GetTCD15_SADDR() uint32 {
	return volatile.LoadUint32(&o.TCD15_SADDR.Reg)
}

// DMA.TCD15_SOFF: TCD Signed Source Address Offset
func (o *DMA_Type) SetTCD15_SOFF(value uint16) {
	volatile.StoreUint16(&o.TCD15_SOFF.Reg, value)
}
func (o *DMA_Type) GetTCD15_SOFF() uint16 {
	return volatile.LoadUint16(&o.TCD15_SOFF.Reg)
}

// DMA.TCD15_ATTR: TCD Transfer Attributes
func (o *DMA_Type) SetTCD15_ATTR_DSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetTCD15_ATTR_DSIZE() uint16 {
	return volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0x7
}
func (o *DMA_Type) SetTCD15_ATTR_DMOD(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0xf8)|value<<3)
}
func (o *DMA_Type) GetTCD15_ATTR_DMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0xf8) >> 3
}
func (o *DMA_Type) SetTCD15_ATTR_SSIZE(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0x700)|value<<8)
}
func (o *DMA_Type) GetTCD15_ATTR_SSIZE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0x700) >> 8
}
func (o *DMA_Type) SetTCD15_ATTR_SMOD(value uint16) {
	volatile.StoreUint16(&o.TCD15_ATTR.Reg, volatile.LoadUint16(&o.TCD15_ATTR.Reg)&^(0xf800)|value<<11)
}
func (o *DMA_Type) GetTCD15_ATTR_SMOD() uint16 {
	return (volatile.LoadUint16(&o.TCD15_ATTR.Reg) & 0xf800) >> 11
}

// DMA.TCD15_NBYTES_MLNO: TCD Minor Byte Count (Minor Loop Disabled)
func (o *DMA_Type) SetTCD15_NBYTES_MLNO(value uint32) {
	volatile.StoreUint32(&o.TCD15_NBYTES_MLNO.Reg, value)
}
func (o *DMA_Type) GetTCD15_NBYTES_MLNO() uint32 {
	return volatile.LoadUint32(&o.TCD15_NBYTES_MLNO.Reg)
}

// DMA.TCD15_SLAST: TCD Last Source Address Adjustment
func (o *DMA_Type) SetTCD15_SLAST(value uint32) {
	volatile.StoreUint32(&o.TCD15_SLAST.Reg, value)
}
func (o *DMA_Type) GetTCD15_SLAST() uint32 {
	return volatile.LoadUint32(&o.TCD15_SLAST.Reg)
}

// DMA.TCD15_DADDR: TCD Destination Address
func (o *DMA_Type) SetTCD15_DADDR(value uint32) {
	volatile.StoreUint32(&o.TCD15_DADDR.Reg, value)
}
func (o *DMA_Type) GetTCD15_DADDR() uint32 {
	return volatile.LoadUint32(&o.TCD15_DADDR.Reg)
}

// DMA.TCD15_DOFF: TCD Signed Destination Address Offset
func (o *DMA_Type) SetTCD15_DOFF(value uint16) {
	volatile.StoreUint16(&o.TCD15_DOFF.Reg, value)
}
func (o *DMA_Type) GetTCD15_DOFF() uint16 {
	return volatile.LoadUint16(&o.TCD15_DOFF.Reg)
}

// DMA.TCD15_CITER_ELINKNO: TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD15_CITER_ELINKNO_CITER(value uint16) {
	volatile.StoreUint16(&o.TCD15_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD15_CITER_ELINKNO_CITER() uint16 {
	return volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD15_CITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_CITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD15_CITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CITER_ELINKNO.Reg) & 0x8000) >> 15
}

// DMA.TCD15_DLASTSGA: TCD Last Destination Address Adjustment/Scatter Gather Address
func (o *DMA_Type) SetTCD15_DLASTSGA(value uint32) {
	volatile.StoreUint32(&o.TCD15_DLASTSGA.Reg, value)
}
func (o *DMA_Type) GetTCD15_DLASTSGA() uint32 {
	return volatile.LoadUint32(&o.TCD15_DLASTSGA.Reg)
}

// DMA.TCD15_CSR: TCD Control and Status
func (o *DMA_Type) SetTCD15_CSR_START(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetTCD15_CSR_START() uint16 {
	return volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x1
}
func (o *DMA_Type) SetTCD15_CSR_INTMAJOR(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetTCD15_CSR_INTMAJOR() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetTCD15_CSR_INTHALF(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetTCD15_CSR_INTHALF() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetTCD15_CSR_DREQ(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetTCD15_CSR_DREQ() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetTCD15_CSR_ESG(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetTCD15_CSR_ESG() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetTCD15_CSR_MAJORELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetTCD15_CSR_MAJORELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetTCD15_CSR_ACTIVE(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetTCD15_CSR_ACTIVE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetTCD15_CSR_DONE(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetTCD15_CSR_DONE() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetTCD15_CSR_MAJORLINKCH(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetTCD15_CSR_MAJORLINKCH() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetTCD15_CSR_BWC(value uint16) {
	volatile.StoreUint16(&o.TCD15_CSR.Reg, volatile.LoadUint16(&o.TCD15_CSR.Reg)&^(0xc000)|value<<14)
}
func (o *DMA_Type) GetTCD15_CSR_BWC() uint16 {
	return (volatile.LoadUint16(&o.TCD15_CSR.Reg) & 0xc000) >> 14
}

// DMA.TCD15_BITER_ELINKNO: TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
func (o *DMA_Type) SetTCD15_BITER_ELINKNO_BITER(value uint16) {
	volatile.StoreUint16(&o.TCD15_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg)&^(0x7fff)|value)
}
func (o *DMA_Type) GetTCD15_BITER_ELINKNO_BITER() uint16 {
	return volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg) & 0x7fff
}
func (o *DMA_Type) SetTCD15_BITER_ELINKNO_ELINK(value uint16) {
	volatile.StoreUint16(&o.TCD15_BITER_ELINKNO.Reg, volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetTCD15_BITER_ELINKNO_ELINK() uint16 {
	return (volatile.LoadUint16(&o.TCD15_BITER_ELINKNO.Reg) & 0x8000) >> 15
}

// FlexBus external bus interface
type FB_Type struct {
	CSAR0  volatile.Register32 // 0x0
	CSMR0  volatile.Register32 // 0x4
	CSCR0  volatile.Register32 // 0x8
	CSAR1  volatile.Register32 // 0xC
	CSMR1  volatile.Register32 // 0x10
	CSCR1  volatile.Register32 // 0x14
	CSAR2  volatile.Register32 // 0x18
	CSMR2  volatile.Register32 // 0x1C
	CSCR2  volatile.Register32 // 0x20
	CSAR3  volatile.Register32 // 0x24
	CSMR3  volatile.Register32 // 0x28
	CSCR3  volatile.Register32 // 0x2C
	CSAR4  volatile.Register32 // 0x30
	CSMR4  volatile.Register32 // 0x34
	CSCR4  volatile.Register32 // 0x38
	CSAR5  volatile.Register32 // 0x3C
	CSMR5  volatile.Register32 // 0x40
	CSCR5  volatile.Register32 // 0x44
	_      [24]byte
	CSPMCR volatile.Register32 // 0x60
}

// FB.CSAR0: Chip Select Address Register
func (o *FB_Type) SetCSAR0_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR0.Reg, volatile.LoadUint32(&o.CSAR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR0_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR0.Reg) & 0xffff0000) >> 16
}

// FB.CSMR0: Chip Select Mask Register
func (o *FB_Type) SetCSMR0_V(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR0_V() uint32 {
	return volatile.LoadUint32(&o.CSMR0.Reg) & 0x1
}
func (o *FB_Type) SetCSMR0_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR0_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR0.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR0_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR0.Reg, volatile.LoadUint32(&o.CSMR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR0_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR0.Reg) & 0xffff0000) >> 16
}

// FB.CSCR0: Chip Select Control Register
func (o *FB_Type) SetCSCR0_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR0_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR0_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR0_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR0_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR0_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR0_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR0_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR0_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR0_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR0_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR0_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR0_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR0_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR0_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR0_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR0_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR0_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR0_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR0_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR0_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR0_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR0_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR0_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR0_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR0.Reg, volatile.LoadUint32(&o.CSCR0.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR0_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR0.Reg) & 0xfc000000) >> 26
}

// FB.CSAR1: Chip Select Address Register
func (o *FB_Type) SetCSAR1_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR1.Reg, volatile.LoadUint32(&o.CSAR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR1_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR1.Reg) & 0xffff0000) >> 16
}

// FB.CSMR1: Chip Select Mask Register
func (o *FB_Type) SetCSMR1_V(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR1_V() uint32 {
	return volatile.LoadUint32(&o.CSMR1.Reg) & 0x1
}
func (o *FB_Type) SetCSMR1_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR1_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR1.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR1_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR1.Reg, volatile.LoadUint32(&o.CSMR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR1_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR1.Reg) & 0xffff0000) >> 16
}

// FB.CSCR1: Chip Select Control Register
func (o *FB_Type) SetCSCR1_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR1_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR1_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR1_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR1_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR1_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR1_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR1_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR1_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR1_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR1_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR1_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR1_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR1_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR1_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR1_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR1_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR1_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR1_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR1_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR1_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR1_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR1_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR1.Reg, volatile.LoadUint32(&o.CSCR1.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR1_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR1.Reg) & 0xfc000000) >> 26
}

// FB.CSAR2: Chip Select Address Register
func (o *FB_Type) SetCSAR2_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR2.Reg, volatile.LoadUint32(&o.CSAR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR2_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR2.Reg) & 0xffff0000) >> 16
}

// FB.CSMR2: Chip Select Mask Register
func (o *FB_Type) SetCSMR2_V(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR2_V() uint32 {
	return volatile.LoadUint32(&o.CSMR2.Reg) & 0x1
}
func (o *FB_Type) SetCSMR2_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR2_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR2.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR2_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR2.Reg, volatile.LoadUint32(&o.CSMR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR2_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR2.Reg) & 0xffff0000) >> 16
}

// FB.CSCR2: Chip Select Control Register
func (o *FB_Type) SetCSCR2_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR2_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR2_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR2_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR2_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR2_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR2_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR2_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR2_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR2_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR2_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR2_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR2_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR2_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR2_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR2_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR2_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR2_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR2_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR2_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR2_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR2_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR2_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR2_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR2_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR2.Reg, volatile.LoadUint32(&o.CSCR2.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR2_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR2.Reg) & 0xfc000000) >> 26
}

// FB.CSAR3: Chip Select Address Register
func (o *FB_Type) SetCSAR3_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR3.Reg, volatile.LoadUint32(&o.CSAR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR3_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR3.Reg) & 0xffff0000) >> 16
}

// FB.CSMR3: Chip Select Mask Register
func (o *FB_Type) SetCSMR3_V(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR3_V() uint32 {
	return volatile.LoadUint32(&o.CSMR3.Reg) & 0x1
}
func (o *FB_Type) SetCSMR3_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR3_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR3.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR3_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR3.Reg, volatile.LoadUint32(&o.CSMR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR3_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR3.Reg) & 0xffff0000) >> 16
}

// FB.CSCR3: Chip Select Control Register
func (o *FB_Type) SetCSCR3_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR3_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR3_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR3_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR3_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR3_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR3_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR3_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR3_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR3_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR3_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR3_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR3_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR3_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR3_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR3_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR3_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR3_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR3_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR3_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR3_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR3_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR3_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR3_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR3_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR3.Reg, volatile.LoadUint32(&o.CSCR3.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR3_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR3.Reg) & 0xfc000000) >> 26
}

// FB.CSAR4: Chip Select Address Register
func (o *FB_Type) SetCSAR4_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR4.Reg, volatile.LoadUint32(&o.CSAR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR4_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR4.Reg) & 0xffff0000) >> 16
}

// FB.CSMR4: Chip Select Mask Register
func (o *FB_Type) SetCSMR4_V(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR4_V() uint32 {
	return volatile.LoadUint32(&o.CSMR4.Reg) & 0x1
}
func (o *FB_Type) SetCSMR4_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR4_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR4.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR4_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR4.Reg, volatile.LoadUint32(&o.CSMR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR4_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR4.Reg) & 0xffff0000) >> 16
}

// FB.CSCR4: Chip Select Control Register
func (o *FB_Type) SetCSCR4_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR4_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR4_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR4_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR4_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR4_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR4_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR4_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR4_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR4_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR4_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR4_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR4_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR4_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR4_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR4_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR4_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR4_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR4_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR4_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR4_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR4_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR4_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR4_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR4_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR4.Reg, volatile.LoadUint32(&o.CSCR4.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR4_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR4.Reg) & 0xfc000000) >> 26
}

// FB.CSAR5: Chip Select Address Register
func (o *FB_Type) SetCSAR5_BA(value uint32) {
	volatile.StoreUint32(&o.CSAR5.Reg, volatile.LoadUint32(&o.CSAR5.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSAR5_BA() uint32 {
	return (volatile.LoadUint32(&o.CSAR5.Reg) & 0xffff0000) >> 16
}

// FB.CSMR5: Chip Select Mask Register
func (o *FB_Type) SetCSMR5_V(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0x1)|value)
}
func (o *FB_Type) GetCSMR5_V() uint32 {
	return volatile.LoadUint32(&o.CSMR5.Reg) & 0x1
}
func (o *FB_Type) SetCSMR5_WP(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSMR5_WP() uint32 {
	return (volatile.LoadUint32(&o.CSMR5.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSMR5_BAM(value uint32) {
	volatile.StoreUint32(&o.CSMR5.Reg, volatile.LoadUint32(&o.CSMR5.Reg)&^(0xffff0000)|value<<16)
}
func (o *FB_Type) GetCSMR5_BAM() uint32 {
	return (volatile.LoadUint32(&o.CSMR5.Reg) & 0xffff0000) >> 16
}

// FB.CSCR5: Chip Select Control Register
func (o *FB_Type) SetCSCR5_BSTW(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x8)|value<<3)
}
func (o *FB_Type) GetCSCR5_BSTW() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x8) >> 3
}
func (o *FB_Type) SetCSCR5_BSTR(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x10)|value<<4)
}
func (o *FB_Type) GetCSCR5_BSTR() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x10) >> 4
}
func (o *FB_Type) SetCSCR5_BEM(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x20)|value<<5)
}
func (o *FB_Type) GetCSCR5_BEM() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x20) >> 5
}
func (o *FB_Type) SetCSCR5_PS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xc0)|value<<6)
}
func (o *FB_Type) GetCSCR5_PS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xc0) >> 6
}
func (o *FB_Type) SetCSCR5_AA(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x100)|value<<8)
}
func (o *FB_Type) GetCSCR5_AA() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x100) >> 8
}
func (o *FB_Type) SetCSCR5_BLS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x200)|value<<9)
}
func (o *FB_Type) GetCSCR5_BLS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x200) >> 9
}
func (o *FB_Type) SetCSCR5_WS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xfc00)|value<<10)
}
func (o *FB_Type) GetCSCR5_WS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xfc00) >> 10
}
func (o *FB_Type) SetCSCR5_WRAH(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x30000)|value<<16)
}
func (o *FB_Type) GetCSCR5_WRAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x30000) >> 16
}
func (o *FB_Type) SetCSCR5_RDAH(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xc0000)|value<<18)
}
func (o *FB_Type) GetCSCR5_RDAH() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xc0000) >> 18
}
func (o *FB_Type) SetCSCR5_ASET(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x300000)|value<<20)
}
func (o *FB_Type) GetCSCR5_ASET() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x300000) >> 20
}
func (o *FB_Type) SetCSCR5_EXTS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x400000)|value<<22)
}
func (o *FB_Type) GetCSCR5_EXTS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x400000) >> 22
}
func (o *FB_Type) SetCSCR5_SWSEN(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0x800000)|value<<23)
}
func (o *FB_Type) GetCSCR5_SWSEN() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0x800000) >> 23
}
func (o *FB_Type) SetCSCR5_SWS(value uint32) {
	volatile.StoreUint32(&o.CSCR5.Reg, volatile.LoadUint32(&o.CSCR5.Reg)&^(0xfc000000)|value<<26)
}
func (o *FB_Type) GetCSCR5_SWS() uint32 {
	return (volatile.LoadUint32(&o.CSCR5.Reg) & 0xfc000000) >> 26
}

// FB.CSPMCR: Chip Select port Multiplexing Control Register
func (o *FB_Type) SetCSPMCR_GROUP5(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf000)|value<<12)
}
func (o *FB_Type) GetCSPMCR_GROUP5() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf000) >> 12
}
func (o *FB_Type) SetCSPMCR_GROUP4(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf0000)|value<<16)
}
func (o *FB_Type) GetCSPMCR_GROUP4() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf0000) >> 16
}
func (o *FB_Type) SetCSPMCR_GROUP3(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf00000)|value<<20)
}
func (o *FB_Type) GetCSPMCR_GROUP3() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf00000) >> 20
}
func (o *FB_Type) SetCSPMCR_GROUP2(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf000000)|value<<24)
}
func (o *FB_Type) GetCSPMCR_GROUP2() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf000000) >> 24
}
func (o *FB_Type) SetCSPMCR_GROUP1(value uint32) {
	volatile.StoreUint32(&o.CSPMCR.Reg, volatile.LoadUint32(&o.CSPMCR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FB_Type) GetCSPMCR_GROUP1() uint32 {
	return (volatile.LoadUint32(&o.CSPMCR.Reg) & 0xf0000000) >> 28
}

// Memory protection unit
type SYSMPU_Type struct {
	CESR        volatile.Register32 // 0x0
	_           [12]byte
	EAR0        volatile.Register32 // 0x10
	EDR0        volatile.Register32 // 0x14
	EAR1        volatile.Register32 // 0x18
	EDR1        volatile.Register32 // 0x1C
	EAR2        volatile.Register32 // 0x20
	EDR2        volatile.Register32 // 0x24
	EAR3        volatile.Register32 // 0x28
	EDR3        volatile.Register32 // 0x2C
	EAR4        volatile.Register32 // 0x30
	EDR4        volatile.Register32 // 0x34
	_           [968]byte
	RGD0_WORD0  volatile.Register32 // 0x400
	RGD0_WORD1  volatile.Register32 // 0x404
	RGD0_WORD2  volatile.Register32 // 0x408
	RGD0_WORD3  volatile.Register32 // 0x40C
	RGD1_WORD0  volatile.Register32 // 0x410
	RGD1_WORD1  volatile.Register32 // 0x414
	RGD1_WORD2  volatile.Register32 // 0x418
	RGD1_WORD3  volatile.Register32 // 0x41C
	RGD2_WORD0  volatile.Register32 // 0x420
	RGD2_WORD1  volatile.Register32 // 0x424
	RGD2_WORD2  volatile.Register32 // 0x428
	RGD2_WORD3  volatile.Register32 // 0x42C
	RGD3_WORD0  volatile.Register32 // 0x430
	RGD3_WORD1  volatile.Register32 // 0x434
	RGD3_WORD2  volatile.Register32 // 0x438
	RGD3_WORD3  volatile.Register32 // 0x43C
	RGD4_WORD0  volatile.Register32 // 0x440
	RGD4_WORD1  volatile.Register32 // 0x444
	RGD4_WORD2  volatile.Register32 // 0x448
	RGD4_WORD3  volatile.Register32 // 0x44C
	RGD5_WORD0  volatile.Register32 // 0x450
	RGD5_WORD1  volatile.Register32 // 0x454
	RGD5_WORD2  volatile.Register32 // 0x458
	RGD5_WORD3  volatile.Register32 // 0x45C
	RGD6_WORD0  volatile.Register32 // 0x460
	RGD6_WORD1  volatile.Register32 // 0x464
	RGD6_WORD2  volatile.Register32 // 0x468
	RGD6_WORD3  volatile.Register32 // 0x46C
	RGD7_WORD0  volatile.Register32 // 0x470
	RGD7_WORD1  volatile.Register32 // 0x474
	RGD7_WORD2  volatile.Register32 // 0x478
	RGD7_WORD3  volatile.Register32 // 0x47C
	RGD8_WORD0  volatile.Register32 // 0x480
	RGD8_WORD1  volatile.Register32 // 0x484
	RGD8_WORD2  volatile.Register32 // 0x488
	RGD8_WORD3  volatile.Register32 // 0x48C
	RGD9_WORD0  volatile.Register32 // 0x490
	RGD9_WORD1  volatile.Register32 // 0x494
	RGD9_WORD2  volatile.Register32 // 0x498
	RGD9_WORD3  volatile.Register32 // 0x49C
	RGD10_WORD0 volatile.Register32 // 0x4A0
	RGD10_WORD1 volatile.Register32 // 0x4A4
	RGD10_WORD2 volatile.Register32 // 0x4A8
	RGD10_WORD3 volatile.Register32 // 0x4AC
	RGD11_WORD0 volatile.Register32 // 0x4B0
	RGD11_WORD1 volatile.Register32 // 0x4B4
	RGD11_WORD2 volatile.Register32 // 0x4B8
	RGD11_WORD3 volatile.Register32 // 0x4BC
	_           [832]byte
	RGDAAC0     volatile.Register32 // 0x800
	RGDAAC1     volatile.Register32 // 0x804
	RGDAAC2     volatile.Register32 // 0x808
	RGDAAC3     volatile.Register32 // 0x80C
	RGDAAC4     volatile.Register32 // 0x810
	RGDAAC5     volatile.Register32 // 0x814
	RGDAAC6     volatile.Register32 // 0x818
	RGDAAC7     volatile.Register32 // 0x81C
	RGDAAC8     volatile.Register32 // 0x820
	RGDAAC9     volatile.Register32 // 0x824
	RGDAAC10    volatile.Register32 // 0x828
	RGDAAC11    volatile.Register32 // 0x82C
}

// SYSMPU.CESR: Control/Error Status Register
func (o *SYSMPU_Type) SetCESR_VLD(value uint32) {
	volatile.StoreUint32(&o.CESR.Reg, volatile.LoadUint32(&o.CESR.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetCESR_VLD() uint32 {
	return volatile.LoadUint32(&o.CESR.Reg) & 0x1
}
func (o *SYSMPU_Type) SetCESR_NRGD(value uint32) {
	volatile.StoreUint32(&o.CESR.Reg, volatile.LoadUint32(&o.CESR.Reg)&^(0xf00)|value<<8)
}
func (o *SYSMPU_Type) GetCESR_NRGD() uint32 {
	return (volatile.LoadUint32(&o.CESR.Reg) & 0xf00) >> 8
}
func (o *SYSMPU_Type) SetCESR_NSP(value uint32) {
	volatile.StoreUint32(&o.CESR.Reg, volatile.LoadUint32(&o.CESR.Reg)&^(0xf000)|value<<12)
}
func (o *SYSMPU_Type) GetCESR_NSP() uint32 {
	return (volatile.LoadUint32(&o.CESR.Reg) & 0xf000) >> 12
}
func (o *SYSMPU_Type) SetCESR_HRL(value uint32) {
	volatile.StoreUint32(&o.CESR.Reg, volatile.LoadUint32(&o.CESR.Reg)&^(0xf0000)|value<<16)
}
func (o *SYSMPU_Type) GetCESR_HRL() uint32 {
	return (volatile.LoadUint32(&o.CESR.Reg) & 0xf0000) >> 16
}
func (o *SYSMPU_Type) SetCESR_SPERR(value uint32) {
	volatile.StoreUint32(&o.CESR.Reg, volatile.LoadUint32(&o.CESR.Reg)&^(0xf8000000)|value<<27)
}
func (o *SYSMPU_Type) GetCESR_SPERR() uint32 {
	return (volatile.LoadUint32(&o.CESR.Reg) & 0xf8000000) >> 27
}

// SYSMPU.EAR0: Error Address Register, slave port n
func (o *SYSMPU_Type) SetEAR0(value uint32) {
	volatile.StoreUint32(&o.EAR0.Reg, value)
}
func (o *SYSMPU_Type) GetEAR0() uint32 {
	return volatile.LoadUint32(&o.EAR0.Reg)
}

// SYSMPU.EDR0: Error Detail Register, slave port n
func (o *SYSMPU_Type) SetEDR0_ERW(value uint32) {
	volatile.StoreUint32(&o.EDR0.Reg, volatile.LoadUint32(&o.EDR0.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetEDR0_ERW() uint32 {
	return volatile.LoadUint32(&o.EDR0.Reg) & 0x1
}
func (o *SYSMPU_Type) SetEDR0_EATTR(value uint32) {
	volatile.StoreUint32(&o.EDR0.Reg, volatile.LoadUint32(&o.EDR0.Reg)&^(0xe)|value<<1)
}
func (o *SYSMPU_Type) GetEDR0_EATTR() uint32 {
	return (volatile.LoadUint32(&o.EDR0.Reg) & 0xe) >> 1
}
func (o *SYSMPU_Type) SetEDR0_EMN(value uint32) {
	volatile.StoreUint32(&o.EDR0.Reg, volatile.LoadUint32(&o.EDR0.Reg)&^(0xf0)|value<<4)
}
func (o *SYSMPU_Type) GetEDR0_EMN() uint32 {
	return (volatile.LoadUint32(&o.EDR0.Reg) & 0xf0) >> 4
}
func (o *SYSMPU_Type) SetEDR0_EPID(value uint32) {
	volatile.StoreUint32(&o.EDR0.Reg, volatile.LoadUint32(&o.EDR0.Reg)&^(0xff00)|value<<8)
}
func (o *SYSMPU_Type) GetEDR0_EPID() uint32 {
	return (volatile.LoadUint32(&o.EDR0.Reg) & 0xff00) >> 8
}
func (o *SYSMPU_Type) SetEDR0_EACD(value uint32) {
	volatile.StoreUint32(&o.EDR0.Reg, volatile.LoadUint32(&o.EDR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSMPU_Type) GetEDR0_EACD() uint32 {
	return (volatile.LoadUint32(&o.EDR0.Reg) & 0xffff0000) >> 16
}

// SYSMPU.EAR1: Error Address Register, slave port n
func (o *SYSMPU_Type) SetEAR1(value uint32) {
	volatile.StoreUint32(&o.EAR1.Reg, value)
}
func (o *SYSMPU_Type) GetEAR1() uint32 {
	return volatile.LoadUint32(&o.EAR1.Reg)
}

// SYSMPU.EDR1: Error Detail Register, slave port n
func (o *SYSMPU_Type) SetEDR1_ERW(value uint32) {
	volatile.StoreUint32(&o.EDR1.Reg, volatile.LoadUint32(&o.EDR1.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetEDR1_ERW() uint32 {
	return volatile.LoadUint32(&o.EDR1.Reg) & 0x1
}
func (o *SYSMPU_Type) SetEDR1_EATTR(value uint32) {
	volatile.StoreUint32(&o.EDR1.Reg, volatile.LoadUint32(&o.EDR1.Reg)&^(0xe)|value<<1)
}
func (o *SYSMPU_Type) GetEDR1_EATTR() uint32 {
	return (volatile.LoadUint32(&o.EDR1.Reg) & 0xe) >> 1
}
func (o *SYSMPU_Type) SetEDR1_EMN(value uint32) {
	volatile.StoreUint32(&o.EDR1.Reg, volatile.LoadUint32(&o.EDR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSMPU_Type) GetEDR1_EMN() uint32 {
	return (volatile.LoadUint32(&o.EDR1.Reg) & 0xf0) >> 4
}
func (o *SYSMPU_Type) SetEDR1_EPID(value uint32) {
	volatile.StoreUint32(&o.EDR1.Reg, volatile.LoadUint32(&o.EDR1.Reg)&^(0xff00)|value<<8)
}
func (o *SYSMPU_Type) GetEDR1_EPID() uint32 {
	return (volatile.LoadUint32(&o.EDR1.Reg) & 0xff00) >> 8
}
func (o *SYSMPU_Type) SetEDR1_EACD(value uint32) {
	volatile.StoreUint32(&o.EDR1.Reg, volatile.LoadUint32(&o.EDR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSMPU_Type) GetEDR1_EACD() uint32 {
	return (volatile.LoadUint32(&o.EDR1.Reg) & 0xffff0000) >> 16
}

// SYSMPU.EAR2: Error Address Register, slave port n
func (o *SYSMPU_Type) SetEAR2(value uint32) {
	volatile.StoreUint32(&o.EAR2.Reg, value)
}
func (o *SYSMPU_Type) GetEAR2() uint32 {
	return volatile.LoadUint32(&o.EAR2.Reg)
}

// SYSMPU.EDR2: Error Detail Register, slave port n
func (o *SYSMPU_Type) SetEDR2_ERW(value uint32) {
	volatile.StoreUint32(&o.EDR2.Reg, volatile.LoadUint32(&o.EDR2.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetEDR2_ERW() uint32 {
	return volatile.LoadUint32(&o.EDR2.Reg) & 0x1
}
func (o *SYSMPU_Type) SetEDR2_EATTR(value uint32) {
	volatile.StoreUint32(&o.EDR2.Reg, volatile.LoadUint32(&o.EDR2.Reg)&^(0xe)|value<<1)
}
func (o *SYSMPU_Type) GetEDR2_EATTR() uint32 {
	return (volatile.LoadUint32(&o.EDR2.Reg) & 0xe) >> 1
}
func (o *SYSMPU_Type) SetEDR2_EMN(value uint32) {
	volatile.StoreUint32(&o.EDR2.Reg, volatile.LoadUint32(&o.EDR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSMPU_Type) GetEDR2_EMN() uint32 {
	return (volatile.LoadUint32(&o.EDR2.Reg) & 0xf0) >> 4
}
func (o *SYSMPU_Type) SetEDR2_EPID(value uint32) {
	volatile.StoreUint32(&o.EDR2.Reg, volatile.LoadUint32(&o.EDR2.Reg)&^(0xff00)|value<<8)
}
func (o *SYSMPU_Type) GetEDR2_EPID() uint32 {
	return (volatile.LoadUint32(&o.EDR2.Reg) & 0xff00) >> 8
}
func (o *SYSMPU_Type) SetEDR2_EACD(value uint32) {
	volatile.StoreUint32(&o.EDR2.Reg, volatile.LoadUint32(&o.EDR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSMPU_Type) GetEDR2_EACD() uint32 {
	return (volatile.LoadUint32(&o.EDR2.Reg) & 0xffff0000) >> 16
}

// SYSMPU.EAR3: Error Address Register, slave port n
func (o *SYSMPU_Type) SetEAR3(value uint32) {
	volatile.StoreUint32(&o.EAR3.Reg, value)
}
func (o *SYSMPU_Type) GetEAR3() uint32 {
	return volatile.LoadUint32(&o.EAR3.Reg)
}

// SYSMPU.EDR3: Error Detail Register, slave port n
func (o *SYSMPU_Type) SetEDR3_ERW(value uint32) {
	volatile.StoreUint32(&o.EDR3.Reg, volatile.LoadUint32(&o.EDR3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetEDR3_ERW() uint32 {
	return volatile.LoadUint32(&o.EDR3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetEDR3_EATTR(value uint32) {
	volatile.StoreUint32(&o.EDR3.Reg, volatile.LoadUint32(&o.EDR3.Reg)&^(0xe)|value<<1)
}
func (o *SYSMPU_Type) GetEDR3_EATTR() uint32 {
	return (volatile.LoadUint32(&o.EDR3.Reg) & 0xe) >> 1
}
func (o *SYSMPU_Type) SetEDR3_EMN(value uint32) {
	volatile.StoreUint32(&o.EDR3.Reg, volatile.LoadUint32(&o.EDR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSMPU_Type) GetEDR3_EMN() uint32 {
	return (volatile.LoadUint32(&o.EDR3.Reg) & 0xf0) >> 4
}
func (o *SYSMPU_Type) SetEDR3_EPID(value uint32) {
	volatile.StoreUint32(&o.EDR3.Reg, volatile.LoadUint32(&o.EDR3.Reg)&^(0xff00)|value<<8)
}
func (o *SYSMPU_Type) GetEDR3_EPID() uint32 {
	return (volatile.LoadUint32(&o.EDR3.Reg) & 0xff00) >> 8
}
func (o *SYSMPU_Type) SetEDR3_EACD(value uint32) {
	volatile.StoreUint32(&o.EDR3.Reg, volatile.LoadUint32(&o.EDR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSMPU_Type) GetEDR3_EACD() uint32 {
	return (volatile.LoadUint32(&o.EDR3.Reg) & 0xffff0000) >> 16
}

// SYSMPU.EAR4: Error Address Register, slave port n
func (o *SYSMPU_Type) SetEAR4(value uint32) {
	volatile.StoreUint32(&o.EAR4.Reg, value)
}
func (o *SYSMPU_Type) GetEAR4() uint32 {
	return volatile.LoadUint32(&o.EAR4.Reg)
}

// SYSMPU.EDR4: Error Detail Register, slave port n
func (o *SYSMPU_Type) SetEDR4_ERW(value uint32) {
	volatile.StoreUint32(&o.EDR4.Reg, volatile.LoadUint32(&o.EDR4.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetEDR4_ERW() uint32 {
	return volatile.LoadUint32(&o.EDR4.Reg) & 0x1
}
func (o *SYSMPU_Type) SetEDR4_EATTR(value uint32) {
	volatile.StoreUint32(&o.EDR4.Reg, volatile.LoadUint32(&o.EDR4.Reg)&^(0xe)|value<<1)
}
func (o *SYSMPU_Type) GetEDR4_EATTR() uint32 {
	return (volatile.LoadUint32(&o.EDR4.Reg) & 0xe) >> 1
}
func (o *SYSMPU_Type) SetEDR4_EMN(value uint32) {
	volatile.StoreUint32(&o.EDR4.Reg, volatile.LoadUint32(&o.EDR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSMPU_Type) GetEDR4_EMN() uint32 {
	return (volatile.LoadUint32(&o.EDR4.Reg) & 0xf0) >> 4
}
func (o *SYSMPU_Type) SetEDR4_EPID(value uint32) {
	volatile.StoreUint32(&o.EDR4.Reg, volatile.LoadUint32(&o.EDR4.Reg)&^(0xff00)|value<<8)
}
func (o *SYSMPU_Type) GetEDR4_EPID() uint32 {
	return (volatile.LoadUint32(&o.EDR4.Reg) & 0xff00) >> 8
}
func (o *SYSMPU_Type) SetEDR4_EACD(value uint32) {
	volatile.StoreUint32(&o.EDR4.Reg, volatile.LoadUint32(&o.EDR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSMPU_Type) GetEDR4_EACD() uint32 {
	return (volatile.LoadUint32(&o.EDR4.Reg) & 0xffff0000) >> 16
}

// SYSMPU.RGD0_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD0_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD0.Reg, volatile.LoadUint32(&o.RGD0_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD0_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD0_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD0_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD1.Reg, volatile.LoadUint32(&o.RGD0_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD0_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD0_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD0_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD0_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD2.Reg, volatile.LoadUint32(&o.RGD0_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD0_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD0_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD0_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD3.Reg, volatile.LoadUint32(&o.RGD0_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD0_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD0_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD0_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD3.Reg, volatile.LoadUint32(&o.RGD0_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD0_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD0_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD0_WORD3.Reg, volatile.LoadUint32(&o.RGD0_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD0_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD0_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD1_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD1_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD0.Reg, volatile.LoadUint32(&o.RGD1_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD1_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD1_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD1_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD1.Reg, volatile.LoadUint32(&o.RGD1_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD1_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD1_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD1_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD1_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD2.Reg, volatile.LoadUint32(&o.RGD1_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD1_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD1_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD1_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD3.Reg, volatile.LoadUint32(&o.RGD1_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD1_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD1_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD1_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD3.Reg, volatile.LoadUint32(&o.RGD1_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD1_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD1_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD1_WORD3.Reg, volatile.LoadUint32(&o.RGD1_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD1_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD1_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD2_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD2_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD0.Reg, volatile.LoadUint32(&o.RGD2_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD2_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD2_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD2_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD1.Reg, volatile.LoadUint32(&o.RGD2_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD2_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD2_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD2_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD2_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD2.Reg, volatile.LoadUint32(&o.RGD2_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD2_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD2_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD2_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD3.Reg, volatile.LoadUint32(&o.RGD2_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD2_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD2_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD2_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD3.Reg, volatile.LoadUint32(&o.RGD2_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD2_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD2_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD2_WORD3.Reg, volatile.LoadUint32(&o.RGD2_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD2_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD2_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD3_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD3_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD0.Reg, volatile.LoadUint32(&o.RGD3_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD3_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD3_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD3_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD1.Reg, volatile.LoadUint32(&o.RGD3_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD3_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD3_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD3_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD3_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD2.Reg, volatile.LoadUint32(&o.RGD3_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD3_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD3_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD3_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD3.Reg, volatile.LoadUint32(&o.RGD3_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD3_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD3_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD3_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD3.Reg, volatile.LoadUint32(&o.RGD3_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD3_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD3_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD3_WORD3.Reg, volatile.LoadUint32(&o.RGD3_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD3_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD3_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD4_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD4_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD0.Reg, volatile.LoadUint32(&o.RGD4_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD4_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD4_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD4_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD1.Reg, volatile.LoadUint32(&o.RGD4_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD4_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD4_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD4_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD4_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD2.Reg, volatile.LoadUint32(&o.RGD4_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD4_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD4_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD4_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD3.Reg, volatile.LoadUint32(&o.RGD4_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD4_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD4_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD4_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD3.Reg, volatile.LoadUint32(&o.RGD4_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD4_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD4_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD4_WORD3.Reg, volatile.LoadUint32(&o.RGD4_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD4_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD4_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD5_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD5_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD0.Reg, volatile.LoadUint32(&o.RGD5_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD5_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD5_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD5_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD1.Reg, volatile.LoadUint32(&o.RGD5_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD5_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD5_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD5_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD5_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD2.Reg, volatile.LoadUint32(&o.RGD5_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD5_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD5_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD5_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD3.Reg, volatile.LoadUint32(&o.RGD5_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD5_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD5_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD5_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD3.Reg, volatile.LoadUint32(&o.RGD5_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD5_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD5_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD5_WORD3.Reg, volatile.LoadUint32(&o.RGD5_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD5_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD5_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD6_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD6_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD0.Reg, volatile.LoadUint32(&o.RGD6_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD6_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD6_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD6_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD1.Reg, volatile.LoadUint32(&o.RGD6_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD6_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD6_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD6_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD6_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD2.Reg, volatile.LoadUint32(&o.RGD6_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD6_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD6_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD6_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD3.Reg, volatile.LoadUint32(&o.RGD6_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD6_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD6_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD6_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD3.Reg, volatile.LoadUint32(&o.RGD6_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD6_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD6_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD6_WORD3.Reg, volatile.LoadUint32(&o.RGD6_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD6_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD6_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD7_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD7_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD0.Reg, volatile.LoadUint32(&o.RGD7_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD7_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD7_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD7_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD1.Reg, volatile.LoadUint32(&o.RGD7_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD7_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD7_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD7_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD7_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD2.Reg, volatile.LoadUint32(&o.RGD7_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD7_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD7_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD7_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD3.Reg, volatile.LoadUint32(&o.RGD7_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD7_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD7_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD7_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD3.Reg, volatile.LoadUint32(&o.RGD7_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD7_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD7_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD7_WORD3.Reg, volatile.LoadUint32(&o.RGD7_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD7_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD7_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD8_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD8_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD0.Reg, volatile.LoadUint32(&o.RGD8_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD8_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD8_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD8_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD1.Reg, volatile.LoadUint32(&o.RGD8_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD8_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD8_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD8_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD8_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD2.Reg, volatile.LoadUint32(&o.RGD8_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD8_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD8_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD8_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD3.Reg, volatile.LoadUint32(&o.RGD8_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD8_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD8_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD8_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD3.Reg, volatile.LoadUint32(&o.RGD8_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD8_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD8_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD8_WORD3.Reg, volatile.LoadUint32(&o.RGD8_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD8_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD8_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD9_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD9_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD0.Reg, volatile.LoadUint32(&o.RGD9_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD9_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD9_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD9_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD1.Reg, volatile.LoadUint32(&o.RGD9_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD9_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD9_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD9_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD9_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD2.Reg, volatile.LoadUint32(&o.RGD9_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD9_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD9_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD9_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD3.Reg, volatile.LoadUint32(&o.RGD9_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD9_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD9_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD9_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD3.Reg, volatile.LoadUint32(&o.RGD9_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD9_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD9_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD9_WORD3.Reg, volatile.LoadUint32(&o.RGD9_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD9_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD9_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD10_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD10_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD0.Reg, volatile.LoadUint32(&o.RGD10_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD10_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD10_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD10_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD1.Reg, volatile.LoadUint32(&o.RGD10_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD10_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD10_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD10_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD10_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD2.Reg, volatile.LoadUint32(&o.RGD10_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD10_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD10_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD10_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD3.Reg, volatile.LoadUint32(&o.RGD10_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD10_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD10_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD10_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD3.Reg, volatile.LoadUint32(&o.RGD10_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD10_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD10_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD10_WORD3.Reg, volatile.LoadUint32(&o.RGD10_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD10_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD10_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGD11_WORD0: Region Descriptor n, Word 0
func (o *SYSMPU_Type) SetRGD11_WORD0_SRTADDR(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD0.Reg, volatile.LoadUint32(&o.RGD11_WORD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD11_WORD0_SRTADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD0.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD11_WORD1: Region Descriptor n, Word 1
func (o *SYSMPU_Type) SetRGD11_WORD1_ENDADDR(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD1.Reg, volatile.LoadUint32(&o.RGD11_WORD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SYSMPU_Type) GetRGD11_WORD1_ENDADDR() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD1.Reg) & 0xffffffe0) >> 5
}

// SYSMPU.RGD11_WORD2: Region Descriptor n, Word 2
func (o *SYSMPU_Type) SetRGD11_WORD2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGD11_WORD2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD2.Reg, volatile.LoadUint32(&o.RGD11_WORD2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGD11_WORD2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGD11_WORD3: Region Descriptor n, Word 3
func (o *SYSMPU_Type) SetRGD11_WORD3_VLD(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD3.Reg, volatile.LoadUint32(&o.RGD11_WORD3.Reg)&^(0x1)|value)
}
func (o *SYSMPU_Type) GetRGD11_WORD3_VLD() uint32 {
	return volatile.LoadUint32(&o.RGD11_WORD3.Reg) & 0x1
}
func (o *SYSMPU_Type) SetRGD11_WORD3_PIDMASK(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD3.Reg, volatile.LoadUint32(&o.RGD11_WORD3.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSMPU_Type) GetRGD11_WORD3_PIDMASK() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD3.Reg) & 0xff0000) >> 16
}
func (o *SYSMPU_Type) SetRGD11_WORD3_PID(value uint32) {
	volatile.StoreUint32(&o.RGD11_WORD3.Reg, volatile.LoadUint32(&o.RGD11_WORD3.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGD11_WORD3_PID() uint32 {
	return (volatile.LoadUint32(&o.RGD11_WORD3.Reg) & 0xff000000) >> 24
}

// SYSMPU.RGDAAC0: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC0_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC0_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC0_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC0_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC0_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC0_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC0_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC0_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC0_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC0_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC0_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC0_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC0_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC0_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC0_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC0_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC0_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC0_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC0_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC0_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC0_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC0_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC0_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC0_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC0_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC0_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC0_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC0_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC0_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC0_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC0_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC0_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC0_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC0_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC0_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC0_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC0_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC0_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC0_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC0.Reg, volatile.LoadUint32(&o.RGDAAC0.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC0_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC0.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC1: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC1_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC1_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC1_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC1_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC1_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC1_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC1_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC1_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC1_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC1_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC1_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC1_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC1_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC1_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC1_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC1_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC1_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC1_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC1_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC1_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC1_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC1_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC1_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC1_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC1_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC1_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC1_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC1_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC1_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC1_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC1_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC1_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC1_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC1_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC1_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC1_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC1_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC1_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC1_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC1.Reg, volatile.LoadUint32(&o.RGDAAC1.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC1_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC1.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC2: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC2_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC2_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC2_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC2_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC2_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC2_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC2_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC2_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC2_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC2_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC2_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC2_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC2_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC2_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC2_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC2_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC2_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC2_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC2_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC2_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC2_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC2_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC2_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC2_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC2_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC2_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC2_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC2_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC2_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC2_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC2_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC2_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC2_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC2_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC2_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC2_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC2_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC2_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC2_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC2.Reg, volatile.LoadUint32(&o.RGDAAC2.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC2_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC2.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC3: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC3_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC3_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC3_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC3_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC3_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC3_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC3_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC3_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC3_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC3_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC3_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC3_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC3_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC3_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC3_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC3_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC3_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC3_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC3_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC3_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC3_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC3_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC3_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC3_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC3_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC3_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC3_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC3_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC3_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC3_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC3_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC3_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC3_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC3_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC3_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC3_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC3_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC3_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC3_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC3.Reg, volatile.LoadUint32(&o.RGDAAC3.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC3_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC3.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC4: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC4_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC4_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC4_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC4_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC4_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC4_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC4_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC4_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC4_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC4_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC4_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC4_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC4_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC4_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC4_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC4_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC4_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC4_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC4_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC4_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC4_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC4_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC4_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC4_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC4_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC4_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC4_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC4_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC4_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC4_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC4_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC4_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC4_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC4_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC4_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC4_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC4_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC4_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC4_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC4.Reg, volatile.LoadUint32(&o.RGDAAC4.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC4_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC4.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC5: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC5_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC5_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC5_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC5_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC5_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC5_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC5_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC5_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC5_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC5_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC5_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC5_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC5_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC5_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC5_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC5_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC5_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC5_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC5_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC5_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC5_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC5_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC5_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC5_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC5_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC5_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC5_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC5_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC5_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC5_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC5_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC5_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC5_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC5_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC5_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC5_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC5_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC5_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC5_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC5.Reg, volatile.LoadUint32(&o.RGDAAC5.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC5_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC5.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC6: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC6_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC6_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC6_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC6_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC6_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC6_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC6_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC6_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC6_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC6_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC6_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC6_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC6_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC6_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC6_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC6_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC6_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC6_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC6_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC6_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC6_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC6_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC6_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC6_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC6_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC6_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC6_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC6_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC6_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC6_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC6_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC6_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC6_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC6_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC6_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC6_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC6_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC6_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC6_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC6.Reg, volatile.LoadUint32(&o.RGDAAC6.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC6_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC6.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC7: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC7_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC7_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC7_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC7_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC7_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC7_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC7_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC7_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC7_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC7_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC7_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC7_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC7_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC7_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC7_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC7_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC7_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC7_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC7_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC7_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC7_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC7_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC7_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC7_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC7_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC7_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC7_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC7_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC7_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC7_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC7_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC7_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC7_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC7_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC7_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC7_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC7_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC7_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC7_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC7.Reg, volatile.LoadUint32(&o.RGDAAC7.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC7_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC7.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC8: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC8_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC8_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC8_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC8_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC8_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC8_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC8_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC8_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC8_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC8_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC8_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC8_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC8_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC8_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC8_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC8_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC8_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC8_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC8_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC8_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC8_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC8_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC8_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC8_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC8_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC8_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC8_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC8_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC8_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC8_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC8_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC8_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC8_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC8_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC8_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC8_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC8_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC8_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC8_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC8.Reg, volatile.LoadUint32(&o.RGDAAC8.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC8_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC8.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC9: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC9_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC9_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC9_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC9_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC9_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC9_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC9_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC9_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC9_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC9_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC9_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC9_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC9_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC9_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC9_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC9_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC9_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC9_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC9_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC9_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC9_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC9_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC9_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC9_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC9_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC9_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC9_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC9_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC9_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC9_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC9_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC9_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC9_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC9_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC9_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC9_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC9_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC9_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC9_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC9.Reg, volatile.LoadUint32(&o.RGDAAC9.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC9_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC9.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC10: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC10_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC10_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC10_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC10_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC10_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC10_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC10_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC10_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC10_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC10_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC10_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC10_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC10_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC10_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC10_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC10_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC10_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC10_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC10_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC10_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC10_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC10_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC10_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC10_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC10_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC10_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC10_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC10_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC10_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC10_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC10_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC10_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC10_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC10_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC10_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC10_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC10_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC10_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC10_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC10.Reg, volatile.LoadUint32(&o.RGDAAC10.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC10_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC10.Reg) & 0x80000000) >> 31
}

// SYSMPU.RGDAAC11: Region Descriptor Alternate Access Control n
func (o *SYSMPU_Type) SetRGDAAC11_M0UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x7)|value)
}
func (o *SYSMPU_Type) GetRGDAAC11_M0UM() uint32 {
	return volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x7
}
func (o *SYSMPU_Type) SetRGDAAC11_M0SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x18)|value<<3)
}
func (o *SYSMPU_Type) GetRGDAAC11_M0SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x18) >> 3
}
func (o *SYSMPU_Type) SetRGDAAC11_M0PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x20)|value<<5)
}
func (o *SYSMPU_Type) GetRGDAAC11_M0PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x20) >> 5
}
func (o *SYSMPU_Type) SetRGDAAC11_M1UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x1c0)|value<<6)
}
func (o *SYSMPU_Type) GetRGDAAC11_M1UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x1c0) >> 6
}
func (o *SYSMPU_Type) SetRGDAAC11_M1SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x600)|value<<9)
}
func (o *SYSMPU_Type) GetRGDAAC11_M1SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x600) >> 9
}
func (o *SYSMPU_Type) SetRGDAAC11_M1PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x800)|value<<11)
}
func (o *SYSMPU_Type) GetRGDAAC11_M1PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x800) >> 11
}
func (o *SYSMPU_Type) SetRGDAAC11_M2UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x7000)|value<<12)
}
func (o *SYSMPU_Type) GetRGDAAC11_M2UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x7000) >> 12
}
func (o *SYSMPU_Type) SetRGDAAC11_M2SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x18000)|value<<15)
}
func (o *SYSMPU_Type) GetRGDAAC11_M2SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x18000) >> 15
}
func (o *SYSMPU_Type) SetRGDAAC11_M2PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x20000)|value<<17)
}
func (o *SYSMPU_Type) GetRGDAAC11_M2PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x20000) >> 17
}
func (o *SYSMPU_Type) SetRGDAAC11_M3UM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x1c0000)|value<<18)
}
func (o *SYSMPU_Type) GetRGDAAC11_M3UM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x1c0000) >> 18
}
func (o *SYSMPU_Type) SetRGDAAC11_M3SM(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x600000)|value<<21)
}
func (o *SYSMPU_Type) GetRGDAAC11_M3SM() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x600000) >> 21
}
func (o *SYSMPU_Type) SetRGDAAC11_M3PE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x800000)|value<<23)
}
func (o *SYSMPU_Type) GetRGDAAC11_M3PE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x800000) >> 23
}
func (o *SYSMPU_Type) SetRGDAAC11_M4WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSMPU_Type) GetRGDAAC11_M4WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x1000000) >> 24
}
func (o *SYSMPU_Type) SetRGDAAC11_M4RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSMPU_Type) GetRGDAAC11_M4RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x2000000) >> 25
}
func (o *SYSMPU_Type) SetRGDAAC11_M5WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSMPU_Type) GetRGDAAC11_M5WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x4000000) >> 26
}
func (o *SYSMPU_Type) SetRGDAAC11_M5RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSMPU_Type) GetRGDAAC11_M5RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x8000000) >> 27
}
func (o *SYSMPU_Type) SetRGDAAC11_M6WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSMPU_Type) GetRGDAAC11_M6WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x10000000) >> 28
}
func (o *SYSMPU_Type) SetRGDAAC11_M6RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSMPU_Type) GetRGDAAC11_M6RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x20000000) >> 29
}
func (o *SYSMPU_Type) SetRGDAAC11_M7WE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSMPU_Type) GetRGDAAC11_M7WE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x40000000) >> 30
}
func (o *SYSMPU_Type) SetRGDAAC11_M7RE(value uint32) {
	volatile.StoreUint32(&o.RGDAAC11.Reg, volatile.LoadUint32(&o.RGDAAC11.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSMPU_Type) GetRGDAAC11_M7RE() uint32 {
	return (volatile.LoadUint32(&o.RGDAAC11.Reg) & 0x80000000) >> 31
}

// Flash Memory Controller
type FMC_Type struct {
	PFAPR     volatile.Register32 // 0x0
	PFB0CR    volatile.Register32 // 0x4
	PFB1CR    volatile.Register32 // 0x8
	_         [244]byte
	TAGVDW0S0 volatile.Register32 // 0x100
	TAGVDW0S1 volatile.Register32 // 0x104
	TAGVDW0S2 volatile.Register32 // 0x108
	TAGVDW0S3 volatile.Register32 // 0x10C
	TAGVDW1S0 volatile.Register32 // 0x110
	TAGVDW1S1 volatile.Register32 // 0x114
	TAGVDW1S2 volatile.Register32 // 0x118
	TAGVDW1S3 volatile.Register32 // 0x11C
	TAGVDW2S0 volatile.Register32 // 0x120
	TAGVDW2S1 volatile.Register32 // 0x124
	TAGVDW2S2 volatile.Register32 // 0x128
	TAGVDW2S3 volatile.Register32 // 0x12C
	TAGVDW3S0 volatile.Register32 // 0x130
	TAGVDW3S1 volatile.Register32 // 0x134
	TAGVDW3S2 volatile.Register32 // 0x138
	TAGVDW3S3 volatile.Register32 // 0x13C
	_         [192]byte
	DATAW0S0U volatile.Register32 // 0x200
	DATAW0S0L volatile.Register32 // 0x204
	DATAW0S1U volatile.Register32 // 0x208
	DATAW0S1L volatile.Register32 // 0x20C
	DATAW0S2U volatile.Register32 // 0x210
	DATAW0S2L volatile.Register32 // 0x214
	DATAW0S3U volatile.Register32 // 0x218
	DATAW0S3L volatile.Register32 // 0x21C
	DATAW1S0U volatile.Register32 // 0x220
	DATAW1S0L volatile.Register32 // 0x224
	DATAW1S1U volatile.Register32 // 0x228
	DATAW1S1L volatile.Register32 // 0x22C
	DATAW1S2U volatile.Register32 // 0x230
	DATAW1S2L volatile.Register32 // 0x234
	DATAW1S3U volatile.Register32 // 0x238
	DATAW1S3L volatile.Register32 // 0x23C
	DATAW2S0U volatile.Register32 // 0x240
	DATAW2S0L volatile.Register32 // 0x244
	DATAW2S1U volatile.Register32 // 0x248
	DATAW2S1L volatile.Register32 // 0x24C
	DATAW2S2U volatile.Register32 // 0x250
	DATAW2S2L volatile.Register32 // 0x254
	DATAW2S3U volatile.Register32 // 0x258
	DATAW2S3L volatile.Register32 // 0x25C
	DATAW3S0U volatile.Register32 // 0x260
	DATAW3S0L volatile.Register32 // 0x264
	DATAW3S1U volatile.Register32 // 0x268
	DATAW3S1L volatile.Register32 // 0x26C
	DATAW3S2U volatile.Register32 // 0x270
	DATAW3S2L volatile.Register32 // 0x274
	DATAW3S3U volatile.Register32 // 0x278
	DATAW3S3L volatile.Register32 // 0x27C
}

// FMC.PFAPR: Flash Access Protection Register
func (o *FMC_Type) SetPFAPR_M0AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x3)|value)
}
func (o *FMC_Type) GetPFAPR_M0AP() uint32 {
	return volatile.LoadUint32(&o.PFAPR.Reg) & 0x3
}
func (o *FMC_Type) SetPFAPR_M1AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc)|value<<2)
}
func (o *FMC_Type) GetPFAPR_M1AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc) >> 2
}
func (o *FMC_Type) SetPFAPR_M2AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x30)|value<<4)
}
func (o *FMC_Type) GetPFAPR_M2AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x30) >> 4
}
func (o *FMC_Type) SetPFAPR_M3AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc0)|value<<6)
}
func (o *FMC_Type) GetPFAPR_M3AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc0) >> 6
}
func (o *FMC_Type) SetPFAPR_M4AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x300)|value<<8)
}
func (o *FMC_Type) GetPFAPR_M4AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x300) >> 8
}
func (o *FMC_Type) SetPFAPR_M5AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc00)|value<<10)
}
func (o *FMC_Type) GetPFAPR_M5AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc00) >> 10
}
func (o *FMC_Type) SetPFAPR_M6AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x3000)|value<<12)
}
func (o *FMC_Type) GetPFAPR_M6AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x3000) >> 12
}
func (o *FMC_Type) SetPFAPR_M7AP(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0xc000)|value<<14)
}
func (o *FMC_Type) GetPFAPR_M7AP() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0xc000) >> 14
}
func (o *FMC_Type) SetPFAPR_M0PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x10000)|value<<16)
}
func (o *FMC_Type) GetPFAPR_M0PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x10000) >> 16
}
func (o *FMC_Type) SetPFAPR_M1PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x20000)|value<<17)
}
func (o *FMC_Type) GetPFAPR_M1PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x20000) >> 17
}
func (o *FMC_Type) SetPFAPR_M2PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x40000)|value<<18)
}
func (o *FMC_Type) GetPFAPR_M2PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x40000) >> 18
}
func (o *FMC_Type) SetPFAPR_M3PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetPFAPR_M3PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetPFAPR_M4PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x100000)|value<<20)
}
func (o *FMC_Type) GetPFAPR_M4PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x100000) >> 20
}
func (o *FMC_Type) SetPFAPR_M5PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x200000)|value<<21)
}
func (o *FMC_Type) GetPFAPR_M5PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x200000) >> 21
}
func (o *FMC_Type) SetPFAPR_M6PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x400000)|value<<22)
}
func (o *FMC_Type) GetPFAPR_M6PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x400000) >> 22
}
func (o *FMC_Type) SetPFAPR_M7PFD(value uint32) {
	volatile.StoreUint32(&o.PFAPR.Reg, volatile.LoadUint32(&o.PFAPR.Reg)&^(0x800000)|value<<23)
}
func (o *FMC_Type) GetPFAPR_M7PFD() uint32 {
	return (volatile.LoadUint32(&o.PFAPR.Reg) & 0x800000) >> 23
}

// FMC.PFB0CR: Flash Bank 0 Control Register
func (o *FMC_Type) SetPFB0CR_B0SEBE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetPFB0CR_B0SEBE() uint32 {
	return volatile.LoadUint32(&o.PFB0CR.Reg) & 0x1
}
func (o *FMC_Type) SetPFB0CR_B0IPE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPFB0CR_B0IPE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPFB0CR_B0DPE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPFB0CR_B0DPE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPFB0CR_B0ICE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetPFB0CR_B0ICE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetPFB0CR_B0DCE(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetPFB0CR_B0DCE() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetPFB0CR_CRC(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xe0)|value<<5)
}
func (o *FMC_Type) GetPFB0CR_CRC() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xe0) >> 5
}
func (o *FMC_Type) SetPFB0CR_B0MW(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x60000)|value<<17)
}
func (o *FMC_Type) GetPFB0CR_B0MW() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x60000) >> 17
}
func (o *FMC_Type) SetPFB0CR_S_B_INV(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0x80000)|value<<19)
}
func (o *FMC_Type) GetPFB0CR_S_B_INV() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0x80000) >> 19
}
func (o *FMC_Type) SetPFB0CR_CINV_WAY(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf00000)|value<<20)
}
func (o *FMC_Type) GetPFB0CR_CINV_WAY() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf00000) >> 20
}
func (o *FMC_Type) SetPFB0CR_CLCK_WAY(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf000000)|value<<24)
}
func (o *FMC_Type) GetPFB0CR_CLCK_WAY() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf000000) >> 24
}
func (o *FMC_Type) SetPFB0CR_B0RWSC(value uint32) {
	volatile.StoreUint32(&o.PFB0CR.Reg, volatile.LoadUint32(&o.PFB0CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FMC_Type) GetPFB0CR_B0RWSC() uint32 {
	return (volatile.LoadUint32(&o.PFB0CR.Reg) & 0xf0000000) >> 28
}

// FMC.PFB1CR: Flash Bank 1 Control Register
func (o *FMC_Type) SetPFB1CR_B1SEBE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetPFB1CR_B1SEBE() uint32 {
	return volatile.LoadUint32(&o.PFB1CR.Reg) & 0x1
}
func (o *FMC_Type) SetPFB1CR_B1IPE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x2)|value<<1)
}
func (o *FMC_Type) GetPFB1CR_B1IPE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x2) >> 1
}
func (o *FMC_Type) SetPFB1CR_B1DPE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x4)|value<<2)
}
func (o *FMC_Type) GetPFB1CR_B1DPE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x4) >> 2
}
func (o *FMC_Type) SetPFB1CR_B1ICE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x8)|value<<3)
}
func (o *FMC_Type) GetPFB1CR_B1ICE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x8) >> 3
}
func (o *FMC_Type) SetPFB1CR_B1DCE(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x10)|value<<4)
}
func (o *FMC_Type) GetPFB1CR_B1DCE() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x10) >> 4
}
func (o *FMC_Type) SetPFB1CR_B1MW(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0x60000)|value<<17)
}
func (o *FMC_Type) GetPFB1CR_B1MW() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0x60000) >> 17
}
func (o *FMC_Type) SetPFB1CR_B1RWSC(value uint32) {
	volatile.StoreUint32(&o.PFB1CR.Reg, volatile.LoadUint32(&o.PFB1CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *FMC_Type) GetPFB1CR_B1RWSC() uint32 {
	return (volatile.LoadUint32(&o.PFB1CR.Reg) & 0xf0000000) >> 28
}

// FMC.TAGVDW0S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S0.Reg, volatile.LoadUint32(&o.TAGVDW0S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S0.Reg, volatile.LoadUint32(&o.TAGVDW0S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S1.Reg, volatile.LoadUint32(&o.TAGVDW0S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S1.Reg, volatile.LoadUint32(&o.TAGVDW0S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S2.Reg, volatile.LoadUint32(&o.TAGVDW0S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S2.Reg, volatile.LoadUint32(&o.TAGVDW0S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW0S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW0S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S3.Reg, volatile.LoadUint32(&o.TAGVDW0S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW0S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW0S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW0S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW0S3.Reg, volatile.LoadUint32(&o.TAGVDW0S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW0S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW0S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S0.Reg, volatile.LoadUint32(&o.TAGVDW1S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S0.Reg, volatile.LoadUint32(&o.TAGVDW1S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S1.Reg, volatile.LoadUint32(&o.TAGVDW1S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S1.Reg, volatile.LoadUint32(&o.TAGVDW1S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S2.Reg, volatile.LoadUint32(&o.TAGVDW1S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S2.Reg, volatile.LoadUint32(&o.TAGVDW1S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW1S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW1S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S3.Reg, volatile.LoadUint32(&o.TAGVDW1S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW1S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW1S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW1S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW1S3.Reg, volatile.LoadUint32(&o.TAGVDW1S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW1S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW1S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S0.Reg, volatile.LoadUint32(&o.TAGVDW2S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S0.Reg, volatile.LoadUint32(&o.TAGVDW2S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S1.Reg, volatile.LoadUint32(&o.TAGVDW2S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S1.Reg, volatile.LoadUint32(&o.TAGVDW2S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S2.Reg, volatile.LoadUint32(&o.TAGVDW2S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S2.Reg, volatile.LoadUint32(&o.TAGVDW2S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW2S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW2S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S3.Reg, volatile.LoadUint32(&o.TAGVDW2S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW2S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW2S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW2S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW2S3.Reg, volatile.LoadUint32(&o.TAGVDW2S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW2S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW2S3.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S0: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S0_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S0.Reg, volatile.LoadUint32(&o.TAGVDW3S0.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S0_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S0.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S0_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S0.Reg, volatile.LoadUint32(&o.TAGVDW3S0.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S0_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S0.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S1: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S1_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S1.Reg, volatile.LoadUint32(&o.TAGVDW3S1.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S1_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S1.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S1_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S1.Reg, volatile.LoadUint32(&o.TAGVDW3S1.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S1_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S1.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S2: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S2_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S2.Reg, volatile.LoadUint32(&o.TAGVDW3S2.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S2_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S2.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S2_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S2.Reg, volatile.LoadUint32(&o.TAGVDW3S2.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S2_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S2.Reg) & 0x7ffe0) >> 5
}

// FMC.TAGVDW3S3: Cache Tag Storage
func (o *FMC_Type) SetTAGVDW3S3_VALID(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S3.Reg, volatile.LoadUint32(&o.TAGVDW3S3.Reg)&^(0x1)|value)
}
func (o *FMC_Type) GetTAGVDW3S3_VALID() uint32 {
	return volatile.LoadUint32(&o.TAGVDW3S3.Reg) & 0x1
}
func (o *FMC_Type) SetTAGVDW3S3_TAG(value uint32) {
	volatile.StoreUint32(&o.TAGVDW3S3.Reg, volatile.LoadUint32(&o.TAGVDW3S3.Reg)&^(0x7ffe0)|value<<5)
}
func (o *FMC_Type) GetTAGVDW3S3_TAG() uint32 {
	return (volatile.LoadUint32(&o.TAGVDW3S3.Reg) & 0x7ffe0) >> 5
}

// FMC.DATAW0S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S0U.Reg)
}

// FMC.DATAW0S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S0L.Reg)
}

// FMC.DATAW0S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S1U.Reg)
}

// FMC.DATAW0S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S1L.Reg)
}

// FMC.DATAW0S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S2U.Reg)
}

// FMC.DATAW0S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S2L.Reg)
}

// FMC.DATAW0S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW0S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW0S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW0S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW0S3U.Reg)
}

// FMC.DATAW0S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW0S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW0S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW0S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW0S3L.Reg)
}

// FMC.DATAW1S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S0U.Reg)
}

// FMC.DATAW1S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S0L.Reg)
}

// FMC.DATAW1S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S1U.Reg)
}

// FMC.DATAW1S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S1L.Reg)
}

// FMC.DATAW1S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S2U.Reg)
}

// FMC.DATAW1S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S2L.Reg)
}

// FMC.DATAW1S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW1S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW1S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW1S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW1S3U.Reg)
}

// FMC.DATAW1S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW1S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW1S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW1S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW1S3L.Reg)
}

// FMC.DATAW2S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S0U.Reg)
}

// FMC.DATAW2S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S0L.Reg)
}

// FMC.DATAW2S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S1U.Reg)
}

// FMC.DATAW2S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S1L.Reg)
}

// FMC.DATAW2S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S2U.Reg)
}

// FMC.DATAW2S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S2L.Reg)
}

// FMC.DATAW2S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW2S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW2S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW2S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW2S3U.Reg)
}

// FMC.DATAW2S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW2S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW2S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW2S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW2S3L.Reg)
}

// FMC.DATAW3S0U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S0U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S0U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S0U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S0U.Reg)
}

// FMC.DATAW3S0L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S0L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S0L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S0L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S0L.Reg)
}

// FMC.DATAW3S1U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S1U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S1U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S1U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S1U.Reg)
}

// FMC.DATAW3S1L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S1L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S1L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S1L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S1L.Reg)
}

// FMC.DATAW3S2U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S2U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S2U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S2U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S2U.Reg)
}

// FMC.DATAW3S2L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S2L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S2L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S2L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S2L.Reg)
}

// FMC.DATAW3S3U: Cache Data Storage (upper word)
func (o *FMC_Type) SetDATAW3S3U(value uint32) {
	volatile.StoreUint32(&o.DATAW3S3U.Reg, value)
}
func (o *FMC_Type) GetDATAW3S3U() uint32 {
	return volatile.LoadUint32(&o.DATAW3S3U.Reg)
}

// FMC.DATAW3S3L: Cache Data Storage (lower word)
func (o *FMC_Type) SetDATAW3S3L(value uint32) {
	volatile.StoreUint32(&o.DATAW3S3L.Reg, value)
}
func (o *FMC_Type) GetDATAW3S3L() uint32 {
	return volatile.LoadUint32(&o.DATAW3S3L.Reg)
}

// Flash Memory Interface
type FTFE_Type struct {
	FSTAT  volatile.Register8 // 0x0
	FCNFG  volatile.Register8 // 0x1
	FSEC   volatile.Register8 // 0x2
	FOPT   volatile.Register8 // 0x3
	FCCOB3 volatile.Register8 // 0x4
	FCCOB2 volatile.Register8 // 0x5
	FCCOB1 volatile.Register8 // 0x6
	FCCOB0 volatile.Register8 // 0x7
	FCCOB7 volatile.Register8 // 0x8
	FCCOB6 volatile.Register8 // 0x9
	FCCOB5 volatile.Register8 // 0xA
	FCCOB4 volatile.Register8 // 0xB
	FCCOBB volatile.Register8 // 0xC
	FCCOBA volatile.Register8 // 0xD
	FCCOB9 volatile.Register8 // 0xE
	FCCOB8 volatile.Register8 // 0xF
	FPROT3 volatile.Register8 // 0x10
	FPROT2 volatile.Register8 // 0x11
	FPROT1 volatile.Register8 // 0x12
	FPROT0 volatile.Register8 // 0x13
	_      [2]byte
	FEPROT volatile.Register8 // 0x16
	FDPROT volatile.Register8 // 0x17
}

// FTFE.FSTAT: Flash Status Register
func (o *FTFE_Type) SetFSTAT_MGSTAT0(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x1)|value)
}
func (o *FTFE_Type) GetFSTAT_MGSTAT0() uint8 {
	return volatile.LoadUint8(&o.FSTAT.Reg) & 0x1
}
func (o *FTFE_Type) SetFSTAT_FPVIOL(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x10)|value<<4)
}
func (o *FTFE_Type) GetFSTAT_FPVIOL() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x10) >> 4
}
func (o *FTFE_Type) SetFSTAT_ACCERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x20)|value<<5)
}
func (o *FTFE_Type) GetFSTAT_ACCERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x20) >> 5
}
func (o *FTFE_Type) SetFSTAT_RDCOLERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x40)|value<<6)
}
func (o *FTFE_Type) GetFSTAT_RDCOLERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x40) >> 6
}
func (o *FTFE_Type) SetFSTAT_CCIF(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x80)|value<<7)
}
func (o *FTFE_Type) GetFSTAT_CCIF() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x80) >> 7
}

// FTFE.FCNFG: Flash Configuration Register
func (o *FTFE_Type) SetFCNFG_EEERDY(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x1)|value)
}
func (o *FTFE_Type) GetFCNFG_EEERDY() uint8 {
	return volatile.LoadUint8(&o.FCNFG.Reg) & 0x1
}
func (o *FTFE_Type) SetFCNFG_RAMRDY(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x2)|value<<1)
}
func (o *FTFE_Type) GetFCNFG_RAMRDY() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x2) >> 1
}
func (o *FTFE_Type) SetFCNFG_PFLSH(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x4)|value<<2)
}
func (o *FTFE_Type) GetFCNFG_PFLSH() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x4) >> 2
}
func (o *FTFE_Type) SetFCNFG_SWAP(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x8)|value<<3)
}
func (o *FTFE_Type) GetFCNFG_SWAP() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x8) >> 3
}
func (o *FTFE_Type) SetFCNFG_ERSSUSP(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x10)|value<<4)
}
func (o *FTFE_Type) GetFCNFG_ERSSUSP() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x10) >> 4
}
func (o *FTFE_Type) SetFCNFG_ERSAREQ(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x20)|value<<5)
}
func (o *FTFE_Type) GetFCNFG_ERSAREQ() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x20) >> 5
}
func (o *FTFE_Type) SetFCNFG_RDCOLLIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x40)|value<<6)
}
func (o *FTFE_Type) GetFCNFG_RDCOLLIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x40) >> 6
}
func (o *FTFE_Type) SetFCNFG_CCIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x80)|value<<7)
}
func (o *FTFE_Type) GetFCNFG_CCIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x80) >> 7
}

// FTFE.FSEC: Flash Security Register
func (o *FTFE_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFE_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFE_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFE_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFE_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFE_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFE_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFE_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFE.FOPT: Flash Option Register
func (o *FTFE_Type) SetFOPT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, value)
}
func (o *FTFE_Type) GetFOPT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg)
}

// FTFE.FCCOB3: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB3(value uint8) {
	volatile.StoreUint8(&o.FCCOB3.Reg, value)
}
func (o *FTFE_Type) GetFCCOB3() uint8 {
	return volatile.LoadUint8(&o.FCCOB3.Reg)
}

// FTFE.FCCOB2: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB2(value uint8) {
	volatile.StoreUint8(&o.FCCOB2.Reg, value)
}
func (o *FTFE_Type) GetFCCOB2() uint8 {
	return volatile.LoadUint8(&o.FCCOB2.Reg)
}

// FTFE.FCCOB1: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB1(value uint8) {
	volatile.StoreUint8(&o.FCCOB1.Reg, value)
}
func (o *FTFE_Type) GetFCCOB1() uint8 {
	return volatile.LoadUint8(&o.FCCOB1.Reg)
}

// FTFE.FCCOB0: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB0(value uint8) {
	volatile.StoreUint8(&o.FCCOB0.Reg, value)
}
func (o *FTFE_Type) GetFCCOB0() uint8 {
	return volatile.LoadUint8(&o.FCCOB0.Reg)
}

// FTFE.FCCOB7: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB7(value uint8) {
	volatile.StoreUint8(&o.FCCOB7.Reg, value)
}
func (o *FTFE_Type) GetFCCOB7() uint8 {
	return volatile.LoadUint8(&o.FCCOB7.Reg)
}

// FTFE.FCCOB6: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB6(value uint8) {
	volatile.StoreUint8(&o.FCCOB6.Reg, value)
}
func (o *FTFE_Type) GetFCCOB6() uint8 {
	return volatile.LoadUint8(&o.FCCOB6.Reg)
}

// FTFE.FCCOB5: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB5(value uint8) {
	volatile.StoreUint8(&o.FCCOB5.Reg, value)
}
func (o *FTFE_Type) GetFCCOB5() uint8 {
	return volatile.LoadUint8(&o.FCCOB5.Reg)
}

// FTFE.FCCOB4: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB4(value uint8) {
	volatile.StoreUint8(&o.FCCOB4.Reg, value)
}
func (o *FTFE_Type) GetFCCOB4() uint8 {
	return volatile.LoadUint8(&o.FCCOB4.Reg)
}

// FTFE.FCCOBB: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOBB(value uint8) {
	volatile.StoreUint8(&o.FCCOBB.Reg, value)
}
func (o *FTFE_Type) GetFCCOBB() uint8 {
	return volatile.LoadUint8(&o.FCCOBB.Reg)
}

// FTFE.FCCOBA: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOBA(value uint8) {
	volatile.StoreUint8(&o.FCCOBA.Reg, value)
}
func (o *FTFE_Type) GetFCCOBA() uint8 {
	return volatile.LoadUint8(&o.FCCOBA.Reg)
}

// FTFE.FCCOB9: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB9(value uint8) {
	volatile.StoreUint8(&o.FCCOB9.Reg, value)
}
func (o *FTFE_Type) GetFCCOB9() uint8 {
	return volatile.LoadUint8(&o.FCCOB9.Reg)
}

// FTFE.FCCOB8: Flash Common Command Object Registers
func (o *FTFE_Type) SetFCCOB8(value uint8) {
	volatile.StoreUint8(&o.FCCOB8.Reg, value)
}
func (o *FTFE_Type) GetFCCOB8() uint8 {
	return volatile.LoadUint8(&o.FCCOB8.Reg)
}

// FTFE.FPROT3: Program Flash Protection Registers
func (o *FTFE_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFE_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFE.FPROT2: Program Flash Protection Registers
func (o *FTFE_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFE_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFE.FPROT1: Program Flash Protection Registers
func (o *FTFE_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFE_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFE.FPROT0: Program Flash Protection Registers
func (o *FTFE_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFE_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFE.FEPROT: EEPROM Protection Register
func (o *FTFE_Type) SetFEPROT(value uint8) {
	volatile.StoreUint8(&o.FEPROT.Reg, value)
}
func (o *FTFE_Type) GetFEPROT() uint8 {
	return volatile.LoadUint8(&o.FEPROT.Reg)
}

// FTFE.FDPROT: Data Flash Protection Register
func (o *FTFE_Type) SetFDPROT(value uint8) {
	volatile.StoreUint8(&o.FDPROT.Reg, value)
}
func (o *FTFE_Type) GetFDPROT() uint8 {
	return volatile.LoadUint8(&o.FDPROT.Reg)
}

// DMA channel multiplexor
type DMAMUX_Type struct {
	CHCFG0  volatile.Register8 // 0x0
	CHCFG1  volatile.Register8 // 0x1
	CHCFG2  volatile.Register8 // 0x2
	CHCFG3  volatile.Register8 // 0x3
	CHCFG4  volatile.Register8 // 0x4
	CHCFG5  volatile.Register8 // 0x5
	CHCFG6  volatile.Register8 // 0x6
	CHCFG7  volatile.Register8 // 0x7
	CHCFG8  volatile.Register8 // 0x8
	CHCFG9  volatile.Register8 // 0x9
	CHCFG10 volatile.Register8 // 0xA
	CHCFG11 volatile.Register8 // 0xB
	CHCFG12 volatile.Register8 // 0xC
	CHCFG13 volatile.Register8 // 0xD
	CHCFG14 volatile.Register8 // 0xE
	CHCFG15 volatile.Register8 // 0xF
}

// DMAMUX.CHCFG0: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG0_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG0_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG0.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG0_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG0_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG0_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG0_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG1: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG1_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG1_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG1.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG1_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG1_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG1_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG1_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG2: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG2_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG2_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG2.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG2_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG2_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG2_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG2_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG3: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG3_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG3_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG3.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG3_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG3_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG3_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG3_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG4: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG4_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG4_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG4.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG4_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG4_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG4.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG4_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG4.Reg, volatile.LoadUint8(&o.CHCFG4.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG4_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG4.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG5: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG5_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG5_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG5.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG5_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG5_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG5.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG5_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG5.Reg, volatile.LoadUint8(&o.CHCFG5.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG5_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG5.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG6: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG6_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG6_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG6.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG6_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG6_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG6.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG6_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG6.Reg, volatile.LoadUint8(&o.CHCFG6.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG6_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG6.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG7: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG7_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG7_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG7.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG7_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG7_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG7.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG7_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG7.Reg, volatile.LoadUint8(&o.CHCFG7.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG7_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG7.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG8: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG8_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG8_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG8.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG8_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG8_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG8.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG8_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG8.Reg, volatile.LoadUint8(&o.CHCFG8.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG8_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG8.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG9: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG9_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG9_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG9.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG9_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG9_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG9.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG9_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG9.Reg, volatile.LoadUint8(&o.CHCFG9.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG9_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG9.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG10: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG10_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG10_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG10.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG10_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG10_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG10.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG10_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG10.Reg, volatile.LoadUint8(&o.CHCFG10.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG10_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG10.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG11: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG11_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG11_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG11.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG11_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG11_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG11.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG11_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG11.Reg, volatile.LoadUint8(&o.CHCFG11.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG11_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG11.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG12: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG12_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG12_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG12.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG12_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG12_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG12.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG12_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG12.Reg, volatile.LoadUint8(&o.CHCFG12.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG12_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG12.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG13: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG13_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG13_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG13.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG13_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG13_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG13.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG13_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG13.Reg, volatile.LoadUint8(&o.CHCFG13.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG13_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG13.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG14: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG14_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG14_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG14.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG14_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG14_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG14.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG14_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG14.Reg, volatile.LoadUint8(&o.CHCFG14.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG14_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG14.Reg) & 0x80) >> 7
}

// DMAMUX.CHCFG15: Channel Configuration register
func (o *DMAMUX_Type) SetCHCFG15_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x3f)|value)
}
func (o *DMAMUX_Type) GetCHCFG15_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG15.Reg) & 0x3f
}
func (o *DMAMUX_Type) SetCHCFG15_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCHCFG15_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG15.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCHCFG15_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG15.Reg, volatile.LoadUint8(&o.CHCFG15.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCHCFG15_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG15.Reg) & 0x80) >> 7
}

// Flex Controller Area Network module
type CAN0_Type struct {
	MCR      volatile.Register32 // 0x0
	CTRL1    volatile.Register32 // 0x4
	TIMER    volatile.Register32 // 0x8
	_        [4]byte
	RXMGMASK volatile.Register32 // 0x10
	RX14MASK volatile.Register32 // 0x14
	RX15MASK volatile.Register32 // 0x18
	ECR      volatile.Register32 // 0x1C
	ESR1     volatile.Register32 // 0x20
	_        [4]byte
	IMASK1   volatile.Register32 // 0x28
	_        [4]byte
	IFLAG1   volatile.Register32 // 0x30
	CTRL2    volatile.Register32 // 0x34
	ESR2     volatile.Register32 // 0x38
	_        [8]byte
	CRCR     volatile.Register32 // 0x44
	RXFGMASK volatile.Register32 // 0x48
	RXFIR    volatile.Register32 // 0x4C
	_        [48]byte
	CS0      volatile.Register32 // 0x80
	ID0      volatile.Register32 // 0x84
	WORD00   volatile.Register32 // 0x88
	WORD10   volatile.Register32 // 0x8C
	CS1      volatile.Register32 // 0x90
	ID1      volatile.Register32 // 0x94
	WORD01   volatile.Register32 // 0x98
	WORD11   volatile.Register32 // 0x9C
	CS2      volatile.Register32 // 0xA0
	ID2      volatile.Register32 // 0xA4
	WORD02   volatile.Register32 // 0xA8
	WORD12   volatile.Register32 // 0xAC
	CS3      volatile.Register32 // 0xB0
	ID3      volatile.Register32 // 0xB4
	WORD03   volatile.Register32 // 0xB8
	WORD13   volatile.Register32 // 0xBC
	CS4      volatile.Register32 // 0xC0
	ID4      volatile.Register32 // 0xC4
	WORD04   volatile.Register32 // 0xC8
	WORD14   volatile.Register32 // 0xCC
	CS5      volatile.Register32 // 0xD0
	ID5      volatile.Register32 // 0xD4
	WORD05   volatile.Register32 // 0xD8
	WORD15   volatile.Register32 // 0xDC
	CS6      volatile.Register32 // 0xE0
	ID6      volatile.Register32 // 0xE4
	WORD06   volatile.Register32 // 0xE8
	WORD16   volatile.Register32 // 0xEC
	CS7      volatile.Register32 // 0xF0
	ID7      volatile.Register32 // 0xF4
	WORD07   volatile.Register32 // 0xF8
	WORD17   volatile.Register32 // 0xFC
	CS8      volatile.Register32 // 0x100
	ID8      volatile.Register32 // 0x104
	WORD08   volatile.Register32 // 0x108
	WORD18   volatile.Register32 // 0x10C
	CS9      volatile.Register32 // 0x110
	ID9      volatile.Register32 // 0x114
	WORD09   volatile.Register32 // 0x118
	WORD19   volatile.Register32 // 0x11C
	CS10     volatile.Register32 // 0x120
	ID10     volatile.Register32 // 0x124
	WORD010  volatile.Register32 // 0x128
	WORD110  volatile.Register32 // 0x12C
	CS11     volatile.Register32 // 0x130
	ID11     volatile.Register32 // 0x134
	WORD011  volatile.Register32 // 0x138
	WORD111  volatile.Register32 // 0x13C
	CS12     volatile.Register32 // 0x140
	ID12     volatile.Register32 // 0x144
	WORD012  volatile.Register32 // 0x148
	WORD112  volatile.Register32 // 0x14C
	CS13     volatile.Register32 // 0x150
	ID13     volatile.Register32 // 0x154
	WORD013  volatile.Register32 // 0x158
	WORD113  volatile.Register32 // 0x15C
	CS14     volatile.Register32 // 0x160
	ID14     volatile.Register32 // 0x164
	WORD014  volatile.Register32 // 0x168
	WORD114  volatile.Register32 // 0x16C
	CS15     volatile.Register32 // 0x170
	ID15     volatile.Register32 // 0x174
	WORD015  volatile.Register32 // 0x178
	WORD115  volatile.Register32 // 0x17C
	_        [1792]byte
	RXIMR0   volatile.Register32 // 0x880
	RXIMR1   volatile.Register32 // 0x884
	RXIMR2   volatile.Register32 // 0x888
	RXIMR3   volatile.Register32 // 0x88C
	RXIMR4   volatile.Register32 // 0x890
	RXIMR5   volatile.Register32 // 0x894
	RXIMR6   volatile.Register32 // 0x898
	RXIMR7   volatile.Register32 // 0x89C
	RXIMR8   volatile.Register32 // 0x8A0
	RXIMR9   volatile.Register32 // 0x8A4
	RXIMR10  volatile.Register32 // 0x8A8
	RXIMR11  volatile.Register32 // 0x8AC
	RXIMR12  volatile.Register32 // 0x8B0
	RXIMR13  volatile.Register32 // 0x8B4
	RXIMR14  volatile.Register32 // 0x8B8
	RXIMR15  volatile.Register32 // 0x8BC
}

// CAN0.MCR: Module Configuration Register
func (o *CAN0_Type) SetMCR_MAXMB(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x7f)|value)
}
func (o *CAN0_Type) GetMCR_MAXMB() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x7f
}
func (o *CAN0_Type) SetMCR_IDAM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x300)|value<<8)
}
func (o *CAN0_Type) GetMCR_IDAM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x300) >> 8
}
func (o *CAN0_Type) SetMCR_AEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetMCR_AEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetMCR_LPRIOEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetMCR_LPRIOEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetMCR_IRMQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetMCR_IRMQ() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetMCR_SRXDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetMCR_SRXDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetMCR_WAKSRC(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetMCR_WAKSRC() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetMCR_LPMACK(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetMCR_LPMACK() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetMCR_WRNEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetMCR_WRNEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetMCR_SLFWAK(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetMCR_SLFWAK() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetMCR_SUPV(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetMCR_SUPV() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetMCR_FRZACK(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetMCR_FRZACK() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetMCR_SOFTRST(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetMCR_SOFTRST() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetMCR_WAKMSK(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetMCR_WAKMSK() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetMCR_NOTRDY(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetMCR_NOTRDY() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetMCR_HALT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetMCR_HALT() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetMCR_RFEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetMCR_RFEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetMCR_FRZ() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// CAN0.CTRL1: Control 1 register
func (o *CAN0_Type) SetCTRL1_PROPSEG(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x7)|value)
}
func (o *CAN0_Type) GetCTRL1_PROPSEG() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x7
}
func (o *CAN0_Type) SetCTRL1_LOM(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetCTRL1_LOM() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetCTRL1_LBUF(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetCTRL1_LBUF() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetCTRL1_TSYN(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetCTRL1_TSYN() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetCTRL1_BOFFREC(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetCTRL1_BOFFREC() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetCTRL1_SMP(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetCTRL1_SMP() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetCTRL1_RWRNMSK(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetCTRL1_RWRNMSK() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetCTRL1_TWRNMSK(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetCTRL1_TWRNMSK() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetCTRL1_LPB(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetCTRL1_LPB() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetCTRL1_CLKSRC(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetCTRL1_CLKSRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetCTRL1_ERRMSK(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetCTRL1_ERRMSK() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetCTRL1_BOFFMSK(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetCTRL1_BOFFMSK() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetCTRL1_PSEG2(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x70000)|value<<16)
}
func (o *CAN0_Type) GetCTRL1_PSEG2() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x70000) >> 16
}
func (o *CAN0_Type) SetCTRL1_PSEG1(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x380000)|value<<19)
}
func (o *CAN0_Type) GetCTRL1_PSEG1() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x380000) >> 19
}
func (o *CAN0_Type) SetCTRL1_RJW(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xc00000)|value<<22)
}
func (o *CAN0_Type) GetCTRL1_RJW() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xc00000) >> 22
}
func (o *CAN0_Type) SetCTRL1_PRESDIV(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetCTRL1_PRESDIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xff000000) >> 24
}

// CAN0.TIMER: Free Running Timer
func (o *CAN0_Type) SetTIMER(value uint32) {
	volatile.StoreUint32(&o.TIMER.Reg, volatile.LoadUint32(&o.TIMER.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetTIMER() uint32 {
	return volatile.LoadUint32(&o.TIMER.Reg) & 0xffff
}

// CAN0.RXMGMASK: Rx Mailboxes Global Mask Register
func (o *CAN0_Type) SetRXMGMASK_MG0(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXMGMASK_MG0() uint32 {
	return volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x1
}
func (o *CAN0_Type) SetRXMGMASK_MG1(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXMGMASK_MG1() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXMGMASK_MG2(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXMGMASK_MG2() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXMGMASK_MG3(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXMGMASK_MG3() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXMGMASK_MG4(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXMGMASK_MG4() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXMGMASK_MG5(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXMGMASK_MG5() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXMGMASK_MG6(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXMGMASK_MG6() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXMGMASK_MG7(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXMGMASK_MG7() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXMGMASK_MG8(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXMGMASK_MG8() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXMGMASK_MG9(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXMGMASK_MG9() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXMGMASK_MG10(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXMGMASK_MG10() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXMGMASK_MG11(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXMGMASK_MG11() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXMGMASK_MG12(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXMGMASK_MG12() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXMGMASK_MG13(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXMGMASK_MG13() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXMGMASK_MG14(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXMGMASK_MG14() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXMGMASK_MG15(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXMGMASK_MG15() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXMGMASK_MG16(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXMGMASK_MG16() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXMGMASK_MG17(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXMGMASK_MG17() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXMGMASK_MG18(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXMGMASK_MG18() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXMGMASK_MG19(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXMGMASK_MG19() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXMGMASK_MG20(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXMGMASK_MG20() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXMGMASK_MG21(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXMGMASK_MG21() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXMGMASK_MG22(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXMGMASK_MG22() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXMGMASK_MG23(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXMGMASK_MG23() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXMGMASK_MG24(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXMGMASK_MG24() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXMGMASK_MG25(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXMGMASK_MG25() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXMGMASK_MG26(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXMGMASK_MG26() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXMGMASK_MG27(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXMGMASK_MG27() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXMGMASK_MG28(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXMGMASK_MG28() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXMGMASK_MG29(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXMGMASK_MG29() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXMGMASK_MG30(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXMGMASK_MG30() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXMGMASK_MG31(value uint32) {
	volatile.StoreUint32(&o.RXMGMASK.Reg, volatile.LoadUint32(&o.RXMGMASK.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXMGMASK_MG31() uint32 {
	return (volatile.LoadUint32(&o.RXMGMASK.Reg) & 0x80000000) >> 31
}

// CAN0.RX14MASK: Rx 14 Mask register
func (o *CAN0_Type) SetRX14MASK_RX14M0(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRX14MASK_RX14M0() uint32 {
	return volatile.LoadUint32(&o.RX14MASK.Reg) & 0x1
}
func (o *CAN0_Type) SetRX14MASK_RX14M1(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRX14MASK_RX14M1() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRX14MASK_RX14M2(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRX14MASK_RX14M2() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRX14MASK_RX14M3(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRX14MASK_RX14M3() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRX14MASK_RX14M4(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRX14MASK_RX14M4() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRX14MASK_RX14M5(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRX14MASK_RX14M5() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRX14MASK_RX14M6(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRX14MASK_RX14M6() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRX14MASK_RX14M7(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRX14MASK_RX14M7() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRX14MASK_RX14M8(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRX14MASK_RX14M8() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRX14MASK_RX14M9(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRX14MASK_RX14M9() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRX14MASK_RX14M10(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRX14MASK_RX14M10() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRX14MASK_RX14M11(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRX14MASK_RX14M11() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRX14MASK_RX14M12(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRX14MASK_RX14M12() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRX14MASK_RX14M13(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRX14MASK_RX14M13() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRX14MASK_RX14M14(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRX14MASK_RX14M14() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRX14MASK_RX14M15(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRX14MASK_RX14M15() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRX14MASK_RX14M16(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRX14MASK_RX14M16() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRX14MASK_RX14M17(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRX14MASK_RX14M17() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRX14MASK_RX14M18(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRX14MASK_RX14M18() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRX14MASK_RX14M19(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRX14MASK_RX14M19() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRX14MASK_RX14M20(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRX14MASK_RX14M20() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRX14MASK_RX14M21(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRX14MASK_RX14M21() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRX14MASK_RX14M22(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRX14MASK_RX14M22() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRX14MASK_RX14M23(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRX14MASK_RX14M23() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRX14MASK_RX14M24(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRX14MASK_RX14M24() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRX14MASK_RX14M25(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRX14MASK_RX14M25() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRX14MASK_RX14M26(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRX14MASK_RX14M26() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRX14MASK_RX14M27(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRX14MASK_RX14M27() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRX14MASK_RX14M28(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRX14MASK_RX14M28() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRX14MASK_RX14M29(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRX14MASK_RX14M29() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRX14MASK_RX14M30(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRX14MASK_RX14M30() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRX14MASK_RX14M31(value uint32) {
	volatile.StoreUint32(&o.RX14MASK.Reg, volatile.LoadUint32(&o.RX14MASK.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRX14MASK_RX14M31() uint32 {
	return (volatile.LoadUint32(&o.RX14MASK.Reg) & 0x80000000) >> 31
}

// CAN0.RX15MASK: Rx 15 Mask register
func (o *CAN0_Type) SetRX15MASK_RX15M0(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRX15MASK_RX15M0() uint32 {
	return volatile.LoadUint32(&o.RX15MASK.Reg) & 0x1
}
func (o *CAN0_Type) SetRX15MASK_RX15M1(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRX15MASK_RX15M1() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRX15MASK_RX15M2(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRX15MASK_RX15M2() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRX15MASK_RX15M3(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRX15MASK_RX15M3() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRX15MASK_RX15M4(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRX15MASK_RX15M4() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRX15MASK_RX15M5(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRX15MASK_RX15M5() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRX15MASK_RX15M6(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRX15MASK_RX15M6() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRX15MASK_RX15M7(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRX15MASK_RX15M7() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRX15MASK_RX15M8(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRX15MASK_RX15M8() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRX15MASK_RX15M9(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRX15MASK_RX15M9() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRX15MASK_RX15M10(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRX15MASK_RX15M10() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRX15MASK_RX15M11(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRX15MASK_RX15M11() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRX15MASK_RX15M12(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRX15MASK_RX15M12() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRX15MASK_RX15M13(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRX15MASK_RX15M13() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRX15MASK_RX15M14(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRX15MASK_RX15M14() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRX15MASK_RX15M15(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRX15MASK_RX15M15() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRX15MASK_RX15M16(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRX15MASK_RX15M16() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRX15MASK_RX15M17(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRX15MASK_RX15M17() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRX15MASK_RX15M18(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRX15MASK_RX15M18() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRX15MASK_RX15M19(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRX15MASK_RX15M19() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRX15MASK_RX15M20(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRX15MASK_RX15M20() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRX15MASK_RX15M21(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRX15MASK_RX15M21() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRX15MASK_RX15M22(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRX15MASK_RX15M22() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRX15MASK_RX15M23(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRX15MASK_RX15M23() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRX15MASK_RX15M24(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRX15MASK_RX15M24() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRX15MASK_RX15M25(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRX15MASK_RX15M25() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRX15MASK_RX15M26(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRX15MASK_RX15M26() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRX15MASK_RX15M27(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRX15MASK_RX15M27() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRX15MASK_RX15M28(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRX15MASK_RX15M28() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRX15MASK_RX15M29(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRX15MASK_RX15M29() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRX15MASK_RX15M30(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRX15MASK_RX15M30() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRX15MASK_RX15M31(value uint32) {
	volatile.StoreUint32(&o.RX15MASK.Reg, volatile.LoadUint32(&o.RX15MASK.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRX15MASK_RX15M31() uint32 {
	return (volatile.LoadUint32(&o.RX15MASK.Reg) & 0x80000000) >> 31
}

// CAN0.ECR: Error Counter
func (o *CAN0_Type) SetECR_TXERRCNT(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetECR_TXERRCNT() uint32 {
	return volatile.LoadUint32(&o.ECR.Reg) & 0xff
}
func (o *CAN0_Type) SetECR_RXERRCNT(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetECR_RXERRCNT() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff00) >> 8
}

// CAN0.ESR1: Error and Status 1 register
func (o *CAN0_Type) SetESR1_WAKINT(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetESR1_WAKINT() uint32 {
	return volatile.LoadUint32(&o.ESR1.Reg) & 0x1
}
func (o *CAN0_Type) SetESR1_ERRINT(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetESR1_ERRINT() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetESR1_BOFFINT(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetESR1_BOFFINT() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetESR1_RX(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetESR1_RX() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetESR1_FLTCONF(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x30)|value<<4)
}
func (o *CAN0_Type) GetESR1_FLTCONF() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x30) >> 4
}
func (o *CAN0_Type) SetESR1_TX(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetESR1_TX() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetESR1_IDLE(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetESR1_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetESR1_RXWRN(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetESR1_RXWRN() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetESR1_TXWRN(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetESR1_TXWRN() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetESR1_STFERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetESR1_STFERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetESR1_FRMERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetESR1_FRMERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetESR1_CRCERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetESR1_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetESR1_ACKERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetESR1_ACKERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetESR1_BIT0ERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetESR1_BIT0ERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetESR1_BIT1ERR(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetESR1_BIT1ERR() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetESR1_RWRNINT(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetESR1_RWRNINT() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetESR1_TWRNINT(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetESR1_TWRNINT() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetESR1_SYNCH(value uint32) {
	volatile.StoreUint32(&o.ESR1.Reg, volatile.LoadUint32(&o.ESR1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetESR1_SYNCH() uint32 {
	return (volatile.LoadUint32(&o.ESR1.Reg) & 0x40000) >> 18
}

// CAN0.IMASK1: Interrupt Masks 1 register
func (o *CAN0_Type) SetIMASK1_BUFLM0(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetIMASK1_BUFLM0() uint32 {
	return volatile.LoadUint32(&o.IMASK1.Reg) & 0x1
}
func (o *CAN0_Type) SetIMASK1_BUFLM1(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetIMASK1_BUFLM1() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetIMASK1_BUFLM2(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetIMASK1_BUFLM2() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetIMASK1_BUFLM3(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetIMASK1_BUFLM3() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetIMASK1_BUFLM4(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetIMASK1_BUFLM4() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetIMASK1_BUFLM5(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetIMASK1_BUFLM5() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetIMASK1_BUFLM6(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetIMASK1_BUFLM6() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetIMASK1_BUFLM7(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetIMASK1_BUFLM7() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetIMASK1_BUFLM8(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetIMASK1_BUFLM8() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetIMASK1_BUFLM9(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetIMASK1_BUFLM9() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetIMASK1_BUFLM10(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetIMASK1_BUFLM10() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetIMASK1_BUFLM11(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetIMASK1_BUFLM11() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetIMASK1_BUFLM12(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetIMASK1_BUFLM12() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetIMASK1_BUFLM13(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetIMASK1_BUFLM13() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetIMASK1_BUFLM14(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetIMASK1_BUFLM14() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetIMASK1_BUFLM15(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetIMASK1_BUFLM15() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetIMASK1_BUFLM16(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetIMASK1_BUFLM16() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetIMASK1_BUFLM17(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetIMASK1_BUFLM17() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetIMASK1_BUFLM18(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetIMASK1_BUFLM18() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetIMASK1_BUFLM19(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetIMASK1_BUFLM19() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetIMASK1_BUFLM20(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetIMASK1_BUFLM20() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetIMASK1_BUFLM21(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetIMASK1_BUFLM21() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetIMASK1_BUFLM22(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetIMASK1_BUFLM22() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetIMASK1_BUFLM23(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetIMASK1_BUFLM23() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetIMASK1_BUFLM24(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetIMASK1_BUFLM24() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetIMASK1_BUFLM25(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetIMASK1_BUFLM25() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetIMASK1_BUFLM26(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetIMASK1_BUFLM26() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetIMASK1_BUFLM27(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetIMASK1_BUFLM27() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetIMASK1_BUFLM28(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetIMASK1_BUFLM28() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetIMASK1_BUFLM29(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetIMASK1_BUFLM29() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetIMASK1_BUFLM30(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetIMASK1_BUFLM30() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetIMASK1_BUFLM31(value uint32) {
	volatile.StoreUint32(&o.IMASK1.Reg, volatile.LoadUint32(&o.IMASK1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetIMASK1_BUFLM31() uint32 {
	return (volatile.LoadUint32(&o.IMASK1.Reg) & 0x80000000) >> 31
}

// CAN0.IFLAG1: Interrupt Flags 1 register
func (o *CAN0_Type) SetIFLAG1_BUF0I(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetIFLAG1_BUF0I() uint32 {
	return volatile.LoadUint32(&o.IFLAG1.Reg) & 0x1
}
func (o *CAN0_Type) SetIFLAG1_BUF4TO1I0(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetIFLAG1_BUF4TO1I0() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetIFLAG1_BUF4TO1I1(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetIFLAG1_BUF4TO1I1() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetIFLAG1_BUF4TO1I2(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetIFLAG1_BUF4TO1I2() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetIFLAG1_BUF4TO1I3(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetIFLAG1_BUF4TO1I3() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetIFLAG1_BUF5I(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetIFLAG1_BUF5I() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetIFLAG1_BUF6I(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetIFLAG1_BUF6I() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetIFLAG1_BUF7I(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetIFLAG1_BUF7I() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I0(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I0() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I1(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I1() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I2(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I2() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I3(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I3() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I4(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I4() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I5(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I5() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I6(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I6() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I7(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I7() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I8(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I8() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I9(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I9() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I10(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I10() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I11(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I11() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I12(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I12() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I13(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I13() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I14(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I14() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I15(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I15() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I16(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I16() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I17(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I17() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I18(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I18() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I19(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I19() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I20(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I20() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I21(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I21() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I22(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I22() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetIFLAG1_BUF31TO8I23(value uint32) {
	volatile.StoreUint32(&o.IFLAG1.Reg, volatile.LoadUint32(&o.IFLAG1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetIFLAG1_BUF31TO8I23() uint32 {
	return (volatile.LoadUint32(&o.IFLAG1.Reg) & 0x80000000) >> 31
}

// CAN0.CTRL2: Control 2 register
func (o *CAN0_Type) SetCTRL2_EACEN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetCTRL2_EACEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetCTRL2_RRS(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetCTRL2_RRS() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetCTRL2_MRP(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetCTRL2_MRP() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetCTRL2_TASD(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xf80000)|value<<19)
}
func (o *CAN0_Type) GetCTRL2_TASD() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xf80000) >> 19
}
func (o *CAN0_Type) SetCTRL2_RFFN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCTRL2_RFFN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xf000000) >> 24
}
func (o *CAN0_Type) SetCTRL2_WRMFRZ(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetCTRL2_WRMFRZ() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x10000000) >> 28
}

// CAN0.ESR2: Error and Status 2 register
func (o *CAN0_Type) SetESR2_IMB(value uint32) {
	volatile.StoreUint32(&o.ESR2.Reg, volatile.LoadUint32(&o.ESR2.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetESR2_IMB() uint32 {
	return (volatile.LoadUint32(&o.ESR2.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetESR2_VPS(value uint32) {
	volatile.StoreUint32(&o.ESR2.Reg, volatile.LoadUint32(&o.ESR2.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetESR2_VPS() uint32 {
	return (volatile.LoadUint32(&o.ESR2.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetESR2_LPTM(value uint32) {
	volatile.StoreUint32(&o.ESR2.Reg, volatile.LoadUint32(&o.ESR2.Reg)&^(0x7f0000)|value<<16)
}
func (o *CAN0_Type) GetESR2_LPTM() uint32 {
	return (volatile.LoadUint32(&o.ESR2.Reg) & 0x7f0000) >> 16
}

// CAN0.CRCR: CRC Register
func (o *CAN0_Type) SetCRCR_TXCRC(value uint32) {
	volatile.StoreUint32(&o.CRCR.Reg, volatile.LoadUint32(&o.CRCR.Reg)&^(0x7fff)|value)
}
func (o *CAN0_Type) GetCRCR_TXCRC() uint32 {
	return volatile.LoadUint32(&o.CRCR.Reg) & 0x7fff
}
func (o *CAN0_Type) SetCRCR_MBCRC(value uint32) {
	volatile.StoreUint32(&o.CRCR.Reg, volatile.LoadUint32(&o.CRCR.Reg)&^(0x7f0000)|value<<16)
}
func (o *CAN0_Type) GetCRCR_MBCRC() uint32 {
	return (volatile.LoadUint32(&o.CRCR.Reg) & 0x7f0000) >> 16
}

// CAN0.RXFGMASK: Rx FIFO Global Mask register
func (o *CAN0_Type) SetRXFGMASK_FGM0(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXFGMASK_FGM0() uint32 {
	return volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x1
}
func (o *CAN0_Type) SetRXFGMASK_FGM1(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXFGMASK_FGM1() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXFGMASK_FGM2(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXFGMASK_FGM2() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXFGMASK_FGM3(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXFGMASK_FGM3() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXFGMASK_FGM4(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXFGMASK_FGM4() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXFGMASK_FGM5(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXFGMASK_FGM5() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXFGMASK_FGM6(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXFGMASK_FGM6() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXFGMASK_FGM7(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXFGMASK_FGM7() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXFGMASK_FGM8(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXFGMASK_FGM8() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXFGMASK_FGM9(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXFGMASK_FGM9() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXFGMASK_FGM10(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXFGMASK_FGM10() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXFGMASK_FGM11(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXFGMASK_FGM11() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXFGMASK_FGM12(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXFGMASK_FGM12() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXFGMASK_FGM13(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXFGMASK_FGM13() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXFGMASK_FGM14(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXFGMASK_FGM14() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXFGMASK_FGM15(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXFGMASK_FGM15() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXFGMASK_FGM16(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXFGMASK_FGM16() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXFGMASK_FGM17(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXFGMASK_FGM17() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXFGMASK_FGM18(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXFGMASK_FGM18() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXFGMASK_FGM19(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXFGMASK_FGM19() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXFGMASK_FGM20(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXFGMASK_FGM20() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXFGMASK_FGM21(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXFGMASK_FGM21() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXFGMASK_FGM22(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXFGMASK_FGM22() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXFGMASK_FGM23(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXFGMASK_FGM23() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXFGMASK_FGM24(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXFGMASK_FGM24() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXFGMASK_FGM25(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXFGMASK_FGM25() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXFGMASK_FGM26(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXFGMASK_FGM26() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXFGMASK_FGM27(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXFGMASK_FGM27() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXFGMASK_FGM28(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXFGMASK_FGM28() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXFGMASK_FGM29(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXFGMASK_FGM29() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXFGMASK_FGM30(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXFGMASK_FGM30() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXFGMASK_FGM31(value uint32) {
	volatile.StoreUint32(&o.RXFGMASK.Reg, volatile.LoadUint32(&o.RXFGMASK.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXFGMASK_FGM31() uint32 {
	return (volatile.LoadUint32(&o.RXFGMASK.Reg) & 0x80000000) >> 31
}

// CAN0.RXFIR: Rx FIFO Information Register
func (o *CAN0_Type) SetRXFIR_IDHIT(value uint32) {
	volatile.StoreUint32(&o.RXFIR.Reg, volatile.LoadUint32(&o.RXFIR.Reg)&^(0x1ff)|value)
}
func (o *CAN0_Type) GetRXFIR_IDHIT() uint32 {
	return volatile.LoadUint32(&o.RXFIR.Reg) & 0x1ff
}

// CAN0.CS0: Message Buffer 0 CS Register
func (o *CAN0_Type) SetCS0_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS0_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS0.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS0_DLC(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS0_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS0.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS0_RTR(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS0_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS0.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS0_IDE(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS0_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS0.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS0_SRR(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS0_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS0.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS0_CODE(value uint32) {
	volatile.StoreUint32(&o.CS0.Reg, volatile.LoadUint32(&o.CS0.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS0_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS0.Reg) & 0xf000000) >> 24
}

// CAN0.ID0: Message Buffer 0 ID Register
func (o *CAN0_Type) SetID0_EXT(value uint32) {
	volatile.StoreUint32(&o.ID0.Reg, volatile.LoadUint32(&o.ID0.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID0_EXT() uint32 {
	return volatile.LoadUint32(&o.ID0.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID0_STD(value uint32) {
	volatile.StoreUint32(&o.ID0.Reg, volatile.LoadUint32(&o.ID0.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID0_STD() uint32 {
	return (volatile.LoadUint32(&o.ID0.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID0_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID0.Reg, volatile.LoadUint32(&o.ID0.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID0_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID0.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD00: Message Buffer 0 WORD0 Register
func (o *CAN0_Type) SetWORD00_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD00.Reg, volatile.LoadUint32(&o.WORD00.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD00_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD00.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD00_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD00.Reg, volatile.LoadUint32(&o.WORD00.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD00_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD00.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD00_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD00.Reg, volatile.LoadUint32(&o.WORD00.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD00_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD00.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD00_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD00.Reg, volatile.LoadUint32(&o.WORD00.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD00_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD00.Reg) & 0xff000000) >> 24
}

// CAN0.WORD10: Message Buffer 0 WORD1 Register
func (o *CAN0_Type) SetWORD10_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD10.Reg, volatile.LoadUint32(&o.WORD10.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD10_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD10.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD10_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD10.Reg, volatile.LoadUint32(&o.WORD10.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD10_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD10.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD10_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD10.Reg, volatile.LoadUint32(&o.WORD10.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD10_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD10.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD10_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD10.Reg, volatile.LoadUint32(&o.WORD10.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD10_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD10.Reg) & 0xff000000) >> 24
}

// CAN0.CS1: Message Buffer 1 CS Register
func (o *CAN0_Type) SetCS1_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS1_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS1.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS1_DLC(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS1_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS1.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS1_RTR(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS1_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS1.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS1_IDE(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS1_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS1.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS1_SRR(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS1_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS1.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS1_CODE(value uint32) {
	volatile.StoreUint32(&o.CS1.Reg, volatile.LoadUint32(&o.CS1.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS1_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS1.Reg) & 0xf000000) >> 24
}

// CAN0.ID1: Message Buffer 1 ID Register
func (o *CAN0_Type) SetID1_EXT(value uint32) {
	volatile.StoreUint32(&o.ID1.Reg, volatile.LoadUint32(&o.ID1.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID1_EXT() uint32 {
	return volatile.LoadUint32(&o.ID1.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID1_STD(value uint32) {
	volatile.StoreUint32(&o.ID1.Reg, volatile.LoadUint32(&o.ID1.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID1_STD() uint32 {
	return (volatile.LoadUint32(&o.ID1.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID1_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID1.Reg, volatile.LoadUint32(&o.ID1.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID1_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID1.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD01: Message Buffer 1 WORD0 Register
func (o *CAN0_Type) SetWORD01_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD01.Reg, volatile.LoadUint32(&o.WORD01.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD01_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD01.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD01_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD01.Reg, volatile.LoadUint32(&o.WORD01.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD01_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD01.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD01_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD01.Reg, volatile.LoadUint32(&o.WORD01.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD01_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD01.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD01_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD01.Reg, volatile.LoadUint32(&o.WORD01.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD01_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD01.Reg) & 0xff000000) >> 24
}

// CAN0.WORD11: Message Buffer 1 WORD1 Register
func (o *CAN0_Type) SetWORD11_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD11.Reg, volatile.LoadUint32(&o.WORD11.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD11_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD11.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD11_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD11.Reg, volatile.LoadUint32(&o.WORD11.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD11_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD11.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD11_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD11.Reg, volatile.LoadUint32(&o.WORD11.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD11_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD11.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD11_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD11.Reg, volatile.LoadUint32(&o.WORD11.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD11_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD11.Reg) & 0xff000000) >> 24
}

// CAN0.CS2: Message Buffer 2 CS Register
func (o *CAN0_Type) SetCS2_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS2_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS2.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS2_DLC(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS2_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS2.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS2_RTR(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS2_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS2.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS2_IDE(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS2_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS2.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS2_SRR(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS2_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS2.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS2_CODE(value uint32) {
	volatile.StoreUint32(&o.CS2.Reg, volatile.LoadUint32(&o.CS2.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS2_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS2.Reg) & 0xf000000) >> 24
}

// CAN0.ID2: Message Buffer 2 ID Register
func (o *CAN0_Type) SetID2_EXT(value uint32) {
	volatile.StoreUint32(&o.ID2.Reg, volatile.LoadUint32(&o.ID2.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID2_EXT() uint32 {
	return volatile.LoadUint32(&o.ID2.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID2_STD(value uint32) {
	volatile.StoreUint32(&o.ID2.Reg, volatile.LoadUint32(&o.ID2.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID2_STD() uint32 {
	return (volatile.LoadUint32(&o.ID2.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID2_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID2.Reg, volatile.LoadUint32(&o.ID2.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID2_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID2.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD02: Message Buffer 2 WORD0 Register
func (o *CAN0_Type) SetWORD02_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD02.Reg, volatile.LoadUint32(&o.WORD02.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD02_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD02.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD02_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD02.Reg, volatile.LoadUint32(&o.WORD02.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD02_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD02.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD02_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD02.Reg, volatile.LoadUint32(&o.WORD02.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD02_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD02.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD02_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD02.Reg, volatile.LoadUint32(&o.WORD02.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD02_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD02.Reg) & 0xff000000) >> 24
}

// CAN0.WORD12: Message Buffer 2 WORD1 Register
func (o *CAN0_Type) SetWORD12_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD12.Reg, volatile.LoadUint32(&o.WORD12.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD12_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD12.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD12_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD12.Reg, volatile.LoadUint32(&o.WORD12.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD12_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD12.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD12_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD12.Reg, volatile.LoadUint32(&o.WORD12.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD12_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD12.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD12_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD12.Reg, volatile.LoadUint32(&o.WORD12.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD12_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD12.Reg) & 0xff000000) >> 24
}

// CAN0.CS3: Message Buffer 3 CS Register
func (o *CAN0_Type) SetCS3_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS3_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS3.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS3_DLC(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS3_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS3.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS3_RTR(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS3_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS3.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS3_IDE(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS3_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS3.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS3_SRR(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS3_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS3.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS3_CODE(value uint32) {
	volatile.StoreUint32(&o.CS3.Reg, volatile.LoadUint32(&o.CS3.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS3_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS3.Reg) & 0xf000000) >> 24
}

// CAN0.ID3: Message Buffer 3 ID Register
func (o *CAN0_Type) SetID3_EXT(value uint32) {
	volatile.StoreUint32(&o.ID3.Reg, volatile.LoadUint32(&o.ID3.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID3_EXT() uint32 {
	return volatile.LoadUint32(&o.ID3.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID3_STD(value uint32) {
	volatile.StoreUint32(&o.ID3.Reg, volatile.LoadUint32(&o.ID3.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID3_STD() uint32 {
	return (volatile.LoadUint32(&o.ID3.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID3_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID3.Reg, volatile.LoadUint32(&o.ID3.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID3_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID3.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD03: Message Buffer 3 WORD0 Register
func (o *CAN0_Type) SetWORD03_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD03.Reg, volatile.LoadUint32(&o.WORD03.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD03_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD03.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD03_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD03.Reg, volatile.LoadUint32(&o.WORD03.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD03_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD03.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD03_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD03.Reg, volatile.LoadUint32(&o.WORD03.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD03_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD03.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD03_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD03.Reg, volatile.LoadUint32(&o.WORD03.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD03_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD03.Reg) & 0xff000000) >> 24
}

// CAN0.WORD13: Message Buffer 3 WORD1 Register
func (o *CAN0_Type) SetWORD13_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD13.Reg, volatile.LoadUint32(&o.WORD13.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD13_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD13.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD13_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD13.Reg, volatile.LoadUint32(&o.WORD13.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD13_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD13.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD13_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD13.Reg, volatile.LoadUint32(&o.WORD13.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD13_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD13.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD13_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD13.Reg, volatile.LoadUint32(&o.WORD13.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD13_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD13.Reg) & 0xff000000) >> 24
}

// CAN0.CS4: Message Buffer 4 CS Register
func (o *CAN0_Type) SetCS4_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS4_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS4.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS4_DLC(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS4_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS4.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS4_RTR(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS4_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS4.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS4_IDE(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS4_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS4.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS4_SRR(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS4_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS4.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS4_CODE(value uint32) {
	volatile.StoreUint32(&o.CS4.Reg, volatile.LoadUint32(&o.CS4.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS4_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS4.Reg) & 0xf000000) >> 24
}

// CAN0.ID4: Message Buffer 4 ID Register
func (o *CAN0_Type) SetID4_EXT(value uint32) {
	volatile.StoreUint32(&o.ID4.Reg, volatile.LoadUint32(&o.ID4.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID4_EXT() uint32 {
	return volatile.LoadUint32(&o.ID4.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID4_STD(value uint32) {
	volatile.StoreUint32(&o.ID4.Reg, volatile.LoadUint32(&o.ID4.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID4_STD() uint32 {
	return (volatile.LoadUint32(&o.ID4.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID4_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID4.Reg, volatile.LoadUint32(&o.ID4.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID4_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID4.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD04: Message Buffer 4 WORD0 Register
func (o *CAN0_Type) SetWORD04_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD04.Reg, volatile.LoadUint32(&o.WORD04.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD04_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD04.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD04_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD04.Reg, volatile.LoadUint32(&o.WORD04.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD04_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD04.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD04_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD04.Reg, volatile.LoadUint32(&o.WORD04.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD04_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD04.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD04_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD04.Reg, volatile.LoadUint32(&o.WORD04.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD04_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD04.Reg) & 0xff000000) >> 24
}

// CAN0.WORD14: Message Buffer 4 WORD1 Register
func (o *CAN0_Type) SetWORD14_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD14.Reg, volatile.LoadUint32(&o.WORD14.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD14_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD14.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD14_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD14.Reg, volatile.LoadUint32(&o.WORD14.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD14_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD14.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD14_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD14.Reg, volatile.LoadUint32(&o.WORD14.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD14_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD14.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD14_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD14.Reg, volatile.LoadUint32(&o.WORD14.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD14_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD14.Reg) & 0xff000000) >> 24
}

// CAN0.CS5: Message Buffer 5 CS Register
func (o *CAN0_Type) SetCS5_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS5_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS5.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS5_DLC(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS5_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS5.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS5_RTR(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS5_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS5.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS5_IDE(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS5_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS5.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS5_SRR(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS5_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS5.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS5_CODE(value uint32) {
	volatile.StoreUint32(&o.CS5.Reg, volatile.LoadUint32(&o.CS5.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS5_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS5.Reg) & 0xf000000) >> 24
}

// CAN0.ID5: Message Buffer 5 ID Register
func (o *CAN0_Type) SetID5_EXT(value uint32) {
	volatile.StoreUint32(&o.ID5.Reg, volatile.LoadUint32(&o.ID5.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID5_EXT() uint32 {
	return volatile.LoadUint32(&o.ID5.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID5_STD(value uint32) {
	volatile.StoreUint32(&o.ID5.Reg, volatile.LoadUint32(&o.ID5.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID5_STD() uint32 {
	return (volatile.LoadUint32(&o.ID5.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID5_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID5.Reg, volatile.LoadUint32(&o.ID5.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID5_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID5.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD05: Message Buffer 5 WORD0 Register
func (o *CAN0_Type) SetWORD05_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD05.Reg, volatile.LoadUint32(&o.WORD05.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD05_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD05.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD05_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD05.Reg, volatile.LoadUint32(&o.WORD05.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD05_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD05.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD05_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD05.Reg, volatile.LoadUint32(&o.WORD05.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD05_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD05.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD05_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD05.Reg, volatile.LoadUint32(&o.WORD05.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD05_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD05.Reg) & 0xff000000) >> 24
}

// CAN0.WORD15: Message Buffer 5 WORD1 Register
func (o *CAN0_Type) SetWORD15_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD15.Reg, volatile.LoadUint32(&o.WORD15.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD15_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD15.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD15_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD15.Reg, volatile.LoadUint32(&o.WORD15.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD15_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD15.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD15_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD15.Reg, volatile.LoadUint32(&o.WORD15.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD15_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD15.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD15_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD15.Reg, volatile.LoadUint32(&o.WORD15.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD15_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD15.Reg) & 0xff000000) >> 24
}

// CAN0.CS6: Message Buffer 6 CS Register
func (o *CAN0_Type) SetCS6_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS6_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS6.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS6_DLC(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS6_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS6.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS6_RTR(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS6_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS6.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS6_IDE(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS6_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS6.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS6_SRR(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS6_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS6.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS6_CODE(value uint32) {
	volatile.StoreUint32(&o.CS6.Reg, volatile.LoadUint32(&o.CS6.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS6_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS6.Reg) & 0xf000000) >> 24
}

// CAN0.ID6: Message Buffer 6 ID Register
func (o *CAN0_Type) SetID6_EXT(value uint32) {
	volatile.StoreUint32(&o.ID6.Reg, volatile.LoadUint32(&o.ID6.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID6_EXT() uint32 {
	return volatile.LoadUint32(&o.ID6.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID6_STD(value uint32) {
	volatile.StoreUint32(&o.ID6.Reg, volatile.LoadUint32(&o.ID6.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID6_STD() uint32 {
	return (volatile.LoadUint32(&o.ID6.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID6_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID6.Reg, volatile.LoadUint32(&o.ID6.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID6_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID6.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD06: Message Buffer 6 WORD0 Register
func (o *CAN0_Type) SetWORD06_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD06.Reg, volatile.LoadUint32(&o.WORD06.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD06_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD06.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD06_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD06.Reg, volatile.LoadUint32(&o.WORD06.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD06_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD06.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD06_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD06.Reg, volatile.LoadUint32(&o.WORD06.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD06_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD06.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD06_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD06.Reg, volatile.LoadUint32(&o.WORD06.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD06_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD06.Reg) & 0xff000000) >> 24
}

// CAN0.WORD16: Message Buffer 6 WORD1 Register
func (o *CAN0_Type) SetWORD16_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD16.Reg, volatile.LoadUint32(&o.WORD16.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD16_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD16.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD16_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD16.Reg, volatile.LoadUint32(&o.WORD16.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD16_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD16.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD16_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD16.Reg, volatile.LoadUint32(&o.WORD16.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD16_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD16.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD16_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD16.Reg, volatile.LoadUint32(&o.WORD16.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD16_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD16.Reg) & 0xff000000) >> 24
}

// CAN0.CS7: Message Buffer 7 CS Register
func (o *CAN0_Type) SetCS7_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS7_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS7.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS7_DLC(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS7_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS7.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS7_RTR(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS7_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS7.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS7_IDE(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS7_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS7.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS7_SRR(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS7_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS7.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS7_CODE(value uint32) {
	volatile.StoreUint32(&o.CS7.Reg, volatile.LoadUint32(&o.CS7.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS7_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS7.Reg) & 0xf000000) >> 24
}

// CAN0.ID7: Message Buffer 7 ID Register
func (o *CAN0_Type) SetID7_EXT(value uint32) {
	volatile.StoreUint32(&o.ID7.Reg, volatile.LoadUint32(&o.ID7.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID7_EXT() uint32 {
	return volatile.LoadUint32(&o.ID7.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID7_STD(value uint32) {
	volatile.StoreUint32(&o.ID7.Reg, volatile.LoadUint32(&o.ID7.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID7_STD() uint32 {
	return (volatile.LoadUint32(&o.ID7.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID7_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID7.Reg, volatile.LoadUint32(&o.ID7.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID7_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID7.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD07: Message Buffer 7 WORD0 Register
func (o *CAN0_Type) SetWORD07_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD07.Reg, volatile.LoadUint32(&o.WORD07.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD07_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD07.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD07_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD07.Reg, volatile.LoadUint32(&o.WORD07.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD07_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD07.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD07_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD07.Reg, volatile.LoadUint32(&o.WORD07.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD07_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD07.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD07_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD07.Reg, volatile.LoadUint32(&o.WORD07.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD07_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD07.Reg) & 0xff000000) >> 24
}

// CAN0.WORD17: Message Buffer 7 WORD1 Register
func (o *CAN0_Type) SetWORD17_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD17.Reg, volatile.LoadUint32(&o.WORD17.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD17_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD17.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD17_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD17.Reg, volatile.LoadUint32(&o.WORD17.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD17_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD17.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD17_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD17.Reg, volatile.LoadUint32(&o.WORD17.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD17_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD17.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD17_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD17.Reg, volatile.LoadUint32(&o.WORD17.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD17_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD17.Reg) & 0xff000000) >> 24
}

// CAN0.CS8: Message Buffer 8 CS Register
func (o *CAN0_Type) SetCS8_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS8_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS8.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS8_DLC(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS8_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS8.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS8_RTR(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS8_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS8.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS8_IDE(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS8_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS8.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS8_SRR(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS8_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS8.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS8_CODE(value uint32) {
	volatile.StoreUint32(&o.CS8.Reg, volatile.LoadUint32(&o.CS8.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS8_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS8.Reg) & 0xf000000) >> 24
}

// CAN0.ID8: Message Buffer 8 ID Register
func (o *CAN0_Type) SetID8_EXT(value uint32) {
	volatile.StoreUint32(&o.ID8.Reg, volatile.LoadUint32(&o.ID8.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID8_EXT() uint32 {
	return volatile.LoadUint32(&o.ID8.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID8_STD(value uint32) {
	volatile.StoreUint32(&o.ID8.Reg, volatile.LoadUint32(&o.ID8.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID8_STD() uint32 {
	return (volatile.LoadUint32(&o.ID8.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID8_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID8.Reg, volatile.LoadUint32(&o.ID8.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID8_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID8.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD08: Message Buffer 8 WORD0 Register
func (o *CAN0_Type) SetWORD08_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD08.Reg, volatile.LoadUint32(&o.WORD08.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD08_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD08.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD08_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD08.Reg, volatile.LoadUint32(&o.WORD08.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD08_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD08.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD08_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD08.Reg, volatile.LoadUint32(&o.WORD08.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD08_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD08.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD08_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD08.Reg, volatile.LoadUint32(&o.WORD08.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD08_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD08.Reg) & 0xff000000) >> 24
}

// CAN0.WORD18: Message Buffer 8 WORD1 Register
func (o *CAN0_Type) SetWORD18_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD18.Reg, volatile.LoadUint32(&o.WORD18.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD18_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD18.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD18_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD18.Reg, volatile.LoadUint32(&o.WORD18.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD18_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD18.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD18_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD18.Reg, volatile.LoadUint32(&o.WORD18.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD18_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD18.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD18_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD18.Reg, volatile.LoadUint32(&o.WORD18.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD18_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD18.Reg) & 0xff000000) >> 24
}

// CAN0.CS9: Message Buffer 9 CS Register
func (o *CAN0_Type) SetCS9_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS9_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS9.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS9_DLC(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS9_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS9.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS9_RTR(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS9_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS9.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS9_IDE(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS9_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS9.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS9_SRR(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS9_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS9.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS9_CODE(value uint32) {
	volatile.StoreUint32(&o.CS9.Reg, volatile.LoadUint32(&o.CS9.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS9_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS9.Reg) & 0xf000000) >> 24
}

// CAN0.ID9: Message Buffer 9 ID Register
func (o *CAN0_Type) SetID9_EXT(value uint32) {
	volatile.StoreUint32(&o.ID9.Reg, volatile.LoadUint32(&o.ID9.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID9_EXT() uint32 {
	return volatile.LoadUint32(&o.ID9.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID9_STD(value uint32) {
	volatile.StoreUint32(&o.ID9.Reg, volatile.LoadUint32(&o.ID9.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID9_STD() uint32 {
	return (volatile.LoadUint32(&o.ID9.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID9_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID9.Reg, volatile.LoadUint32(&o.ID9.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID9_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID9.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD09: Message Buffer 9 WORD0 Register
func (o *CAN0_Type) SetWORD09_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD09.Reg, volatile.LoadUint32(&o.WORD09.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD09_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD09.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD09_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD09.Reg, volatile.LoadUint32(&o.WORD09.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD09_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD09.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD09_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD09.Reg, volatile.LoadUint32(&o.WORD09.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD09_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD09.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD09_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD09.Reg, volatile.LoadUint32(&o.WORD09.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD09_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD09.Reg) & 0xff000000) >> 24
}

// CAN0.WORD19: Message Buffer 9 WORD1 Register
func (o *CAN0_Type) SetWORD19_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD19.Reg, volatile.LoadUint32(&o.WORD19.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD19_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD19.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD19_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD19.Reg, volatile.LoadUint32(&o.WORD19.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD19_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD19.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD19_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD19.Reg, volatile.LoadUint32(&o.WORD19.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD19_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD19.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD19_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD19.Reg, volatile.LoadUint32(&o.WORD19.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD19_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD19.Reg) & 0xff000000) >> 24
}

// CAN0.CS10: Message Buffer 10 CS Register
func (o *CAN0_Type) SetCS10_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS10_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS10.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS10_DLC(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS10_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS10.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS10_RTR(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS10_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS10.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS10_IDE(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS10_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS10.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS10_SRR(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS10_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS10.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS10_CODE(value uint32) {
	volatile.StoreUint32(&o.CS10.Reg, volatile.LoadUint32(&o.CS10.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS10_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS10.Reg) & 0xf000000) >> 24
}

// CAN0.ID10: Message Buffer 10 ID Register
func (o *CAN0_Type) SetID10_EXT(value uint32) {
	volatile.StoreUint32(&o.ID10.Reg, volatile.LoadUint32(&o.ID10.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID10_EXT() uint32 {
	return volatile.LoadUint32(&o.ID10.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID10_STD(value uint32) {
	volatile.StoreUint32(&o.ID10.Reg, volatile.LoadUint32(&o.ID10.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID10_STD() uint32 {
	return (volatile.LoadUint32(&o.ID10.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID10_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID10.Reg, volatile.LoadUint32(&o.ID10.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID10_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID10.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD010: Message Buffer 10 WORD0 Register
func (o *CAN0_Type) SetWORD010_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD010.Reg, volatile.LoadUint32(&o.WORD010.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD010_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD010.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD010_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD010.Reg, volatile.LoadUint32(&o.WORD010.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD010_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD010.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD010_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD010.Reg, volatile.LoadUint32(&o.WORD010.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD010_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD010.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD010_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD010.Reg, volatile.LoadUint32(&o.WORD010.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD010_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD010.Reg) & 0xff000000) >> 24
}

// CAN0.WORD110: Message Buffer 10 WORD1 Register
func (o *CAN0_Type) SetWORD110_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD110.Reg, volatile.LoadUint32(&o.WORD110.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD110_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD110.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD110_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD110.Reg, volatile.LoadUint32(&o.WORD110.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD110_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD110.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD110_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD110.Reg, volatile.LoadUint32(&o.WORD110.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD110_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD110.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD110_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD110.Reg, volatile.LoadUint32(&o.WORD110.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD110_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD110.Reg) & 0xff000000) >> 24
}

// CAN0.CS11: Message Buffer 11 CS Register
func (o *CAN0_Type) SetCS11_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS11_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS11.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS11_DLC(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS11_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS11.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS11_RTR(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS11_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS11.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS11_IDE(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS11_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS11.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS11_SRR(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS11_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS11.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS11_CODE(value uint32) {
	volatile.StoreUint32(&o.CS11.Reg, volatile.LoadUint32(&o.CS11.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS11_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS11.Reg) & 0xf000000) >> 24
}

// CAN0.ID11: Message Buffer 11 ID Register
func (o *CAN0_Type) SetID11_EXT(value uint32) {
	volatile.StoreUint32(&o.ID11.Reg, volatile.LoadUint32(&o.ID11.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID11_EXT() uint32 {
	return volatile.LoadUint32(&o.ID11.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID11_STD(value uint32) {
	volatile.StoreUint32(&o.ID11.Reg, volatile.LoadUint32(&o.ID11.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID11_STD() uint32 {
	return (volatile.LoadUint32(&o.ID11.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID11_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID11.Reg, volatile.LoadUint32(&o.ID11.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID11_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID11.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD011: Message Buffer 11 WORD0 Register
func (o *CAN0_Type) SetWORD011_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD011.Reg, volatile.LoadUint32(&o.WORD011.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD011_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD011.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD011_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD011.Reg, volatile.LoadUint32(&o.WORD011.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD011_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD011.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD011_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD011.Reg, volatile.LoadUint32(&o.WORD011.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD011_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD011.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD011_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD011.Reg, volatile.LoadUint32(&o.WORD011.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD011_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD011.Reg) & 0xff000000) >> 24
}

// CAN0.WORD111: Message Buffer 11 WORD1 Register
func (o *CAN0_Type) SetWORD111_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD111.Reg, volatile.LoadUint32(&o.WORD111.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD111_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD111.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD111_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD111.Reg, volatile.LoadUint32(&o.WORD111.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD111_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD111.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD111_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD111.Reg, volatile.LoadUint32(&o.WORD111.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD111_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD111.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD111_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD111.Reg, volatile.LoadUint32(&o.WORD111.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD111_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD111.Reg) & 0xff000000) >> 24
}

// CAN0.CS12: Message Buffer 12 CS Register
func (o *CAN0_Type) SetCS12_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS12_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS12.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS12_DLC(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS12_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS12.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS12_RTR(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS12_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS12.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS12_IDE(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS12_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS12.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS12_SRR(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS12_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS12.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS12_CODE(value uint32) {
	volatile.StoreUint32(&o.CS12.Reg, volatile.LoadUint32(&o.CS12.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS12_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS12.Reg) & 0xf000000) >> 24
}

// CAN0.ID12: Message Buffer 12 ID Register
func (o *CAN0_Type) SetID12_EXT(value uint32) {
	volatile.StoreUint32(&o.ID12.Reg, volatile.LoadUint32(&o.ID12.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID12_EXT() uint32 {
	return volatile.LoadUint32(&o.ID12.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID12_STD(value uint32) {
	volatile.StoreUint32(&o.ID12.Reg, volatile.LoadUint32(&o.ID12.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID12_STD() uint32 {
	return (volatile.LoadUint32(&o.ID12.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID12_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID12.Reg, volatile.LoadUint32(&o.ID12.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID12_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID12.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD012: Message Buffer 12 WORD0 Register
func (o *CAN0_Type) SetWORD012_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD012.Reg, volatile.LoadUint32(&o.WORD012.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD012_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD012.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD012_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD012.Reg, volatile.LoadUint32(&o.WORD012.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD012_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD012.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD012_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD012.Reg, volatile.LoadUint32(&o.WORD012.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD012_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD012.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD012_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD012.Reg, volatile.LoadUint32(&o.WORD012.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD012_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD012.Reg) & 0xff000000) >> 24
}

// CAN0.WORD112: Message Buffer 12 WORD1 Register
func (o *CAN0_Type) SetWORD112_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD112.Reg, volatile.LoadUint32(&o.WORD112.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD112_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD112.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD112_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD112.Reg, volatile.LoadUint32(&o.WORD112.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD112_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD112.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD112_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD112.Reg, volatile.LoadUint32(&o.WORD112.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD112_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD112.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD112_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD112.Reg, volatile.LoadUint32(&o.WORD112.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD112_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD112.Reg) & 0xff000000) >> 24
}

// CAN0.CS13: Message Buffer 13 CS Register
func (o *CAN0_Type) SetCS13_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS13_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS13.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS13_DLC(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS13_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS13.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS13_RTR(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS13_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS13.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS13_IDE(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS13_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS13.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS13_SRR(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS13_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS13.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS13_CODE(value uint32) {
	volatile.StoreUint32(&o.CS13.Reg, volatile.LoadUint32(&o.CS13.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS13_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS13.Reg) & 0xf000000) >> 24
}

// CAN0.ID13: Message Buffer 13 ID Register
func (o *CAN0_Type) SetID13_EXT(value uint32) {
	volatile.StoreUint32(&o.ID13.Reg, volatile.LoadUint32(&o.ID13.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID13_EXT() uint32 {
	return volatile.LoadUint32(&o.ID13.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID13_STD(value uint32) {
	volatile.StoreUint32(&o.ID13.Reg, volatile.LoadUint32(&o.ID13.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID13_STD() uint32 {
	return (volatile.LoadUint32(&o.ID13.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID13_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID13.Reg, volatile.LoadUint32(&o.ID13.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID13_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID13.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD013: Message Buffer 13 WORD0 Register
func (o *CAN0_Type) SetWORD013_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD013.Reg, volatile.LoadUint32(&o.WORD013.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD013_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD013.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD013_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD013.Reg, volatile.LoadUint32(&o.WORD013.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD013_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD013.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD013_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD013.Reg, volatile.LoadUint32(&o.WORD013.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD013_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD013.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD013_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD013.Reg, volatile.LoadUint32(&o.WORD013.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD013_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD013.Reg) & 0xff000000) >> 24
}

// CAN0.WORD113: Message Buffer 13 WORD1 Register
func (o *CAN0_Type) SetWORD113_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD113.Reg, volatile.LoadUint32(&o.WORD113.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD113_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD113.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD113_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD113.Reg, volatile.LoadUint32(&o.WORD113.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD113_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD113.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD113_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD113.Reg, volatile.LoadUint32(&o.WORD113.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD113_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD113.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD113_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD113.Reg, volatile.LoadUint32(&o.WORD113.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD113_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD113.Reg) & 0xff000000) >> 24
}

// CAN0.CS14: Message Buffer 14 CS Register
func (o *CAN0_Type) SetCS14_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS14_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS14.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS14_DLC(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS14_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS14.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS14_RTR(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS14_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS14.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS14_IDE(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS14_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS14.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS14_SRR(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS14_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS14.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS14_CODE(value uint32) {
	volatile.StoreUint32(&o.CS14.Reg, volatile.LoadUint32(&o.CS14.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS14_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS14.Reg) & 0xf000000) >> 24
}

// CAN0.ID14: Message Buffer 14 ID Register
func (o *CAN0_Type) SetID14_EXT(value uint32) {
	volatile.StoreUint32(&o.ID14.Reg, volatile.LoadUint32(&o.ID14.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID14_EXT() uint32 {
	return volatile.LoadUint32(&o.ID14.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID14_STD(value uint32) {
	volatile.StoreUint32(&o.ID14.Reg, volatile.LoadUint32(&o.ID14.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID14_STD() uint32 {
	return (volatile.LoadUint32(&o.ID14.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID14_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID14.Reg, volatile.LoadUint32(&o.ID14.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID14_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID14.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD014: Message Buffer 14 WORD0 Register
func (o *CAN0_Type) SetWORD014_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD014.Reg, volatile.LoadUint32(&o.WORD014.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD014_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD014.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD014_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD014.Reg, volatile.LoadUint32(&o.WORD014.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD014_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD014.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD014_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD014.Reg, volatile.LoadUint32(&o.WORD014.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD014_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD014.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD014_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD014.Reg, volatile.LoadUint32(&o.WORD014.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD014_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD014.Reg) & 0xff000000) >> 24
}

// CAN0.WORD114: Message Buffer 14 WORD1 Register
func (o *CAN0_Type) SetWORD114_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD114.Reg, volatile.LoadUint32(&o.WORD114.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD114_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD114.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD114_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD114.Reg, volatile.LoadUint32(&o.WORD114.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD114_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD114.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD114_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD114.Reg, volatile.LoadUint32(&o.WORD114.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD114_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD114.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD114_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD114.Reg, volatile.LoadUint32(&o.WORD114.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD114_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD114.Reg) & 0xff000000) >> 24
}

// CAN0.CS15: Message Buffer 15 CS Register
func (o *CAN0_Type) SetCS15_TIME_STAMP(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0xffff)|value)
}
func (o *CAN0_Type) GetCS15_TIME_STAMP() uint32 {
	return volatile.LoadUint32(&o.CS15.Reg) & 0xffff
}
func (o *CAN0_Type) SetCS15_DLC(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN0_Type) GetCS15_DLC() uint32 {
	return (volatile.LoadUint32(&o.CS15.Reg) & 0xf0000) >> 16
}
func (o *CAN0_Type) SetCS15_RTR(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetCS15_RTR() uint32 {
	return (volatile.LoadUint32(&o.CS15.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetCS15_IDE(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetCS15_IDE() uint32 {
	return (volatile.LoadUint32(&o.CS15.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetCS15_SRR(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetCS15_SRR() uint32 {
	return (volatile.LoadUint32(&o.CS15.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetCS15_CODE(value uint32) {
	volatile.StoreUint32(&o.CS15.Reg, volatile.LoadUint32(&o.CS15.Reg)&^(0xf000000)|value<<24)
}
func (o *CAN0_Type) GetCS15_CODE() uint32 {
	return (volatile.LoadUint32(&o.CS15.Reg) & 0xf000000) >> 24
}

// CAN0.ID15: Message Buffer 15 ID Register
func (o *CAN0_Type) SetID15_EXT(value uint32) {
	volatile.StoreUint32(&o.ID15.Reg, volatile.LoadUint32(&o.ID15.Reg)&^(0x3ffff)|value)
}
func (o *CAN0_Type) GetID15_EXT() uint32 {
	return volatile.LoadUint32(&o.ID15.Reg) & 0x3ffff
}
func (o *CAN0_Type) SetID15_STD(value uint32) {
	volatile.StoreUint32(&o.ID15.Reg, volatile.LoadUint32(&o.ID15.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *CAN0_Type) GetID15_STD() uint32 {
	return (volatile.LoadUint32(&o.ID15.Reg) & 0x1ffc0000) >> 18
}
func (o *CAN0_Type) SetID15_PRIO(value uint32) {
	volatile.StoreUint32(&o.ID15.Reg, volatile.LoadUint32(&o.ID15.Reg)&^(0xe0000000)|value<<29)
}
func (o *CAN0_Type) GetID15_PRIO() uint32 {
	return (volatile.LoadUint32(&o.ID15.Reg) & 0xe0000000) >> 29
}

// CAN0.WORD015: Message Buffer 15 WORD0 Register
func (o *CAN0_Type) SetWORD015_DATA_BYTE_3(value uint32) {
	volatile.StoreUint32(&o.WORD015.Reg, volatile.LoadUint32(&o.WORD015.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD015_DATA_BYTE_3() uint32 {
	return volatile.LoadUint32(&o.WORD015.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD015_DATA_BYTE_2(value uint32) {
	volatile.StoreUint32(&o.WORD015.Reg, volatile.LoadUint32(&o.WORD015.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD015_DATA_BYTE_2() uint32 {
	return (volatile.LoadUint32(&o.WORD015.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD015_DATA_BYTE_1(value uint32) {
	volatile.StoreUint32(&o.WORD015.Reg, volatile.LoadUint32(&o.WORD015.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD015_DATA_BYTE_1() uint32 {
	return (volatile.LoadUint32(&o.WORD015.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD015_DATA_BYTE_0(value uint32) {
	volatile.StoreUint32(&o.WORD015.Reg, volatile.LoadUint32(&o.WORD015.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD015_DATA_BYTE_0() uint32 {
	return (volatile.LoadUint32(&o.WORD015.Reg) & 0xff000000) >> 24
}

// CAN0.WORD115: Message Buffer 15 WORD1 Register
func (o *CAN0_Type) SetWORD115_DATA_BYTE_7(value uint32) {
	volatile.StoreUint32(&o.WORD115.Reg, volatile.LoadUint32(&o.WORD115.Reg)&^(0xff)|value)
}
func (o *CAN0_Type) GetWORD115_DATA_BYTE_7() uint32 {
	return volatile.LoadUint32(&o.WORD115.Reg) & 0xff
}
func (o *CAN0_Type) SetWORD115_DATA_BYTE_6(value uint32) {
	volatile.StoreUint32(&o.WORD115.Reg, volatile.LoadUint32(&o.WORD115.Reg)&^(0xff00)|value<<8)
}
func (o *CAN0_Type) GetWORD115_DATA_BYTE_6() uint32 {
	return (volatile.LoadUint32(&o.WORD115.Reg) & 0xff00) >> 8
}
func (o *CAN0_Type) SetWORD115_DATA_BYTE_5(value uint32) {
	volatile.StoreUint32(&o.WORD115.Reg, volatile.LoadUint32(&o.WORD115.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN0_Type) GetWORD115_DATA_BYTE_5() uint32 {
	return (volatile.LoadUint32(&o.WORD115.Reg) & 0xff0000) >> 16
}
func (o *CAN0_Type) SetWORD115_DATA_BYTE_4(value uint32) {
	volatile.StoreUint32(&o.WORD115.Reg, volatile.LoadUint32(&o.WORD115.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN0_Type) GetWORD115_DATA_BYTE_4() uint32 {
	return (volatile.LoadUint32(&o.WORD115.Reg) & 0xff000000) >> 24
}

// CAN0.RXIMR0: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR0_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR0_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR0.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR0_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR0_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR0_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR0_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR0_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR0_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR0_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR0_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR0_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR0_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR0_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR0_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR0_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR0_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR0_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR0_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR0_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR0_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR0_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR0_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR0_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR0_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR0_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR0_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR0_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR0_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR0_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR0_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR0_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR0_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR0_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR0_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR0_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR0_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR0_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR0_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR0_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR0_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR0_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR0_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR0_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR0_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR0_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR0_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR0_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR0_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR0_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR0_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR0_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR0_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR0_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR0_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR0_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR0_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR0_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR0_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR0_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR0_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR0_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR0_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR0_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR0.Reg, volatile.LoadUint32(&o.RXIMR0.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR0_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR0.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR1: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR1_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR1_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR1.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR1_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR1_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR1_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR1_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR1_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR1_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR1_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR1_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR1_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR1_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR1_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR1_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR1_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR1_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR1_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR1_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR1_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR1_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR1_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR1_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR1_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR1_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR1_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR1_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR1_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR1_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR1_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR1_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR1_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR1_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR1_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR1_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR1_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR1_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR1_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR1_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR1_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR1_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR1_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR1_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR1_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR1_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR1_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR1_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR1_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR1_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR1_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR1_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR1_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR1_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR1_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR1_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR1_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR1_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR1_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR1_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR1_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR1_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR1_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR1_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR1_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR1.Reg, volatile.LoadUint32(&o.RXIMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR1_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR1.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR2: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR2_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR2_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR2.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR2_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR2_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR2_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR2_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR2_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR2_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR2_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR2_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR2_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR2_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR2_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR2_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR2_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR2_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR2_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR2_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR2_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR2_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR2_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR2_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR2_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR2_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR2_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR2_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR2_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR2_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR2_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR2_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR2_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR2_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR2_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR2_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR2_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR2_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR2_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR2_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR2_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR2_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR2_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR2_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR2_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR2_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR2_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR2_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR2_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR2_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR2_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR2_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR2_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR2_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR2_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR2_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR2_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR2_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR2_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR2_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR2_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR2_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR2_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR2_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR2_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR2.Reg, volatile.LoadUint32(&o.RXIMR2.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR2_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR2.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR3: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR3_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR3_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR3.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR3_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR3_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR3_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR3_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR3_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR3_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR3_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR3_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR3_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR3_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR3_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR3_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR3_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR3_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR3_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR3_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR3_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR3_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR3_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR3_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR3_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR3_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR3_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR3_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR3_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR3_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR3_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR3_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR3_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR3_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR3_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR3_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR3_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR3_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR3_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR3_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR3_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR3_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR3_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR3_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR3_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR3_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR3_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR3_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR3_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR3_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR3_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR3_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR3_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR3_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR3_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR3_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR3_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR3_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR3_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR3_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR3_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR3_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR3_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR3_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR3_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR3.Reg, volatile.LoadUint32(&o.RXIMR3.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR3_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR3.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR4: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR4_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR4_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR4.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR4_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR4_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR4_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR4_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR4_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR4_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR4_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR4_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR4_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR4_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR4_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR4_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR4_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR4_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR4_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR4_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR4_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR4_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR4_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR4_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR4_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR4_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR4_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR4_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR4_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR4_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR4_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR4_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR4_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR4_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR4_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR4_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR4_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR4_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR4_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR4_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR4_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR4_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR4_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR4_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR4_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR4_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR4_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR4_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR4_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR4_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR4_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR4_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR4_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR4_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR4_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR4_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR4_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR4_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR4_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR4_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR4_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR4_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR4_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR4_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR4_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR4.Reg, volatile.LoadUint32(&o.RXIMR4.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR4_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR4.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR5: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR5_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR5_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR5.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR5_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR5_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR5_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR5_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR5_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR5_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR5_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR5_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR5_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR5_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR5_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR5_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR5_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR5_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR5_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR5_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR5_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR5_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR5_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR5_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR5_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR5_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR5_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR5_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR5_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR5_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR5_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR5_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR5_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR5_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR5_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR5_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR5_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR5_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR5_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR5_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR5_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR5_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR5_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR5_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR5_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR5_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR5_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR5_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR5_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR5_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR5_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR5_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR5_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR5_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR5_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR5_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR5_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR5_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR5_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR5_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR5_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR5_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR5_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR5_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR5_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR5.Reg, volatile.LoadUint32(&o.RXIMR5.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR5_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR5.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR6: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR6_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR6_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR6.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR6_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR6_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR6_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR6_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR6_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR6_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR6_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR6_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR6_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR6_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR6_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR6_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR6_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR6_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR6_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR6_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR6_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR6_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR6_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR6_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR6_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR6_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR6_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR6_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR6_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR6_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR6_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR6_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR6_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR6_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR6_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR6_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR6_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR6_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR6_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR6_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR6_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR6_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR6_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR6_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR6_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR6_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR6_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR6_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR6_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR6_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR6_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR6_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR6_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR6_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR6_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR6_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR6_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR6_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR6_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR6_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR6_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR6_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR6_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR6_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR6_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR6.Reg, volatile.LoadUint32(&o.RXIMR6.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR6_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR6.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR7: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR7_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR7_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR7.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR7_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR7_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR7_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR7_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR7_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR7_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR7_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR7_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR7_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR7_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR7_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR7_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR7_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR7_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR7_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR7_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR7_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR7_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR7_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR7_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR7_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR7_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR7_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR7_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR7_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR7_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR7_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR7_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR7_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR7_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR7_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR7_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR7_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR7_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR7_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR7_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR7_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR7_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR7_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR7_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR7_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR7_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR7_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR7_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR7_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR7_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR7_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR7_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR7_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR7_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR7_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR7_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR7_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR7_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR7_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR7_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR7_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR7_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR7_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR7_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR7_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR7.Reg, volatile.LoadUint32(&o.RXIMR7.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR7_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR7.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR8: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR8_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR8_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR8.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR8_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR8_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR8_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR8_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR8_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR8_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR8_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR8_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR8_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR8_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR8_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR8_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR8_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR8_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR8_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR8_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR8_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR8_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR8_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR8_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR8_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR8_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR8_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR8_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR8_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR8_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR8_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR8_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR8_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR8_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR8_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR8_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR8_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR8_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR8_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR8_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR8_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR8_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR8_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR8_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR8_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR8_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR8_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR8_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR8_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR8_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR8_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR8_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR8_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR8_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR8_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR8_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR8_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR8_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR8_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR8_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR8_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR8_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR8_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR8_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR8_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR8.Reg, volatile.LoadUint32(&o.RXIMR8.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR8_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR8.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR9: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR9_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR9_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR9.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR9_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR9_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR9_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR9_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR9_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR9_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR9_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR9_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR9_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR9_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR9_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR9_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR9_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR9_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR9_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR9_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR9_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR9_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR9_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR9_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR9_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR9_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR9_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR9_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR9_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR9_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR9_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR9_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR9_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR9_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR9_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR9_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR9_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR9_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR9_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR9_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR9_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR9_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR9_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR9_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR9_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR9_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR9_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR9_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR9_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR9_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR9_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR9_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR9_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR9_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR9_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR9_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR9_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR9_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR9_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR9_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR9_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR9_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR9_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR9_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR9_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR9.Reg, volatile.LoadUint32(&o.RXIMR9.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR9_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR9.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR10: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR10_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR10_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR10.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR10_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR10_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR10_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR10_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR10_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR10_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR10_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR10_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR10_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR10_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR10_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR10_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR10_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR10_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR10_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR10_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR10_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR10_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR10_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR10_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR10_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR10_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR10_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR10_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR10_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR10_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR10_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR10_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR10_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR10_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR10_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR10_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR10_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR10_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR10_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR10_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR10_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR10_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR10_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR10_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR10_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR10_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR10_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR10_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR10_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR10_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR10_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR10_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR10_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR10_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR10_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR10_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR10_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR10_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR10_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR10_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR10_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR10_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR10_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR10_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR10_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR10.Reg, volatile.LoadUint32(&o.RXIMR10.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR10_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR10.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR11: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR11_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR11_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR11.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR11_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR11_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR11_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR11_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR11_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR11_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR11_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR11_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR11_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR11_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR11_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR11_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR11_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR11_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR11_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR11_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR11_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR11_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR11_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR11_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR11_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR11_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR11_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR11_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR11_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR11_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR11_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR11_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR11_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR11_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR11_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR11_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR11_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR11_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR11_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR11_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR11_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR11_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR11_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR11_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR11_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR11_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR11_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR11_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR11_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR11_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR11_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR11_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR11_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR11_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR11_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR11_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR11_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR11_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR11_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR11_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR11_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR11_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR11_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR11_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR11_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR11.Reg, volatile.LoadUint32(&o.RXIMR11.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR11_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR11.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR12: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR12_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR12_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR12.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR12_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR12_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR12_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR12_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR12_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR12_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR12_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR12_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR12_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR12_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR12_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR12_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR12_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR12_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR12_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR12_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR12_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR12_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR12_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR12_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR12_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR12_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR12_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR12_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR12_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR12_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR12_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR12_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR12_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR12_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR12_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR12_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR12_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR12_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR12_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR12_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR12_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR12_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR12_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR12_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR12_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR12_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR12_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR12_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR12_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR12_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR12_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR12_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR12_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR12_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR12_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR12_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR12_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR12_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR12_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR12_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR12_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR12_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR12_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR12_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR12_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR12.Reg, volatile.LoadUint32(&o.RXIMR12.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR12_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR12.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR13: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR13_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR13_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR13.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR13_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR13_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR13_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR13_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR13_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR13_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR13_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR13_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR13_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR13_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR13_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR13_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR13_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR13_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR13_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR13_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR13_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR13_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR13_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR13_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR13_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR13_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR13_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR13_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR13_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR13_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR13_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR13_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR13_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR13_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR13_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR13_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR13_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR13_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR13_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR13_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR13_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR13_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR13_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR13_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR13_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR13_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR13_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR13_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR13_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR13_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR13_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR13_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR13_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR13_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR13_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR13_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR13_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR13_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR13_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR13_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR13_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR13_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR13_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR13_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR13_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR13.Reg, volatile.LoadUint32(&o.RXIMR13.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR13_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR13.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR14: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR14_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR14_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR14.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR14_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR14_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR14_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR14_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR14_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR14_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR14_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR14_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR14_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR14_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR14_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR14_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR14_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR14_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR14_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR14_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR14_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR14_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR14_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR14_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR14_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR14_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR14_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR14_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR14_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR14_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR14_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR14_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR14_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR14_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR14_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR14_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR14_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR14_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR14_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR14_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR14_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR14_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR14_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR14_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR14_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR14_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR14_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR14_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR14_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR14_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR14_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR14_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR14_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR14_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR14_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR14_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR14_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR14_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR14_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR14_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR14_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR14_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR14_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR14_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR14_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR14.Reg, volatile.LoadUint32(&o.RXIMR14.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR14_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR14.Reg) & 0x80000000) >> 31
}

// CAN0.RXIMR15: Rx Individual Mask Registers
func (o *CAN0_Type) SetRXIMR15_MI0(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x1)|value)
}
func (o *CAN0_Type) GetRXIMR15_MI0() uint32 {
	return volatile.LoadUint32(&o.RXIMR15.Reg) & 0x1
}
func (o *CAN0_Type) SetRXIMR15_MI1(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x2)|value<<1)
}
func (o *CAN0_Type) GetRXIMR15_MI1() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x2) >> 1
}
func (o *CAN0_Type) SetRXIMR15_MI2(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x4)|value<<2)
}
func (o *CAN0_Type) GetRXIMR15_MI2() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x4) >> 2
}
func (o *CAN0_Type) SetRXIMR15_MI3(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x8)|value<<3)
}
func (o *CAN0_Type) GetRXIMR15_MI3() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x8) >> 3
}
func (o *CAN0_Type) SetRXIMR15_MI4(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x10)|value<<4)
}
func (o *CAN0_Type) GetRXIMR15_MI4() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x10) >> 4
}
func (o *CAN0_Type) SetRXIMR15_MI5(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x20)|value<<5)
}
func (o *CAN0_Type) GetRXIMR15_MI5() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x20) >> 5
}
func (o *CAN0_Type) SetRXIMR15_MI6(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x40)|value<<6)
}
func (o *CAN0_Type) GetRXIMR15_MI6() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x40) >> 6
}
func (o *CAN0_Type) SetRXIMR15_MI7(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x80)|value<<7)
}
func (o *CAN0_Type) GetRXIMR15_MI7() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x80) >> 7
}
func (o *CAN0_Type) SetRXIMR15_MI8(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x100)|value<<8)
}
func (o *CAN0_Type) GetRXIMR15_MI8() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x100) >> 8
}
func (o *CAN0_Type) SetRXIMR15_MI9(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x200)|value<<9)
}
func (o *CAN0_Type) GetRXIMR15_MI9() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x200) >> 9
}
func (o *CAN0_Type) SetRXIMR15_MI10(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x400)|value<<10)
}
func (o *CAN0_Type) GetRXIMR15_MI10() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x400) >> 10
}
func (o *CAN0_Type) SetRXIMR15_MI11(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x800)|value<<11)
}
func (o *CAN0_Type) GetRXIMR15_MI11() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x800) >> 11
}
func (o *CAN0_Type) SetRXIMR15_MI12(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x1000)|value<<12)
}
func (o *CAN0_Type) GetRXIMR15_MI12() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x1000) >> 12
}
func (o *CAN0_Type) SetRXIMR15_MI13(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x2000)|value<<13)
}
func (o *CAN0_Type) GetRXIMR15_MI13() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x2000) >> 13
}
func (o *CAN0_Type) SetRXIMR15_MI14(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x4000)|value<<14)
}
func (o *CAN0_Type) GetRXIMR15_MI14() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x4000) >> 14
}
func (o *CAN0_Type) SetRXIMR15_MI15(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x8000)|value<<15)
}
func (o *CAN0_Type) GetRXIMR15_MI15() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x8000) >> 15
}
func (o *CAN0_Type) SetRXIMR15_MI16(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x10000)|value<<16)
}
func (o *CAN0_Type) GetRXIMR15_MI16() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x10000) >> 16
}
func (o *CAN0_Type) SetRXIMR15_MI17(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x20000)|value<<17)
}
func (o *CAN0_Type) GetRXIMR15_MI17() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x20000) >> 17
}
func (o *CAN0_Type) SetRXIMR15_MI18(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x40000)|value<<18)
}
func (o *CAN0_Type) GetRXIMR15_MI18() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x40000) >> 18
}
func (o *CAN0_Type) SetRXIMR15_MI19(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x80000)|value<<19)
}
func (o *CAN0_Type) GetRXIMR15_MI19() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x80000) >> 19
}
func (o *CAN0_Type) SetRXIMR15_MI20(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x100000)|value<<20)
}
func (o *CAN0_Type) GetRXIMR15_MI20() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x100000) >> 20
}
func (o *CAN0_Type) SetRXIMR15_MI21(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x200000)|value<<21)
}
func (o *CAN0_Type) GetRXIMR15_MI21() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x200000) >> 21
}
func (o *CAN0_Type) SetRXIMR15_MI22(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x400000)|value<<22)
}
func (o *CAN0_Type) GetRXIMR15_MI22() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x400000) >> 22
}
func (o *CAN0_Type) SetRXIMR15_MI23(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x800000)|value<<23)
}
func (o *CAN0_Type) GetRXIMR15_MI23() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x800000) >> 23
}
func (o *CAN0_Type) SetRXIMR15_MI24(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN0_Type) GetRXIMR15_MI24() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x1000000) >> 24
}
func (o *CAN0_Type) SetRXIMR15_MI25(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN0_Type) GetRXIMR15_MI25() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x2000000) >> 25
}
func (o *CAN0_Type) SetRXIMR15_MI26(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN0_Type) GetRXIMR15_MI26() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x4000000) >> 26
}
func (o *CAN0_Type) SetRXIMR15_MI27(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN0_Type) GetRXIMR15_MI27() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x8000000) >> 27
}
func (o *CAN0_Type) SetRXIMR15_MI28(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN0_Type) GetRXIMR15_MI28() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x10000000) >> 28
}
func (o *CAN0_Type) SetRXIMR15_MI29(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN0_Type) GetRXIMR15_MI29() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x20000000) >> 29
}
func (o *CAN0_Type) SetRXIMR15_MI30(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN0_Type) GetRXIMR15_MI30() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x40000000) >> 30
}
func (o *CAN0_Type) SetRXIMR15_MI31(value uint32) {
	volatile.StoreUint32(&o.RXIMR15.Reg, volatile.LoadUint32(&o.RXIMR15.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN0_Type) GetRXIMR15_MI31() uint32 {
	return (volatile.LoadUint32(&o.RXIMR15.Reg) & 0x80000000) >> 31
}

// Random Number Generator Accelerator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	ER volatile.Register32 // 0x8
	OR volatile.Register32 // 0xC
}

// RNG.CR: RNGA Control Register
func (o *RNG_Type) SetCR_GO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetCR_GO() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RNG_Type) SetCR_HA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetCR_HA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetCR_INTM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_INTM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetCR_CLRI(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_CLRI() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_SLP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RNG_Type) GetCR_SLP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}

// RNG.SR: RNGA Status Register
func (o *RNG_Type) SetSR_SECV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_SECV() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RNG_Type) SetSR_LRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_LRS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_ORU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_ORU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetSR_SLP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RNG_Type) GetSR_SLP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RNG_Type) SetSR_OREG_LVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xff00)|value<<8)
}
func (o *RNG_Type) GetSR_OREG_LVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xff00) >> 8
}
func (o *RNG_Type) SetSR_OREG_SIZE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xff0000)|value<<16)
}
func (o *RNG_Type) GetSR_OREG_SIZE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xff0000) >> 16
}

// RNG.ER: RNGA Entropy Register
func (o *RNG_Type) SetER(value uint32) {
	volatile.StoreUint32(&o.ER.Reg, value)
}
func (o *RNG_Type) GetER() uint32 {
	return volatile.LoadUint32(&o.ER.Reg)
}

// RNG.OR: RNGA Output Register
func (o *RNG_Type) SetOR(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, value)
}
func (o *RNG_Type) GetOR() uint32 {
	return volatile.LoadUint32(&o.OR.Reg)
}

// Serial Peripheral Interface
type SPI_Type struct {
	MCR   volatile.Register32 // 0x0
	_     [4]byte
	TCR   volatile.Register32 // 0x8
	CTAR0 volatile.Register32 // 0xC
	CTAR1 volatile.Register32 // 0x10
	_     [24]byte
	SR    volatile.Register32 // 0x2C
	RSER  volatile.Register32 // 0x30
	PUSHR volatile.Register32 // 0x34
	POPR  volatile.Register32 // 0x38
	TXFR0 volatile.Register32 // 0x3C
	TXFR1 volatile.Register32 // 0x40
	TXFR2 volatile.Register32 // 0x44
	TXFR3 volatile.Register32 // 0x48
	_     [48]byte
	RXFR0 volatile.Register32 // 0x7C
	RXFR1 volatile.Register32 // 0x80
	RXFR2 volatile.Register32 // 0x84
	RXFR3 volatile.Register32 // 0x88
}

// SPI.MCR: Module Configuration Register
func (o *SPI_Type) SetMCR_HALT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMCR_HALT() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *SPI_Type) SetMCR_SMPL_PT(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetMCR_SMPL_PT() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetMCR_CLR_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetMCR_CLR_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetMCR_CLR_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetMCR_CLR_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetMCR_DIS_RXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetMCR_DIS_RXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetMCR_DIS_TXF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetMCR_DIS_TXF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetMCR_DOZE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetMCR_DOZE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetMCR_PCSIS0(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetMCR_PCSIS0() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetMCR_PCSIS1(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetMCR_PCSIS1() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetMCR_PCSIS2(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000)|value<<18)
}
func (o *SPI_Type) GetMCR_PCSIS2() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000) >> 18
}
func (o *SPI_Type) SetMCR_PCSIS3(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetMCR_PCSIS3() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetMCR_PCSIS4(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100000)|value<<20)
}
func (o *SPI_Type) GetMCR_PCSIS4() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100000) >> 20
}
func (o *SPI_Type) SetMCR_PCSIS5(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200000)|value<<21)
}
func (o *SPI_Type) GetMCR_PCSIS5() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200000) >> 21
}
func (o *SPI_Type) SetMCR_ROOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetMCR_ROOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetMCR_PCSSE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetMCR_PCSSE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetMCR_MTFE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetMCR_MTFE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetMCR_FRZ() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetMCR_DCONF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x30000000)|value<<28)
}
func (o *SPI_Type) GetMCR_DCONF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x30000000) >> 28
}
func (o *SPI_Type) SetMCR_CONT_SCKE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetMCR_CONT_SCKE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetMCR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetMCR_MSTR() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// SPI.TCR: Transfer Count Register
func (o *SPI_Type) SetTCR_SPI_TCNT(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTCR_SPI_TCNT() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xffff0000) >> 16
}

// SPI.CTAR0: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR0_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR0_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR0.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR0_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR0_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR0_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR0_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR0_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR0_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR0_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR0_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR0_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR0_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR0_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR0_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR0_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR0_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR0_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR0_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR0_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR0_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR0_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR0.Reg, volatile.LoadUint32(&o.CTAR0.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR0_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR0.Reg) & 0x80000000) >> 31
}

// SPI.CTAR1: Clock and Transfer Attributes Register (In Master Mode)
func (o *SPI_Type) SetCTAR1_BR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetCTAR1_BR() uint32 {
	return volatile.LoadUint32(&o.CTAR1.Reg) & 0xf
}
func (o *SPI_Type) SetCTAR1_DT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCTAR1_DT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCTAR1_ASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCTAR1_ASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCTAR1_CSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetCTAR1_CSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetCTAR1_PBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x30000)|value<<16)
}
func (o *SPI_Type) GetCTAR1_PBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x30000) >> 16
}
func (o *SPI_Type) SetCTAR1_PDT(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc0000)|value<<18)
}
func (o *SPI_Type) GetCTAR1_PDT() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc0000) >> 18
}
func (o *SPI_Type) SetCTAR1_PASC(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x300000)|value<<20)
}
func (o *SPI_Type) GetCTAR1_PASC() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x300000) >> 20
}
func (o *SPI_Type) SetCTAR1_PCSSCK(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0xc00000)|value<<22)
}
func (o *SPI_Type) GetCTAR1_PCSSCK() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0xc00000) >> 22
}
func (o *SPI_Type) SetCTAR1_LSBFE(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCTAR1_LSBFE() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetCTAR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetCTAR1_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetCTAR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetCTAR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetCTAR1_FMSZ(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x78000000)|value<<27)
}
func (o *SPI_Type) GetCTAR1_FMSZ() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x78000000) >> 27
}
func (o *SPI_Type) SetCTAR1_DBR(value uint32) {
	volatile.StoreUint32(&o.CTAR1.Reg, volatile.LoadUint32(&o.CTAR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetCTAR1_DBR() uint32 {
	return (volatile.LoadUint32(&o.CTAR1.Reg) & 0x80000000) >> 31
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_POPNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetSR_POPNXTPTR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0xf
}
func (o *SPI_Type) SetSR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetSR_RXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetSR_TXNXTPTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetSR_TXNXTPTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetSR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf000)|value<<12)
}
func (o *SPI_Type) GetSR_TXCTR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf000) >> 12
}
func (o *SPI_Type) SetSR_RFDF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetSR_RFDF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetSR_RFOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetSR_RFOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetSR_TFFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetSR_TFFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetSR_TFUF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetSR_TFUF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetSR_EOQF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetSR_EOQF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetSR_TXRXS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *SPI_Type) GetSR_TXRXS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *SPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// SPI.RSER: DMA/Interrupt Request Select and Enable Register
func (o *SPI_Type) SetRSER_RFDF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetRSER_RFDF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetRSER_RFDF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetRSER_RFDF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetRSER_RFOF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetRSER_RFOF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetRSER_TFFF_DIRS(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetRSER_TFFF_DIRS() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x1000000) >> 24
}
func (o *SPI_Type) SetRSER_TFFF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x2000000)|value<<25)
}
func (o *SPI_Type) GetRSER_TFFF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x2000000) >> 25
}
func (o *SPI_Type) SetRSER_TFUF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetRSER_TFUF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetRSER_EOQF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x10000000)|value<<28)
}
func (o *SPI_Type) GetRSER_EOQF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x10000000) >> 28
}
func (o *SPI_Type) SetRSER_TCF_RE(value uint32) {
	volatile.StoreUint32(&o.RSER.Reg, volatile.LoadUint32(&o.RSER.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetRSER_TCF_RE() uint32 {
	return (volatile.LoadUint32(&o.RSER.Reg) & 0x80000000) >> 31
}

// SPI.PUSHR: PUSH TX FIFO Register In Master Mode
func (o *SPI_Type) SetPUSHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetPUSHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.PUSHR.Reg) & 0xffff
}
func (o *SPI_Type) SetPUSHR_PCS0(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetPUSHR_PCS0() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x10000) >> 16
}
func (o *SPI_Type) SetPUSHR_PCS1(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x20000)|value<<17)
}
func (o *SPI_Type) GetPUSHR_PCS1() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x20000) >> 17
}
func (o *SPI_Type) SetPUSHR_PCS2(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x40000)|value<<18)
}
func (o *SPI_Type) GetPUSHR_PCS2() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x40000) >> 18
}
func (o *SPI_Type) SetPUSHR_PCS3(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x80000)|value<<19)
}
func (o *SPI_Type) GetPUSHR_PCS3() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x80000) >> 19
}
func (o *SPI_Type) SetPUSHR_PCS4(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x100000)|value<<20)
}
func (o *SPI_Type) GetPUSHR_PCS4() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x100000) >> 20
}
func (o *SPI_Type) SetPUSHR_PCS5(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x200000)|value<<21)
}
func (o *SPI_Type) GetPUSHR_PCS5() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x200000) >> 21
}
func (o *SPI_Type) SetPUSHR_CTCNT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x4000000)|value<<26)
}
func (o *SPI_Type) GetPUSHR_CTCNT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x4000000) >> 26
}
func (o *SPI_Type) SetPUSHR_EOQ(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x8000000)|value<<27)
}
func (o *SPI_Type) GetPUSHR_EOQ() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x8000000) >> 27
}
func (o *SPI_Type) SetPUSHR_CTAS(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x70000000)|value<<28)
}
func (o *SPI_Type) GetPUSHR_CTAS() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x70000000) >> 28
}
func (o *SPI_Type) SetPUSHR_CONT(value uint32) {
	volatile.StoreUint32(&o.PUSHR.Reg, volatile.LoadUint32(&o.PUSHR.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_Type) GetPUSHR_CONT() uint32 {
	return (volatile.LoadUint32(&o.PUSHR.Reg) & 0x80000000) >> 31
}

// SPI.POPR: POP RX FIFO Register
func (o *SPI_Type) SetPOPR(value uint32) {
	volatile.StoreUint32(&o.POPR.Reg, value)
}
func (o *SPI_Type) GetPOPR() uint32 {
	return volatile.LoadUint32(&o.POPR.Reg)
}

// SPI.TXFR0: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR0_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR0_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR0_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR0.Reg, volatile.LoadUint32(&o.TXFR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR0_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR0.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR1: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR1_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR1_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR1_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR1.Reg, volatile.LoadUint32(&o.TXFR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR1_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR1.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR2: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR2_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR2_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR2_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR2.Reg, volatile.LoadUint32(&o.TXFR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR2_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR2.Reg) & 0xffff0000) >> 16
}

// SPI.TXFR3: Transmit FIFO Registers
func (o *SPI_Type) SetTXFR3_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXFR3_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff
}
func (o *SPI_Type) SetTXFR3_TXCMD_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXFR3.Reg, volatile.LoadUint32(&o.TXFR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetTXFR3_TXCMD_TXDATA() uint32 {
	return (volatile.LoadUint32(&o.TXFR3.Reg) & 0xffff0000) >> 16
}

// SPI.RXFR0: Receive FIFO Registers
func (o *SPI_Type) SetRXFR0(value uint32) {
	volatile.StoreUint32(&o.RXFR0.Reg, value)
}
func (o *SPI_Type) GetRXFR0() uint32 {
	return volatile.LoadUint32(&o.RXFR0.Reg)
}

// SPI.RXFR1: Receive FIFO Registers
func (o *SPI_Type) SetRXFR1(value uint32) {
	volatile.StoreUint32(&o.RXFR1.Reg, value)
}
func (o *SPI_Type) GetRXFR1() uint32 {
	return volatile.LoadUint32(&o.RXFR1.Reg)
}

// SPI.RXFR2: Receive FIFO Registers
func (o *SPI_Type) SetRXFR2(value uint32) {
	volatile.StoreUint32(&o.RXFR2.Reg, value)
}
func (o *SPI_Type) GetRXFR2() uint32 {
	return volatile.LoadUint32(&o.RXFR2.Reg)
}

// SPI.RXFR3: Receive FIFO Registers
func (o *SPI_Type) SetRXFR3(value uint32) {
	volatile.StoreUint32(&o.RXFR3.Reg, value)
}
func (o *SPI_Type) GetRXFR3() uint32 {
	return volatile.LoadUint32(&o.RXFR3.Reg)
}

// Inter-IC Sound / Synchronous Audio Interface
type I2S0_Type struct {
	TCSR volatile.Register32 // 0x0
	TCR1 volatile.Register32 // 0x4
	TCR2 volatile.Register32 // 0x8
	TCR3 volatile.Register32 // 0xC
	TCR4 volatile.Register32 // 0x10
	TCR5 volatile.Register32 // 0x14
	_    [8]byte
	TDR0 volatile.Register32 // 0x20
	TDR1 volatile.Register32 // 0x24
	_    [24]byte
	TFR0 volatile.Register32 // 0x40
	TFR1 volatile.Register32 // 0x44
	_    [24]byte
	TMR  volatile.Register32 // 0x60
	_    [28]byte
	RCSR volatile.Register32 // 0x80
	RCR1 volatile.Register32 // 0x84
	RCR2 volatile.Register32 // 0x88
	RCR3 volatile.Register32 // 0x8C
	RCR4 volatile.Register32 // 0x90
	RCR5 volatile.Register32 // 0x94
	_    [8]byte
	RDR0 volatile.Register32 // 0xA0
	RDR1 volatile.Register32 // 0xA4
	_    [24]byte
	RFR0 volatile.Register32 // 0xC0
	RFR1 volatile.Register32 // 0xC4
	_    [24]byte
	RMR  volatile.Register32 // 0xE0
	_    [28]byte
	MCR  volatile.Register32 // 0x100
	MDR  volatile.Register32 // 0x104
}

// I2S0.TCSR: SAI Transmit Control Register
func (o *I2S0_Type) SetTCSR_FRDE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCSR_FRDE() uint32 {
	return volatile.LoadUint32(&o.TCSR.Reg) & 0x1
}
func (o *I2S0_Type) SetTCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCSR_FRIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetTCSR_FRIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetTCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetTCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetTCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetTCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetTCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetTCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetTCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetTCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetTCSR_FRF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCSR_FRF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetTCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetTCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetTCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetTCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetTCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetTCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetTCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetTCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetTCSR_SR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCSR_FR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetTCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetTCSR_TE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetTCSR_TE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000000) >> 31
}

// I2S0.TCR1: SAI Transmit Configuration 1 Register
func (o *I2S0_Type) SetTCR1_TFW(value uint32) {
	volatile.StoreUint32(&o.TCR1.Reg, volatile.LoadUint32(&o.TCR1.Reg)&^(0x7)|value)
}
func (o *I2S0_Type) GetTCR1_TFW() uint32 {
	return volatile.LoadUint32(&o.TCR1.Reg) & 0x7
}

// I2S0.TCR2: SAI Transmit Configuration 2 Register
func (o *I2S0_Type) SetTCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetTCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.TCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetTCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetTCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetTCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetTCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.TCR3: SAI Transmit Configuration 3 Register
func (o *I2S0_Type) SetTCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x1f)|value)
}
func (o *I2S0_Type) GetTCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.TCR3.Reg) & 0x1f
}
func (o *I2S0_Type) SetTCR3_TCE0(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCR3_TCE0() uint32 {
	return (volatile.LoadUint32(&o.TCR3.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetTCR3_TCE1(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetTCR3_TCE1() uint32 {
	return (volatile.LoadUint32(&o.TCR3.Reg) & 0x20000) >> 17
}

// I2S0.TCR4: SAI Transmit Configuration 4 Register
func (o *I2S0_Type) SetTCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.TCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetTCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetTCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetTCR4_MF(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetTCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetTCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetTCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x1f0000) >> 16
}

// I2S0.TCR5: SAI Transmit Configuration 5 Register
func (o *I2S0_Type) SetTCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetTCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetTCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetTCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.TDR0: SAI Transmit Data Register
func (o *I2S0_Type) SetTDR0(value uint32) {
	volatile.StoreUint32(&o.TDR0.Reg, value)
}
func (o *I2S0_Type) GetTDR0() uint32 {
	return volatile.LoadUint32(&o.TDR0.Reg)
}

// I2S0.TDR1: SAI Transmit Data Register
func (o *I2S0_Type) SetTDR1(value uint32) {
	volatile.StoreUint32(&o.TDR1.Reg, value)
}
func (o *I2S0_Type) GetTDR1() uint32 {
	return volatile.LoadUint32(&o.TDR1.Reg)
}

// I2S0.TFR0: SAI Transmit FIFO Register
func (o *I2S0_Type) SetTFR0_RFP(value uint32) {
	volatile.StoreUint32(&o.TFR0.Reg, volatile.LoadUint32(&o.TFR0.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetTFR0_RFP() uint32 {
	return volatile.LoadUint32(&o.TFR0.Reg) & 0xf
}
func (o *I2S0_Type) SetTFR0_WFP(value uint32) {
	volatile.StoreUint32(&o.TFR0.Reg, volatile.LoadUint32(&o.TFR0.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetTFR0_WFP() uint32 {
	return (volatile.LoadUint32(&o.TFR0.Reg) & 0xf0000) >> 16
}

// I2S0.TFR1: SAI Transmit FIFO Register
func (o *I2S0_Type) SetTFR1_RFP(value uint32) {
	volatile.StoreUint32(&o.TFR1.Reg, volatile.LoadUint32(&o.TFR1.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetTFR1_RFP() uint32 {
	return volatile.LoadUint32(&o.TFR1.Reg) & 0xf
}
func (o *I2S0_Type) SetTFR1_WFP(value uint32) {
	volatile.StoreUint32(&o.TFR1.Reg, volatile.LoadUint32(&o.TFR1.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetTFR1_WFP() uint32 {
	return (volatile.LoadUint32(&o.TFR1.Reg) & 0xf0000) >> 16
}

// I2S0.TMR: SAI Transmit Mask Register
func (o *I2S0_Type) SetTMR_TWM0(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTMR_TWM0() uint32 {
	return volatile.LoadUint32(&o.TMR.Reg) & 0x1
}
func (o *I2S0_Type) SetTMR_TWM1(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTMR_TWM1() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTMR_TWM2(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x4)|value<<2)
}
func (o *I2S0_Type) GetTMR_TWM2() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x4) >> 2
}
func (o *I2S0_Type) SetTMR_TWM3(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetTMR_TWM3() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetTMR_TWM4(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetTMR_TWM4() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetTMR_TWM5(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x20)|value<<5)
}
func (o *I2S0_Type) GetTMR_TWM5() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x20) >> 5
}
func (o *I2S0_Type) SetTMR_TWM6(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x40)|value<<6)
}
func (o *I2S0_Type) GetTMR_TWM6() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x40) >> 6
}
func (o *I2S0_Type) SetTMR_TWM7(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x80)|value<<7)
}
func (o *I2S0_Type) GetTMR_TWM7() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x80) >> 7
}
func (o *I2S0_Type) SetTMR_TWM8(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetTMR_TWM8() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetTMR_TWM9(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetTMR_TWM9() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetTMR_TWM10(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetTMR_TWM10() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetTMR_TWM11(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetTMR_TWM11() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetTMR_TWM12(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetTMR_TWM12() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetTMR_TWM13(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x2000)|value<<13)
}
func (o *I2S0_Type) GetTMR_TWM13() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x2000) >> 13
}
func (o *I2S0_Type) SetTMR_TWM14(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x4000)|value<<14)
}
func (o *I2S0_Type) GetTMR_TWM14() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x4000) >> 14
}
func (o *I2S0_Type) SetTMR_TWM15(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x8000)|value<<15)
}
func (o *I2S0_Type) GetTMR_TWM15() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x8000) >> 15
}
func (o *I2S0_Type) SetTMR_TWM16(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTMR_TWM16() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetTMR_TWM17(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetTMR_TWM17() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetTMR_TWM18(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetTMR_TWM18() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetTMR_TWM19(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetTMR_TWM19() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetTMR_TWM20(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetTMR_TWM20() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetTMR_TWM21(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x200000)|value<<21)
}
func (o *I2S0_Type) GetTMR_TWM21() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x200000) >> 21
}
func (o *I2S0_Type) SetTMR_TWM22(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x400000)|value<<22)
}
func (o *I2S0_Type) GetTMR_TWM22() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x400000) >> 22
}
func (o *I2S0_Type) SetTMR_TWM23(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x800000)|value<<23)
}
func (o *I2S0_Type) GetTMR_TWM23() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x800000) >> 23
}
func (o *I2S0_Type) SetTMR_TWM24(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTMR_TWM24() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTMR_TWM25(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTMR_TWM25() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTMR_TWM26(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S0_Type) GetTMR_TWM26() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x4000000) >> 26
}
func (o *I2S0_Type) SetTMR_TWM27(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S0_Type) GetTMR_TWM27() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x8000000) >> 27
}
func (o *I2S0_Type) SetTMR_TWM28(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTMR_TWM28() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTMR_TWM29(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTMR_TWM29() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTMR_TWM30(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetTMR_TWM30() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetTMR_TWM31(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetTMR_TWM31() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0x80000000) >> 31
}

// I2S0.RCSR: SAI Receive Control Register
func (o *I2S0_Type) SetRCSR_FRDE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCSR_FRDE() uint32 {
	return volatile.LoadUint32(&o.RCSR.Reg) & 0x1
}
func (o *I2S0_Type) SetRCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCSR_FRIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetRCSR_FRIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetRCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetRCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetRCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetRCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetRCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetRCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetRCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetRCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetRCSR_FRF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCSR_FRF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetRCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetRCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetRCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetRCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetRCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetRCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetRCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetRCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetRCSR_SR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCSR_FR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetRCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetRCSR_RE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetRCSR_RE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000000) >> 31
}

// I2S0.RCR1: SAI Receive Configuration 1 Register
func (o *I2S0_Type) SetRCR1_RFW(value uint32) {
	volatile.StoreUint32(&o.RCR1.Reg, volatile.LoadUint32(&o.RCR1.Reg)&^(0x7)|value)
}
func (o *I2S0_Type) GetRCR1_RFW() uint32 {
	return volatile.LoadUint32(&o.RCR1.Reg) & 0x7
}

// I2S0.RCR2: SAI Receive Configuration 2 Register
func (o *I2S0_Type) SetRCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetRCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.RCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetRCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetRCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetRCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetRCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.RCR3: SAI Receive Configuration 3 Register
func (o *I2S0_Type) SetRCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x1f)|value)
}
func (o *I2S0_Type) GetRCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.RCR3.Reg) & 0x1f
}
func (o *I2S0_Type) SetRCR3_RCE0(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCR3_RCE0() uint32 {
	return (volatile.LoadUint32(&o.RCR3.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetRCR3_RCE1(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetRCR3_RCE1() uint32 {
	return (volatile.LoadUint32(&o.RCR3.Reg) & 0x20000) >> 17
}

// I2S0.RCR4: SAI Receive Configuration 4 Register
func (o *I2S0_Type) SetRCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.RCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetRCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetRCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetRCR4_MF(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetRCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetRCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetRCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x1f0000) >> 16
}

// I2S0.RCR5: SAI Receive Configuration 5 Register
func (o *I2S0_Type) SetRCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetRCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetRCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetRCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.RDR0: SAI Receive Data Register
func (o *I2S0_Type) SetRDR0(value uint32) {
	volatile.StoreUint32(&o.RDR0.Reg, value)
}
func (o *I2S0_Type) GetRDR0() uint32 {
	return volatile.LoadUint32(&o.RDR0.Reg)
}

// I2S0.RDR1: SAI Receive Data Register
func (o *I2S0_Type) SetRDR1(value uint32) {
	volatile.StoreUint32(&o.RDR1.Reg, value)
}
func (o *I2S0_Type) GetRDR1() uint32 {
	return volatile.LoadUint32(&o.RDR1.Reg)
}

// I2S0.RFR0: SAI Receive FIFO Register
func (o *I2S0_Type) SetRFR0_RFP(value uint32) {
	volatile.StoreUint32(&o.RFR0.Reg, volatile.LoadUint32(&o.RFR0.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetRFR0_RFP() uint32 {
	return volatile.LoadUint32(&o.RFR0.Reg) & 0xf
}
func (o *I2S0_Type) SetRFR0_WFP(value uint32) {
	volatile.StoreUint32(&o.RFR0.Reg, volatile.LoadUint32(&o.RFR0.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetRFR0_WFP() uint32 {
	return (volatile.LoadUint32(&o.RFR0.Reg) & 0xf0000) >> 16
}

// I2S0.RFR1: SAI Receive FIFO Register
func (o *I2S0_Type) SetRFR1_RFP(value uint32) {
	volatile.StoreUint32(&o.RFR1.Reg, volatile.LoadUint32(&o.RFR1.Reg)&^(0xf)|value)
}
func (o *I2S0_Type) GetRFR1_RFP() uint32 {
	return volatile.LoadUint32(&o.RFR1.Reg) & 0xf
}
func (o *I2S0_Type) SetRFR1_WFP(value uint32) {
	volatile.StoreUint32(&o.RFR1.Reg, volatile.LoadUint32(&o.RFR1.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S0_Type) GetRFR1_WFP() uint32 {
	return (volatile.LoadUint32(&o.RFR1.Reg) & 0xf0000) >> 16
}

// I2S0.RMR: SAI Receive Mask Register
func (o *I2S0_Type) SetRMR_RWM0(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRMR_RWM0() uint32 {
	return volatile.LoadUint32(&o.RMR.Reg) & 0x1
}
func (o *I2S0_Type) SetRMR_RWM1(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRMR_RWM1() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRMR_RWM2(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x4)|value<<2)
}
func (o *I2S0_Type) GetRMR_RWM2() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x4) >> 2
}
func (o *I2S0_Type) SetRMR_RWM3(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetRMR_RWM3() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetRMR_RWM4(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetRMR_RWM4() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetRMR_RWM5(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x20)|value<<5)
}
func (o *I2S0_Type) GetRMR_RWM5() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x20) >> 5
}
func (o *I2S0_Type) SetRMR_RWM6(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x40)|value<<6)
}
func (o *I2S0_Type) GetRMR_RWM6() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x40) >> 6
}
func (o *I2S0_Type) SetRMR_RWM7(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x80)|value<<7)
}
func (o *I2S0_Type) GetRMR_RWM7() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x80) >> 7
}
func (o *I2S0_Type) SetRMR_RWM8(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x100)|value<<8)
}
func (o *I2S0_Type) GetRMR_RWM8() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x100) >> 8
}
func (o *I2S0_Type) SetRMR_RWM9(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetRMR_RWM9() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetRMR_RWM10(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetRMR_RWM10() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetRMR_RWM11(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetRMR_RWM11() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetRMR_RWM12(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetRMR_RWM12() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetRMR_RWM13(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x2000)|value<<13)
}
func (o *I2S0_Type) GetRMR_RWM13() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x2000) >> 13
}
func (o *I2S0_Type) SetRMR_RWM14(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x4000)|value<<14)
}
func (o *I2S0_Type) GetRMR_RWM14() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x4000) >> 14
}
func (o *I2S0_Type) SetRMR_RWM15(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x8000)|value<<15)
}
func (o *I2S0_Type) GetRMR_RWM15() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x8000) >> 15
}
func (o *I2S0_Type) SetRMR_RWM16(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRMR_RWM16() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x10000) >> 16
}
func (o *I2S0_Type) SetRMR_RWM17(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetRMR_RWM17() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetRMR_RWM18(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetRMR_RWM18() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetRMR_RWM19(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetRMR_RWM19() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetRMR_RWM20(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetRMR_RWM20() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetRMR_RWM21(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x200000)|value<<21)
}
func (o *I2S0_Type) GetRMR_RWM21() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x200000) >> 21
}
func (o *I2S0_Type) SetRMR_RWM22(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x400000)|value<<22)
}
func (o *I2S0_Type) GetRMR_RWM22() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x400000) >> 22
}
func (o *I2S0_Type) SetRMR_RWM23(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x800000)|value<<23)
}
func (o *I2S0_Type) GetRMR_RWM23() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x800000) >> 23
}
func (o *I2S0_Type) SetRMR_RWM24(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRMR_RWM24() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRMR_RWM25(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRMR_RWM25() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRMR_RWM26(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S0_Type) GetRMR_RWM26() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x4000000) >> 26
}
func (o *I2S0_Type) SetRMR_RWM27(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S0_Type) GetRMR_RWM27() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x8000000) >> 27
}
func (o *I2S0_Type) SetRMR_RWM28(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRMR_RWM28() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRMR_RWM29(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRMR_RWM29() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRMR_RWM30(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetRMR_RWM30() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetRMR_RWM31(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetRMR_RWM31() uint32 {
	return (volatile.LoadUint32(&o.RMR.Reg) & 0x80000000) >> 31
}

// I2S0.MCR: SAI MCLK Control Register
func (o *I2S0_Type) SetMCR_MICS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S0_Type) GetMCR_MICS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x3000000) >> 24
}
func (o *I2S0_Type) SetMCR_MOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetMCR_MOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetMCR_DUF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetMCR_DUF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// I2S0.MDR: SAI MCLK Divide Register
func (o *I2S0_Type) SetMDR_DIVIDE(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xfff)|value)
}
func (o *I2S0_Type) GetMDR_DIVIDE() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg) & 0xfff
}
func (o *I2S0_Type) SetMDR_FRACT(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xff000)|value<<12)
}
func (o *I2S0_Type) GetMDR_FRACT() uint32 {
	return (volatile.LoadUint32(&o.MDR.Reg) & 0xff000) >> 12
}

// Cyclic Redundancy Check
type CRC_Type struct {
	DATA  volatile.Register32 // 0x0
	GPOLY volatile.Register32 // 0x4
	CTRL  volatile.Register32 // 0x8
}

// CRC.DATA: CRC Data register
func (o *CRC_Type) SetDATA_LL(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetDATA_LL() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}
func (o *CRC_Type) SetDATA_LU(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff00)|value<<8)
}
func (o *CRC_Type) GetDATA_LU() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff00) >> 8
}
func (o *CRC_Type) SetDATA_HL(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff0000)|value<<16)
}
func (o *CRC_Type) GetDATA_HL() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff0000) >> 16
}
func (o *CRC_Type) SetDATA_HU(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff000000)|value<<24)
}
func (o *CRC_Type) GetDATA_HU() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff000000) >> 24
}

// CRC.GPOLY: CRC Polynomial register
func (o *CRC_Type) SetGPOLY_LOW(value uint32) {
	volatile.StoreUint32(&o.GPOLY.Reg, volatile.LoadUint32(&o.GPOLY.Reg)&^(0xffff)|value)
}
func (o *CRC_Type) GetGPOLY_LOW() uint32 {
	return volatile.LoadUint32(&o.GPOLY.Reg) & 0xffff
}
func (o *CRC_Type) SetGPOLY_HIGH(value uint32) {
	volatile.StoreUint32(&o.GPOLY.Reg, volatile.LoadUint32(&o.GPOLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *CRC_Type) GetGPOLY_HIGH() uint32 {
	return (volatile.LoadUint32(&o.GPOLY.Reg) & 0xffff0000) >> 16
}

// CRC.CTRL: CRC Control register
func (o *CRC_Type) SetCTRL_TCRC(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *CRC_Type) GetCTRL_TCRC() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *CRC_Type) SetCTRL_WAS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *CRC_Type) GetCTRL_WAS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *CRC_Type) SetCTRL_FXOR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *CRC_Type) GetCTRL_FXOR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *CRC_Type) SetCTRL_TOTR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *CRC_Type) GetCTRL_TOTR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30000000) >> 28
}
func (o *CRC_Type) SetCTRL_TOT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *CRC_Type) GetCTRL_TOT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// USB Device Charger Detection module
type USBDCD_Type struct {
	CONTROL     volatile.Register32 // 0x0
	CLOCK       volatile.Register32 // 0x4
	STATUS      volatile.Register32 // 0x8
	_           [4]byte
	TIMER0      volatile.Register32 // 0x10
	TIMER1      volatile.Register32 // 0x14
	TIMER2_BC11 volatile.Register32 // 0x18
}

// USBDCD.CONTROL: Control register
func (o *USBDCD_Type) SetCONTROL_IACK(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1)|value)
}
func (o *USBDCD_Type) GetCONTROL_IACK() uint32 {
	return volatile.LoadUint32(&o.CONTROL.Reg) & 0x1
}
func (o *USBDCD_Type) SetCONTROL_IF(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x100)|value<<8)
}
func (o *USBDCD_Type) GetCONTROL_IF() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x100) >> 8
}
func (o *USBDCD_Type) SetCONTROL_IE(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x10000)|value<<16)
}
func (o *USBDCD_Type) GetCONTROL_IE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x10000) >> 16
}
func (o *USBDCD_Type) SetCONTROL_BC12(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x20000)|value<<17)
}
func (o *USBDCD_Type) GetCONTROL_BC12() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x20000) >> 17
}
func (o *USBDCD_Type) SetCONTROL_START(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1000000)|value<<24)
}
func (o *USBDCD_Type) GetCONTROL_START() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x1000000) >> 24
}
func (o *USBDCD_Type) SetCONTROL_SR(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2000000)|value<<25)
}
func (o *USBDCD_Type) GetCONTROL_SR() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2000000) >> 25
}

// USBDCD.CLOCK: Clock register
func (o *USBDCD_Type) SetCLOCK_CLOCK_UNIT(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x1)|value)
}
func (o *USBDCD_Type) GetCLOCK_CLOCK_UNIT() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0x1
}
func (o *USBDCD_Type) SetCLOCK_CLOCK_SPEED(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xffc)|value<<2)
}
func (o *USBDCD_Type) GetCLOCK_CLOCK_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xffc) >> 2
}

// USBDCD.STATUS: Status register
func (o *USBDCD_Type) SetSTATUS_SEQ_RES(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x30000)|value<<16)
}
func (o *USBDCD_Type) GetSTATUS_SEQ_RES() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x30000) >> 16
}
func (o *USBDCD_Type) SetSTATUS_SEQ_STAT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xc0000)|value<<18)
}
func (o *USBDCD_Type) GetSTATUS_SEQ_STAT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xc0000) >> 18
}
func (o *USBDCD_Type) SetSTATUS_ERR(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100000)|value<<20)
}
func (o *USBDCD_Type) GetSTATUS_ERR() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100000) >> 20
}
func (o *USBDCD_Type) SetSTATUS_TO(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200000)|value<<21)
}
func (o *USBDCD_Type) GetSTATUS_TO() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200000) >> 21
}
func (o *USBDCD_Type) SetSTATUS_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400000)|value<<22)
}
func (o *USBDCD_Type) GetSTATUS_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400000) >> 22
}

// USBDCD.TIMER0: TIMER0 register
func (o *USBDCD_Type) SetTIMER0_TUNITCON(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0xfff)|value)
}
func (o *USBDCD_Type) GetTIMER0_TUNITCON() uint32 {
	return volatile.LoadUint32(&o.TIMER0.Reg) & 0xfff
}
func (o *USBDCD_Type) SetTIMER0_TSEQ_INIT(value uint32) {
	volatile.StoreUint32(&o.TIMER0.Reg, volatile.LoadUint32(&o.TIMER0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *USBDCD_Type) GetTIMER0_TSEQ_INIT() uint32 {
	return (volatile.LoadUint32(&o.TIMER0.Reg) & 0x3ff0000) >> 16
}

// USBDCD.TIMER1: TIMER1 register
func (o *USBDCD_Type) SetTIMER1_TVDPSRC_ON(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0x3ff)|value)
}
func (o *USBDCD_Type) GetTIMER1_TVDPSRC_ON() uint32 {
	return volatile.LoadUint32(&o.TIMER1.Reg) & 0x3ff
}
func (o *USBDCD_Type) SetTIMER1_TDCD_DBNC(value uint32) {
	volatile.StoreUint32(&o.TIMER1.Reg, volatile.LoadUint32(&o.TIMER1.Reg)&^(0x3ff0000)|value<<16)
}
func (o *USBDCD_Type) GetTIMER1_TDCD_DBNC() uint32 {
	return (volatile.LoadUint32(&o.TIMER1.Reg) & 0x3ff0000) >> 16
}

// USBDCD.TIMER2_BC11: TIMER2_BC11 register
func (o *USBDCD_Type) SetTIMER2_BC11_CHECK_DM(value uint32) {
	volatile.StoreUint32(&o.TIMER2_BC11.Reg, volatile.LoadUint32(&o.TIMER2_BC11.Reg)&^(0xf)|value)
}
func (o *USBDCD_Type) GetTIMER2_BC11_CHECK_DM() uint32 {
	return volatile.LoadUint32(&o.TIMER2_BC11.Reg) & 0xf
}
func (o *USBDCD_Type) SetTIMER2_BC11_TVDPSRC_CON(value uint32) {
	volatile.StoreUint32(&o.TIMER2_BC11.Reg, volatile.LoadUint32(&o.TIMER2_BC11.Reg)&^(0x3ff0000)|value<<16)
}
func (o *USBDCD_Type) GetTIMER2_BC11_TVDPSRC_CON() uint32 {
	return (volatile.LoadUint32(&o.TIMER2_BC11.Reg) & 0x3ff0000) >> 16
}

// Programmable Delay Block
type PDB0_Type struct {
	SC       volatile.Register32 // 0x0
	MOD      volatile.Register32 // 0x4
	CNT      volatile.Register32 // 0x8
	IDLY     volatile.Register32 // 0xC
	CH0C1    volatile.Register32 // 0x10
	CH0S     volatile.Register32 // 0x14
	CH0DLY0  volatile.Register32 // 0x18
	CH0DLY1  volatile.Register32 // 0x1C
	_        [24]byte
	CH1C1    volatile.Register32 // 0x38
	CH1S     volatile.Register32 // 0x3C
	CH1DLY0  volatile.Register32 // 0x40
	CH1DLY1  volatile.Register32 // 0x44
	_        [264]byte
	DACINTC0 volatile.Register32 // 0x150
	DACINT0  volatile.Register32 // 0x154
	DACINTC1 volatile.Register32 // 0x158
	DACINT1  volatile.Register32 // 0x15C
	_        [48]byte
	POEN     volatile.Register32 // 0x190
	PO0DLY   volatile.Register32 // 0x194
	PO1DLY   volatile.Register32 // 0x198
	PO2DLY   volatile.Register32 // 0x19C
}

// PDB0.SC: Status and Control register
func (o *PDB0_Type) SetSC_LDOK(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetSC_LDOK() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x1
}
func (o *PDB0_Type) SetSC_CONT(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetSC_CONT() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetSC_MULT(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xc)|value<<2)
}
func (o *PDB0_Type) GetSC_MULT() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xc) >> 2
}
func (o *PDB0_Type) SetSC_PDBIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetSC_PDBIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetSC_PDBIF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetSC_PDBIF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetSC_PDBEN(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetSC_PDBEN() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetSC_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xf00)|value<<8)
}
func (o *PDB0_Type) GetSC_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xf00) >> 8
}
func (o *PDB0_Type) SetSC_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7000)|value<<12)
}
func (o *PDB0_Type) GetSC_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x7000) >> 12
}
func (o *PDB0_Type) SetSC_DMAEN(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x8000)|value<<15)
}
func (o *PDB0_Type) GetSC_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x8000) >> 15
}
func (o *PDB0_Type) SetSC_SWTRIG(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x10000)|value<<16)
}
func (o *PDB0_Type) GetSC_SWTRIG() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x10000) >> 16
}
func (o *PDB0_Type) SetSC_PDBEIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20000)|value<<17)
}
func (o *PDB0_Type) GetSC_PDBEIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20000) >> 17
}
func (o *PDB0_Type) SetSC_LDMOD(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0xc0000)|value<<18)
}
func (o *PDB0_Type) GetSC_LDMOD() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0xc0000) >> 18
}

// PDB0.MOD: Modulus register
func (o *PDB0_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// PDB0.CNT: Counter register
func (o *PDB0_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// PDB0.IDLY: Interrupt Delay register
func (o *PDB0_Type) SetIDLY(value uint32) {
	volatile.StoreUint32(&o.IDLY.Reg, volatile.LoadUint32(&o.IDLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetIDLY() uint32 {
	return volatile.LoadUint32(&o.IDLY.Reg) & 0xffff
}

// PDB0.CH0C1: Channel n Control register 1
func (o *PDB0_Type) SetCH0C1_EN0(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetCH0C1_EN0() uint32 {
	return volatile.LoadUint32(&o.CH0C1.Reg) & 0x1
}
func (o *PDB0_Type) SetCH0C1_EN1(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetCH0C1_EN1() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetCH0C1_EN2(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x4)|value<<2)
}
func (o *PDB0_Type) GetCH0C1_EN2() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x4) >> 2
}
func (o *PDB0_Type) SetCH0C1_EN3(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x8)|value<<3)
}
func (o *PDB0_Type) GetCH0C1_EN3() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x8) >> 3
}
func (o *PDB0_Type) SetCH0C1_EN4(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x10)|value<<4)
}
func (o *PDB0_Type) GetCH0C1_EN4() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x10) >> 4
}
func (o *PDB0_Type) SetCH0C1_EN5(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetCH0C1_EN5() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetCH0C1_EN6(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetCH0C1_EN6() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetCH0C1_EN7(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetCH0C1_EN7() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetCH0C1_TOS0(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x100)|value<<8)
}
func (o *PDB0_Type) GetCH0C1_TOS0() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x100) >> 8
}
func (o *PDB0_Type) SetCH0C1_TOS1(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x200)|value<<9)
}
func (o *PDB0_Type) GetCH0C1_TOS1() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x200) >> 9
}
func (o *PDB0_Type) SetCH0C1_TOS2(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x400)|value<<10)
}
func (o *PDB0_Type) GetCH0C1_TOS2() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x400) >> 10
}
func (o *PDB0_Type) SetCH0C1_TOS3(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x800)|value<<11)
}
func (o *PDB0_Type) GetCH0C1_TOS3() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x800) >> 11
}
func (o *PDB0_Type) SetCH0C1_TOS4(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x1000)|value<<12)
}
func (o *PDB0_Type) GetCH0C1_TOS4() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x1000) >> 12
}
func (o *PDB0_Type) SetCH0C1_TOS5(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x2000)|value<<13)
}
func (o *PDB0_Type) GetCH0C1_TOS5() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x2000) >> 13
}
func (o *PDB0_Type) SetCH0C1_TOS6(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x4000)|value<<14)
}
func (o *PDB0_Type) GetCH0C1_TOS6() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x4000) >> 14
}
func (o *PDB0_Type) SetCH0C1_TOS7(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x8000)|value<<15)
}
func (o *PDB0_Type) GetCH0C1_TOS7() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x8000) >> 15
}
func (o *PDB0_Type) SetCH0C1_BB0(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x10000)|value<<16)
}
func (o *PDB0_Type) GetCH0C1_BB0() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x10000) >> 16
}
func (o *PDB0_Type) SetCH0C1_BB1(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x20000)|value<<17)
}
func (o *PDB0_Type) GetCH0C1_BB1() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x20000) >> 17
}
func (o *PDB0_Type) SetCH0C1_BB2(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x40000)|value<<18)
}
func (o *PDB0_Type) GetCH0C1_BB2() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x40000) >> 18
}
func (o *PDB0_Type) SetCH0C1_BB3(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x80000)|value<<19)
}
func (o *PDB0_Type) GetCH0C1_BB3() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x80000) >> 19
}
func (o *PDB0_Type) SetCH0C1_BB4(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x100000)|value<<20)
}
func (o *PDB0_Type) GetCH0C1_BB4() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x100000) >> 20
}
func (o *PDB0_Type) SetCH0C1_BB5(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x200000)|value<<21)
}
func (o *PDB0_Type) GetCH0C1_BB5() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x200000) >> 21
}
func (o *PDB0_Type) SetCH0C1_BB6(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x400000)|value<<22)
}
func (o *PDB0_Type) GetCH0C1_BB6() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x400000) >> 22
}
func (o *PDB0_Type) SetCH0C1_BB7(value uint32) {
	volatile.StoreUint32(&o.CH0C1.Reg, volatile.LoadUint32(&o.CH0C1.Reg)&^(0x800000)|value<<23)
}
func (o *PDB0_Type) GetCH0C1_BB7() uint32 {
	return (volatile.LoadUint32(&o.CH0C1.Reg) & 0x800000) >> 23
}

// PDB0.CH0S: Channel n Status register
func (o *PDB0_Type) SetCH0S_ERR0(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetCH0S_ERR0() uint32 {
	return volatile.LoadUint32(&o.CH0S.Reg) & 0x1
}
func (o *PDB0_Type) SetCH0S_ERR1(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetCH0S_ERR1() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetCH0S_ERR2(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x4)|value<<2)
}
func (o *PDB0_Type) GetCH0S_ERR2() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x4) >> 2
}
func (o *PDB0_Type) SetCH0S_ERR3(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x8)|value<<3)
}
func (o *PDB0_Type) GetCH0S_ERR3() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x8) >> 3
}
func (o *PDB0_Type) SetCH0S_ERR4(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x10)|value<<4)
}
func (o *PDB0_Type) GetCH0S_ERR4() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x10) >> 4
}
func (o *PDB0_Type) SetCH0S_ERR5(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetCH0S_ERR5() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetCH0S_ERR6(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetCH0S_ERR6() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetCH0S_ERR7(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetCH0S_ERR7() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetCH0S_CF(value uint32) {
	volatile.StoreUint32(&o.CH0S.Reg, volatile.LoadUint32(&o.CH0S.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH0S_CF() uint32 {
	return (volatile.LoadUint32(&o.CH0S.Reg) & 0xff0000) >> 16
}

// PDB0.CH0DLY0: Channel n Delay 0 register
func (o *PDB0_Type) SetCH0DLY0_DLY(value uint32) {
	volatile.StoreUint32(&o.CH0DLY0.Reg, volatile.LoadUint32(&o.CH0DLY0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH0DLY0_DLY() uint32 {
	return volatile.LoadUint32(&o.CH0DLY0.Reg) & 0xffff
}

// PDB0.CH0DLY1: Channel n Delay 1 register
func (o *PDB0_Type) SetCH0DLY1_DLY(value uint32) {
	volatile.StoreUint32(&o.CH0DLY1.Reg, volatile.LoadUint32(&o.CH0DLY1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH0DLY1_DLY() uint32 {
	return volatile.LoadUint32(&o.CH0DLY1.Reg) & 0xffff
}

// PDB0.CH1C1: Channel n Control register 1
func (o *PDB0_Type) SetCH1C1_EN0(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetCH1C1_EN0() uint32 {
	return volatile.LoadUint32(&o.CH1C1.Reg) & 0x1
}
func (o *PDB0_Type) SetCH1C1_EN1(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetCH1C1_EN1() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetCH1C1_EN2(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x4)|value<<2)
}
func (o *PDB0_Type) GetCH1C1_EN2() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x4) >> 2
}
func (o *PDB0_Type) SetCH1C1_EN3(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x8)|value<<3)
}
func (o *PDB0_Type) GetCH1C1_EN3() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x8) >> 3
}
func (o *PDB0_Type) SetCH1C1_EN4(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x10)|value<<4)
}
func (o *PDB0_Type) GetCH1C1_EN4() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x10) >> 4
}
func (o *PDB0_Type) SetCH1C1_EN5(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetCH1C1_EN5() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetCH1C1_EN6(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetCH1C1_EN6() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetCH1C1_EN7(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetCH1C1_EN7() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetCH1C1_TOS0(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x100)|value<<8)
}
func (o *PDB0_Type) GetCH1C1_TOS0() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x100) >> 8
}
func (o *PDB0_Type) SetCH1C1_TOS1(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x200)|value<<9)
}
func (o *PDB0_Type) GetCH1C1_TOS1() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x200) >> 9
}
func (o *PDB0_Type) SetCH1C1_TOS2(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x400)|value<<10)
}
func (o *PDB0_Type) GetCH1C1_TOS2() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x400) >> 10
}
func (o *PDB0_Type) SetCH1C1_TOS3(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x800)|value<<11)
}
func (o *PDB0_Type) GetCH1C1_TOS3() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x800) >> 11
}
func (o *PDB0_Type) SetCH1C1_TOS4(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x1000)|value<<12)
}
func (o *PDB0_Type) GetCH1C1_TOS4() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x1000) >> 12
}
func (o *PDB0_Type) SetCH1C1_TOS5(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x2000)|value<<13)
}
func (o *PDB0_Type) GetCH1C1_TOS5() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x2000) >> 13
}
func (o *PDB0_Type) SetCH1C1_TOS6(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x4000)|value<<14)
}
func (o *PDB0_Type) GetCH1C1_TOS6() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x4000) >> 14
}
func (o *PDB0_Type) SetCH1C1_TOS7(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x8000)|value<<15)
}
func (o *PDB0_Type) GetCH1C1_TOS7() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x8000) >> 15
}
func (o *PDB0_Type) SetCH1C1_BB0(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x10000)|value<<16)
}
func (o *PDB0_Type) GetCH1C1_BB0() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x10000) >> 16
}
func (o *PDB0_Type) SetCH1C1_BB1(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x20000)|value<<17)
}
func (o *PDB0_Type) GetCH1C1_BB1() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x20000) >> 17
}
func (o *PDB0_Type) SetCH1C1_BB2(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x40000)|value<<18)
}
func (o *PDB0_Type) GetCH1C1_BB2() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x40000) >> 18
}
func (o *PDB0_Type) SetCH1C1_BB3(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x80000)|value<<19)
}
func (o *PDB0_Type) GetCH1C1_BB3() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x80000) >> 19
}
func (o *PDB0_Type) SetCH1C1_BB4(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x100000)|value<<20)
}
func (o *PDB0_Type) GetCH1C1_BB4() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x100000) >> 20
}
func (o *PDB0_Type) SetCH1C1_BB5(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x200000)|value<<21)
}
func (o *PDB0_Type) GetCH1C1_BB5() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x200000) >> 21
}
func (o *PDB0_Type) SetCH1C1_BB6(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x400000)|value<<22)
}
func (o *PDB0_Type) GetCH1C1_BB6() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x400000) >> 22
}
func (o *PDB0_Type) SetCH1C1_BB7(value uint32) {
	volatile.StoreUint32(&o.CH1C1.Reg, volatile.LoadUint32(&o.CH1C1.Reg)&^(0x800000)|value<<23)
}
func (o *PDB0_Type) GetCH1C1_BB7() uint32 {
	return (volatile.LoadUint32(&o.CH1C1.Reg) & 0x800000) >> 23
}

// PDB0.CH1S: Channel n Status register
func (o *PDB0_Type) SetCH1S_ERR0(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetCH1S_ERR0() uint32 {
	return volatile.LoadUint32(&o.CH1S.Reg) & 0x1
}
func (o *PDB0_Type) SetCH1S_ERR1(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetCH1S_ERR1() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetCH1S_ERR2(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x4)|value<<2)
}
func (o *PDB0_Type) GetCH1S_ERR2() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x4) >> 2
}
func (o *PDB0_Type) SetCH1S_ERR3(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x8)|value<<3)
}
func (o *PDB0_Type) GetCH1S_ERR3() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x8) >> 3
}
func (o *PDB0_Type) SetCH1S_ERR4(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x10)|value<<4)
}
func (o *PDB0_Type) GetCH1S_ERR4() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x10) >> 4
}
func (o *PDB0_Type) SetCH1S_ERR5(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetCH1S_ERR5() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetCH1S_ERR6(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetCH1S_ERR6() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetCH1S_ERR7(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetCH1S_ERR7() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0x80) >> 7
}
func (o *PDB0_Type) SetCH1S_CF(value uint32) {
	volatile.StoreUint32(&o.CH1S.Reg, volatile.LoadUint32(&o.CH1S.Reg)&^(0xff0000)|value<<16)
}
func (o *PDB0_Type) GetCH1S_CF() uint32 {
	return (volatile.LoadUint32(&o.CH1S.Reg) & 0xff0000) >> 16
}

// PDB0.CH1DLY0: Channel n Delay 0 register
func (o *PDB0_Type) SetCH1DLY0_DLY(value uint32) {
	volatile.StoreUint32(&o.CH1DLY0.Reg, volatile.LoadUint32(&o.CH1DLY0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH1DLY0_DLY() uint32 {
	return volatile.LoadUint32(&o.CH1DLY0.Reg) & 0xffff
}

// PDB0.CH1DLY1: Channel n Delay 1 register
func (o *PDB0_Type) SetCH1DLY1_DLY(value uint32) {
	volatile.StoreUint32(&o.CH1DLY1.Reg, volatile.LoadUint32(&o.CH1DLY1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetCH1DLY1_DLY() uint32 {
	return volatile.LoadUint32(&o.CH1DLY1.Reg) & 0xffff
}

// PDB0.DACINTC0: DAC Interval Trigger n Control register
func (o *PDB0_Type) SetDACINTC0_TOE(value uint32) {
	volatile.StoreUint32(&o.DACINTC0.Reg, volatile.LoadUint32(&o.DACINTC0.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetDACINTC0_TOE() uint32 {
	return volatile.LoadUint32(&o.DACINTC0.Reg) & 0x1
}
func (o *PDB0_Type) SetDACINTC0_EXT(value uint32) {
	volatile.StoreUint32(&o.DACINTC0.Reg, volatile.LoadUint32(&o.DACINTC0.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetDACINTC0_EXT() uint32 {
	return (volatile.LoadUint32(&o.DACINTC0.Reg) & 0x2) >> 1
}

// PDB0.DACINT0: DAC Interval n register
func (o *PDB0_Type) SetDACINT0_INT(value uint32) {
	volatile.StoreUint32(&o.DACINT0.Reg, volatile.LoadUint32(&o.DACINT0.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetDACINT0_INT() uint32 {
	return volatile.LoadUint32(&o.DACINT0.Reg) & 0xffff
}

// PDB0.DACINTC1: DAC Interval Trigger n Control register
func (o *PDB0_Type) SetDACINTC1_TOE(value uint32) {
	volatile.StoreUint32(&o.DACINTC1.Reg, volatile.LoadUint32(&o.DACINTC1.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetDACINTC1_TOE() uint32 {
	return volatile.LoadUint32(&o.DACINTC1.Reg) & 0x1
}
func (o *PDB0_Type) SetDACINTC1_EXT(value uint32) {
	volatile.StoreUint32(&o.DACINTC1.Reg, volatile.LoadUint32(&o.DACINTC1.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetDACINTC1_EXT() uint32 {
	return (volatile.LoadUint32(&o.DACINTC1.Reg) & 0x2) >> 1
}

// PDB0.DACINT1: DAC Interval n register
func (o *PDB0_Type) SetDACINT1_INT(value uint32) {
	volatile.StoreUint32(&o.DACINT1.Reg, volatile.LoadUint32(&o.DACINT1.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetDACINT1_INT() uint32 {
	return volatile.LoadUint32(&o.DACINT1.Reg) & 0xffff
}

// PDB0.POEN: Pulse-Out n Enable register
func (o *PDB0_Type) SetPOEN_POEN0(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x1)|value)
}
func (o *PDB0_Type) GetPOEN_POEN0() uint32 {
	return volatile.LoadUint32(&o.POEN.Reg) & 0x1
}
func (o *PDB0_Type) SetPOEN_POEN1(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x2)|value<<1)
}
func (o *PDB0_Type) GetPOEN_POEN1() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x2) >> 1
}
func (o *PDB0_Type) SetPOEN_POEN2(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x4)|value<<2)
}
func (o *PDB0_Type) GetPOEN_POEN2() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x4) >> 2
}
func (o *PDB0_Type) SetPOEN_POEN3(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x8)|value<<3)
}
func (o *PDB0_Type) GetPOEN_POEN3() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x8) >> 3
}
func (o *PDB0_Type) SetPOEN_POEN4(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x10)|value<<4)
}
func (o *PDB0_Type) GetPOEN_POEN4() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x10) >> 4
}
func (o *PDB0_Type) SetPOEN_POEN5(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x20)|value<<5)
}
func (o *PDB0_Type) GetPOEN_POEN5() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x20) >> 5
}
func (o *PDB0_Type) SetPOEN_POEN6(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x40)|value<<6)
}
func (o *PDB0_Type) GetPOEN_POEN6() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x40) >> 6
}
func (o *PDB0_Type) SetPOEN_POEN7(value uint32) {
	volatile.StoreUint32(&o.POEN.Reg, volatile.LoadUint32(&o.POEN.Reg)&^(0x80)|value<<7)
}
func (o *PDB0_Type) GetPOEN_POEN7() uint32 {
	return (volatile.LoadUint32(&o.POEN.Reg) & 0x80) >> 7
}

// PDB0.PO0DLY: Pulse-Out n Delay register
func (o *PDB0_Type) SetPO0DLY_DLY2(value uint32) {
	volatile.StoreUint32(&o.PO0DLY.Reg, volatile.LoadUint32(&o.PO0DLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetPO0DLY_DLY2() uint32 {
	return volatile.LoadUint32(&o.PO0DLY.Reg) & 0xffff
}
func (o *PDB0_Type) SetPO0DLY_DLY1(value uint32) {
	volatile.StoreUint32(&o.PO0DLY.Reg, volatile.LoadUint32(&o.PO0DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *PDB0_Type) GetPO0DLY_DLY1() uint32 {
	return (volatile.LoadUint32(&o.PO0DLY.Reg) & 0xffff0000) >> 16
}

// PDB0.PO1DLY: Pulse-Out n Delay register
func (o *PDB0_Type) SetPO1DLY_DLY2(value uint32) {
	volatile.StoreUint32(&o.PO1DLY.Reg, volatile.LoadUint32(&o.PO1DLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetPO1DLY_DLY2() uint32 {
	return volatile.LoadUint32(&o.PO1DLY.Reg) & 0xffff
}
func (o *PDB0_Type) SetPO1DLY_DLY1(value uint32) {
	volatile.StoreUint32(&o.PO1DLY.Reg, volatile.LoadUint32(&o.PO1DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *PDB0_Type) GetPO1DLY_DLY1() uint32 {
	return (volatile.LoadUint32(&o.PO1DLY.Reg) & 0xffff0000) >> 16
}

// PDB0.PO2DLY: Pulse-Out n Delay register
func (o *PDB0_Type) SetPO2DLY_DLY2(value uint32) {
	volatile.StoreUint32(&o.PO2DLY.Reg, volatile.LoadUint32(&o.PO2DLY.Reg)&^(0xffff)|value)
}
func (o *PDB0_Type) GetPO2DLY_DLY2() uint32 {
	return volatile.LoadUint32(&o.PO2DLY.Reg) & 0xffff
}
func (o *PDB0_Type) SetPO2DLY_DLY1(value uint32) {
	volatile.StoreUint32(&o.PO2DLY.Reg, volatile.LoadUint32(&o.PO2DLY.Reg)&^(0xffff0000)|value<<16)
}
func (o *PDB0_Type) GetPO2DLY_DLY1() uint32 {
	return (volatile.LoadUint32(&o.PO2DLY.Reg) & 0xffff0000) >> 16
}

// Periodic Interrupt Timer
type PIT_Type struct {
	MCR    volatile.Register32 // 0x0
	_      [252]byte
	LDVAL0 volatile.Register32 // 0x100
	CVAL0  volatile.Register32 // 0x104
	TCTRL0 volatile.Register32 // 0x108
	TFLG0  volatile.Register32 // 0x10C
	LDVAL1 volatile.Register32 // 0x110
	CVAL1  volatile.Register32 // 0x114
	TCTRL1 volatile.Register32 // 0x118
	TFLG1  volatile.Register32 // 0x11C
	LDVAL2 volatile.Register32 // 0x120
	CVAL2  volatile.Register32 // 0x124
	TCTRL2 volatile.Register32 // 0x128
	TFLG2  volatile.Register32 // 0x12C
	LDVAL3 volatile.Register32 // 0x130
	CVAL3  volatile.Register32 // 0x134
	TCTRL3 volatile.Register32 // 0x138
	TFLG3  volatile.Register32 // 0x13C
}

// PIT.MCR: PIT Module Control Register
func (o *PIT_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetMCR_FRZ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PIT_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}

// PIT.LDVAL0: Timer Load Value Register
func (o *PIT_Type) SetLDVAL0(value uint32) {
	volatile.StoreUint32(&o.LDVAL0.Reg, value)
}
func (o *PIT_Type) GetLDVAL0() uint32 {
	return volatile.LoadUint32(&o.LDVAL0.Reg)
}

// PIT.CVAL0: Current Timer Value Register
func (o *PIT_Type) SetCVAL0(value uint32) {
	volatile.StoreUint32(&o.CVAL0.Reg, value)
}
func (o *PIT_Type) GetCVAL0() uint32 {
	return volatile.LoadUint32(&o.CVAL0.Reg)
}

// PIT.TCTRL0: Timer Control Register
func (o *PIT_Type) SetTCTRL0_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL0_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL0.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL0_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL0_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL0_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL0_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x4) >> 2
}

// PIT.TFLG0: Timer Flag Register
func (o *PIT_Type) SetTFLG0_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG0.Reg, volatile.LoadUint32(&o.TFLG0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG0_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG0.Reg) & 0x1
}

// PIT.LDVAL1: Timer Load Value Register
func (o *PIT_Type) SetLDVAL1(value uint32) {
	volatile.StoreUint32(&o.LDVAL1.Reg, value)
}
func (o *PIT_Type) GetLDVAL1() uint32 {
	return volatile.LoadUint32(&o.LDVAL1.Reg)
}

// PIT.CVAL1: Current Timer Value Register
func (o *PIT_Type) SetCVAL1(value uint32) {
	volatile.StoreUint32(&o.CVAL1.Reg, value)
}
func (o *PIT_Type) GetCVAL1() uint32 {
	return volatile.LoadUint32(&o.CVAL1.Reg)
}

// PIT.TCTRL1: Timer Control Register
func (o *PIT_Type) SetTCTRL1_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL1_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL1.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL1_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL1_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL1_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL1_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x4) >> 2
}

// PIT.TFLG1: Timer Flag Register
func (o *PIT_Type) SetTFLG1_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG1.Reg, volatile.LoadUint32(&o.TFLG1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG1_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG1.Reg) & 0x1
}

// PIT.LDVAL2: Timer Load Value Register
func (o *PIT_Type) SetLDVAL2(value uint32) {
	volatile.StoreUint32(&o.LDVAL2.Reg, value)
}
func (o *PIT_Type) GetLDVAL2() uint32 {
	return volatile.LoadUint32(&o.LDVAL2.Reg)
}

// PIT.CVAL2: Current Timer Value Register
func (o *PIT_Type) SetCVAL2(value uint32) {
	volatile.StoreUint32(&o.CVAL2.Reg, value)
}
func (o *PIT_Type) GetCVAL2() uint32 {
	return volatile.LoadUint32(&o.CVAL2.Reg)
}

// PIT.TCTRL2: Timer Control Register
func (o *PIT_Type) SetTCTRL2_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL2_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL2.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL2_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL2_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL2.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL2_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL2.Reg, volatile.LoadUint32(&o.TCTRL2.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL2_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL2.Reg) & 0x4) >> 2
}

// PIT.TFLG2: Timer Flag Register
func (o *PIT_Type) SetTFLG2_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG2.Reg, volatile.LoadUint32(&o.TFLG2.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG2_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG2.Reg) & 0x1
}

// PIT.LDVAL3: Timer Load Value Register
func (o *PIT_Type) SetLDVAL3(value uint32) {
	volatile.StoreUint32(&o.LDVAL3.Reg, value)
}
func (o *PIT_Type) GetLDVAL3() uint32 {
	return volatile.LoadUint32(&o.LDVAL3.Reg)
}

// PIT.CVAL3: Current Timer Value Register
func (o *PIT_Type) SetCVAL3(value uint32) {
	volatile.StoreUint32(&o.CVAL3.Reg, value)
}
func (o *PIT_Type) GetCVAL3() uint32 {
	return volatile.LoadUint32(&o.CVAL3.Reg)
}

// PIT.TCTRL3: Timer Control Register
func (o *PIT_Type) SetTCTRL3_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL3_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL3.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL3_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL3_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL3.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL3_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL3.Reg, volatile.LoadUint32(&o.TCTRL3.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL3_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL3.Reg) & 0x4) >> 2
}

// PIT.TFLG3: Timer Flag Register
func (o *PIT_Type) SetTFLG3_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG3.Reg, volatile.LoadUint32(&o.TFLG3.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG3_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG3.Reg) & 0x1
}

// FlexTimer Module
type FTM_Type struct {
	SC       volatile.Register32 // 0x0
	CNT      volatile.Register32 // 0x4
	MOD      volatile.Register32 // 0x8
	C0SC     volatile.Register32 // 0xC
	C0V      volatile.Register32 // 0x10
	C1SC     volatile.Register32 // 0x14
	C1V      volatile.Register32 // 0x18
	C2SC     volatile.Register32 // 0x1C
	C2V      volatile.Register32 // 0x20
	C3SC     volatile.Register32 // 0x24
	C3V      volatile.Register32 // 0x28
	C4SC     volatile.Register32 // 0x2C
	C4V      volatile.Register32 // 0x30
	C5SC     volatile.Register32 // 0x34
	C5V      volatile.Register32 // 0x38
	C6SC     volatile.Register32 // 0x3C
	C6V      volatile.Register32 // 0x40
	C7SC     volatile.Register32 // 0x44
	C7V      volatile.Register32 // 0x48
	CNTIN    volatile.Register32 // 0x4C
	STATUS   volatile.Register32 // 0x50
	MODE     volatile.Register32 // 0x54
	SYNC     volatile.Register32 // 0x58
	OUTINIT  volatile.Register32 // 0x5C
	OUTMASK  volatile.Register32 // 0x60
	COMBINE  volatile.Register32 // 0x64
	DEADTIME volatile.Register32 // 0x68
	EXTTRIG  volatile.Register32 // 0x6C
	POL      volatile.Register32 // 0x70
	FMS      volatile.Register32 // 0x74
	FILTER   volatile.Register32 // 0x78
	FLTCTRL  volatile.Register32 // 0x7C
	QDCTRL   volatile.Register32 // 0x80
	CONF     volatile.Register32 // 0x84
	FLTPOL   volatile.Register32 // 0x88
	SYNCONF  volatile.Register32 // 0x8C
	INVCTRL  volatile.Register32 // 0x90
	SWOCTRL  volatile.Register32 // 0x94
	PWMLOAD  volatile.Register32 // 0x98
}

// FTM.SC: Status And Control
func (o *FTM_Type) SetSC_PS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7)|value)
}
func (o *FTM_Type) GetSC_PS() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x7
}
func (o *FTM_Type) SetSC_CLKS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x18)|value<<3)
}
func (o *FTM_Type) GetSC_CLKS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x18) >> 3
}
func (o *FTM_Type) SetSC_CPWMS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSC_CPWMS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSC_TOIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSC_TOIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSC_TOF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSC_TOF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}

// FTM.CNT: Counter
func (o *FTM_Type) SetCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// FTM.MOD: Modulo
func (o *FTM_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// FTM.C0SC: Channel (n) Status And Control
func (o *FTM_Type) SetC0SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC0SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C0SC.Reg) & 0x1
}
func (o *FTM_Type) SetC0SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC0SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC0SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC0SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC0SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC0SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC0SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC0SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC0SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC0SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC0SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC0SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x80) >> 7
}

// FTM.C0V: Channel (n) Value
func (o *FTM_Type) SetC0V_VAL(value uint32) {
	volatile.StoreUint32(&o.C0V.Reg, volatile.LoadUint32(&o.C0V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC0V_VAL() uint32 {
	return volatile.LoadUint32(&o.C0V.Reg) & 0xffff
}

// FTM.C1SC: Channel (n) Status And Control
func (o *FTM_Type) SetC1SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC1SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C1SC.Reg) & 0x1
}
func (o *FTM_Type) SetC1SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC1SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC1SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC1SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC1SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC1SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC1SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC1SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC1SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC1SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC1SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC1SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x80) >> 7
}

// FTM.C1V: Channel (n) Value
func (o *FTM_Type) SetC1V_VAL(value uint32) {
	volatile.StoreUint32(&o.C1V.Reg, volatile.LoadUint32(&o.C1V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC1V_VAL() uint32 {
	return volatile.LoadUint32(&o.C1V.Reg) & 0xffff
}

// FTM.C2SC: Channel (n) Status And Control
func (o *FTM_Type) SetC2SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC2SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C2SC.Reg) & 0x1
}
func (o *FTM_Type) SetC2SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC2SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC2SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC2SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC2SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC2SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC2SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC2SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC2SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC2SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC2SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC2SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x80) >> 7
}

// FTM.C2V: Channel (n) Value
func (o *FTM_Type) SetC2V_VAL(value uint32) {
	volatile.StoreUint32(&o.C2V.Reg, volatile.LoadUint32(&o.C2V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC2V_VAL() uint32 {
	return volatile.LoadUint32(&o.C2V.Reg) & 0xffff
}

// FTM.C3SC: Channel (n) Status And Control
func (o *FTM_Type) SetC3SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC3SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C3SC.Reg) & 0x1
}
func (o *FTM_Type) SetC3SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC3SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC3SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC3SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC3SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC3SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC3SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC3SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC3SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC3SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC3SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC3SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x80) >> 7
}

// FTM.C3V: Channel (n) Value
func (o *FTM_Type) SetC3V_VAL(value uint32) {
	volatile.StoreUint32(&o.C3V.Reg, volatile.LoadUint32(&o.C3V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC3V_VAL() uint32 {
	return volatile.LoadUint32(&o.C3V.Reg) & 0xffff
}

// FTM.C4SC: Channel (n) Status And Control
func (o *FTM_Type) SetC4SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC4SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C4SC.Reg) & 0x1
}
func (o *FTM_Type) SetC4SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC4SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC4SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC4SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC4SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC4SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC4SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC4SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC4SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC4SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC4SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC4SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x80) >> 7
}

// FTM.C4V: Channel (n) Value
func (o *FTM_Type) SetC4V_VAL(value uint32) {
	volatile.StoreUint32(&o.C4V.Reg, volatile.LoadUint32(&o.C4V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC4V_VAL() uint32 {
	return volatile.LoadUint32(&o.C4V.Reg) & 0xffff
}

// FTM.C5SC: Channel (n) Status And Control
func (o *FTM_Type) SetC5SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC5SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C5SC.Reg) & 0x1
}
func (o *FTM_Type) SetC5SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC5SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC5SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC5SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC5SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC5SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC5SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC5SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC5SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC5SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC5SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC5SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x80) >> 7
}

// FTM.C5V: Channel (n) Value
func (o *FTM_Type) SetC5V_VAL(value uint32) {
	volatile.StoreUint32(&o.C5V.Reg, volatile.LoadUint32(&o.C5V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC5V_VAL() uint32 {
	return volatile.LoadUint32(&o.C5V.Reg) & 0xffff
}

// FTM.C6SC: Channel (n) Status And Control
func (o *FTM_Type) SetC6SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC6SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C6SC.Reg) & 0x1
}
func (o *FTM_Type) SetC6SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC6SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC6SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC6SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC6SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC6SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC6SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC6SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC6SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC6SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC6SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C6SC.Reg, volatile.LoadUint32(&o.C6SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC6SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C6SC.Reg) & 0x80) >> 7
}

// FTM.C6V: Channel (n) Value
func (o *FTM_Type) SetC6V_VAL(value uint32) {
	volatile.StoreUint32(&o.C6V.Reg, volatile.LoadUint32(&o.C6V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC6V_VAL() uint32 {
	return volatile.LoadUint32(&o.C6V.Reg) & 0xffff
}

// FTM.C7SC: Channel (n) Status And Control
func (o *FTM_Type) SetC7SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetC7SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C7SC.Reg) & 0x1
}
func (o *FTM_Type) SetC7SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetC7SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetC7SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetC7SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetC7SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetC7SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetC7SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetC7SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetC7SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetC7SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetC7SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C7SC.Reg, volatile.LoadUint32(&o.C7SC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetC7SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C7SC.Reg) & 0x80) >> 7
}

// FTM.C7V: Channel (n) Value
func (o *FTM_Type) SetC7V_VAL(value uint32) {
	volatile.StoreUint32(&o.C7V.Reg, volatile.LoadUint32(&o.C7V.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetC7V_VAL() uint32 {
	return volatile.LoadUint32(&o.C7V.Reg) & 0xffff
}

// FTM.CNTIN: Counter Initial Value
func (o *FTM_Type) SetCNTIN_INIT(value uint32) {
	volatile.StoreUint32(&o.CNTIN.Reg, volatile.LoadUint32(&o.CNTIN.Reg)&^(0xffff)|value)
}
func (o *FTM_Type) GetCNTIN_INIT() uint32 {
	return volatile.LoadUint32(&o.CNTIN.Reg) & 0xffff
}

// FTM.STATUS: Capture And Compare Status
func (o *FTM_Type) SetSTATUS_CH0F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSTATUS_CH0F() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *FTM_Type) SetSTATUS_CH1F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSTATUS_CH1F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSTATUS_CH2F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSTATUS_CH2F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSTATUS_CH3F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSTATUS_CH3F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSTATUS_CH4F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSTATUS_CH4F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSTATUS_CH5F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSTATUS_CH5F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSTATUS_CH6F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSTATUS_CH6F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSTATUS_CH7F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSTATUS_CH7F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}

// FTM.MODE: Features Mode Selection
func (o *FTM_Type) SetMODE_FTMEN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetMODE_FTMEN() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *FTM_Type) SetMODE_INIT(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetMODE_INIT() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetMODE_WPDIS(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetMODE_WPDIS() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetMODE_PWMSYNC(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetMODE_PWMSYNC() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetMODE_CAPTEST(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetMODE_CAPTEST() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetMODE_FAULTM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x60)|value<<5)
}
func (o *FTM_Type) GetMODE_FAULTM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x60) >> 5
}
func (o *FTM_Type) SetMODE_FAULTIE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetMODE_FAULTIE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x80) >> 7
}

// FTM.SYNC: Synchronization
func (o *FTM_Type) SetSYNC_CNTMIN(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSYNC_CNTMIN() uint32 {
	return volatile.LoadUint32(&o.SYNC.Reg) & 0x1
}
func (o *FTM_Type) SetSYNC_CNTMAX(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSYNC_CNTMAX() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSYNC_REINIT(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSYNC_REINIT() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSYNC_SYNCHOM(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSYNC_SYNCHOM() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSYNC_TRIG0(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSYNC_TRIG0() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSYNC_TRIG1(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSYNC_TRIG1() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSYNC_TRIG2(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSYNC_TRIG2() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSYNC_SWSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSYNC_SWSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x80) >> 7
}

// FTM.OUTINIT: Initial State For Channels Output
func (o *FTM_Type) SetOUTINIT_CH0OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetOUTINIT_CH0OI() uint32 {
	return volatile.LoadUint32(&o.OUTINIT.Reg) & 0x1
}
func (o *FTM_Type) SetOUTINIT_CH1OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetOUTINIT_CH1OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetOUTINIT_CH2OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetOUTINIT_CH2OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetOUTINIT_CH3OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetOUTINIT_CH3OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetOUTINIT_CH4OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetOUTINIT_CH4OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetOUTINIT_CH5OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetOUTINIT_CH5OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetOUTINIT_CH6OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetOUTINIT_CH6OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetOUTINIT_CH7OI(value uint32) {
	volatile.StoreUint32(&o.OUTINIT.Reg, volatile.LoadUint32(&o.OUTINIT.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetOUTINIT_CH7OI() uint32 {
	return (volatile.LoadUint32(&o.OUTINIT.Reg) & 0x80) >> 7
}

// FTM.OUTMASK: Output Mask
func (o *FTM_Type) SetOUTMASK_CH0OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetOUTMASK_CH0OM() uint32 {
	return volatile.LoadUint32(&o.OUTMASK.Reg) & 0x1
}
func (o *FTM_Type) SetOUTMASK_CH1OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetOUTMASK_CH1OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetOUTMASK_CH2OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetOUTMASK_CH2OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetOUTMASK_CH3OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetOUTMASK_CH3OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetOUTMASK_CH4OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetOUTMASK_CH4OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetOUTMASK_CH5OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetOUTMASK_CH5OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetOUTMASK_CH6OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetOUTMASK_CH6OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetOUTMASK_CH7OM(value uint32) {
	volatile.StoreUint32(&o.OUTMASK.Reg, volatile.LoadUint32(&o.OUTMASK.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetOUTMASK_CH7OM() uint32 {
	return (volatile.LoadUint32(&o.OUTMASK.Reg) & 0x80) >> 7
}

// FTM.COMBINE: Function For Linked Channels
func (o *FTM_Type) SetCOMBINE_COMBINE0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetCOMBINE_COMBINE0() uint32 {
	return volatile.LoadUint32(&o.COMBINE.Reg) & 0x1
}
func (o *FTM_Type) SetCOMBINE_COMP0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetCOMBINE_COMP0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetCOMBINE_DECAPEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetCOMBINE_DECAP0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetCOMBINE_DECAP0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetCOMBINE_DTEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetCOMBINE_DTEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetCOMBINE_SYNCEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetCOMBINE_FAULTEN0(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN0() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetCOMBINE_COMBINE1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetCOMBINE_COMBINE1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetCOMBINE_COMP1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetCOMBINE_COMP1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetCOMBINE_DECAPEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetCOMBINE_DECAP1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetCOMBINE_DECAP1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetCOMBINE_DTEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetCOMBINE_DTEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetCOMBINE_SYNCEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2000)|value<<13)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2000) >> 13
}
func (o *FTM_Type) SetCOMBINE_FAULTEN1(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4000)|value<<14)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN1() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4000) >> 14
}
func (o *FTM_Type) SetCOMBINE_COMBINE2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10000)|value<<16)
}
func (o *FTM_Type) GetCOMBINE_COMBINE2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10000) >> 16
}
func (o *FTM_Type) SetCOMBINE_COMP2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20000)|value<<17)
}
func (o *FTM_Type) GetCOMBINE_COMP2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20000) >> 17
}
func (o *FTM_Type) SetCOMBINE_DECAPEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40000)|value<<18)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40000) >> 18
}
func (o *FTM_Type) SetCOMBINE_DECAP2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x80000)|value<<19)
}
func (o *FTM_Type) GetCOMBINE_DECAP2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x80000) >> 19
}
func (o *FTM_Type) SetCOMBINE_DTEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x100000)|value<<20)
}
func (o *FTM_Type) GetCOMBINE_DTEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x100000) >> 20
}
func (o *FTM_Type) SetCOMBINE_SYNCEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x200000)|value<<21)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x200000) >> 21
}
func (o *FTM_Type) SetCOMBINE_FAULTEN2(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x400000)|value<<22)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN2() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x400000) >> 22
}
func (o *FTM_Type) SetCOMBINE_COMBINE3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x1000000)|value<<24)
}
func (o *FTM_Type) GetCOMBINE_COMBINE3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x1000000) >> 24
}
func (o *FTM_Type) SetCOMBINE_COMP3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x2000000)|value<<25)
}
func (o *FTM_Type) GetCOMBINE_COMP3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x2000000) >> 25
}
func (o *FTM_Type) SetCOMBINE_DECAPEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x4000000)|value<<26)
}
func (o *FTM_Type) GetCOMBINE_DECAPEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x4000000) >> 26
}
func (o *FTM_Type) SetCOMBINE_DECAP3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x8000000)|value<<27)
}
func (o *FTM_Type) GetCOMBINE_DECAP3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x8000000) >> 27
}
func (o *FTM_Type) SetCOMBINE_DTEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x10000000)|value<<28)
}
func (o *FTM_Type) GetCOMBINE_DTEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x10000000) >> 28
}
func (o *FTM_Type) SetCOMBINE_SYNCEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x20000000)|value<<29)
}
func (o *FTM_Type) GetCOMBINE_SYNCEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x20000000) >> 29
}
func (o *FTM_Type) SetCOMBINE_FAULTEN3(value uint32) {
	volatile.StoreUint32(&o.COMBINE.Reg, volatile.LoadUint32(&o.COMBINE.Reg)&^(0x40000000)|value<<30)
}
func (o *FTM_Type) GetCOMBINE_FAULTEN3() uint32 {
	return (volatile.LoadUint32(&o.COMBINE.Reg) & 0x40000000) >> 30
}

// FTM.DEADTIME: Deadtime Insertion Control
func (o *FTM_Type) SetDEADTIME_DTVAL(value uint32) {
	volatile.StoreUint32(&o.DEADTIME.Reg, volatile.LoadUint32(&o.DEADTIME.Reg)&^(0x3f)|value)
}
func (o *FTM_Type) GetDEADTIME_DTVAL() uint32 {
	return volatile.LoadUint32(&o.DEADTIME.Reg) & 0x3f
}
func (o *FTM_Type) SetDEADTIME_DTPS(value uint32) {
	volatile.StoreUint32(&o.DEADTIME.Reg, volatile.LoadUint32(&o.DEADTIME.Reg)&^(0xc0)|value<<6)
}
func (o *FTM_Type) GetDEADTIME_DTPS() uint32 {
	return (volatile.LoadUint32(&o.DEADTIME.Reg) & 0xc0) >> 6
}

// FTM.EXTTRIG: FTM External Trigger
func (o *FTM_Type) SetEXTTRIG_CH2TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetEXTTRIG_CH2TRIG() uint32 {
	return volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x1
}
func (o *FTM_Type) SetEXTTRIG_CH3TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetEXTTRIG_CH3TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetEXTTRIG_CH4TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetEXTTRIG_CH4TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetEXTTRIG_CH5TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetEXTTRIG_CH5TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetEXTTRIG_CH0TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetEXTTRIG_CH0TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetEXTTRIG_CH1TRIG(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetEXTTRIG_CH1TRIG() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetEXTTRIG_INITTRIGEN(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetEXTTRIG_INITTRIGEN() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetEXTTRIG_TRIGF(value uint32) {
	volatile.StoreUint32(&o.EXTTRIG.Reg, volatile.LoadUint32(&o.EXTTRIG.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetEXTTRIG_TRIGF() uint32 {
	return (volatile.LoadUint32(&o.EXTTRIG.Reg) & 0x80) >> 7
}

// FTM.POL: Channels Polarity
func (o *FTM_Type) SetPOL_POL0(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetPOL_POL0() uint32 {
	return volatile.LoadUint32(&o.POL.Reg) & 0x1
}
func (o *FTM_Type) SetPOL_POL1(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetPOL_POL1() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetPOL_POL2(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetPOL_POL2() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetPOL_POL3(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetPOL_POL3() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetPOL_POL4(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetPOL_POL4() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetPOL_POL5(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetPOL_POL5() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetPOL_POL6(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetPOL_POL6() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetPOL_POL7(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetPOL_POL7() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x80) >> 7
}

// FTM.FMS: Fault Mode Status
func (o *FTM_Type) SetFMS_FAULTF0(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFMS_FAULTF0() uint32 {
	return volatile.LoadUint32(&o.FMS.Reg) & 0x1
}
func (o *FTM_Type) SetFMS_FAULTF1(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFMS_FAULTF1() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFMS_FAULTF2(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFMS_FAULTF2() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFMS_FAULTF3(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFMS_FAULTF3() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetFMS_FAULTIN(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetFMS_FAULTIN() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetFMS_WPEN(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetFMS_WPEN() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetFMS_FAULTF(value uint32) {
	volatile.StoreUint32(&o.FMS.Reg, volatile.LoadUint32(&o.FMS.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetFMS_FAULTF() uint32 {
	return (volatile.LoadUint32(&o.FMS.Reg) & 0x80) >> 7
}

// FTM.FILTER: Input Capture Filter Control
func (o *FTM_Type) SetFILTER_CH0FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf)|value)
}
func (o *FTM_Type) GetFILTER_CH0FVAL() uint32 {
	return volatile.LoadUint32(&o.FILTER.Reg) & 0xf
}
func (o *FTM_Type) SetFILTER_CH1FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf0)|value<<4)
}
func (o *FTM_Type) GetFILTER_CH1FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf0) >> 4
}
func (o *FTM_Type) SetFILTER_CH2FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf00)|value<<8)
}
func (o *FTM_Type) GetFILTER_CH2FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf00) >> 8
}
func (o *FTM_Type) SetFILTER_CH3FVAL(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, volatile.LoadUint32(&o.FILTER.Reg)&^(0xf000)|value<<12)
}
func (o *FTM_Type) GetFILTER_CH3FVAL() uint32 {
	return (volatile.LoadUint32(&o.FILTER.Reg) & 0xf000) >> 12
}

// FTM.FLTCTRL: Fault Control
func (o *FTM_Type) SetFLTCTRL_FAULT0EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFLTCTRL_FAULT0EN() uint32 {
	return volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetFLTCTRL_FAULT1EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFLTCTRL_FAULT1EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFLTCTRL_FAULT2EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFLTCTRL_FAULT2EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFLTCTRL_FAULT3EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFLTCTRL_FAULT3EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetFLTCTRL_FFLTR0EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR0EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetFLTCTRL_FFLTR1EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR1EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetFLTCTRL_FFLTR2EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR2EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetFLTCTRL_FFLTR3EN(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetFLTCTRL_FFLTR3EN() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetFLTCTRL_FFVAL(value uint32) {
	volatile.StoreUint32(&o.FLTCTRL.Reg, volatile.LoadUint32(&o.FLTCTRL.Reg)&^(0xf00)|value<<8)
}
func (o *FTM_Type) GetFLTCTRL_FFVAL() uint32 {
	return (volatile.LoadUint32(&o.FLTCTRL.Reg) & 0xf00) >> 8
}

// FTM.QDCTRL: Quadrature Decoder Control And Status
func (o *FTM_Type) SetQDCTRL_QUADEN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetQDCTRL_QUADEN() uint32 {
	return volatile.LoadUint32(&o.QDCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetQDCTRL_TOFDIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetQDCTRL_TOFDIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetQDCTRL_QUADIR(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetQDCTRL_QUADIR() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetQDCTRL_QUADMODE(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetQDCTRL_QUADMODE() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetQDCTRL_PHBPOL(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetQDCTRL_PHBPOL() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetQDCTRL_PHAPOL(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetQDCTRL_PHAPOL() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetQDCTRL_PHBFLTREN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetQDCTRL_PHBFLTREN() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetQDCTRL_PHAFLTREN(value uint32) {
	volatile.StoreUint32(&o.QDCTRL.Reg, volatile.LoadUint32(&o.QDCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetQDCTRL_PHAFLTREN() uint32 {
	return (volatile.LoadUint32(&o.QDCTRL.Reg) & 0x80) >> 7
}

// FTM.CONF: Configuration
func (o *FTM_Type) SetCONF_NUMTOF(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1f)|value)
}
func (o *FTM_Type) GetCONF_NUMTOF() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1f
}
func (o *FTM_Type) SetCONF_BDMMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xc0)|value<<6)
}
func (o *FTM_Type) GetCONF_BDMMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xc0) >> 6
}
func (o *FTM_Type) SetCONF_GTBEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetCONF_GTBEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetCONF_GTBEOUT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetCONF_GTBEOUT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400) >> 10
}

// FTM.FLTPOL: FTM Fault Input Polarity
func (o *FTM_Type) SetFLTPOL_FLT0POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetFLTPOL_FLT0POL() uint32 {
	return volatile.LoadUint32(&o.FLTPOL.Reg) & 0x1
}
func (o *FTM_Type) SetFLTPOL_FLT1POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetFLTPOL_FLT1POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetFLTPOL_FLT2POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetFLTPOL_FLT2POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetFLTPOL_FLT3POL(value uint32) {
	volatile.StoreUint32(&o.FLTPOL.Reg, volatile.LoadUint32(&o.FLTPOL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetFLTPOL_FLT3POL() uint32 {
	return (volatile.LoadUint32(&o.FLTPOL.Reg) & 0x8) >> 3
}

// FTM.SYNCONF: Synchronization Configuration
func (o *FTM_Type) SetSYNCONF_HWTRIGMODE(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSYNCONF_HWTRIGMODE() uint32 {
	return volatile.LoadUint32(&o.SYNCONF.Reg) & 0x1
}
func (o *FTM_Type) SetSYNCONF_CNTINC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSYNCONF_CNTINC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSYNCONF_INVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSYNCONF_INVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSYNCONF_SWOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSYNCONF_SWOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSYNCONF_SYNCMODE(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSYNCONF_SYNCMODE() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetSYNCONF_SWRSTCNT(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetSYNCONF_SWRSTCNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetSYNCONF_SWWRBUF(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetSYNCONF_SWWRBUF() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetSYNCONF_SWOM(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetSYNCONF_SWOM() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetSYNCONF_SWINVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetSYNCONF_SWINVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetSYNCONF_SWSOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetSYNCONF_SWSOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetSYNCONF_HWRSTCNT(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x10000)|value<<16)
}
func (o *FTM_Type) GetSYNCONF_HWRSTCNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x10000) >> 16
}
func (o *FTM_Type) SetSYNCONF_HWWRBUF(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x20000)|value<<17)
}
func (o *FTM_Type) GetSYNCONF_HWWRBUF() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x20000) >> 17
}
func (o *FTM_Type) SetSYNCONF_HWOM(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x40000)|value<<18)
}
func (o *FTM_Type) GetSYNCONF_HWOM() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x40000) >> 18
}
func (o *FTM_Type) SetSYNCONF_HWINVC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x80000)|value<<19)
}
func (o *FTM_Type) GetSYNCONF_HWINVC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x80000) >> 19
}
func (o *FTM_Type) SetSYNCONF_HWSOC(value uint32) {
	volatile.StoreUint32(&o.SYNCONF.Reg, volatile.LoadUint32(&o.SYNCONF.Reg)&^(0x100000)|value<<20)
}
func (o *FTM_Type) GetSYNCONF_HWSOC() uint32 {
	return (volatile.LoadUint32(&o.SYNCONF.Reg) & 0x100000) >> 20
}

// FTM.INVCTRL: FTM Inverting Control
func (o *FTM_Type) SetINVCTRL_INV0EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetINVCTRL_INV0EN() uint32 {
	return volatile.LoadUint32(&o.INVCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetINVCTRL_INV1EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetINVCTRL_INV1EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetINVCTRL_INV2EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetINVCTRL_INV2EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetINVCTRL_INV3EN(value uint32) {
	volatile.StoreUint32(&o.INVCTRL.Reg, volatile.LoadUint32(&o.INVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetINVCTRL_INV3EN() uint32 {
	return (volatile.LoadUint32(&o.INVCTRL.Reg) & 0x8) >> 3
}

// FTM.SWOCTRL: FTM Software Output Control
func (o *FTM_Type) SetSWOCTRL_CH0OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetSWOCTRL_CH0OC() uint32 {
	return volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x1
}
func (o *FTM_Type) SetSWOCTRL_CH1OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetSWOCTRL_CH1OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetSWOCTRL_CH2OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetSWOCTRL_CH2OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetSWOCTRL_CH3OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetSWOCTRL_CH3OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetSWOCTRL_CH4OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetSWOCTRL_CH4OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetSWOCTRL_CH5OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetSWOCTRL_CH5OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetSWOCTRL_CH6OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetSWOCTRL_CH6OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetSWOCTRL_CH7OC(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetSWOCTRL_CH7OC() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetSWOCTRL_CH0OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x100)|value<<8)
}
func (o *FTM_Type) GetSWOCTRL_CH0OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x100) >> 8
}
func (o *FTM_Type) SetSWOCTRL_CH1OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetSWOCTRL_CH1OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x200) >> 9
}
func (o *FTM_Type) SetSWOCTRL_CH2OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x400)|value<<10)
}
func (o *FTM_Type) GetSWOCTRL_CH2OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x400) >> 10
}
func (o *FTM_Type) SetSWOCTRL_CH3OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x800)|value<<11)
}
func (o *FTM_Type) GetSWOCTRL_CH3OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x800) >> 11
}
func (o *FTM_Type) SetSWOCTRL_CH4OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *FTM_Type) GetSWOCTRL_CH4OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x1000) >> 12
}
func (o *FTM_Type) SetSWOCTRL_CH5OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *FTM_Type) GetSWOCTRL_CH5OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x2000) >> 13
}
func (o *FTM_Type) SetSWOCTRL_CH6OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *FTM_Type) GetSWOCTRL_CH6OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x4000) >> 14
}
func (o *FTM_Type) SetSWOCTRL_CH7OCV(value uint32) {
	volatile.StoreUint32(&o.SWOCTRL.Reg, volatile.LoadUint32(&o.SWOCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *FTM_Type) GetSWOCTRL_CH7OCV() uint32 {
	return (volatile.LoadUint32(&o.SWOCTRL.Reg) & 0x8000) >> 15
}

// FTM.PWMLOAD: FTM PWM Load
func (o *FTM_Type) SetPWMLOAD_CH0SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x1)|value)
}
func (o *FTM_Type) GetPWMLOAD_CH0SEL() uint32 {
	return volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x1
}
func (o *FTM_Type) SetPWMLOAD_CH1SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x2)|value<<1)
}
func (o *FTM_Type) GetPWMLOAD_CH1SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x2) >> 1
}
func (o *FTM_Type) SetPWMLOAD_CH2SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x4)|value<<2)
}
func (o *FTM_Type) GetPWMLOAD_CH2SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x4) >> 2
}
func (o *FTM_Type) SetPWMLOAD_CH3SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x8)|value<<3)
}
func (o *FTM_Type) GetPWMLOAD_CH3SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x8) >> 3
}
func (o *FTM_Type) SetPWMLOAD_CH4SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x10)|value<<4)
}
func (o *FTM_Type) GetPWMLOAD_CH4SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x10) >> 4
}
func (o *FTM_Type) SetPWMLOAD_CH5SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x20)|value<<5)
}
func (o *FTM_Type) GetPWMLOAD_CH5SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x20) >> 5
}
func (o *FTM_Type) SetPWMLOAD_CH6SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x40)|value<<6)
}
func (o *FTM_Type) GetPWMLOAD_CH6SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x40) >> 6
}
func (o *FTM_Type) SetPWMLOAD_CH7SEL(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x80)|value<<7)
}
func (o *FTM_Type) GetPWMLOAD_CH7SEL() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x80) >> 7
}
func (o *FTM_Type) SetPWMLOAD_LDOK(value uint32) {
	volatile.StoreUint32(&o.PWMLOAD.Reg, volatile.LoadUint32(&o.PWMLOAD.Reg)&^(0x200)|value<<9)
}
func (o *FTM_Type) GetPWMLOAD_LDOK() uint32 {
	return (volatile.LoadUint32(&o.PWMLOAD.Reg) & 0x200) >> 9
}

// Analog-to-Digital Converter
type ADC_Type struct {
	SC1A volatile.Register32 // 0x0
	SC1B volatile.Register32 // 0x4
	CFG1 volatile.Register32 // 0x8
	CFG2 volatile.Register32 // 0xC
	RA   volatile.Register32 // 0x10
	RB   volatile.Register32 // 0x14
	CV1  volatile.Register32 // 0x18
	CV2  volatile.Register32 // 0x1C
	SC2  volatile.Register32 // 0x20
	SC3  volatile.Register32 // 0x24
	OFS  volatile.Register32 // 0x28
	PG   volatile.Register32 // 0x2C
	MG   volatile.Register32 // 0x30
	CLPD volatile.Register32 // 0x34
	CLPS volatile.Register32 // 0x38
	CLP4 volatile.Register32 // 0x3C
	CLP3 volatile.Register32 // 0x40
	CLP2 volatile.Register32 // 0x44
	CLP1 volatile.Register32 // 0x48
	CLP0 volatile.Register32 // 0x4C
	_    [4]byte
	CLMD volatile.Register32 // 0x54
	CLMS volatile.Register32 // 0x58
	CLM4 volatile.Register32 // 0x5C
	CLM3 volatile.Register32 // 0x60
	CLM2 volatile.Register32 // 0x64
	CLM1 volatile.Register32 // 0x68
	CLM0 volatile.Register32 // 0x6C
}

// ADC.SC1A: ADC Status and Control Registers 1
func (o *ADC_Type) SetSC1A_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSC1A_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1A.Reg) & 0x1f
}
func (o *ADC_Type) SetSC1A_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSC1A_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSC1A_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC1A_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC1A_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC1A_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x80) >> 7
}

// ADC.SC1B: ADC Status and Control Registers 1
func (o *ADC_Type) SetSC1B_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSC1B_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1B.Reg) & 0x1f
}
func (o *ADC_Type) SetSC1B_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSC1B_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSC1B_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSC1B_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSC1B_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSC1B_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x80) >> 7
}

// ADC.CFG1: ADC Configuration Register 1
func (o *ADC_Type) SetCFG1_ADICLK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFG1_ADICLK() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x3
}
func (o *ADC_Type) SetCFG1_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCFG1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCFG1_ADLSMP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCFG1_ADLSMP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCFG1_ADIV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x60)|value<<5)
}
func (o *ADC_Type) GetCFG1_ADIV() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x60) >> 5
}
func (o *ADC_Type) SetCFG1_ADLPC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCFG1_ADLPC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}

// ADC.CFG2: ADC Configuration Register 2
func (o *ADC_Type) SetCFG2_ADLSTS(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetCFG2_ADLSTS() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x3
}
func (o *ADC_Type) SetCFG2_ADHSC(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCFG2_ADHSC() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCFG2_ADACKEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCFG2_ADACKEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCFG2_MUXSEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCFG2_MUXSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}

// ADC.RA: ADC Data Result Register
func (o *ADC_Type) SetRA_D(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRA_D() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0xffff
}

// ADC.RB: ADC Data Result Register
func (o *ADC_Type) SetRB_D(value uint32) {
	volatile.StoreUint32(&o.RB.Reg, volatile.LoadUint32(&o.RB.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRB_D() uint32 {
	return volatile.LoadUint32(&o.RB.Reg) & 0xffff
}

// ADC.CV1: Compare Value Registers
func (o *ADC_Type) SetCV1_CV(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, volatile.LoadUint32(&o.CV1.Reg)&^(0xffff)|value)
}
f