"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerXXS = exports.ContainerXS = exports.ContainerSM = exports.ContainerMD = exports.ContainerLG = exports.Container = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const sizes_1 = require("./sizes");
const mediaQueries_1 = require("../mediaQueries");
const LEVEL = {
    lg: sizes_1.WIDTH.DESKTOP_MAX,
    md: sizes_1.WIDTH.TABLET_MAX,
    sm: sizes_1.WIDTH.TABLET_MIN,
    xs: sizes_1.WIDTH.MOBILE,
    xxs: sizes_1.WIDTH.TINY,
};
const containerStyle = ({ centerText = false, level = undefined, verticalCenter = false, }) => ({
    margin: verticalCenter ? 'auto' : '0 auto',
    maxWidth: level ? `${LEVEL[level]}px` : undefined,
    position: 'relative',
    textAlign: centerText ? 'center' : 'left',
    width: '100%',
    [mediaQueries_1.media[mediaQueries_1.QueryKeys.DESKTOP]]: level
        ? undefined
        : {
            padding: 0,
            width: `${sizes_1.WIDTH.DESKTOP_MIN - sizes_1.GUTTER * 2}px`,
        },
});
exports.Container = (0, react_1.forwardRef)((_a, ref) => {
    var { centerText, level, verticalCenter } = _a, props = __rest(_a, ["centerText", "level", "verticalCenter"]);
    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ ref: ref, css: containerStyle({ centerText, level, verticalCenter }) }, props)));
});
exports.Container.displayName = 'Container';
exports.ContainerLG = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Container, Object.assign({ ref: ref, level: 'lg' }, props))));
exports.ContainerLG.displayName = 'ContainerLG';
exports.ContainerMD = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Container, Object.assign({ ref: ref, level: 'md' }, props))));
exports.ContainerMD.displayName = 'ContainerMD';
exports.ContainerSM = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Container, Object.assign({ ref: ref, level: 'sm' }, props))));
exports.ContainerSM.displayName = 'ContainerSM';
exports.ContainerXS = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Container, Object.assign({ ref: ref, level: 'xs' }, props))));
exports.ContainerXS.displayName = 'ContainerXS';
exports.ContainerXXS = (0, react_1.forwardRef)((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Container, Object.assign({ ref: ref, level: 'xxs' }, props))));
exports.ContainerXXS.displayName = 'ContainerXXS';
