"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pagination = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity");
const Layout_1 = require("../Layout");
const Text_1 = require("../Text");
const Pagination = (_a) => {
    var { currentPage = 0, numberOfPages = 1, goPage, previousPageComponent: PreviousPageComponent = () => '<', nextPageComponent: NextPageComponent = () => '>' } = _a, props = __rest(_a, ["currentPage", "numberOfPages", "goPage", "previousPageComponent", "nextPageComponent"]);
    const isLastPage = currentPage === numberOfPages - 1;
    const isFirstPage = currentPage === 0;
    const renderPageList = () => {
        const lastPageIndex = numberOfPages - 1;
        const spanLength = 1;
        const endLength = 1;
        const skipLength = 1;
        const normalizeCount = endLength + skipLength + spanLength;
        const dots = (key) => ((0, jsx_runtime_1.jsx)(Text_1.Bold, Object.assign({ fontSize: '11px' }, { children: '…' }), key));
        const renderPageNumber = pageIndex => currentPage === pageIndex ? ((0, jsx_runtime_1.jsx)(Text_1.Bold, Object.assign({ fontSize: '11px', style: { color: Identity_1.COLOR.BLUE, margin: '0 8px' }, "data-uie-name": "status-active-page" }, { children: pageIndex + 1 }), pageIndex)) : ((0, jsx_runtime_1.jsx)(Text_1.Link, Object.assign({ style: { margin: '0 8px' }, onClick: () => goPage(pageIndex), "data-uie-name": "go-page" }, { children: pageIndex + 1 }), pageIndex));
        const normalizedCurrent = Math.min(Math.max(currentPage, normalizeCount), lastPageIndex - normalizeCount);
        const beforeCount = normalizedCurrent - spanLength - endLength;
        const afterCount = lastPageIndex - endLength - normalizedCurrent - spanLength;
        const pages = Array.from(Array(numberOfPages), (_, index) => renderPageNumber(index));
        if (afterCount > skipLength) {
            pages.splice(normalizedCurrent + spanLength + 1, afterCount, dots('dots-end'));
        }
        if (beforeCount > skipLength) {
            pages.splice(endLength, beforeCount, dots('dots-start'));
        }
        return pages;
    };
    return ((0, jsx_runtime_1.jsxs)(Layout_1.FlexBox, Object.assign({ align: "flex-end", "data-uie-name": "element-pagination" }, props, { children: [(0, jsx_runtime_1.jsx)("div", Object.assign({ css: { flexBasis: 100 } }, { children: !isFirstPage && ((0, jsx_runtime_1.jsx)(Text_1.Link, Object.assign({ block: true, onClick: () => goPage(currentPage - 1), "data-uie-name": "go-previous-page" }, { children: (0, jsx_runtime_1.jsx)(PreviousPageComponent, {}) }))) })), (0, jsx_runtime_1.jsx)("div", Object.assign({ css: { alignItems: 'flex-end', display: 'flex', flexDirection: 'row', margin: '0 auto' }, "data-uie-name": "list-pages" }, { children: renderPageList() })), (0, jsx_runtime_1.jsx)("div", Object.assign({ css: { display: 'flex', flexBasis: 100, justifyContent: 'flex-end' } }, { children: !isLastPage && ((0, jsx_runtime_1.jsx)(Text_1.Link, Object.assign({ block: true, onClick: () => goPage(currentPage + 1), "data-uie-name": "go-next-page" }, { children: (0, jsx_runtime_1.jsx)(NextPageComponent, {}) }))) }))] })));
};
exports.Pagination = Pagination;
