"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LabelLink = exports.Label = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Link_1 = require("./Link");
const Text_1 = require("./Text");
const Identity_1 = require("../Identity");
const labelStyle = (theme, _a) => {
    var { markInvalid, bold = false, color = theme.general.color, fontSize = theme.fontSizes.small } = _a, props = __rest(_a, ["markInvalid", "bold", "color", "fontSize"]);
    return (Object.assign(Object.assign({}, (0, Text_1.textStyle)(theme, Object.assign({ bold, color, fontSize }, props))), { '&:focus-within': {
            color: Identity_1.COLOR.BLUE,
        }, color: markInvalid ? Identity_1.COLOR.RED : 'initial', width: '100%' }));
};
const Label = (props) => ((0, jsx_runtime_1.jsx)("label", Object.assign({ css: (theme) => labelStyle(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.Label = Label;
const labelLinkStyle = (theme, _a) => {
    var { fontSize = theme.fontSizes.small } = _a, props = __rest(_a, ["fontSize"]);
    return (Object.assign({}, (0, Link_1.linkStyle)(theme, Object.assign({ fontSize }, props))));
};
const LabelLink = (props) => ((0, jsx_runtime_1.jsx)("a", Object.assign({ css: (theme) => labelLinkStyle(theme, props) }, (0, Text_1.filterTextProps)(props))));
exports.LabelLink = LabelLink;
