"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Large = exports.Uppercase = exports.Muted = exports.Small = exports.Bold = exports.Text = exports.textStyle = exports.filterTextProps = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const React = __importStar(require("react"));
const Identity_1 = require("../Identity");
const util_1 = require("../util");
const filterTextProps = (props) => {
    return (0, util_1.filterProps)(props, [
        'block',
        'bold',
        'center',
        'color',
        'fontSize',
        'light',
        'muted',
        'noWrap',
        'textTransform',
        'truncate',
    ]);
};
exports.filterTextProps = filterTextProps;
const textStyle = (theme, { block = false, bold = false, center = false, color = theme.general.color, fontSize = theme.fontSizes.base, light = false, muted = false, noWrap = false, textTransform = 'none', truncate = false, }) => ({
    color: muted ? Identity_1.COLOR.GRAY : color,
    display: block ? 'block' : 'inline',
    fontSize: fontSize,
    fontWeight: bold ? 600 : light ? 200 : 400,
    overflow: truncate ? 'hidden' : undefined,
    textAlign: center ? 'center' : 'left',
    textOverflow: truncate ? 'ellipsis' : undefined,
    textTransform: textTransform,
    whiteSpace: noWrap ? 'nowrap' : undefined,
});
exports.textStyle = textStyle;
exports.Text = React.forwardRef((props, ref) => ((0, jsx_runtime_1.jsx)("span", Object.assign({ ref: ref, css: (theme) => (0, exports.textStyle)(theme, props) }, (0, exports.filterTextProps)(props)))));
exports.Text.displayName = 'Text';
exports.Bold = React.forwardRef((props, ref) => ((0, jsx_runtime_1.jsx)(exports.Text, Object.assign({ ref: ref, bold: true }, props))));
exports.Bold.displayName = 'Bold';
exports.Small = React.forwardRef((props, ref) => (0, jsx_runtime_1.jsx)(exports.Text, Object.assign({ ref: ref, fontSize: '12px' }, props)));
exports.Small.displayName = 'Small';
exports.Muted = React.forwardRef((props, ref) => (0, jsx_runtime_1.jsx)(exports.Text, Object.assign({ ref: ref, muted: true }, props)));
exports.Muted.displayName = 'Muted';
exports.Uppercase = React.forwardRef((props, ref) => (0, jsx_runtime_1.jsx)(exports.Text, Object.assign({ ref: ref, textTransform: 'uppercase' }, props)));
exports.Uppercase.displayName = 'Uppercase';
exports.Large = React.forwardRef((props, ref) => (0, jsx_runtime_1.jsx)(exports.Text, Object.assign({ ref: ref, fontSize: '48px', light: true }, props)));
exports.Large.displayName = 'Large';
