/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ScoutingMissionTest
extends FreeColTestCase {
    private static final Role scoutRole = ScoutingMissionTest.spec().getRole("model.role.scout");
    private static final UnitType scoutType = ScoutingMissionTest.spec().getUnitType("model.unit.seasonedScout");
    private static final LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testHorsesLost() {
        ServerGame game = ServerTestHelper.startServerGame(ScoutingMissionTest.getTestMap(true));
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        dutch.exploreMap(true);
        Tile settlementTile = map.getTile(2, 1);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.player(inca).settlementTile(settlementTile).build();
        IndianSettlement is = settlementTile.getIndianSettlement();
        Player.makeContact(inca, dutch);
        Tile unitTile = map.getTile(2, 2);
        ServerUnit scout = new ServerUnit(game, unitTile, dutch, scoutType, scoutRole);
        ScoutingMissionTest.assertEquals((Object)scoutRole, (Object)scout.getRole());
        AIUnit aiUnit = aiMain.getAIUnit(scout);
        aiUnit.changeMission(null);
        ScoutingMissionTest.assertNotNull((String)"The scout should be an AI unit", (Object)aiUnit);
        ScoutingMissionTest.assertEquals((String)"Scout should have the scout role", (Object)scoutRole, (Object)scout.getRole());
        ScoutingMissionTest.assertTrue((String)"Scout should be able to speak to chief", (boolean)scout.hasAbility("model.ability.speakWithChief"));
        ScoutingMissionTest.assertEquals((String)"The Inca settlement should be a scouting target", null, (String)ScoutingMission.invalidMissionReason(aiUnit, is));
        ScoutingMissionTest.assertEquals((String)"The Inca settlement should be found as scouting target", (Object)is, (Object)ScoutingMission.findMissionTarget(aiUnit, 10, false));
        ScoutingMissionTest.assertEquals((String)"Scouting mission should be assignable to scout", null, (String)ScoutingMission.invalidMissionReason(aiUnit));
        ScoutingMission mission = new ScoutingMission(aiMain, aiUnit, is);
        ScoutingMissionTest.assertEquals((String)"Scout should have been assigned the Scouting mission", (Object)mission, (Object)aiUnit.getMission());
        ScoutingMissionTest.assertEquals(null, (String)mission.invalidReason());
        ScoutingMissionTest.assertTrue((String)"Scouting mission should be valid", (boolean)mission.isValid());
        ScoutingMissionTest.assertEquals((String)"Scouting mission target should be the Inca settlement", (Object)is, (Object)mission.getTarget());
        scout.changeRole(ScoutingMissionTest.spec().getDefaultRole(), 0);
        ScoutingMissionTest.assertFalse((String)"Scout should not have the scout role", (boolean)scout.hasAbility("model.ability.speakWithChief"));
        ScoutingMissionTest.assertNotNull((String)"Scouting mission should be invalid", (Object)aiUnit.getMission().invalidReason());
        ScoutingMissionTest.assertNotNull((String)"Scouting mission should be impossible for this unit", (Object)ScoutingMission.invalidMissionReason(aiUnit));
        scout.changeRole(scoutRole, 1);
        ScoutingMissionTest.assertTrue((String)"Scouting mission should be valid again", (boolean)aiUnit.getMission().isValid());
        is.setScouted(dutch);
        ScoutingMissionTest.assertFalse((String)"Scouting mission should be invalid lacking target", (boolean)aiUnit.getMission().isValid());
        Tile lcrTile = map.getTile(2, 3);
        lcrTile.addLostCityRumour(new LostCityRumour((Game)game, lcrTile));
        ScoutingMissionTest.assertEquals((String)"Scouting mission should be possible for this unit", null, (String)ScoutingMission.invalidMissionReason(aiUnit));
        ScoutingMissionTest.assertEquals((String)"The LCR tile should be a scouting target", (Object)lcrTile, (Object)ScoutingMission.findMissionTarget(aiUnit, 10, false));
    }
}

