/*
 * Decompiled with CFR 0.152.
 */
package com.connectina.swing.fontchooser;

import com.connectina.swing.fontchooser.DefaultFontSelectionModel;
import com.connectina.swing.fontchooser.FontChooserDialog;
import com.connectina.swing.fontchooser.FontSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JPanel {
    private static final long serialVersionUID = 5157499702004637097L;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/connectina/swing/fontchooser/resources/i18n/JFontChooser");
    private FontSelectionModel selectionModel;
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    private JLabel familyLabel;
    private JList familyList;
    private JScrollPane familyScrollPane;
    private JPanel fontPanel;
    private JLabel previewAreaLabel;
    private JPanel previewAreaPanel;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JLabel sizeLabel;
    private JList sizeList;
    private JScrollPane sizeScrollPane;
    private JSpinner sizeSpinner;
    private JLabel styleLabel;
    private JList styleList;
    private JScrollPane styleScrollPane;

    public JFontChooser() {
        this(new Font("SansSerif", 0, 12));
    }

    public JFontChooser(Font initialFont) {
        this(new DefaultFontSelectionModel(initialFont));
    }

    public JFontChooser(FontSelectionModel model) {
        this.selectionModel = model;
        this.initComponents();
        this.initPanel();
    }

    public Font getSelectedFont() {
        return this.selectionModel.getSelectedFont();
    }

    public void setSelectedFont(Font Font2) {
        this.selectionModel.setSelectedFont(Font2);
    }

    public FontSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(FontSelectionModel newModel) {
        FontSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldModel, newModel);
    }

    public static Font showDialog(Window parent, Font initialFont) throws HeadlessException {
        JFontChooser pane = new JFontChooser(initialFont != null ? initialFont : new Font("SansSerif", 0, 12));
        FontSelectionActionListener selectionListener = new FontSelectionActionListener(pane);
        JDialog dialog = JFontChooser.createDialog(parent, true, pane, selectionListener);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return selectionListener.getFont();
    }

    public static Font showDialog(Window parent, JFontChooser fontChooser, Font initialFont) throws HeadlessException {
        fontChooser.setSelectedFont(initialFont != null ? initialFont : new Font("SansSerif", 0, 12));
        FontSelectionActionListener selectionListener = new FontSelectionActionListener(fontChooser);
        JDialog dialog = JFontChooser.createDialog(parent, true, fontChooser, selectionListener);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return selectionListener.getFont();
    }

    public static JDialog createDialog(Window parent, boolean modal, JFontChooser chooserPane, ActionListener okListener) throws HeadlessException {
        if (parent instanceof JDialog) {
            return new FontChooserDialog((JDialog)parent, modal, chooserPane, okListener);
        }
        if (parent instanceof JFrame) {
            return new FontChooserDialog((JFrame)parent, modal, chooserPane, okListener);
        }
        throw new IllegalArgumentException("JFrame or JDialog parent is required.");
    }

    public void addChangeListener(ChangeListener l) {
        this.selectionModel.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.selectionModel.removeChangeListener(l);
    }

    private void initPanel() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (String fontName : this.selectionModel.getAvailableFontNames()) {
            listModel.addElement(fontName);
        }
        this.familyList.setModel(listModel);
        this.familyList.getSelectionModel().setSelectionMode(0);
        this.familyList.setSelectedValue(this.selectionModel.getSelectedFont().getName(), true);
        this.familyList.addListSelectionListener(new FamilyListSelectionListener());
        listModel = new DefaultListModel();
        listModel.addElement(this.getFontStyleName(0));
        listModel.addElement(this.getFontStyleName(1));
        listModel.addElement(this.getFontStyleName(2));
        listModel.addElement(this.getFontStyleName(3));
        this.styleList.setModel(listModel);
        this.styleList.getSelectionModel().setSelectionMode(0);
        this.styleList.setSelectedIndex(this.selectionModel.getSelectedFont().getStyle());
        this.styleList.addListSelectionListener(new StyleListSelectionListener());
        listModel = new DefaultListModel();
        int size = 6;
        int step = 1;
        int ceil = 14;
        do {
            listModel.addElement(size);
            if (size != ceil) continue;
            ceil += ceil;
            step += step;
        } while ((size += step) <= 128);
        this.sizeList.setModel(listModel);
        this.sizeList.getSelectionModel().setSelectionMode(0);
        if (listModel.contains(this.selectionModel.getSelectedFont().getSize())) {
            this.sizeList.setSelectedValue(this.selectionModel.getSelectedFont().getSize(), true);
        }
        this.sizeList.addListSelectionListener(new SizeListSelectionListener());
        this.sizeSpinner.addChangeListener(new SizeSpinnerListener());
        this.sizeSpinner.setValue(this.selectionModel.getSelectedFont().getSize());
        this.previewAreaLabel.setFont(this.selectionModel.getSelectedFont());
        this.previewAreaLabel.setText(bundle.getString("font.preview.text"));
    }

    private String getFontStyleName(int index) {
        String result = null;
        switch (index) {
            case 0: {
                result = bundle.getString("style.plain");
                break;
            }
            case 1: {
                result = bundle.getString("style.bold");
                break;
            }
            case 2: {
                result = bundle.getString("style.italic");
                break;
            }
            case 3: {
                result = bundle.getString("style.bolditalic");
                break;
            }
            default: {
                result = bundle.getString("style.plain");
            }
        }
        return result;
    }

    private void initComponents() {
        this.fontPanel = new JPanel();
        this.familyLabel = new JLabel();
        this.styleLabel = new JLabel();
        this.sizeLabel = new JLabel();
        this.familyScrollPane = new JScrollPane();
        this.familyList = new JList();
        this.styleScrollPane = new JScrollPane();
        this.styleList = new JList();
        this.sizeSpinner = new JSpinner();
        int spinnerHeight = (int)this.sizeSpinner.getPreferredSize().getHeight();
        this.sizeSpinner.setPreferredSize(new Dimension(60, spinnerHeight));
        this.sizeScrollPane = new JScrollPane();
        this.sizeList = new JList();
        this.previewPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.previewAreaPanel = new JPanel();
        this.previewAreaLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.fontPanel.setLayout(new GridBagLayout());
        this.familyLabel.setLabelFor(this.familyList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.fontPanel.add((Component)this.familyLabel, gridBagConstraints);
        this.styleLabel.setLabelFor(this.styleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.fontPanel.add((Component)this.styleLabel, gridBagConstraints);
        this.sizeLabel.setLabelFor(this.sizeList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontPanel.add((Component)this.sizeLabel, gridBagConstraints);
        this.familyScrollPane.setMinimumSize(new Dimension(80, 50));
        this.familyScrollPane.setPreferredSize(new Dimension(240, 150));
        this.familyScrollPane.setViewportView(this.familyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.fontPanel.add((Component)this.familyScrollPane, gridBagConstraints);
        this.styleScrollPane.setMinimumSize(new Dimension(60, 120));
        this.styleScrollPane.setPreferredSize(new Dimension(80, 150));
        this.styleScrollPane.setViewportView(this.styleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.fontPanel.add((Component)this.styleScrollPane, gridBagConstraints);
        this.sizeSpinner.setModel(new SpinnerNumberModel(12, 6, 128, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.fontPanel.add((Component)this.sizeSpinner, gridBagConstraints);
        this.sizeScrollPane.setMinimumSize(new Dimension(50, 120));
        this.sizeScrollPane.setPreferredSize(new Dimension(60, 150));
        this.sizeScrollPane.setViewportView(this.sizeList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.fontPanel.add((Component)this.sizeScrollPane, gridBagConstraints);
        this.add((Component)this.fontPanel, "Center");
        this.familyLabel.setDisplayedMnemonic(bundle.getString("font.family.mnemonic").charAt(0));
        this.familyLabel.setText(bundle.getString("font.family"));
        this.styleLabel.setDisplayedMnemonic(bundle.getString("font.style.mnemonic").charAt(0));
        this.styleLabel.setText(bundle.getString("font.style"));
        this.sizeLabel.setDisplayedMnemonic(bundle.getString("font.size.mnemonic").charAt(0));
        this.sizeLabel.setText(bundle.getString("font.size"));
        this.previewLabel.setDisplayedMnemonic(bundle.getString("font.preview.mnemonic").charAt(0));
        this.previewLabel.setText(bundle.getString("font.preview"));
        this.previewPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.previewPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.previewAreaPanel.setBackground(new Color(255, 255, 255));
        this.previewAreaPanel.setBorder(BorderFactory.createEtchedBorder());
        this.previewAreaPanel.setPreferredSize(new Dimension(200, 80));
        this.previewAreaPanel.setLayout(new BorderLayout());
        this.previewAreaLabel.setHorizontalAlignment(0);
        this.previewAreaPanel.add((Component)this.previewAreaLabel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.previewPanel.add((Component)this.previewAreaPanel, gridBagConstraints);
        this.add((Component)this.previewPanel, "South");
    }

    private static class FontSelectionActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 8141913945783951693L;
        private JFontChooser chooser;
        private Font font;

        public FontSelectionActionListener(JFontChooser c) {
            this.chooser = c;
        }

        public void actionPerformed(ActionEvent e) {
            this.font = this.chooser.getSelectedFont();
        }

        public Font getFont() {
            return this.font;
        }
    }

    private class SizeSpinnerListener
    implements ChangeListener {
        private SizeSpinnerListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int value = (Integer)JFontChooser.this.sizeSpinner.getValue();
            int index = ((DefaultListModel)JFontChooser.this.sizeList.getModel()).indexOf(value);
            if (index > -1) {
                JFontChooser.this.sizeList.setSelectedValue(value, true);
            } else {
                JFontChooser.this.sizeList.clearSelection();
            }
        }
    }

    private class SizeListSelectionListener
    implements ListSelectionListener {
        private SizeListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int index = ((DefaultListModel)JFontChooser.this.sizeList.getModel()).indexOf(JFontChooser.this.sizeList.getSelectedValue());
                if (index > -1) {
                    JFontChooser.this.sizeSpinner.setValue((Integer)JFontChooser.this.sizeList.getSelectedValue());
                }
                JFontChooser.this.selectionModel.setSelectedFont(JFontChooser.this.selectionModel.getSelectedFont().deriveFont(Float.valueOf(JFontChooser.this.sizeSpinner.getValue().toString()).floatValue()));
                JFontChooser.this.previewAreaLabel.setFont(JFontChooser.this.selectionModel.getSelectedFont());
            }
        }
    }

    private class StyleListSelectionListener
    implements ListSelectionListener {
        private StyleListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JFontChooser.this.selectionModel.setSelectedFont(JFontChooser.this.selectionModel.getSelectedFont().deriveFont(JFontChooser.this.styleList.getSelectedIndex()));
                JFontChooser.this.previewAreaLabel.setFont(JFontChooser.this.selectionModel.getSelectedFont());
            }
        }
    }

    private class FamilyListSelectionListener
    implements ListSelectionListener {
        private FamilyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JFontChooser.this.selectionModel.setSelectedFont(new Font(JFontChooser.this.familyList.getSelectedValue().toString(), JFontChooser.this.styleList.getSelectedIndex(), Integer.valueOf(JFontChooser.this.sizeSpinner.getValue().toString())));
                JFontChooser.this.previewAreaLabel.setFont(JFontChooser.this.selectionModel.getSelectedFont());
            }
        }
    }
}

