/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.generator;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpellCheckerDictionaryGenerator {
    private static final Logger LOG = Logger.getInstance(SpellCheckerDictionaryGenerator.class);
    private final Set<String> globalSeenNames = new HashSet<String>();
    protected final Project myProject;
    private final String myDefaultDictName;
    protected final String myDictOutputFolder;
    protected final MultiMap<String, VirtualFile> myDict2FolderMap;
    protected final Set<VirtualFile> myExcludedFolders = new HashSet<VirtualFile>();
    protected SpellCheckerManager mySpellCheckerManager;

    public SpellCheckerDictionaryGenerator(Project project, String dictOutputFolder, String defaultDictName) {
        this.myDict2FolderMap = new MultiMap();
        this.myProject = project;
        this.myDefaultDictName = defaultDictName;
        this.mySpellCheckerManager = SpellCheckerManager.getInstance(this.myProject);
        this.myDictOutputFolder = dictOutputFolder;
    }

    public void addFolder(String dictName, VirtualFile path) {
        this.myDict2FolderMap.putValue((Object)dictName, (Object)path);
    }

    public void excludeFolder(VirtualFile folder) {
        this.myExcludedFolders.add(folder);
    }

    public void generate() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(false);
            ArrayList dictionaries = new ArrayList(this.myDict2FolderMap.keySet());
            this.generate(this.myDefaultDictName, progressIndicator);
            progressIndicator.setFraction(1.0 / (double)(dictionaries.size() + 1));
            Collections.sort(dictionaries);
            for (int i = 0; i < dictionaries.size(); ++i) {
                String dict = (String)dictionaries.get(i);
                if (this.myDefaultDictName.equals(dict)) continue;
                this.generate(dict, progressIndicator);
                progressIndicator.setFraction((double)i / ((double)dictionaries.size() + 1.0));
            }
        }, SpellCheckerBundle.message("dictionary.generator.progress.title", new Object[0]), true, this.myProject);
    }

    private void generate(@NotNull String dict, ProgressIndicator progressIndicator) {
        if (dict == null) {
            SpellCheckerDictionaryGenerator.$$$reportNull$$$0(0);
        }
        progressIndicator.setText(SpellCheckerBundle.message("dictionary.generator.processing.title", dict));
        this.generateDictionary(this.myProject, this.myDict2FolderMap.get((Object)dict), this.myDictOutputFolder + "/" + dict + ".dic", progressIndicator);
    }

    private void generateDictionary(Project project, Collection<VirtualFile> folderPaths, String outFile, ProgressIndicator progressIndicator) {
        HashSet seenNames = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (VirtualFile folder : folderPaths) {
                progressIndicator.setText2(SpellCheckerBundle.message("dictionary.generator.scanning.folder.title", folder.getPath()));
                PsiManager manager = PsiManager.getInstance((Project)project);
                this.processFolder(seenNames, manager, folder);
            }
        });
        if (seenNames.isEmpty()) {
            LOG.info("  No new words was found.");
            return;
        }
        StringBuilder builder = new StringBuilder();
        ArrayList names = new ArrayList(seenNames);
        Collections.sort(names);
        for (String name : names) {
            if (!builder.isEmpty()) {
                builder.append("\n");
            }
            builder.append(name);
        }
        File dictionaryFile = new File(outFile);
        FileUtil.createIfDoesntExist((File)dictionaryFile);
        try (FileWriter writer = new FileWriter(dictionaryFile.getPath());){
            writer.write(builder.toString());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void processFolder(final HashSet<String> seenNames, final PsiManager manager, VirtualFile folder) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                PsiFile psiFile;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressIndicatorProvider.checkCanceled();
                if (SpellCheckerDictionaryGenerator.this.myExcludedFolders.contains(file)) {
                    return false;
                }
                if (!file.isDirectory() && (psiFile = manager.findFile(file)) != null) {
                    SpellCheckerDictionaryGenerator.this.processFile(psiFile, seenNames);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator$1", "visitFile"));
            }
        });
    }

    protected abstract void processFile(PsiFile var1, HashSet<String> var2);

    protected void process(@NotNull PsiElement element, @NotNull HashSet<String> seenNames) {
        if (element == null) {
            SpellCheckerDictionaryGenerator.$$$reportNull$$$0(1);
        }
        if (seenNames == null) {
            SpellCheckerDictionaryGenerator.$$$reportNull$$$0(2);
        }
        int endOffset = element.getTextRange().getEndOffset();
        ArrayList<PsiElement> leafs = new ArrayList<PsiElement>();
        if (element.getChildren().length == 0) {
            leafs.add(element);
        } else {
            PsiElement currentLeaf = PsiTreeUtil.firstChild((PsiElement)element);
            while (currentLeaf != null && currentLeaf.getTextRange().getEndOffset() <= endOffset) {
                leafs.add(currentLeaf);
                currentLeaf = PsiTreeUtil.nextLeaf((PsiElement)currentLeaf);
            }
        }
        for (PsiElement leaf : leafs) {
            this.processLeafsNames(leaf, seenNames);
        }
    }

    protected void processLeafsNames(@NotNull PsiElement leafElement, final @NotNull HashSet<String> seenNames) {
        if (leafElement == null) {
            SpellCheckerDictionaryGenerator.$$$reportNull$$$0(3);
        }
        if (seenNames == null) {
            SpellCheckerDictionaryGenerator.$$$reportNull$$$0(4);
        }
        final Language language = leafElement.getLanguage();
        SpellCheckingInspection.tokenize(leafElement, language, new TokenConsumer(){

            @Override
            public void consumeToken(PsiElement element, String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
                splitter.split(text, rangeToCheck, (Consumer<TextRange>)((Consumer)textRange -> {
                    String word = textRange.substring(text);
                    SpellCheckerDictionaryGenerator.this.addSeenWord(seenNames, word, language);
                }));
            }
        }, null);
    }

    protected void addSeenWord(HashSet<String> seenNames, String word, Language language) {
        String lowerWord = StringUtil.toLowerCase((String)word);
        if (this.globalSeenNames.contains(lowerWord)) {
            return;
        }
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(language);
        if (namesValidator.isKeyword(word, this.myProject)) {
            return;
        }
        this.globalSeenNames.add(lowerWord);
        if (this.mySpellCheckerManager.hasProblem(lowerWord)) {
            seenNames.add(lowerWord);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dict";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/generator/SpellCheckerDictionaryGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafsNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

