/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.action.SaveImageActionKt;
import org.intellij.images.scientific.statistics.ScientificImageActionsCollector;
import org.intellij.images.scientific.utils.ScientificImageViewerCoroutineKt;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/images/scientific/action/SaveImageAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nSaveImageAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveImageAction.kt\norg/intellij/images/scientific/action/SaveImageAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class SaveImageAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String IMAGE_FORMAT = "png";
    @NotNull
    private static final String IMAGE_DEFAULT_NAME = "myimg";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        FileSaverDialog chooser;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null || project == null) {
            SaveImageActionKt.access$getLogger$p().error("Missing project or image file.");
            return;
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(ImagesBundle.message("dialog.title.save.image", new Object[0]), "", IMAGE_FORMAT);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog fileSaverDialog2 = chooser = fileSaverDialog;
        String string = project.getBasePath();
        if (string != null) {
            void it;
            String string2 = string;
            FileSaverDialog fileSaverDialog3 = fileSaverDialog2;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)it);
            fileSaverDialog2 = fileSaverDialog3;
        } else {
            virtualFile = null;
        }
        VirtualFileWrapper wrapper = fileSaverDialog2.save(virtualFile, IMAGE_DEFAULT_NAME);
        if (wrapper == null) {
            return;
        }
        File file = wrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        File targetFile = file;
        String string3 = FilesKt.getExtension((File)targetFile).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String selectedFormat = string3;
        ScientificImageViewerCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(wrapper, virtualFile2, selectedFormat, null){
            int label;
            final /* synthetic */ VirtualFileWrapper $wrapper;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ String $selectedFormat;
            {
                this.$wrapper = $wrapper;
                this.$virtualFile = $virtualFile;
                this.$selectedFormat = $selectedFormat;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$wrapper, this.$virtualFile, this.$selectedFormat, null){
                            int label;
                            final /* synthetic */ VirtualFileWrapper $wrapper;
                            final /* synthetic */ VirtualFile $virtualFile;
                            final /* synthetic */ String $selectedFormat;
                            {
                                this.$wrapper = $wrapper;
                                this.$virtualFile = $virtualFile;
                                this.$selectedFormat = $selectedFormat;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        try {
                                            Files.write(this.$wrapper.getFile().toPath(), this.$virtualFile.contentsToByteArray(), new OpenOption[0]);
                                        }
                                        catch (IOException e) {
                                            SaveImageActionKt.access$getLogger$p().warn("Failed to save image", (Throwable)e);
                                        }
                                        ScientificImageActionsCollector.INSTANCE.logSaveAsImageInvoked$intellij_platform_images(this.$selectedFormat);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.SCIENTIFIC_MODE_KEY) : null) != null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/scientific/action/SaveImageAction$Companion;", "", "<init>", "()V", "IMAGE_FORMAT", "", "IMAGE_DEFAULT_NAME", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

