/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JUnit3StyleTestMethodInJUnit4ClassInspection
extends BaseInspection {
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = JUnitBundle.message("junit3.style.test.method.in.junit4.class.problem.descriptor", new Object[0]);
        if (string == null) {
            JUnit3StyleTestMethodInJUnit4ClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction("org.junit.Test", (PsiModifierListOwner)((PsiMethod)infos[0]), new String[0]));
    }

    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor();
    }

    public static boolean containsJUnit4Annotation(PsiElement element) {
        JUnit4AnnotationVisitor visitor = new JUnit4AnnotationVisitor();
        element.accept((PsiElementVisitor)visitor);
        return visitor.isJUnit4AnnotationFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInspection/JUnit3StyleTestMethodInJUnit4ClassInspection", "buildErrorString"));
    }

    private static class JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor
    extends BaseInspectionVisitor {
        private JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            String name = method.getName();
            if (!name.startsWith("test")) {
                return;
            }
            if (!TestUtils.isRunnable((PsiMethod)method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)containingClass);
            if (testFramework != null) {
                String testFrameworkName;
                if (testFramework.isTestMethod((PsiElement)method, false) && ((testFrameworkName = testFramework.getName()).equals("JUnit4") || testFrameworkName.equals("JUnit5"))) {
                    return;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Ignore", (int)0) || testFramework.findSetUpMethod((PsiElement)containingClass) == method || testFramework.findTearDownMethod((PsiElement)containingClass) == method) {
                    return;
                }
            }
            if (TestUtils.isJUnitTestClass((PsiClass)containingClass)) {
                return;
            }
            if (!JUnit3StyleTestMethodInJUnit4ClassInspection.containsJUnit4Annotation((PsiElement)containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[]{method});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/junit/codeInspection/JUnit3StyleTestMethodInJUnit4ClassInspection$JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor", "visitMethod"));
        }
    }

    private static class JUnit4AnnotationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myJUnit4AnnotationFound = false;

        private JUnit4AnnotationVisitor() {
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                JUnit4AnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            @NonNls String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.startsWith("org.junit.")) {
                return;
            }
            this.myJUnit4AnnotationFound = true;
        }

        public boolean isJUnit4AnnotationFound() {
            return this.myJUnit4AnnotationFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/execution/junit/codeInspection/JUnit3StyleTestMethodInJUnit4ClassInspection$JUnit4AnnotationVisitor", "visitAnnotation"));
        }
    }
}

