/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.methods;

import com.intellij.rt.coverage.instrumentation.data.FilteredMethodStorage;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.methods.MethodFilter;
import com.intellij.rt.coverage.util.OptionsUtil;

public class KotlinLocalFunctionInsideIgnoredMethodFilter
implements MethodFilter {
    public boolean shouldIgnore(InstrumentationData context) {
        if (!OptionsUtil.IGNORE_LOCAL_FUNCTIONS_IN_IGNORED_METHODS) {
            return false;
        }
        int access = context.getMethodAccess();
        if ((access & 2) == 0 || (access & 0x10) == 0 || (access & 8) == 0) {
            return false;
        }
        int idx = -1;
        String name = context.getMethodName();
        String className = context.get(Key.CLASS_NAME);
        FilteredMethodStorage storage = context.getProjectContext().getFilteredStorage();
        block0: while ((idx = name.indexOf(36, idx + 1)) >= 0) {
            String outerMethodName = name.substring(0, idx);
            boolean[] blArray = new boolean[]{false, true};
            int n = 0;
            while (true) {
                if (n >= 2) continue block0;
                boolean included = blArray[n];
                if (storage.isMethodNameRegistered(className, outerMethodName, included)) {
                    storage.addMethod(className, context.getMethodName() + context.getMethodDesc(), included);
                    return !included;
                }
                ++n;
            }
            break;
        }
        return false;
    }
}

