/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared.branchedTransformations;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.branchedTransformations.UnfoldPropertyUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.BranchedUnfoldingUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0016J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/branchedTransformations/UnfoldPropertyToIfIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/branchedTransformations/UnfoldPropertyUtils$Context;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "isApplicableByPsi", "", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.intentions.shared"})
public final class UnfoldPropertyToIfIntention
extends KotlinApplicableModCommandAction<KtProperty, UnfoldPropertyUtils.Context> {
    public UnfoldPropertyToIfIntention() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.property.initializer.with.if.expression", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
        return presentation;
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element.isLocal() && element.getInitializer() instanceof KtIfExpression;
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        KtIfExpression ktIfExpression = ktExpression instanceof KtIfExpression ? (KtIfExpression)ktExpression : null;
        if (ktIfExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtIfExpression initializer2 = ktIfExpression;
        PsiElement psiElement = initializer2.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getIfKeyword(...)");
        int endOffset = TextRangeUtilsKt.textRangeIn(psiElement, (PsiElement)element).getEndOffset();
        return CollectionsKt.listOf((Object)new TextRange(0, endOffset));
    }

    @Override
    @Nullable
    public UnfoldPropertyUtils.Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return UnfoldPropertyUtils.INSTANCE.prepareUnfoldPropertyContext$kotlin_code_insight_intentions_shared($this$prepareContext, element);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty element, @NotNull UnfoldPropertyUtils.Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtBinaryExpression ktBinaryExpression = UnfoldPropertyUtils.INSTANCE.splitPropertyDeclaration$kotlin_code_insight_intentions_shared(element, elementContext.getPropertyExplicitType());
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression assignment2 = ktBinaryExpression;
        BranchedUnfoldingUtils.INSTANCE.unfoldAssignmentToIf(assignment2, (Function1<? super Integer, Unit>)((Function1)arg_0 -> UnfoldPropertyToIfIntention.invoke$lambda$0(updater2, arg_0)));
    }

    private static final Unit invoke$lambda$0(ModPsiUpdater $updater, int it) {
        $updater.moveCaretTo(it);
        return Unit.INSTANCE;
    }
}

