/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.smart;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/smart/ArtificialElementInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "textBeforeCaret", "", "textAfterCaret", "shortenRefs", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "kotlin.completion.impl.k1"})
public final class ArtificialElementInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final String textBeforeCaret;
    @NotNull
    private final String textAfterCaret;
    private final boolean shortenRefs;

    public ArtificialElementInsertHandler(@NotNull String textBeforeCaret, @NotNull String textAfterCaret, boolean shortenRefs) {
        Intrinsics.checkNotNullParameter((Object)textBeforeCaret, (String)"textBeforeCaret");
        Intrinsics.checkNotNullParameter((Object)textAfterCaret, (String)"textAfterCaret");
        this.textBeforeCaret = textBeforeCaret;
        this.textAfterCaret = textAfterCaret;
        this.shortenRefs = shortenRefs;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int offset = context.getEditor().getCaretModel().getOffset();
        int startOffset = offset - item.getLookupString().length();
        context.getDocument().deleteString(startOffset, offset);
        context.getDocument().insertString(startOffset, (CharSequence)(this.textBeforeCaret + this.textAfterCaret));
        context.getEditor().getCaretModel().moveToOffset(startOffset + this.textBeforeCaret.length());
        if (this.shortenRefs) {
            CompletionUtilsKt.shortenReferences$default(context, startOffset, startOffset + this.textBeforeCaret.length() + this.textAfterCaret.length(), null, 8, null);
        }
    }
}

