/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.idea.core.TemplatesKt;
import org.jetbrains.kotlin.idea.createFromUsage.GenerationUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.CreateKotlinCallablePsiEditor;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.ExpressionForCreateCallable;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.NewCallableInfo;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.ParameterNameExpression;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.CreateFromUsageUtil;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.TransformToJavaUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J<\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\rH\u0002J\u001c\u0010\u001d\u001a\u00020\t*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/CreateKotlinCallablePsiEditor;", "", "project", "Lcom/intellij/openapi/project/Project;", "callableInfo", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/NewCallableInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/NewCallableInfo;)V", "showEditor", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "anchor", "Lcom/intellij/psi/PsiElement;", "isExtension", "", "targetClass", "insertContainer", "elementToReplace", "moveCaretToCallable", "editor", "Lcom/intellij/openapi/editor/Editor;", "getDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "kotlin.jvm.PlatformType", "runTemplate", "function", "setupTemplate", "Lcom/intellij/codeInsight/template/Template;", "setupParameter", "Lcom/intellij/codeInsight/template/TemplateBuilderImpl;", "parameterIndex", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "buildTemplateListener", "Lcom/intellij/codeInsight/template/TemplateEditingAdapter;", "file", "Lcom/intellij/psi/PsiFile;", "functionMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "kotlin.code-insight.k2"})
@SourceDebugExtension(value={"SMAP\nCreateKotlinCallablePsiEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateKotlinCallablePsiEditor.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/CreateKotlinCallablePsiEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1878#2,3:181\n1878#2,3:184\n*S KotlinDebug\n*F\n+ 1 CreateKotlinCallablePsiEditor.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/CreateKotlinCallablePsiEditor\n*L\n106#1:181,3\n112#1:184,3\n*E\n"})
public final class CreateKotlinCallablePsiEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final NewCallableInfo callableInfo;

    public CreateKotlinCallablePsiEditor(@NotNull Project project, @NotNull NewCallableInfo callableInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)callableInfo, (String)"callableInfo");
        this.project = project;
        this.callableInfo = callableInfo;
    }

    public final void showEditor(@NotNull KtNamedDeclaration declaration, @NotNull PsiElement anchor, boolean isExtension, @Nullable PsiElement targetClass, @NotNull PsiElement insertContainer, @Nullable PsiElement elementToReplace) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)insertContainer, (String)"insertContainer");
        if (this.callableInfo.isForCompanion()) {
            if (insertContainer instanceof KtClass) {
                psiElement = (PsiElement)KotlinPsiModificationUtils.getOrCreateCompanionObject((KtClass)insertContainer);
            } else {
                KtClass ktClass;
                KtClass ktClass2 = ktClass = targetClass instanceof KtClass ? (KtClass)targetClass : null;
                if (ktClass != null) {
                    boolean hasCompanionObject = !((Collection)ktClass.getCompanionObjects()).isEmpty();
                    KtObjectDeclaration companion = KotlinPsiModificationUtils.getOrCreateCompanionObject(ktClass);
                    if (!hasCompanionObject && isExtension) {
                        KtClassBody ktClassBody = companion.getBody();
                        if (ktClassBody != null) {
                            ktClassBody.delete();
                        }
                    }
                }
                psiElement = insertContainer;
            }
        } else {
            psiElement = insertContainer;
        }
        PsiElement containerMaybeCompanion = psiElement;
        PsiElement added = null;
        if (targetClass instanceof PsiClass) {
            FqName fqName2 = this.callableInfo.getContainerClassFqName();
            if (fqName2 == null) {
                fqName2 = FqName.ROOT;
            }
            FqName fqName3 = fqName2;
            PsiMember psiMember = TransformToJavaUtil.INSTANCE.convertToJava(declaration, fqName3, (PsiClass)targetClass);
            if (psiMember == null) {
                return;
            }
            added = (PsiElement)psiMember;
        } else {
            PsiElement psiElement2;
            if (elementToReplace != null && elementToReplace.isValid()) {
                PsiElement psiElement3 = elementToReplace.replace((PsiElement)declaration);
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
            } else {
                psiElement2 = (PsiElement)CreateFromUsageUtil.placeDeclarationInContainer$default(CreateFromUsageUtil.INSTANCE, declaration, containerMaybeCompanion, anchor, null, 8, null);
            }
            added = psiElement2;
        }
        PsiElement psiElement4 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)added);
        if (psiElement4 == null) {
            return;
        }
        PsiElement psiProcessed = psiElement4;
        this.runTemplate(psiProcessed);
    }

    public static /* synthetic */ void showEditor$default(CreateKotlinCallablePsiEditor createKotlinCallablePsiEditor, KtNamedDeclaration ktNamedDeclaration, PsiElement psiElement, boolean bl, PsiElement psiElement2, PsiElement psiElement3, PsiElement psiElement4, int n, Object object) {
        if ((n & 0x20) != 0) {
            psiElement4 = null;
        }
        createKotlinCallablePsiEditor.showEditor(ktNamedDeclaration, psiElement, bl, psiElement2, psiElement3, psiElement4);
    }

    private final void moveCaretToCallable(Editor editor, PsiElement declaration) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        caretModel2.moveToOffset(PsiTreeUtilKt.getStartOffset((PsiElement)declaration));
    }

    private final PsiDocumentManager getDocumentManager() {
        return PsiDocumentManager.getInstance((Project)this.project);
    }

    private final void runTemplate(PsiElement function) {
        PsiFile file = function.getContainingFile();
        Editor editor = EditorHelper.openInEditor((PsiElement)((PsiElement)file));
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(function.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker functionMarker = rangeMarker;
        Intrinsics.checkNotNull((Object)editor);
        this.moveCaretToCallable(editor, function);
        Template template2 = this.setupTemplate(function);
        Intrinsics.checkNotNull((Object)file);
        TemplateEditingAdapter listener2 = this.buildTemplateListener(editor, file, functionMarker);
        TemplateManager.getInstance((Project)this.project).startTemplate(editor, template2, (TemplateEditingListener)listener2);
    }

    private final Template setupTemplate(PsiElement declaration) {
        KtParameter parameter;
        int index2;
        int n;
        int index$iv;
        boolean $i$f$forEachIndexed;
        Iterable $this$forEachIndexed$iv;
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(declaration);
        if (declaration instanceof KtCallableDeclaration) {
            List list2 = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            $this$forEachIndexed$iv = list2;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KtParameter ktParameter = (KtParameter)item$iv;
                index2 = n;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)parameter);
                this.setupParameter(builder2, index2, parameter);
            }
            KtTypeReference returnType = ((KtCallableDeclaration)declaration).getTypeReference();
            if (returnType != null) {
                builder2.replaceElement((PsiElement)returnType, (Expression)new ExpressionForCreateCallable(this.callableInfo.getCandidatesOfRenderedReturnType()));
            }
        }
        if (declaration instanceof KtClassOrObject) {
            $this$forEachIndexed$iv = ((KtClassOrObject)declaration).getPrimaryConstructorParameters();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                parameter = (KtParameter)item$iv;
                index2 = n;
                boolean bl = false;
                this.setupParameter(builder2, index2, parameter);
            }
        }
        Template template2 = builder2.buildInlineTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)template2, (String)"buildInlineTemplate(...)");
        return template2;
    }

    private final void setupParameter(TemplateBuilderImpl $this$setupParameter, int parameterIndex, KtParameter parameter) {
        PsiElement psiElement = parameter.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        $this$setupParameter.replaceElement(nameIdentifier, (Expression)new ParameterNameExpression(parameterIndex, CollectionsKt.toList((Iterable)this.callableInfo.getParameterCandidates().get(parameterIndex).getNames())));
        KtTypeReference ktTypeReference = parameter.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference parameterTypeElement = ktTypeReference;
        $this$setupParameter.replaceElement((PsiElement)parameterTypeElement, (Expression)new ExpressionForCreateCallable(this.callableInfo.getParameterCandidates().get(parameterIndex).getRenderedTypes()));
    }

    private final TemplateEditingAdapter buildTemplateListener(Editor editor, PsiFile file, RangeMarker functionMarker) {
        return new TemplateEditingAdapter(this, editor, file, functionMarker){
            final /* synthetic */ CreateKotlinCallablePsiEditor this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ RangeMarker $functionMarker;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$file = $file;
                this.$functionMarker = $functionMarker;
            }

            private final void finishTemplate(boolean brokenOff) {
                CreateKotlinCallablePsiEditor.access$getDocumentManager(this.this$0).commitDocument(this.$editor.getDocument());
                if (brokenOff) {
                    boolean $i$f$isUnitTestMode = false;
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        return;
                    }
                }
                this.updateCallableBody();
            }

            private final SmartPsiElementPointer<KtNamedDeclaration> getPointerToNewCallable() {
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.$file, (int)this.$functionMarker.getStartOffset(), KtNamedDeclaration.class, (boolean)false);
                return ktNamedDeclaration != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktNamedDeclaration)) : null;
            }

            private final void updateCallableBody() {
                SmartPsiElementPointer<KtNamedDeclaration> smartPsiElementPointer = this.getPointerToNewCallable();
                if (smartPsiElementPointer == null) {
                    return;
                }
                SmartPsiElementPointer<KtNamedDeclaration> pointerToNewCallable = smartPsiElementPointer;
                WriteCommandAction.writeCommandAction((Project)CreateKotlinCallablePsiEditor.access$getProject$p(this.this$0)).run(() -> buildTemplateListener.1.updateCallableBody$lambda$0(pointerToNewCallable, this, this.this$0, this.$editor));
            }

            private final void setupDeclarationBody(KtDeclarationWithBody func) {
                if (!(func instanceof KtNamedFunction) && !(func instanceof KtPropertyAccessor)) {
                    return;
                }
                KtExpression ktExpression = func.getBodyExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression oldBody = ktExpression;
                Project project = ((PsiElement)func).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String string = ((NavigationItem)func).getName();
                Object object = func instanceof KtFunction ? (KtFunction)func : null;
                if (object == null || (object = object.getTypeReference()) == null || (object = object.getText()) == null) {
                    object = "";
                }
                String bodyText = TemplatesKt.getFunctionBodyTextFromTemplate(project, TemplateKind.FUNCTION, string, (String)object, CreateKotlinCallablePsiEditor.access$getCallableInfo$p(this.this$0).getContainerClassFqName());
                Project project2 = ((PsiElement)func).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                oldBody.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createBlock(bodyText));
            }

            public void templateCancelled(Template template2) {
                this.finishTemplate(true);
            }

            public void templateFinished(Template template2, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                this.finishTemplate(brokenOff);
            }

            private static final void updateCallableBody$lambda$0(SmartPsiElementPointer $pointerToNewCallable, buildTemplateListener.1 this$0, CreateKotlinCallablePsiEditor this$1, Editor $editor) {
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)$pointerToNewCallable.getElement();
                if (ktNamedDeclaration == null) {
                    return;
                }
                KtNamedDeclaration newDecl = ktNamedDeclaration;
                if (newDecl instanceof KtNamedFunction) {
                    this$0.setupDeclarationBody((KtDeclarationWithBody)newDecl);
                }
                CodeStyleManager.getInstance((Project)CreateKotlinCallablePsiEditor.access$getProject$p(this$1)).reformat((PsiElement)newDecl);
                GenerationUtilsKt.setupEditorSelection($editor, newDecl);
            }
        };
    }

    public static final /* synthetic */ PsiDocumentManager access$getDocumentManager(CreateKotlinCallablePsiEditor $this) {
        return $this.getDocumentManager();
    }

    public static final /* synthetic */ Project access$getProject$p(CreateKotlinCallablePsiEditor $this) {
        return $this.project;
    }

    public static final /* synthetic */ NewCallableInfo access$getCallableInfo$p(CreateKotlinCallablePsiEditor $this) {
        return $this.callableInfo;
    }
}

