/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.psi.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.QuickFixBranchUtil;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0094\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typeContainsError", "", "typePresentation", "", "typeSourceCode", "variablePresentation", "getText", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "invoke", "", "OnType", "ForOverridden", "ComponentFunctionReturnTypeMismatchFactory", "PropertyOrReturnTypeMismatchOnOverrideFactory", "VariableInitializedWithNullFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nChangeVariableTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeVariableTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public class ChangeVariableTypeFix
extends KotlinQuickFixAction<KtCallableDeclaration> {
    private final boolean typeContainsError;
    @NotNull
    private final String typePresentation;
    @NotNull
    private final String typeSourceCode;

    public ChangeVariableTypeFix(@NotNull KtCallableDeclaration element, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)element);
        this.typeContainsError = ErrorUtils.INSTANCE.containsErrorType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public String variablePresentation() {
        block3: {
            block2: {
                v0 = this.getElement();
                Intrinsics.checkNotNull(v0);
                element = (KtCallableDeclaration)v0;
                name = element.getName();
                if (name == null) break block2;
                var4_3 = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)element, null, 1, null).getContainingDeclaration();
                container = var4_3 instanceof ClassDescriptor != false ? (ClassDescriptor)var4_3 : null;
                v1 /* !! */  = container;
                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getName()) == null) ** GOTO lbl-1000
                it = var5_5 = v1 /* !! */ ;
                $i$a$-takeUnless-ChangeVariableTypeFix$variablePresentation$containerName$1 = false;
                v1 /* !! */  = it.isSpecial() == false ? var5_5 : null;
                if (v1 /* !! */  != null) {
                    v2 = v1 /* !! */ .asString();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                v3 = containerName = v2;
                v4 = v3 != null ? "'" + v3 + "." + name + "'" : "'" + name + "'";
                break block3;
            }
            v4 = null;
        }
        return v4;
    }

    @NotNull
    public String getText() {
        String string;
        if (this.getElement() == null) {
            return "";
        }
        String variablePresentation = this.variablePresentation();
        if (variablePresentation != null) {
            Object[] objectArray = new Object[]{variablePresentation, this.typePresentation};
            string = KotlinBundle.message((String)"change.type.of.0.to.1", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{this.typePresentation};
            string = KotlinBundle.message((String)"change.type.to.0", (Object[])objectArray);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.change.return.type.family", (Object[])new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !this.typeContainsError;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)this.getElement();
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration element = ktCallableDeclaration;
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        boolean bl2 = bl = element.getNameIdentifier() != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ChangeVariableTypeFix$invoke$22 = false;
            String $i$a$-assert-ChangeVariableTypeFix$invoke$22 = "ChangeVariableTypeFix applied to variable without name";
            throw new AssertionError((Object)$i$a$-assert-ChangeVariableTypeFix$invoke$22);
        }
        KtTypeReference replacingTypeReference = psiFactory.createType(this.typeSourceCode);
        ArrayList<KtTypeReference> toShorten = new ArrayList<KtTypeReference>();
        KtTypeReference ktTypeReference = element.setTypeReference(replacingTypeReference);
        Intrinsics.checkNotNull((Object)ktTypeReference);
        toShorten.add(ktTypeReference);
        if (element instanceof KtProperty) {
            KtTypeReference setterParameterTypeRef;
            KtPropertyAccessor ktPropertyAccessor;
            KtTypeReference getterReturnTypeRef;
            KtPropertyAccessor ktPropertyAccessor2 = ((KtProperty)element).getGetter();
            Object object = getterReturnTypeRef = ktPropertyAccessor2 != null ? ktPropertyAccessor2.getReturnTypeReference() : null;
            if (getterReturnTypeRef != null) {
                PsiElement psiElement = getterReturnTypeRef.replace((PsiElement)replacingTypeReference);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                toShorten.add((KtTypeReference)psiElement);
            }
            KtTypeReference ktTypeReference2 = (ktPropertyAccessor = ((KtProperty)element).getSetter()) != null && (ktPropertyAccessor = ktPropertyAccessor.getParameter()) != null ? ktPropertyAccessor.getTypeReference() : (setterParameterTypeRef = null);
            if (setterParameterTypeRef != null) {
                PsiElement psiElement = setterParameterTypeRef.replace((PsiElement)replacingTypeReference);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
                toShorten.add((KtTypeReference)psiElement);
            }
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, toShorten, null, false, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ComponentFunctionReturnTypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class ComponentFunctionReturnTypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final ComponentFunctionReturnTypeMismatchFactory INSTANCE = new ComponentFunctionReturnTypeMismatchFactory();

        private ComponentFunctionReturnTypeMismatchFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            KtDestructuringDeclarationEntry entry = ChangeCallableReturnTypeFix.Companion.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
            BindingContext context = ResolutionUtils.analyze$default((KtElement)entry, null, 1, null);
            ResolvedCall resolvedCall = (ResolvedCall)context.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
            if (resolvedCall == null) {
                return null;
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            CallableDescriptor callableDescriptor = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
            if (DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) == null) {
                return null;
            }
            KotlinType kotlinType = ((FunctionDescriptor)resolvedCall2.getCandidateDescriptor()).getReturnType();
            if (kotlinType == null) {
                return null;
            }
            KotlinType expectedType = kotlinType;
            return new ChangeVariableTypeFix((KtCallableDeclaration)entry, expectedType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$ForOverridden;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "element", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "kotlin.idea"})
    public static final class ForOverridden
    extends ChangeVariableTypeFix {
        public ForOverridden(@NotNull KtVariableDeclaration element, @NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            super((KtCallableDeclaration)element, type2);
        }

        @Override
        @Nullable
        public String variablePresentation() {
            String string = super.variablePresentation();
            if (string == null) {
                return null;
            }
            String presentation = string;
            Object[] objectArray = new Object[]{presentation};
            return KotlinBundle.message((String)"base.property.0", (Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$OnType;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/types/KotlinType;)V", "variablePresentation", "", "kotlin.idea"})
    public static final class OnType
    extends ChangeVariableTypeFix
    implements HighPriorityAction {
        public OnType(@NotNull KtCallableDeclaration element, @NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            super(element, type2);
        }

        @Nullable
        public Void variablePresentation() {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$PropertyOrReturnTypeMismatchOnOverrideFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class PropertyOrReturnTypeMismatchOnOverrideFactory
    extends KotlinIntentionActionsFactory {
        @NotNull
        public static final PropertyOrReturnTypeMismatchOnOverrideFactory INSTANCE = new PropertyOrReturnTypeMismatchOnOverrideFactory();

        private PropertyOrReturnTypeMismatchOnOverrideFactory() {
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            PsiElement overriddenProperty;
            KtCallableDeclaration element;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            LinkedList<ChangeVariableTypeFix> actions = new LinkedList<ChangeVariableTypeFix>();
            PsiElement psiElement = diagnostic.getPsiElement();
            KtCallableDeclaration ktCallableDeclaration = element = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
            if (!(element instanceof KtProperty) && !(element instanceof KtParameter)) {
                return actions;
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny((KtDeclaration)element, BodyResolveMode.FULL);
            PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
            if (propertyDescriptor == null) {
                return actions;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            KotlinType lowerBoundOfOverriddenPropertiesTypes = QuickFixBranchUtil.findLowerBoundOfOverriddenCallablesReturnTypes((CallableDescriptor)descriptor2);
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                throw new IllegalStateException("Property type cannot be null if it mismatches something".toString());
            }
            KotlinType propertyType = kotlinType;
            LinkedList<PropertyDescriptor> overriddenMismatchingProperties = new LinkedList<PropertyDescriptor>();
            boolean canChangeOverriddenPropertyType = true;
            for (PropertyDescriptor overriddenProperty2 : descriptor2.getOverriddenDescriptors()) {
                KotlinType overriddenPropertyType = overriddenProperty2.getReturnType();
                if (overriddenPropertyType == null) continue;
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(propertyType, overriddenPropertyType)) {
                    overriddenMismatchingProperties.add(overriddenProperty2);
                } else if (overriddenProperty2.isVar() && !KotlinTypeChecker.DEFAULT.equalTypes(overriddenPropertyType, propertyType)) {
                    canChangeOverriddenPropertyType = false;
                }
                if (!overriddenProperty2.isVar() || lowerBoundOfOverriddenPropertiesTypes == null || KotlinTypeChecker.DEFAULT.equalTypes(lowerBoundOfOverriddenPropertiesTypes, overriddenPropertyType)) continue;
                lowerBoundOfOverriddenPropertiesTypes = null;
            }
            if (lowerBoundOfOverriddenPropertiesTypes != null) {
                actions.add(new OnType(element, lowerBoundOfOverriddenPropertiesTypes));
            }
            if (overriddenMismatchingProperties.size() == 1 && canChangeOverriddenPropertyType && (overriddenProperty = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)CollectionsKt.single((List)overriddenMismatchingProperties)))) instanceof KtProperty) {
                actions.add(new ForOverridden((KtVariableDeclaration)overriddenProperty, propertyType));
            }
            return actions;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$VariableInitializedWithNullFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nChangeVariableTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeVariableTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$VariableInitializedWithNullFactory\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,181:1\n213#2:182\n*S KotlinDebug\n*F\n+ 1 ChangeVariableTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$VariableInitializedWithNullFactory\n*L\n165#1:182\n*E\n"})
    public static final class VariableInitializedWithNullFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final VariableInitializedWithNullFactory INSTANCE = new VariableInitializedWithNullFactory();

        private VariableInitializedWithNullFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getStrictParentOfType = false;
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBinaryExpression.class, (boolean)true);
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression binaryExpression = ktBinaryExpression;
            KtExpression ktExpression = binaryExpression.getLeft();
            if (ktExpression == null) {
                return null;
            }
            KtExpression left = ktExpression;
            if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
            PsiElement psiElement = ktReference != null ? ktReference.resolve() : null;
            KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property = ktProperty;
            if (!property.isVar() || property.getTypeReference() != null || !IfThenUtilsKt.isNullExpression(property.getInitializer())) {
                return null;
            }
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            Object object = Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH) ? (KotlinType)((DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic)).getB() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH_WARNING) ? (KotlinType)((DiagnosticWithParameters2)Errors.TYPE_MISMATCH_WARNING.cast((UnboundDiagnostic)diagnostic)).getB() : (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS) ? (KotlinType)((DiagnosticWithParameters2)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.cast((UnboundDiagnostic)diagnostic)).getB() : null));
            if (object == null) {
                return null;
            }
            KotlinType actualType = object;
            return new ChangeVariableTypeFix((KtCallableDeclaration)property, TypeUtilsKt.makeNullable((KotlinType)actualType));
        }
    }
}

