/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/references/KotlinWebReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "spaceSymbolsSplitter", "Lkotlin/text/Regex;", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "kotlin.code-insight.impl-base"})
public final class KotlinWebReferenceContributor
extends PsiReferenceContributor {
    @NotNull
    private final Regex spaceSymbolsSplitter = new Regex("\\s");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar2) {
        Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
        registrar2.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(KtStringTemplateExpression.class), new PsiReferenceProvider(this){
            final /* synthetic */ KotlinWebReferenceContributor this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean acceptsTarget(PsiElement target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return false;
            }

            public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                KtStringTemplateExpression ktStringTemplateExpression = element instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)element : null;
                if (ktStringTemplateExpression == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiReference.EMPTY_ARRAY;
                }
                KtStringTemplateExpression stringTemplateExpression = ktStringTemplateExpression;
                if (!stringTemplateExpression.textContains(':')) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiReference.EMPTY_ARRAY;
                }
                SmartList results2 = new SmartList();
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])stringTemplateExpression.getEntries());
                while (iterator2.hasNext()) {
                    KtStringTemplateEntry entry = (KtStringTemplateEntry)iterator2.next();
                    if (entry.getExpression() != null) continue;
                    String string = entry.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence charSequence = string;
                    Regex regex = KotlinWebReferenceContributor.access$getSpaceSymbolsSplitter$p(this.this$0);
                    int n = 0;
                    List texts = regex.split(charSequence, n);
                    int startIndex = entry.getStartOffsetInParent();
                    for (String text : texts) {
                        if (((CharSequence)text).length() > 0 && GlobalPathReferenceProvider.isWebReferenceUrl((String)text)) {
                            results2.add((Object)new WebReference((PsiElement)stringTemplateExpression, new TextRange(startIndex, startIndex + text.length()), text));
                        }
                        startIndex += text.length() + 1;
                    }
                }
                Object[] objectArray = results2.toArray((Object[])PsiReference.EMPTY_ARRAY);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
                return (PsiReference[])objectArray;
            }
        });
    }

    public static final /* synthetic */ Regex access$getSpaceSymbolsSplitter$p(KotlinWebReferenceContributor $this) {
        return $this.spaceSymbolsSplitter;
    }
}

