/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileFormattingService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaFileFormattingService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/FileFormattingService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "formatFile", "", "text", "filename", "createPsiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.project-wizard.idea"})
public final class IdeaFileFormattingService
implements FileFormattingService,
IdeaWizardService {
    @NotNull
    private final Project project;

    public IdeaFileFormattingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public String formatFile(@NotNull String text, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return (String)ActionsKt.runReadAction(() -> IdeaFileFormattingService.formatFile$lambda$0(this, text, filename));
    }

    private final KtFile createPsiFile(String text, String filename) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)new File(StringsKt.removeSuffix((String)filename, (CharSequence)".vm"))), (Object)"kt") ? new KtPsiFactory(this.project, false, 2, null).createFile(text) : null;
    }

    private static final String formatFile$lambda$0(IdeaFileFormattingService this$0, String $text, String $filename) {
        String string = StringUtil.convertLineSeparators((String)$text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        KtFile ktFile2 = this$0.createPsiFile(string, $filename);
        if (ktFile2 == null) {
            return $text;
        }
        KtFile psiFile = ktFile2;
        String string2 = CodeStyleManager.getInstance((Project)this$0.project).reformat((PsiElement)psiFile).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return string2;
    }
}

