/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class OpenBrowserAction
extends AbstractAction {
    private final List<String> urls = new ArrayList<String>();
    private final String originalName;

    public OpenBrowserAction(String name, String url) {
        this(name, url, null);
    }

    public OpenBrowserAction(String name, String url, ImageResource icon) {
        if (icon == null) {
            new ImageProvider("help/internet").getResource().attachImageIcon(this, true);
        } else {
            icon.attachImageIcon(this, true);
        }
        this.urls.add(url);
        this.originalName = name;
        this.updateNameAndDescription();
    }

    public void addUrl(String url) {
        this.urls.add(url);
        this.updateNameAndDescription();
    }

    private void updateNameAndDescription() {
        String countString = this.urls.size() > 1 ? I18n.tr(" ({0})", this.urls.size()) : "";
        this.putValue("Name", this.originalName + (Serializable)((Object)countString));
        this.putValue("ShortDescription", Utils.shortenString(I18n.tr("Open {0}", String.join((CharSequence)", ", this.urls)), 256));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int size = this.urls.size();
        if (size > Config.getPref().getInt("warn.open.maxbrowser", 10) && !OpenBrowserAction.confirmLaunchMultiple(size)) {
            return;
        }
        for (String url : this.urls) {
            OpenBrowser.displayUrl(url);
        }
    }

    public static boolean confirmLaunchMultiple(int numBrowsers) {
        String msg = I18n.trn("You are about to launch {0} browser window.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", "You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", numBrowsers, numBrowsers);
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), new ImageProvider("ok"), I18n.trn("Click to continue and to open {0} browser", "Click to continue and to open {0} browsers", numBrowsers, numBrowsers), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), new StringBuilder(msg).insert(0, "<html>").append("</html>").toString(), I18n.tr("Warning", new Object[0]), 2, null, spec, spec[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
    }
}

