/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import sun.awt.SunToolkit;
import sun.font.GlyphDisposedListener;
import sun.font.GlyphList;
import sun.font.StrikeCache;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.MutableInteger;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;

public class XRGlyphCache
implements GlyphDisposedListener {
    XRBackend con;
    XRCompositeManager maskBuffer;
    HashMap<MutableInteger, XRGlyphCacheEntry> cacheMap = new HashMap(256);
    int nextID = 1;
    MutableInteger tmp = new MutableInteger(0);
    int grayGlyphSet;
    int lcdGlyphSet;
    int time = 0;
    int cachedPixels = 0;
    static final int MAX_CACHED_PIXELS = 100000;
    ArrayList<Integer> freeGlyphIDs = new ArrayList(255);
    static final boolean batchGlyphUpload = true;

    public XRGlyphCache(XRCompositeManager maskBuf) {
        this.con = maskBuf.getBackend();
        this.maskBuffer = maskBuf;
        this.grayGlyphSet = this.con.XRenderCreateGlyphSet(2);
        this.lcdGlyphSet = this.con.XRenderCreateGlyphSet(0);
        StrikeCache.addGlyphDisposedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void glyphDisposed(ArrayList<Long> glyphPtrList) {
        try {
            SunToolkit.awtLock();
            GrowableIntArray glyphIDList = new GrowableIntArray(1, glyphPtrList.size());
            for (long glyphPtr : glyphPtrList) {
                int glyphID = XRGlyphCacheEntry.getGlyphID(glyphPtr);
                if (glyphID == 0) continue;
                glyphIDList.addInt(glyphID);
            }
            this.freeGlyphs(glyphIDList);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    protected int getFreeGlyphID() {
        if (this.freeGlyphIDs.size() > 0) {
            int newID = this.freeGlyphIDs.remove(this.freeGlyphIDs.size() - 1);
            return newID;
        }
        return this.nextID++;
    }

    protected XRGlyphCacheEntry getEntryForPointer(long imgPtr) {
        int id = XRGlyphCacheEntry.getGlyphID(imgPtr);
        if (id == 0) {
            return null;
        }
        this.tmp.setValue(id);
        return this.cacheMap.get(this.tmp);
    }

    public XRGlyphCacheEntry[] cacheGlyphs(GlyphList glyphList) {
        ++this.time;
        XRGlyphCacheEntry[] entries = new XRGlyphCacheEntry[glyphList.getNumGlyphs()];
        long[] imgPtrs = glyphList.getImages();
        ArrayList<XRGlyphCacheEntry> uncachedGlyphs = null;
        for (int i = 0; i < glyphList.getNumGlyphs(); ++i) {
            if (imgPtrs[i] == 0L) continue;
            XRGlyphCacheEntry glyph = this.getEntryForPointer(imgPtrs[i]);
            if (glyph == null) {
                glyph = new XRGlyphCacheEntry(imgPtrs[i], glyphList);
                glyph.setGlyphID(this.getFreeGlyphID());
                this.cacheMap.put(new MutableInteger(glyph.getGlyphID()), glyph);
                if (uncachedGlyphs == null) {
                    uncachedGlyphs = new ArrayList<XRGlyphCacheEntry>();
                }
                uncachedGlyphs.add(glyph);
            }
            glyph.setLastUsed(this.time);
            entries[i] = glyph;
        }
        if (uncachedGlyphs != null) {
            this.uploadGlyphs(entries, uncachedGlyphs, glyphList, null);
        }
        return entries;
    }

    protected void uploadGlyphs(XRGlyphCacheEntry[] glyphs, ArrayList<XRGlyphCacheEntry> uncachedGlyphs, GlyphList gl, int[] glIndices) {
        for (XRGlyphCacheEntry glyph : uncachedGlyphs) {
            this.cachedPixels += glyph.getPixelCnt();
        }
        if (this.cachedPixels > 100000) {
            this.clearCache(glyphs);
        }
        boolean containsLCDGlyphs = this.containsLCDGlyphs(uncachedGlyphs);
        List<XRGlyphCacheEntry>[] seperatedGlyphList = this.seperateGlyphTypes(uncachedGlyphs, containsLCDGlyphs);
        List<XRGlyphCacheEntry> grayGlyphList = seperatedGlyphList[0];
        List<XRGlyphCacheEntry> lcdGlyphList = seperatedGlyphList[1];
        if (grayGlyphList != null && grayGlyphList.size() > 0) {
            this.con.XRenderAddGlyphs(this.grayGlyphSet, gl, grayGlyphList, this.generateGlyphImageStream(grayGlyphList));
        }
        if (lcdGlyphList != null && lcdGlyphList.size() > 0) {
            this.con.XRenderAddGlyphs(this.lcdGlyphSet, gl, lcdGlyphList, this.generateGlyphImageStream(lcdGlyphList));
        }
    }

    protected List<XRGlyphCacheEntry>[] seperateGlyphTypes(List<XRGlyphCacheEntry> glyphList, boolean containsLCDGlyphs) {
        ArrayList<XRGlyphCacheEntry> lcdGlyphs = null;
        ArrayList<XRGlyphCacheEntry> grayGlyphs = null;
        for (XRGlyphCacheEntry cacheEntry : glyphList) {
            if (cacheEntry.isGrayscale(containsLCDGlyphs)) {
                if (grayGlyphs == null) {
                    grayGlyphs = new ArrayList<XRGlyphCacheEntry>(glyphList.size());
                }
                cacheEntry.setGlyphSet(this.grayGlyphSet);
                grayGlyphs.add(cacheEntry);
                continue;
            }
            if (lcdGlyphs == null) {
                lcdGlyphs = new ArrayList<XRGlyphCacheEntry>(glyphList.size());
            }
            cacheEntry.setGlyphSet(this.lcdGlyphSet);
            lcdGlyphs.add(cacheEntry);
        }
        return new List[]{grayGlyphs, lcdGlyphs};
    }

    protected byte[] generateGlyphImageStream(List<XRGlyphCacheEntry> glyphList) {
        boolean isLCDGlyph = glyphList.get(0).getGlyphSet() == this.lcdGlyphSet;
        ByteArrayOutputStream stream = new ByteArrayOutputStream((isLCDGlyph ? 4 : 1) * 48 * glyphList.size());
        for (XRGlyphCacheEntry cacheEntry : glyphList) {
            cacheEntry.writePixelData(stream, isLCDGlyph);
        }
        return stream.toByteArray();
    }

    protected boolean containsLCDGlyphs(List<XRGlyphCacheEntry> entries) {
        boolean containsLCDGlyphs = false;
        for (XRGlyphCacheEntry entry : entries) {
            containsLCDGlyphs = entry.getSourceRowBytes() != entry.getWidth();
            if (!containsLCDGlyphs) continue;
            return true;
        }
        return false;
    }

    protected void clearCache(XRGlyphCacheEntry[] glyps) {
        ArrayList<XRGlyphCacheEntry> cacheList = new ArrayList<XRGlyphCacheEntry>(this.cacheMap.values());
        Collections.sort(cacheList, new Comparator<XRGlyphCacheEntry>(){

            @Override
            public int compare(XRGlyphCacheEntry e1, XRGlyphCacheEntry e2) {
                return e2.getLastUsed() - e1.getLastUsed();
            }
        });
        for (XRGlyphCacheEntry glyph : glyps) {
            glyph.setPinned();
        }
        GrowableIntArray deleteGlyphList = new GrowableIntArray(1, 10);
        int pixelsToRelease = this.cachedPixels - 100000;
        for (int i = cacheList.size() - 1; i >= 0 && pixelsToRelease > 0; --i) {
            XRGlyphCacheEntry entry = cacheList.get(i);
            if (entry.isPinned()) continue;
            pixelsToRelease -= entry.getPixelCnt();
            deleteGlyphList.addInt(entry.getGlyphID());
        }
        for (XRGlyphCacheEntry glyph : glyps) {
            glyph.setUnpinned();
        }
        this.freeGlyphs(deleteGlyphList);
    }

    private void freeGlyphs(GrowableIntArray glyphIdList) {
        GrowableIntArray removedLCDGlyphs = new GrowableIntArray(1, 10);
        GrowableIntArray removedGrayscaleGlyphs = new GrowableIntArray(1, 10);
        for (int i = 0; i < glyphIdList.getSize(); ++i) {
            int glyphId = glyphIdList.getInt(i);
            this.freeGlyphIDs.add(glyphId);
            this.tmp.setValue(glyphId);
            XRGlyphCacheEntry entry = this.cacheMap.get(this.tmp);
            this.cachedPixels -= entry.getPixelCnt();
            this.cacheMap.remove(this.tmp);
            if (entry.getGlyphSet() == this.grayGlyphSet) {
                removedGrayscaleGlyphs.addInt(glyphId);
            } else {
                removedLCDGlyphs.addInt(glyphId);
            }
            entry.setGlyphID(0);
        }
        if (removedGrayscaleGlyphs.getSize() > 0) {
            this.con.XRenderFreeGlyphs(this.grayGlyphSet, removedGrayscaleGlyphs.getSizedArray());
        }
        if (removedLCDGlyphs.getSize() > 0) {
            this.con.XRenderFreeGlyphs(this.lcdGlyphSet, removedLCDGlyphs.getSizedArray());
        }
    }
}

