/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.MutableTreeNodeEx;
import com.jidesoft.dialog.TreeIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class DialogPageTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final long serialVersionUID = 3680042627478398736L;
    private Color _selectedForeground;
    private Color _nonSelectedForeground;
    private Color _selectedBackground;
    private Color _nonSelectedBackground;
    private Color _selectedBorderColor;
    private Icon _selectedIcon;
    private Icon _blankIcon;
    private Icon _openIcon;
    private Icon _closedIcon;
    private Color _defaultTextSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
    private Color _defaultTextNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
    private Color _defaultBkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
    private Color _defaultBkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
    private Color _defaultBorderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
    private Icon _defaultOpenIcon = UIDefaultsLookup.getIcon("Tree.openIcon");
    private Icon _defaultClosedIcon = UIDefaultsLookup.getIcon("Tree.closedIcon");
    private boolean m_selected;
    private static final Icon SELECTED = TreeIconsFactory.getImageIcon("icons/selected-b16.gif");
    private static final Icon BLANK = TreeIconsFactory.getImageIcon("icons/blank-16.gif");

    public DialogPageTreeCellRenderer() {
        this.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object obj = node.getUserObject();
        if (obj instanceof Boolean) {
            this.setText("Retrieving data...");
        }
        if (obj instanceof AbstractDialogPage) {
            AbstractDialogPage idata = (AbstractDialogPage)obj;
            this.setText(idata.getTitle());
        } else {
            this.setText(obj.toString());
            this.setIcon(null);
        }
        this.setFont(tree.getFont());
        boolean treeIsEnabled = tree.isEnabled();
        boolean nodeIsEnabled = !(value instanceof MutableTreeNodeEx) || ((MutableTreeNodeEx)value).isEnabled();
        boolean isEnabled = treeIsEnabled && nodeIsEnabled;
        this.setEnabled(isEnabled);
        if (!isEnabled) {
            sel = false;
        }
        this.setForeground(sel ? this.getSelectedForeground() : this.getNonSelectedForeground());
        this.setBackground(sel ? this.getSelectedBackground() : this.getNonSelectedBackground());
        if (leaf) {
            if (sel) {
                this.setIcon(SELECTED);
            } else {
                this.setIcon(BLANK);
            }
        } else if (expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.m_selected = sel;
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return this;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Color bColor = this.getBackground();
        Icon icon = this.getIcon();
        g2.setColor(bColor);
        int offset = 0;
        if (icon != null && this.getText() != null) {
            offset = icon.getIconWidth() + this.getIconTextGap() - 1;
        }
        g2.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
        if (this.m_selected) {
            g2.setColor(this.getSelectedBorderColor());
            g2.drawRect(offset, 0, this.getWidth() - offset - 1, this.getHeight() - 1);
        }
        super.paintComponent(g2);
    }

    public Color getSelectedForeground() {
        if (this._selectedForeground == null) {
            if (this._defaultTextSelectionColor == null) {
                this._defaultTextSelectionColor = UIDefaultsLookup.getColor("Tree.selectionForeground");
            }
            return this._defaultTextSelectionColor;
        }
        return this._selectedForeground;
    }

    public void setSelectedForeground(Color selectedForeground) {
        this._selectedForeground = selectedForeground;
    }

    public Color getNonSelectedForeground() {
        if (this._nonSelectedForeground == null) {
            if (this._defaultTextNonSelectionColor == null) {
                this._defaultTextNonSelectionColor = UIDefaultsLookup.getColor("Tree.textForeground");
            }
            return this._defaultTextNonSelectionColor;
        }
        return this._nonSelectedForeground;
    }

    public void setNonSelectedForeground(Color nonSelectedForeground) {
        this._nonSelectedForeground = nonSelectedForeground;
    }

    public Color getSelectedBackground() {
        if (this._selectedBackground == null) {
            if (this._defaultBkSelectionColor == null) {
                this._defaultBkSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBackground");
            }
            return this._defaultBkSelectionColor;
        }
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color selectedBackground) {
        this._selectedBackground = selectedBackground;
    }

    public Color getNonSelectedBackground() {
        if (this._nonSelectedBackground == null) {
            if (this._defaultBkNonSelectionColor == null) {
                this._defaultBkNonSelectionColor = UIDefaultsLookup.getColor("Tree.textBackground");
            }
            return this._defaultBkNonSelectionColor;
        }
        return this._nonSelectedBackground;
    }

    public void setNonSelectedBackground(Color nonSelectedBackground) {
        this._nonSelectedBackground = nonSelectedBackground;
    }

    public Color getSelectedBorderColor() {
        if (this._selectedBorderColor == null) {
            if (this._defaultBorderSelectionColor == null) {
                this._defaultBorderSelectionColor = UIDefaultsLookup.getColor("Tree.selectionBorderColor");
            }
            return this._defaultBorderSelectionColor;
        }
        return this._selectedBorderColor;
    }

    public void setSelectedBorderColor(Color selectedBorderColor) {
        this._selectedBorderColor = selectedBorderColor;
    }

    public Icon getSelectedIcon() {
        if (this._selectedIcon == null) {
            return SELECTED;
        }
        return this._selectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this._selectedIcon = selectedIcon;
    }

    public Icon getBlankIcon() {
        if (this._blankIcon == null) {
            return BLANK;
        }
        return this._blankIcon;
    }

    public void setBlankIcon(Icon blankIcon) {
        this._blankIcon = blankIcon;
    }

    public Icon getOpenIcon() {
        if (this._openIcon == null) {
            if (this._defaultOpenIcon == null) {
                this._defaultOpenIcon = UIDefaultsLookup.getIcon("Tree.openIcon");
            }
            return this._defaultOpenIcon;
        }
        return this._openIcon;
    }

    public void setOpenIcon(Icon openIcon) {
        this._openIcon = openIcon;
    }

    public Icon getClosedIcon() {
        if (this._closedIcon == null) {
            if (this._defaultClosedIcon == null) {
                this._defaultClosedIcon = UIDefaultsLookup.getIcon("Tree.closedIcon");
            }
            return this._defaultClosedIcon;
        }
        return this._closedIcon;
    }

    public void setClosedIcon(Icon closedIcon) {
        this._closedIcon = closedIcon;
    }
}

