/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.misc.SeeChars;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ChineseCharacterBasedLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseLexiconAndWordSegmenter;
import edu.stanford.nlp.parser.lexparser.ChineseSimWordAvgDepGrammar;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.SisterAnnotationStats;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.pennchinese.BikelChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.CTBErrorCorrectingTreeNormalizer;
import edu.stanford.nlp.trees.international.pennchinese.CTBTreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.ChineseCollinizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.trees.international.pennchinese.SunJurafskyChineseHeadFinder;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseTreebankParserParams
extends AbstractTreebankParserParams {
    private ChineseTreebankLanguagePack ctlp = (ChineseTreebankLanguagePack)super.treebankLanguagePack();
    public boolean charTags = false;
    public boolean useCharacterBasedLexicon = false;
    public boolean useMaxentLexicon = false;
    public boolean useMaxentDepGrammar = false;
    public boolean segmentMarkov = false;
    public boolean segmentMaxMatch = false;
    public boolean sunJurafskyHeadFinder = false;
    public boolean bikelHeadFinder = false;
    public boolean discardFrags = false;
    public boolean useSimilarWordMap = false;
    private Lexicon lex;
    private WordSegmenter segmenter;
    private HeadFinder headFinder = null;
    public static boolean chineseSplitDouHao = false;
    public static boolean chineseSplitPunct = true;
    public static boolean chineseSplitPunctLR = false;
    public static boolean markVVsisterIP = true;
    public static boolean markPsisterIP = true;
    public static boolean markIPsisterVVorP = true;
    public static boolean markADgrandchildOfIP = false;
    public static boolean gpaAD = true;
    public static boolean chineseVerySelectiveTagPA = false;
    public static boolean chineseSelectiveTagPA = false;
    public static boolean markIPsisterBA = true;
    public static boolean markVPadjunct = true;
    public static boolean markNPmodNP = true;
    public static boolean markModifiedNP = true;
    public static boolean markNPconj = true;
    public static boolean markMultiNtag = false;
    public static boolean markIPsisDEC = true;
    public static boolean markIPconj = false;
    public static boolean markIPadjsubj = false;
    public static int chineseSplitVP = 3;
    public static boolean mergeNNVV = false;
    public static boolean unaryIP = false;
    public static boolean unaryCP = false;
    public static boolean paRootDtr = false;
    public static boolean markPostverbalP = false;
    public static boolean markPostverbalPP = false;
    public static boolean splitBaseNP = false;
    public static boolean tagWordSize = false;
    public static boolean markCC = false;
    public static boolean splitNPTMP = false;
    public static boolean splitPPTMP = false;
    public static boolean splitXPTMP = false;
    public static boolean dominatesV = false;
    private int depGramFeatureLevel = 0;
    private static final long serialVersionUID = 2L;

    private static void printlnErr(String s) {
        EncodingPrintWriter.err.println(s, "GB18030");
    }

    public ChineseTreebankParserParams() {
        super(new ChineseTreebankLanguagePack());
    }

    @Override
    public HeadFinder headFinder() {
        if (this.headFinder == null) {
            if (this.sunJurafskyHeadFinder) {
                return new SunJurafskyChineseHeadFinder();
            }
            if (this.bikelHeadFinder) {
                return new BikelChineseHeadFinder();
            }
            return new ChineseHeadFinder();
        }
        return this.headFinder;
    }

    @Override
    public Lexicon lex(Options.LexOptions op) {
        if (this.useCharacterBasedLexicon) {
            this.lex = new ChineseCharacterBasedLexicon();
            return this.lex;
        }
        if (op.uwModel == null) {
            op.uwModel = "edu.stanford.nlp.parser.lexparser.ChineseUnknownWordModel";
        }
        ChineseLexicon clex = new ChineseLexicon(op);
        WordSegmenter seg = this.segmenter;
        this.lex = seg != null ? new ChineseLexiconAndWordSegmenter(clex, seg) : clex;
        return this.lex;
    }

    @Override
    public double[] MLEDependencyGrammarSmoothingParams() {
        return new double[]{5.8, 17.7, 6.5, 0.4};
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        CTBErrorCorrectingTreeNormalizer tn = new CTBErrorCorrectingTreeNormalizer(splitNPTMP, splitPPTMP, splitXPTMP, this.charTags);
        return new CTBTreeReaderFactory(tn, this.discardFrags);
    }

    @Override
    public DiskTreebank diskTreebank() {
        String encoding = this.inputEncoding;
        if (!Charset.isSupported(encoding)) {
            ChineseTreebankParserParams.printlnErr("Warning: desired encoding " + encoding + " not accepted. ");
            ChineseTreebankParserParams.printlnErr("Using UTF-8 to construct DiskTreebank");
            encoding = "UTF-8";
        }
        return new DiskTreebank(this.treeReaderFactory(), encoding);
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        String encoding = this.inputEncoding;
        if (!Charset.isSupported(encoding)) {
            System.out.println("Warning: desired encoding " + encoding + " not accepted. ");
            System.out.println("Using UTF-8 to construct MemoryTreebank");
            encoding = "UTF-8";
        }
        return new MemoryTreebank(this.treeReaderFactory(), encoding);
    }

    @Override
    public TreeTransformer collinizer() {
        return new ChineseCollinizer(this.ctlp);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new ChineseCollinizer(this.ctlp, false);
    }

    @Override
    public String[] sisterSplitters() {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        String grandParentStr;
        Tree grandParent;
        String parentStr;
        Tree parent;
        if (t == null || t.isLeaf()) {
            return t;
        }
        if (root == null || t.equals(root)) {
            parent = null;
            parentStr = "";
        } else {
            parent = t.parent(root);
            parentStr = parent.label().value();
        }
        if (parent == null || parent.equals(root)) {
            grandParent = null;
            grandParentStr = "";
        } else {
            grandParent = parent.parent(root);
            grandParentStr = grandParent.label().value();
        }
        String baseParentStr = this.ctlp.basicCategory(parentStr);
        String baseGrandParentStr = this.ctlp.basicCategory(grandParentStr);
        CoreLabel lab = (CoreLabel)t.label();
        String word = lab.word();
        String tag = lab.tag();
        String baseTag = this.ctlp.basicCategory(tag);
        String category = lab.value();
        String baseCategory = this.ctlp.basicCategory(category);
        if (t.isPreTerminal()) {
            int i;
            boolean seenIP;
            List<String> leftAunts = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(parent, grandParent));
            List<String> rightAunts = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(parent, grandParent));
            if (chineseSplitPunct && baseTag.equals("PU")) {
                if (ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(word)) {
                    tag = tag + "-DOU";
                } else if (ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(word)) {
                    tag = tag + "-COMMA";
                } else if (ChineseTreebankLanguagePack.chineseColonAcceptFilter().accept(word)) {
                    tag = tag + "-COLON";
                } else if (ChineseTreebankLanguagePack.chineseQuoteMarkAcceptFilter().accept(word)) {
                    tag = chineseSplitPunctLR ? (ChineseTreebankLanguagePack.chineseLeftQuoteMarkAcceptFilter().accept(word) ? tag + "-LQUOTE" : tag + "-RQUOTE") : tag + "-QUOTE";
                } else if (ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(word)) {
                    tag = tag + "-ENDSENT";
                } else if (ChineseTreebankLanguagePack.chineseParenthesisAcceptFilter().accept(word)) {
                    tag = chineseSplitPunctLR ? (ChineseTreebankLanguagePack.chineseLeftParenthesisAcceptFilter().accept(word) ? tag + "-LPAREN" : tag + "-RPAREN") : tag + "-PAREN";
                } else if (ChineseTreebankLanguagePack.chineseDashAcceptFilter().accept(word)) {
                    tag = tag + "-DASH";
                } else if (ChineseTreebankLanguagePack.chineseOtherAcceptFilter().accept(word)) {
                    tag = tag + "-OTHER";
                } else {
                    ChineseTreebankParserParams.printlnErr("Unknown punct (you should add it to CTLP): " + tag + " " + word);
                    SeeChars.seeChars(word, "GB18030");
                }
            } else if (chineseSplitDouHao && ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(word) && baseTag.equals("PU")) {
                tag = tag + "-DOU";
            }
            if (tagWordSize) {
                int l = word.length();
                tag = tag + "-" + l + "CHARS";
            }
            if (mergeNNVV && baseTag.equals("NN")) {
                tag = "VV";
            }
            if ((chineseSelectiveTagPA || chineseVerySelectiveTagPA) && (baseTag.equals("CC") || baseTag.equals("P"))) {
                tag = tag + "-" + baseParentStr;
            }
            if (chineseSelectiveTagPA && baseTag.equals("VV")) {
                tag = tag + "-" + baseParentStr;
            }
            if (markMultiNtag && tag.startsWith("N")) {
                for (int i2 = 0; i2 < parent.numChildren(); ++i2) {
                    if (!parent.children()[i2].label().value().startsWith("N") || parent.children()[i2] == t) continue;
                    tag = tag + "=N";
                }
            }
            if (markVVsisterIP && baseTag.equals("VV")) {
                seenIP = false;
                for (i = 0; i < parent.numChildren(); ++i) {
                    if (!parent.children()[i].label().value().startsWith("IP")) continue;
                    seenIP = true;
                }
                if (seenIP) {
                    tag = tag + "-IP";
                }
            }
            if (markPsisterIP && baseTag.equals("P")) {
                seenIP = false;
                for (i = 0; i < parent.numChildren(); ++i) {
                    if (!parent.children()[i].label().value().startsWith("IP")) continue;
                    seenIP = true;
                }
                if (seenIP) {
                    tag = tag + "-IP";
                }
            }
            if (markADgrandchildOfIP && baseTag.equals("AD") && baseGrandParentStr.equals("IP")) {
                tag = tag + "~IP";
            }
            if (gpaAD && baseTag.equals("AD")) {
                tag = tag + "~" + baseGrandParentStr;
            }
            if (markPostverbalP && leftAunts.contains("VV") && baseTag.equals("P")) {
                tag = tag + "^=lVV";
            }
            CategoryWordTag label = new CategoryWordTag(tag, word, tag);
            t.setLabel(label);
        } else {
            Tree[] kids = t.children();
            List<String> leftSis = this.listBasicCategories(SisterAnnotationStats.leftSisterLabels(t, parent));
            List<String> rightSis = this.listBasicCategories(SisterAnnotationStats.rightSisterLabels(t, parent));
            if (paRootDtr && baseParentStr.equals("ROOT")) {
                category = category + "^ROOT";
            }
            if (markIPsisterBA && baseCategory.equals("IP") && leftSis.contains("BA")) {
                category = category + "=BA";
            }
            if (dominatesV && ChineseTreebankParserParams.hasV(t.preTerminalYield())) {
                category = category + "-v";
            }
            if (markIPsisterVVorP && baseCategory.equals("IP") && (leftSis.contains("VV") || leftSis.contains("P"))) {
                category = category + "=VVP";
            }
            if (markIPsisDEC && baseCategory.equals("IP") && rightSis.contains("DEC")) {
                category = category + "=DEC";
            }
            if (baseCategory.equals("VP")) {
                if (chineseSplitVP == 3) {
                    boolean hasCC = false;
                    boolean hasPU = false;
                    boolean hasLexV = false;
                    for (Tree kid : kids) {
                        if (kid.label().value().startsWith("CC")) {
                            hasCC = true;
                            continue;
                        }
                        if (kid.label().value().startsWith("PU")) {
                            hasPU = true;
                            continue;
                        }
                        if (!StringUtils.lookingAt(kid.label().value(), "(V[ACEV]|VCD|VCP|VNV|VPT|VRD|VSB)")) continue;
                        hasLexV = true;
                    }
                    category = hasCC || hasPU && !hasLexV ? category + "-CRD" : (hasLexV ? category + "-COMP" : category + "-ADJT");
                } else if (chineseSplitVP >= 1) {
                    boolean hasBA = false;
                    for (Tree kid : kids) {
                        if (kid.label().value().startsWith("BA")) {
                            hasBA = true;
                            continue;
                        }
                        if (chineseSplitVP != 2 || !this.tlp.basicCategory(kid.label().value()).equals("VP")) continue;
                        Tree[] arr$ = kid.children();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Tree kidkid = arr$[i$];
                            if (!kidkid.label().value().startsWith("BA")) continue;
                            hasBA = true;
                        }
                    }
                    if (hasBA) {
                        category = category + "-BA";
                    }
                }
            }
            if (markVPadjunct && baseParentStr.equals("VP")) {
                Tree[] sisters = parent.children();
                boolean hasVPsister = false;
                boolean hasCC = false;
                boolean hasPU = false;
                boolean hasLexV = false;
                for (Tree sister : sisters) {
                    if (this.tlp.basicCategory(sister.label().value()).equals("VP")) {
                        hasVPsister = true;
                    }
                    if (sister.label().value().startsWith("CC")) {
                        hasCC = true;
                    }
                    if (sister.label().value().startsWith("PU")) {
                        hasPU = true;
                    }
                    if (!StringUtils.lookingAt(sister.label().value(), "(V[ACEV]|VCD|VCP|VNV|VPT|VRD|VSB)")) continue;
                    hasLexV = true;
                }
                if (hasVPsister && !hasCC && !hasPU && !hasLexV) {
                    category = category + "-VPADJ";
                }
            }
            if (markNPmodNP && baseCategory.equals("NP") && baseParentStr.equals("NP") && rightSis.contains("NP")) {
                category = category + "=MODIFIERNP";
            }
            if (markModifiedNP && baseCategory.equals("NP") && baseParentStr.equals("NP") && rightSis.isEmpty() && (leftSis.contains("ADJP") || leftSis.contains("NP") || leftSis.contains("DNP") || leftSis.contains("QP") || leftSis.contains("CP") || leftSis.contains("PP"))) {
                category = category + "=MODIFIEDNP";
            }
            if (markNPconj && baseCategory.equals("NP") && baseParentStr.equals("NP") && (rightSis.contains("CC") || rightSis.contains("PU") || leftSis.contains("CC") || leftSis.contains("PU"))) {
                category = category + "=CONJ";
            }
            if (markIPconj && baseCategory.equals("IP") && baseParentStr.equals("IP")) {
                Tree[] sisters = parent.children();
                boolean hasCommaSis = false;
                boolean hasIPSis = false;
                for (Tree sister : sisters) {
                    if (this.ctlp.basicCategory(sister.label().value()).equals("PU") && ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(((Object)sister.children()[0].label()).toString())) {
                        hasCommaSis = true;
                    }
                    if (!this.ctlp.basicCategory(sister.label().value()).equals("IP") || sister == t) continue;
                    hasIPSis = true;
                }
                if (hasCommaSis && hasIPSis) {
                    category = category + "-CONJ";
                }
            }
            if (unaryIP && baseCategory.equals("IP") && t.numChildren() == 1) {
                category = category + "-U";
            }
            if (unaryCP && baseCategory.equals("CP") && t.numChildren() == 1) {
                category = category + "-U";
            }
            if (splitBaseNP && baseCategory.equals("NP") && t.isPrePreTerminal()) {
                category = category + "-B";
            }
            if (markPostverbalPP && leftSis.contains("VV") && baseCategory.equals("PP")) {
                category = category + "=lVV";
            }
            if ((markADgrandchildOfIP || gpaAD) && this.listBasicCategories(SisterAnnotationStats.kidLabels(t)).contains("AD")) {
                category = category + "^ADVP";
            }
            if (markCC) {
                for (int i = 1; i < kids.length - 1; ++i) {
                    String cat2 = kids[i].label().value();
                    if (!cat2.startsWith("CC")) continue;
                    category = category + "-CC";
                }
            }
            CategoryWordTag label = new CategoryWordTag(category, word, tag);
            t.setLabel(label);
        }
        return t;
    }

    @Override
    public void display() {
        String chineseParams = "Using ChineseTreebankParserParams chineseSplitDouHao=" + chineseSplitDouHao + " chineseSplitPunct=" + chineseSplitPunct + " chineseSplitPunctLR=" + chineseSplitPunctLR + " markVVsisterIP=" + markVVsisterIP + " markVPadjunct=" + markVPadjunct + " chineseSplitVP=" + chineseSplitVP + " mergeNNVV=" + mergeNNVV + " unaryIP=" + unaryIP + " unaryCP=" + unaryCP + " paRootDtr=" + paRootDtr + " markPsisterIP=" + markPsisterIP + " markIPsisterVVorP=" + markIPsisterVVorP + " markADgrandchildOfIP=" + markADgrandchildOfIP + " gpaAD=" + gpaAD + " markIPsisterBA=" + markIPsisterBA + " markNPmodNP=" + markNPmodNP + " markNPconj=" + markNPconj + " markMultiNtag=" + markMultiNtag + " markIPsisDEC=" + markIPsisDEC + " markIPconj=" + markIPconj + " markIPadjsubj=" + markIPadjsubj + " markPostverbalP=" + markPostverbalP + " markPostverbalPP=" + markPostverbalPP + " baseNP=" + splitBaseNP + " headFinder=" + (this.sunJurafskyHeadFinder ? "sunJurafsky" : (this.bikelHeadFinder ? "bikel" : "levy")) + " discardFrags=" + this.discardFrags + " dominatesV=" + dominatesV;
        ChineseTreebankParserParams.printlnErr(chineseParams);
    }

    private List<String> listBasicCategories(List<String> l) {
        ArrayList<String> l1 = new ArrayList<String>();
        for (String s : l) {
            l1.add(this.ctlp.basicCategory(s));
        }
        return l1;
    }

    private static boolean hasV(List tags) {
        int tsize = tags.size();
        for (int i = 0; i < tsize; ++i) {
            String str = tags.get(i).toString();
            if (!str.startsWith("V")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-paRootDtr")) {
            paRootDtr = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryIP")) {
            unaryIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryCP")) {
            unaryCP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPostverbalP")) {
            markPostverbalP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPostverbalPP")) {
            markPostverbalPP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-baseNP")) {
            splitBaseNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markVVsisterIP")) {
            markVVsisterIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markPsisterIP")) {
            markPsisterIP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisterVVorP")) {
            markIPsisterVVorP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisterBA")) {
            markIPsisterBA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesV")) {
            dominatesV = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gpaAD")) {
            gpaAD = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markVPadjunct")) {
            markVPadjunct = Boolean.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markNPmodNP")) {
            markNPmodNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markModifiedNP")) {
            markModifiedNP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markNPconj")) {
            markNPconj = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitPunct")) {
            chineseSplitPunct = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitPunctLR")) {
            chineseSplitPunct = true;
            chineseSplitPunctLR = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSelectiveTagPA")) {
            chineseSelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseVerySelectiveTagPA")) {
            chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markIPsisDEC")) {
            markIPsisDEC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseSplitVP")) {
            chineseSplitVP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-tagWordSize")) {
            tagWordSize = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-vanilla")) {
            chineseSplitDouHao = false;
            chineseSplitPunct = false;
            chineseSplitPunctLR = false;
            markVVsisterIP = false;
            markPsisterIP = false;
            markIPsisterVVorP = false;
            markADgrandchildOfIP = false;
            gpaAD = false;
            markIPsisterBA = false;
            markVPadjunct = false;
            markNPmodNP = false;
            markModifiedNP = false;
            markNPconj = false;
            markMultiNtag = false;
            markIPsisDEC = false;
            markIPconj = false;
            markIPadjsubj = false;
            chineseSplitVP = 0;
            mergeNNVV = false;
            unaryIP = false;
            unaryCP = false;
            paRootDtr = false;
            markPostverbalP = false;
            markPostverbalPP = false;
            splitBaseNP = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-acl03chinese")) {
            Train.markovOrder = 1;
            Train.markovFactor = true;
            chineseSplitDouHao = false;
            chineseSplitPunct = true;
            chineseSplitPunctLR = true;
            markVVsisterIP = true;
            markPsisterIP = true;
            markIPsisterVVorP = true;
            markADgrandchildOfIP = false;
            gpaAD = true;
            markIPsisterBA = false;
            markVPadjunct = true;
            markNPmodNP = true;
            markModifiedNP = true;
            markNPconj = true;
            markMultiNtag = false;
            markIPsisDEC = true;
            markIPconj = false;
            markIPadjsubj = false;
            chineseSplitVP = 3;
            mergeNNVV = false;
            unaryIP = true;
            unaryCP = true;
            paRootDtr = true;
            markPostverbalP = false;
            markPostverbalPP = false;
            splitBaseNP = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chineseFactored")) {
            chineseSplitDouHao = false;
            chineseSplitPunct = true;
            chineseSplitPunctLR = true;
            markVVsisterIP = true;
            markPsisterIP = true;
            markIPsisterVVorP = true;
            markADgrandchildOfIP = false;
            gpaAD = true;
            markIPsisterBA = true;
            markVPadjunct = true;
            markNPmodNP = true;
            markModifiedNP = true;
            markNPconj = true;
            markMultiNtag = false;
            markIPsisDEC = true;
            markIPconj = false;
            markIPadjsubj = false;
            chineseSplitVP = 3;
            mergeNNVV = false;
            unaryIP = true;
            unaryCP = true;
            paRootDtr = true;
            markPostverbalP = false;
            markPostverbalPP = false;
            splitBaseNP = false;
            chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-chinesePCFG")) {
            Train.markovOrder = 2;
            Train.markovFactor = true;
            Train.HSEL_CUT = 5;
            Train.PA = true;
            Train.gPA = true;
            Train.selectiveSplit = false;
            chineseSplitDouHao = false;
            chineseSplitPunct = true;
            chineseSplitPunctLR = true;
            markVVsisterIP = true;
            markPsisterIP = false;
            markIPsisterVVorP = true;
            markADgrandchildOfIP = false;
            gpaAD = false;
            markIPsisterBA = true;
            markVPadjunct = true;
            markNPmodNP = true;
            markModifiedNP = true;
            markNPconj = false;
            markMultiNtag = false;
            markIPsisDEC = false;
            markIPconj = false;
            markIPadjsubj = false;
            chineseSplitVP = 0;
            mergeNNVV = false;
            unaryIP = false;
            unaryCP = false;
            paRootDtr = false;
            markPostverbalP = false;
            markPostverbalPP = false;
            splitBaseNP = false;
            chineseVerySelectiveTagPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-sunHead")) {
            this.sunJurafskyHeadFinder = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-bikelHead")) {
            this.bikelHeadFinder = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-discardFrags")) {
            this.discardFrags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-charLex")) {
            this.useCharacterBasedLexicon = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-charUnk")) {
            ChineseLexicon.useCharBasedUnknownWordModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gtUnknown")) {
            ChineseLexicon.useGoodTuringUnknownWordModel = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentUnk")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-tuneSigma")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-trainCountThresh") && i + 1 < args.length) {
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markCC")) {
            markCC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentMarkov") || args[i].equalsIgnoreCase("-segmentWords")) {
            this.segmentMarkov = true;
            try {
                this.segmenter = (WordSegmenter)Class.forName("edu.stanford.nlp.parser.lexparser.ChineseMarkovWordSegmenter").newInstance();
            }
            catch (Exception e) {
                ChineseTreebankParserParams.printlnErr("Couldn't instantiate segmenter edu.stanford.nlp.parser.lexparser.ChineseMarkovWordSegmenter: " + e);
            }
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentMaxMatch")) {
            this.segmentMaxMatch = true;
            try {
                this.segmenter = (WordSegmenter)Class.forName("edu.stanford.nlp.parser.lexparser.MaxMatchSegmenter").newInstance();
            }
            catch (Exception e) {
                ChineseTreebankParserParams.printlnErr("Couldn't instantiate segmenter edu.stanford.nlp.parser.lexparser.MaxMatchSegmenter: " + e);
            }
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmentDPMaxMatch")) {
            this.segmentMaxMatch = true;
            try {
                this.segmenter = (WordSegmenter)Class.forName("edu.stanford.nlp.wordseg.MaxMatchSegmenter").newInstance();
            }
            catch (Exception e) {
                ChineseTreebankParserParams.printlnErr("Couldn't instantiate segmenter edu.stanford.nlp.wordseg.MaxMatchSegmenter: " + e);
            }
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLex")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-fixUnkFunctionWords")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-similarWordSmoothing")) {
            this.useSimilarWordMap = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLexSeenTagsOnly")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-maxentLexFeatLevel") && i + 1 < args.length) {
            i += 2;
        } else if (args[i].equalsIgnoreCase("-maxentDepGrammarFeatLevel") && i + 1 < args.length) {
            this.depGramFeatureLevel = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-maxentDepGrammar")) {
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNPTMP")) {
            splitNPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitPPTMP")) {
            splitPPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitXPTMP")) {
            splitXPTMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-segmenter")) {
            try {
                this.segmenter = (WordSegmenter)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                ChineseTreebankParserParams.printlnErr("Couldn't instantiate segmenter " + args[i + 1] + ": " + e);
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
            }
            i += 2;
        }
        return i;
    }

    @Override
    public Extractor<DependencyGrammar> dependencyGrammarExtractor(Options op) {
        if (this.useSimilarWordMap) {
            return new MLEDependencyGrammarExtractor(op){

                public MLEDependencyGrammar formResult() {
                    this.wordNumberer.number("UNK");
                    ChineseSimWordAvgDepGrammar dg = new ChineseSimWordAvgDepGrammar(this.tlpParams, this.directional, this.useDistance, this.useCoarseDistance);
                    if (ChineseTreebankParserParams.this.lex == null) {
                        throw new RuntimeException("Attempt to create ChineseSimWordAvgDepGrammar before Lexicon!!!");
                    }
                    dg.setLex(ChineseTreebankParserParams.this.lex);
                    for (IntDependency dependency : this.dependencyCounter.keySet()) {
                        dg.addRule(dependency, this.dependencyCounter.getCount(dependency));
                    }
                    return dg;
                }
            };
        }
        return new MLEDependencyGrammarExtractor(op);
    }

    public ArrayList<Word> defaultTestSentence() {
        return Sentence.toUntaggedList("\u951f\u65a4\u62f7", "\u951f\u65a4\u62f7", "\u5b66\u6821", "\u951f\u65a4\u62f7", "\u5b66\u4e60", "\u951f\u65a4\u62f7");
    }

    public static void main(String[] args) {
        ChineseTreebankParserParams tlpp = new ChineseTreebankParserParams();
        System.out.println("Default encoding is: " + tlpp.diskTreebank().encoding());
        if (args.length < 2) {
            ChineseTreebankParserParams.printlnErr("Usage: edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams treesPath fileRange");
        } else {
            DiskTreebank m = tlpp.diskTreebank();
            m.loadPath(args[0], (FileFilter)new NumberRangesFileFilter(args[1], false));
            for (Tree t : m) {
                t.pennPrint(tlpp.pw());
            }
            System.out.println("There were " + m.size() + " trees.");
        }
    }
}

