/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.common.util.concurrent.ListenableFuture;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.NotifyOnceListener;

public final class StepListener<Response>
extends NotifyOnceListener<Response> {
    private final ListenableFuture<Response> delegate = new ListenableFuture();

    protected void innerOnResponse(Response response) {
        this.delegate.onResponse(response);
    }

    protected void innerOnFailure(Exception e) {
        this.delegate.onFailure(e);
    }

    public void whenComplete(CheckedConsumer<Response, Exception> onResponse, Consumer<Exception> onFailure) {
        this.delegate.addListener(ActionListener.wrap(onResponse, onFailure), OpenSearchExecutors.newDirectExecutorService(), null);
    }

    public Response result() {
        if (!this.delegate.isDone()) {
            throw new IllegalStateException("step is not completed yet");
        }
        return FutureUtils.get(this.delegate, 0L, TimeUnit.NANOSECONDS);
    }
}

