/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    public static final String LATEST_PROTOCOL_VERSION = "2024-11-05";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String METHOD_RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        HashMap map = (HashMap)objectMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    private static JsonSchema parseSchema(String schema) {
        try {
            return (JsonSchema)OBJECT_MAPPER.readValue(schema, JsonSchema.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCRequest(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="id") Object id, @JsonProperty(value="params") Object params) implements JSONRPCMessage
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JSONRPCMessage {
        public String jsonrpc();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCNotification(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="method") String method, @JsonProperty(value="params") Object params) implements JSONRPCMessage
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JSONRPCResponse(@JsonProperty(value="jsonrpc") String jsonrpc, @JsonProperty(value="id") Object id, @JsonProperty(value="result") Object result, @JsonProperty(value="error") JSONRPCError error) implements JSONRPCMessage
    {

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record JSONRPCError(@JsonProperty(value="code") int code, @JsonProperty(value="message") String message, @JsonProperty(value="data") Object data) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record JsonSchema(@JsonProperty(value="type") String type, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="required") List<String> required, @JsonProperty(value="additionalProperties") Boolean additionalProperties) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListRootsResult(@JsonProperty(value="roots") List<Root> roots) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Root(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddedResource(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="resource") ResourceContents resource) implements Content
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ImageContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="data") String data, @JsonProperty(value="mimeType") String mimeType) implements Content
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TextContent(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority, @JsonProperty(value="text") String text) implements Content
    {
        public TextContent(String content) {
            this(null, null, content);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource")})
    public static interface Content {
        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            throw new IllegalArgumentException("Unknown content type: " + String.valueOf(this));
        }
    }

    public record CompleteResult(CompleteCompletion completion) {

        public record CompleteCompletion(@JsonProperty(value="values") List<String> values, @JsonProperty(value="total") Integer total, @JsonProperty(value="hasMore") Boolean hasMore) {
        }
    }

    public record CompleteRequest(PromptOrResourceReference ref, CompleteArgument argument) implements Request
    {

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static interface PromptOrResourceReference {
            public String type();
        }

        public record CompleteArgument(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        }

        public record ResourceReference(@JsonProperty(value="type") String type, @JsonProperty(value="uri") String uri) implements PromptOrResourceReference
        {
        }

        public record PromptReference(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name) implements PromptOrResourceReference
        {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SetLevelRequest(@JsonProperty(value="level") LoggingLevel level) {
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record LoggingMessageNotification(@JsonProperty(value="level") LoggingLevel level, @JsonProperty(value="logger") String logger, @JsonProperty(value="data") String data) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private LoggingLevel level = LoggingLevel.INFO;
            private String logger = "server";
            private String data;

            public Builder level(LoggingLevel level) {
                this.level = level;
                return this;
            }

            public Builder logger(String logger) {
                this.logger = logger;
                return this;
            }

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public LoggingMessageNotification build() {
                return new LoggingMessageNotification(this.level, this.logger, this.data);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ProgressNotification(@JsonProperty(value="progressToken") String progressToken, @JsonProperty(value="progress") double progress, @JsonProperty(value="total") Double total) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PaginatedResult(@JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PaginatedRequest(@JsonProperty(value="cursor") String cursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CreateMessageResult(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content, @JsonProperty(value="model") String model, @JsonProperty(value="stopReason") StopReason stopReason) {
        public static Builder builder() {
            return new Builder();
        }

        public static enum StopReason {
            END_TURN,
            STOP_SEQUENCE,
            MAX_TOKENS;

        }

        public static class Builder {
            private Role role = Role.ASSISTANT;
            private Content content;
            private String model;
            private StopReason stopReason = StopReason.END_TURN;

            public Builder role(Role role) {
                this.role = role;
                return this;
            }

            public Builder content(Content content) {
                this.content = content;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder stopReason(StopReason stopReason) {
                this.stopReason = stopReason;
                return this;
            }

            public Builder message(String message) {
                this.content = new TextContent(message);
                return this;
            }

            public CreateMessageResult build() {
                return new CreateMessageResult(this.role, this.content, this.model, this.stopReason);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CreateMessageRequest(@JsonProperty(value="messages") List<SamplingMessage> messages, @JsonProperty(value="modelPreferences") ModelPreferences modelPreferences, @JsonProperty(value="systemPrompt") String systemPrompt, @JsonProperty(value="includeContext") ContextInclusionStrategy includeContext, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="maxTokens") int maxTokens, @JsonProperty(value="stopSequences") List<String> stopSequences, @JsonProperty(value="metadata") Map<String, Object> metadata) implements Request
    {
        public static Builder builder() {
            return new Builder();
        }

        public static enum ContextInclusionStrategy {
            NONE,
            THIS_SERVER,
            ALL_SERVERS;

        }

        public static class Builder {
            private List<SamplingMessage> messages;
            private ModelPreferences modelPreferences;
            private String systemPrompt;
            private ContextInclusionStrategy includeContext;
            private Double temperature;
            private int maxTokens;
            private List<String> stopSequences;
            private Map<String, Object> metadata;

            public Builder messages(List<SamplingMessage> messages) {
                this.messages = messages;
                return this;
            }

            public Builder modelPreferences(ModelPreferences modelPreferences) {
                this.modelPreferences = modelPreferences;
                return this;
            }

            public Builder systemPrompt(String systemPrompt) {
                this.systemPrompt = systemPrompt;
                return this;
            }

            public Builder includeContext(ContextInclusionStrategy includeContext) {
                this.includeContext = includeContext;
                return this;
            }

            public Builder temperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder maxTokens(int maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder metadata(Map<String, Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            public CreateMessageRequest build() {
                return new CreateMessageRequest(this.messages, this.modelPreferences, this.systemPrompt, this.includeContext, this.temperature, this.maxTokens, this.stopSequences, this.metadata);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SamplingMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ModelHint(@JsonProperty(value="name") String name) {
        public static ModelHint of(String name) {
            return new ModelHint(name);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ModelPreferences(@JsonProperty(value="hints") List<ModelHint> hints, @JsonProperty(value="costPriority") Double costPriority, @JsonProperty(value="speedPriority") Double speedPriority, @JsonProperty(value="intelligencePriority") Double intelligencePriority) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<ModelHint> hints;
            private Double costPriority;
            private Double speedPriority;
            private Double intelligencePriority;

            public Builder hints(List<ModelHint> hints) {
                this.hints = hints;
                return this;
            }

            public Builder addHint(String name) {
                if (this.hints == null) {
                    this.hints = new ArrayList<ModelHint>();
                }
                this.hints.add(new ModelHint(name));
                return this;
            }

            public Builder costPriority(Double costPriority) {
                this.costPriority = costPriority;
                return this;
            }

            public Builder speedPriority(Double speedPriority) {
                this.speedPriority = speedPriority;
                return this;
            }

            public Builder intelligencePriority(Double intelligencePriority) {
                this.intelligencePriority = intelligencePriority;
                return this;
            }

            public ModelPreferences build() {
                return new ModelPreferences(this.hints, this.costPriority, this.speedPriority, this.intelligencePriority);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CallToolResult(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="isError") Boolean isError) {
        public CallToolResult(String content, Boolean isError) {
            this(List.of(new TextContent(content)), isError);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<Content> content = new ArrayList<Content>();
            private Boolean isError;

            public Builder content(List<Content> content) {
                Assert.notNull(content, "content must not be null");
                this.content = content;
                return this;
            }

            public Builder textContent(List<String> textContent) {
                Assert.notNull(textContent, "textContent must not be null");
                textContent.stream().map(TextContent::new).forEach(this.content::add);
                return this;
            }

            public Builder addContent(Content contentItem) {
                Assert.notNull(contentItem, "contentItem must not be null");
                if (this.content == null) {
                    this.content = new ArrayList<Content>();
                }
                this.content.add(contentItem);
                return this;
            }

            public Builder addTextContent(String text) {
                Assert.notNull(text, "text must not be null");
                return this.addContent(new TextContent(text));
            }

            public Builder isError(Boolean isError) {
                Assert.notNull(isError, "isError must not be null");
                this.isError = isError;
                return this;
            }

            public CallToolResult build() {
                return new CallToolResult(this.content, this.isError);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CallToolRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments) implements Request
    {
        public CallToolRequest(String name, String jsonArguments) {
            this(name, CallToolRequest.parseJsonArguments(jsonArguments));
        }

        private static Map<String, Object> parseJsonArguments(String jsonArguments) {
            try {
                return (Map)OBJECT_MAPPER.readValue(jsonArguments, MAP_TYPE_REF);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid arguments: " + jsonArguments, e);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Tool(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="inputSchema") JsonSchema inputSchema) {
        public Tool(String name, String description, String schema) {
            this(name, description, McpSchema.parseSchema(schema));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListToolsResult(@JsonProperty(value="tools") List<Tool> tools, @JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record GetPromptResult(@JsonProperty(value="description") String description, @JsonProperty(value="messages") List<PromptMessage> messages) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record GetPromptRequest(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments) implements Request
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListPromptsResult(@JsonProperty(value="prompts") List<Prompt> prompts, @JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PromptMessage(@JsonProperty(value="role") Role role, @JsonProperty(value="content") Content content) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record PromptArgument(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="required") Boolean required) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Prompt(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="arguments") List<PromptArgument> arguments) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record BlobResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="blob") String blob) implements ResourceContents
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TextResourceContents(@JsonProperty(value="uri") String uri, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="text") String text) implements ResourceContents
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents {
        public String uri();

        public String mimeType();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record UnsubscribeRequest(@JsonProperty(value="uri") String uri) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record SubscribeRequest(@JsonProperty(value="uri") String uri) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ReadResourceResult(@JsonProperty(value="contents") List<ResourceContents> contents) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ReadResourceRequest(@JsonProperty(value="uri") String uri) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListResourceTemplatesResult(@JsonProperty(value="resourceTemplates") List<ResourceTemplate> resourceTemplates, @JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListResourcesResult(@JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="nextCursor") String nextCursor) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ResourceTemplate(@JsonProperty(value="uriTemplate") String uriTemplate, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) implements Annotated
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Resource(@JsonProperty(value="uri") String uri, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="annotations") Annotations annotations) implements Annotated
    {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Annotations(@JsonProperty(value="audience") List<Role> audience, @JsonProperty(value="priority") Double priority) {
    }

    public static interface Annotated {
        public Annotations annotations();
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Implementation(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ServerCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="logging") LoggingCapabilities logging, @JsonProperty(value="prompts") PromptCapabilities prompts, @JsonProperty(value="resources") ResourceCapabilities resources, @JsonProperty(value="tools") ToolCapabilities tools) {
        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record LoggingCapabilities() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record PromptCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record ResourceCapabilities(@JsonProperty(value="subscribe") Boolean subscribe, @JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record ToolCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private LoggingCapabilities logging = new LoggingCapabilities();
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging() {
                this.logging = new LoggingCapabilities();
                return this;
            }

            public Builder prompts(Boolean listChanged) {
                this.prompts = new PromptCapabilities(listChanged);
                return this;
            }

            public Builder resources(Boolean subscribe, Boolean listChanged) {
                this.resources = new ResourceCapabilities(subscribe, listChanged);
                return this;
            }

            public Builder tools(Boolean listChanged) {
                this.tools = new ToolCapabilities(listChanged);
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ClientCapabilities(@JsonProperty(value="experimental") Map<String, Object> experimental, @JsonProperty(value="roots") RootCapabilities roots, @JsonProperty(value="sampling") Sampling sampling) {
        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record RootCapabilities(@JsonProperty(value="listChanged") Boolean listChanged) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public record Sampling() {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootCapabilities roots;
            private Sampling sampling;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(Boolean listChanged) {
                this.roots = new RootCapabilities(listChanged);
                return this;
            }

            public Builder sampling() {
                this.sampling = new Sampling();
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record InitializeResult(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ServerCapabilities capabilities, @JsonProperty(value="serverInfo") Implementation serverInfo, @JsonProperty(value="instructions") String instructions) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record InitializeRequest(@JsonProperty(value="protocolVersion") String protocolVersion, @JsonProperty(value="capabilities") ClientCapabilities capabilities, @JsonProperty(value="clientInfo") Implementation clientInfo) implements Request
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Request {
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
    }
}

