/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.time.Duration;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0080\b\u0018\u0000 12\u00020\u0001:\t-./012345B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\rH\u00c6\u0003JG\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "name", "", "isEnabled", "", "source", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Source;", "format", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;", "trigger", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger;", "delivery", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery;", "<init>", "(Ljava/lang/String;ZLorg/opensearch/reportsscheduler/model/ReportDefinition$Source;Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger;Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery;)V", "getName", "()Ljava/lang/String;", "()Z", "getSource", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$Source;", "getFormat", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;", "getTrigger", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger;", "getDelivery", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "builder", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "SourceType", "TriggerType", "DeliveryFormat", "FileFormat", "Companion", "Source", "Format", "Trigger", "Delivery", "opensearch-reports-scheduler"})
public final class ReportDefinition
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean isEnabled;
    @NotNull
    private final Source source;
    @NotNull
    private final Format format;
    @NotNull
    private final Trigger trigger;
    @Nullable
    private final Delivery delivery;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(ReportDefinition.class);
    @NotNull
    private static final String NAME_TAG = "name";
    @NotNull
    private static final String IS_ENABLED_TAG = "isEnabled";
    @NotNull
    private static final String SOURCE_TAG = "source";
    @NotNull
    private static final String FORMAT_TAG = "format";
    @NotNull
    private static final String TRIGGER_TAG = "trigger";
    @NotNull
    private static final String DELIVERY_TAG = "delivery";

    public ReportDefinition(@NotNull String name, boolean isEnabled, @NotNull Source source, @NotNull Format format, @NotNull Trigger trigger, @Nullable Delivery delivery) {
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_TAG);
        Intrinsics.checkNotNullParameter((Object)source, (String)SOURCE_TAG);
        Intrinsics.checkNotNullParameter((Object)format, (String)FORMAT_TAG);
        Intrinsics.checkNotNullParameter((Object)trigger, (String)TRIGGER_TAG);
        this.name = name;
        this.isEnabled = isEnabled;
        this.source = source;
        this.format = format;
        this.trigger = trigger;
        this.delivery = delivery;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    @NotNull
    public final Format getFormat() {
        return this.format;
    }

    @NotNull
    public final Trigger getTrigger() {
        return this.trigger;
    }

    @Nullable
    public final Delivery getDelivery() {
        return this.delivery;
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(ReportDefinition reportDefinition, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            params = ToXContent.EMPTY_PARAMS;
        }
        return reportDefinition.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        builder.startObject().field(NAME_TAG, this.name).field(IS_ENABLED_TAG, this.isEnabled);
        builder.field(SOURCE_TAG);
        this.source.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.field(FORMAT_TAG);
        this.format.toXContent(builder, ToXContent.EMPTY_PARAMS);
        builder.field(TRIGGER_TAG);
        this.trigger.toXContent(builder, ToXContent.EMPTY_PARAMS);
        if (this.delivery != null) {
            builder.field(DELIVERY_TAG);
            this.delivery.toXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        builder.endObject();
        return builder;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final boolean component2() {
        return this.isEnabled;
    }

    @NotNull
    public final Source component3() {
        return this.source;
    }

    @NotNull
    public final Format component4() {
        return this.format;
    }

    @NotNull
    public final Trigger component5() {
        return this.trigger;
    }

    @Nullable
    public final Delivery component6() {
        return this.delivery;
    }

    @NotNull
    public final ReportDefinition copy(@NotNull String name, boolean isEnabled, @NotNull Source source, @NotNull Format format, @NotNull Trigger trigger, @Nullable Delivery delivery) {
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_TAG);
        Intrinsics.checkNotNullParameter((Object)source, (String)SOURCE_TAG);
        Intrinsics.checkNotNullParameter((Object)format, (String)FORMAT_TAG);
        Intrinsics.checkNotNullParameter((Object)trigger, (String)TRIGGER_TAG);
        return new ReportDefinition(name, isEnabled, source, format, trigger, delivery);
    }

    public static /* synthetic */ ReportDefinition copy$default(ReportDefinition reportDefinition, String string, boolean bl, Source source, Format format, Trigger trigger, Delivery delivery, int n, Object object) {
        if ((n & 1) != 0) {
            string = reportDefinition.name;
        }
        if ((n & 2) != 0) {
            bl = reportDefinition.isEnabled;
        }
        if ((n & 4) != 0) {
            source = reportDefinition.source;
        }
        if ((n & 8) != 0) {
            format = reportDefinition.format;
        }
        if ((n & 0x10) != 0) {
            trigger = reportDefinition.trigger;
        }
        if ((n & 0x20) != 0) {
            delivery = reportDefinition.delivery;
        }
        return reportDefinition.copy(string, bl, source, format, trigger, delivery);
    }

    @NotNull
    public String toString() {
        return "ReportDefinition(name=" + this.name + ", isEnabled=" + this.isEnabled + ", source=" + this.source + ", format=" + this.format + ", trigger=" + this.trigger + ", delivery=" + this.delivery + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Boolean.hashCode(this.isEnabled);
        result = result * 31 + this.source.hashCode();
        result = result * 31 + this.format.hashCode();
        result = result * 31 + this.trigger.hashCode();
        result = result * 31 + (this.delivery == null ? 0 : this.delivery.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition reportDefinition = (ReportDefinition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)reportDefinition.name)) {
            return false;
        }
        if (this.isEnabled != reportDefinition.isEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.source, (Object)reportDefinition.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.format, (Object)reportDefinition.format)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.trigger, (Object)reportDefinition.trigger)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.delivery, (Object)reportDefinition.delivery);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "NAME_TAG", "", "IS_ENABLED_TAG", "SOURCE_TAG", "FORMAT_TAG", "TRIGGER_TAG", "DELIVERY_TAG", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinition;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final ReportDefinition parse(@NotNull XContentParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String name = null;
            boolean isEnabled = false;
            Source source = null;
            Format format = null;
            Trigger trigger = null;
            Delivery delivery = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block16: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName;
                block27: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block27;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 823466996: {
                            if (string.equals(ReportDefinition.DELIVERY_TAG)) {
                                n = 1;
                            }
                            break;
                        }
                        case 2105594551: {
                            if (string.equals(ReportDefinition.IS_ENABLED_TAG)) {
                                n = 2;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals(ReportDefinition.NAME_TAG)) {
                                n = 3;
                            }
                            break;
                        }
                        case -1268779017: {
                            if (string.equals(ReportDefinition.FORMAT_TAG)) {
                                n = 4;
                            }
                            break;
                        }
                        case -896505829: {
                            if (string.equals(ReportDefinition.SOURCE_TAG)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1059891784: {
                            if (string.equals(ReportDefinition.TRIGGER_TAG)) {
                                n = 6;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            name = parser.text();
                            continue block16;
                        }
                        case 2: {
                            isEnabled = parser.booleanValue();
                            continue block16;
                        }
                        case 5: {
                            source = Source.Companion.parse(parser);
                            continue block16;
                        }
                        case 4: {
                            format = Format.Companion.parse(parser);
                            continue block16;
                        }
                        case 6: {
                            trigger = Trigger.Companion.parse(parser);
                            continue block16;
                        }
                        case 1: {
                            delivery = Delivery.Companion.parse(parser);
                            continue block16;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("reports:ReportDefinition Skipping Unknown field " + fieldName);
            }
            if (name == null) {
                throw new IllegalArgumentException("name field absent");
            }
            if (source == null) {
                throw new IllegalArgumentException("source field absent");
            }
            if (format == null) {
                throw new IllegalArgumentException("format field absent");
            }
            if (trigger == null) {
                throw new IllegalArgumentException("trigger field absent");
            }
            return new ReportDefinition(name, isEnabled, source, format, trigger, delivery);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 !2\u00020\u0001:\u0001!B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "title", "", "textDescription", "htmlDescription", "configIds", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "getTextDescription", "getHtmlDescription", "getConfigIds", "()Ljava/util/List;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-reports-scheduler"})
    public static final class Delivery
    implements ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String title;
        @NotNull
        private final String textDescription;
        @Nullable
        private final String htmlDescription;
        @NotNull
        private final List<String> configIds;
        @NotNull
        private static final String TITLE_TAG = "title";
        @NotNull
        private static final String TEXT_DESCRIPTION_TAG = "textDescription";
        @NotNull
        private static final String HTML_DESCRIPTION_TAG = "htmlDescription";
        @NotNull
        private static final String CONFIG_IDS_TAG = "configIds";

        public Delivery(@NotNull String title, @NotNull String textDescription, @Nullable String htmlDescription, @NotNull List<String> configIds) {
            Intrinsics.checkNotNullParameter((Object)title, (String)TITLE_TAG);
            Intrinsics.checkNotNullParameter((Object)textDescription, (String)TEXT_DESCRIPTION_TAG);
            Intrinsics.checkNotNullParameter(configIds, (String)CONFIG_IDS_TAG);
            this.title = title;
            this.textDescription = textDescription;
            this.htmlDescription = htmlDescription;
            this.configIds = configIds;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getTextDescription() {
            return this.textDescription;
        }

        @Nullable
        public final String getHtmlDescription() {
            return this.htmlDescription;
        }

        @NotNull
        public final List<String> getConfigIds() {
            return this.configIds;
        }

        @NotNull
        public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNull((Object)builder);
            builder.startObject().field(TITLE_TAG, this.title).field(TEXT_DESCRIPTION_TAG, this.textDescription);
            if (this.htmlDescription != null) {
                builder.field(HTML_DESCRIPTION_TAG, this.htmlDescription);
            }
            builder.field(CONFIG_IDS_TAG, (Iterable)this.configIds);
            builder.endObject();
            return builder;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.textDescription;
        }

        @Nullable
        public final String component3() {
            return this.htmlDescription;
        }

        @NotNull
        public final List<String> component4() {
            return this.configIds;
        }

        @NotNull
        public final Delivery copy(@NotNull String title, @NotNull String textDescription, @Nullable String htmlDescription, @NotNull List<String> configIds) {
            Intrinsics.checkNotNullParameter((Object)title, (String)TITLE_TAG);
            Intrinsics.checkNotNullParameter((Object)textDescription, (String)TEXT_DESCRIPTION_TAG);
            Intrinsics.checkNotNullParameter(configIds, (String)CONFIG_IDS_TAG);
            return new Delivery(title, textDescription, htmlDescription, configIds);
        }

        public static /* synthetic */ Delivery copy$default(Delivery delivery, String string, String string2, String string3, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = delivery.title;
            }
            if ((n & 2) != 0) {
                string2 = delivery.textDescription;
            }
            if ((n & 4) != 0) {
                string3 = delivery.htmlDescription;
            }
            if ((n & 8) != 0) {
                list = delivery.configIds;
            }
            return delivery.copy(string, string2, string3, list);
        }

        @NotNull
        public String toString() {
            return "Delivery(title=" + this.title + ", textDescription=" + this.textDescription + ", htmlDescription=" + this.htmlDescription + ", configIds=" + this.configIds + ")";
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = result * 31 + this.textDescription.hashCode();
            result = result * 31 + (this.htmlDescription == null ? 0 : this.htmlDescription.hashCode());
            result = result * 31 + ((Object)this.configIds).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Delivery)) {
                return false;
            }
            Delivery delivery = (Delivery)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)delivery.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textDescription, (Object)delivery.textDescription)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.htmlDescription, (Object)delivery.htmlDescription)) {
                return false;
            }
            return Intrinsics.areEqual(this.configIds, delivery.configIds);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery$Companion;", "", "<init>", "()V", "TITLE_TAG", "", "TEXT_DESCRIPTION_TAG", "HTML_DESCRIPTION_TAG", "CONFIG_IDS_TAG", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Delivery;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-reports-scheduler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Delivery parse(@NotNull XContentParser parser) {
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                String title = null;
                String textDescription = null;
                String htmlDescription = null;
                List<String> configIds = CollectionsKt.emptyList();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                block12: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                    String fieldName;
                    block19: {
                        fieldName = parser.currentName();
                        parser.nextToken();
                        String string = fieldName;
                        if (string == null) break block19;
                        int n = -1;
                        switch (string.hashCode()) {
                            case 443930767: {
                                if (string.equals(Delivery.TEXT_DESCRIPTION_TAG)) {
                                    n = 1;
                                }
                                break;
                            }
                            case -804471786: {
                                if (string.equals(Delivery.CONFIG_IDS_TAG)) {
                                    n = 2;
                                }
                                break;
                            }
                            case 110371416: {
                                if (string.equals(Delivery.TITLE_TAG)) {
                                    n = 3;
                                }
                                break;
                            }
                            case -1560462511: {
                                if (string.equals(Delivery.HTML_DESCRIPTION_TAG)) {
                                    n = 4;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 3: {
                                title = parser.text();
                                continue block12;
                            }
                            case 1: {
                                textDescription = parser.text();
                                continue block12;
                            }
                            case 4: {
                                htmlDescription = parser.textOrNull();
                                continue block12;
                            }
                            case 2: {
                                configIds = HelpersKt.stringList(parser);
                                continue block12;
                            }
                        }
                    }
                    ReportDefinition.Companion.getLog().info("reports: Delivery Unknown field " + fieldName);
                }
                if (title == null) {
                    throw new IllegalArgumentException("title field absent");
                }
                if (textDescription == null) {
                    throw new IllegalArgumentException("textDescription field absent");
                }
                return new Delivery(title, textDescription, htmlDescription, configIds);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$DeliveryFormat;", "", "<init>", "(Ljava/lang/String;I)V", "LinkOnly", "Attachment", "Embedded", "opensearch-reports-scheduler"})
    public static final class DeliveryFormat
    extends Enum<DeliveryFormat> {
        public static final /* enum */ DeliveryFormat LinkOnly = new DeliveryFormat();
        public static final /* enum */ DeliveryFormat Attachment = new DeliveryFormat();
        public static final /* enum */ DeliveryFormat Embedded = new DeliveryFormat();
        private static final /* synthetic */ DeliveryFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DeliveryFormat[] values() {
            return (DeliveryFormat[])$VALUES.clone();
        }

        public static DeliveryFormat valueOf(String value) {
            return Enum.valueOf(DeliveryFormat.class, value);
        }

        @NotNull
        public static EnumEntries<DeliveryFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deliveryFormatArray = new DeliveryFormat[]{DeliveryFormat.LinkOnly, DeliveryFormat.Attachment, DeliveryFormat.Embedded};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$FileFormat;", "", "<init>", "(Ljava/lang/String;I)V", "Pdf", "Png", "Csv", "Xlsx", "opensearch-reports-scheduler"})
    public static final class FileFormat
    extends Enum<FileFormat> {
        public static final /* enum */ FileFormat Pdf = new FileFormat();
        public static final /* enum */ FileFormat Png = new FileFormat();
        public static final /* enum */ FileFormat Csv = new FileFormat();
        public static final /* enum */ FileFormat Xlsx = new FileFormat();
        private static final /* synthetic */ FileFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileFormat[] values() {
            return (FileFormat[])$VALUES.clone();
        }

        public static FileFormat valueOf(String value) {
            return Enum.valueOf(FileFormat.class, value);
        }

        @NotNull
        public static EnumEntries<FileFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileFormatArray = new FileFormat[]{FileFormat.Pdf, FileFormat.Png, FileFormat.Csv, FileFormat.Xlsx};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u0000 /2\u00020\u0001:\u0001/BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010#\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\tH\u00c6\u0003J^\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0007H\u00d6\u0001J\t\u0010.\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u00060"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "duration", "Ljava/time/Duration;", "fileFormat", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$FileFormat;", "limit", "", "header", "", "footer", "timeFrom", "timeTo", "<init>", "(Ljava/time/Duration;Lorg/opensearch/reportsscheduler/model/ReportDefinition$FileFormat;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDuration", "()Ljava/time/Duration;", "getFileFormat", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$FileFormat;", "getLimit", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHeader", "()Ljava/lang/String;", "getFooter", "getTimeFrom", "getTimeTo", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/time/Duration;Lorg/opensearch/reportsscheduler/model/ReportDefinition$FileFormat;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;", "equals", "", "other", "", "hashCode", "toString", "Companion", "opensearch-reports-scheduler"})
    public static final class Format
    implements ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Duration duration;
        @NotNull
        private final FileFormat fileFormat;
        @Nullable
        private final Integer limit;
        @Nullable
        private final String header;
        @Nullable
        private final String footer;
        @Nullable
        private final String timeFrom;
        @Nullable
        private final String timeTo;
        @NotNull
        private static final String DURATION_TAG = "duration";
        @NotNull
        private static final String FILE_FORMAT_TAG = "fileFormat";
        @NotNull
        private static final String LIMIT_TAG = "limit";
        @NotNull
        private static final String HEADER_TAG = "header";
        @NotNull
        private static final String FOOTER_TAG = "footer";
        @NotNull
        private static final String TIME_FROM_TAG = "timeFrom";
        @NotNull
        private static final String TIME_TO_TAG = "timeTo";

        public Format(@NotNull Duration duration, @NotNull FileFormat fileFormat, @Nullable Integer limit, @Nullable String header, @Nullable String footer, @Nullable String timeFrom, @Nullable String timeTo) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)DURATION_TAG);
            Intrinsics.checkNotNullParameter((Object)((Object)fileFormat), (String)FILE_FORMAT_TAG);
            this.duration = duration;
            this.fileFormat = fileFormat;
            this.limit = limit;
            this.header = header;
            this.footer = footer;
            this.timeFrom = timeFrom;
            this.timeTo = timeTo;
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @NotNull
        public final FileFormat getFileFormat() {
            return this.fileFormat;
        }

        @Nullable
        public final Integer getLimit() {
            return this.limit;
        }

        @Nullable
        public final String getHeader() {
            return this.header;
        }

        @Nullable
        public final String getFooter() {
            return this.footer;
        }

        @Nullable
        public final String getTimeFrom() {
            return this.timeFrom;
        }

        @Nullable
        public final String getTimeTo() {
            return this.timeTo;
        }

        @NotNull
        public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNull((Object)builder);
            builder.startObject().field(DURATION_TAG, this.duration.toString()).field(FILE_FORMAT_TAG, this.fileFormat.name());
            if (this.limit != null) {
                builder.field(LIMIT_TAG, this.limit.intValue());
            }
            if (this.header != null) {
                builder.field(HEADER_TAG, this.header);
            }
            if (this.footer != null) {
                builder.field(FOOTER_TAG, this.footer);
            }
            builder.field(TIME_FROM_TAG, this.timeFrom);
            builder.field(TIME_TO_TAG, this.timeTo);
            builder.endObject();
            return builder;
        }

        @NotNull
        public final Duration component1() {
            return this.duration;
        }

        @NotNull
        public final FileFormat component2() {
            return this.fileFormat;
        }

        @Nullable
        public final Integer component3() {
            return this.limit;
        }

        @Nullable
        public final String component4() {
            return this.header;
        }

        @Nullable
        public final String component5() {
            return this.footer;
        }

        @Nullable
        public final String component6() {
            return this.timeFrom;
        }

        @Nullable
        public final String component7() {
            return this.timeTo;
        }

        @NotNull
        public final Format copy(@NotNull Duration duration, @NotNull FileFormat fileFormat, @Nullable Integer limit, @Nullable String header, @Nullable String footer, @Nullable String timeFrom, @Nullable String timeTo) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)DURATION_TAG);
            Intrinsics.checkNotNullParameter((Object)((Object)fileFormat), (String)FILE_FORMAT_TAG);
            return new Format(duration, fileFormat, limit, header, footer, timeFrom, timeTo);
        }

        public static /* synthetic */ Format copy$default(Format format, Duration duration, FileFormat fileFormat, Integer n, String string, String string2, String string3, String string4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                duration = format.duration;
            }
            if ((n2 & 2) != 0) {
                fileFormat = format.fileFormat;
            }
            if ((n2 & 4) != 0) {
                n = format.limit;
            }
            if ((n2 & 8) != 0) {
                string = format.header;
            }
            if ((n2 & 0x10) != 0) {
                string2 = format.footer;
            }
            if ((n2 & 0x20) != 0) {
                string3 = format.timeFrom;
            }
            if ((n2 & 0x40) != 0) {
                string4 = format.timeTo;
            }
            return format.copy(duration, fileFormat, n, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Format(duration=" + this.duration + ", fileFormat=" + this.fileFormat + ", limit=" + this.limit + ", header=" + this.header + ", footer=" + this.footer + ", timeFrom=" + this.timeFrom + ", timeTo=" + this.timeTo + ")";
        }

        public int hashCode() {
            int result = this.duration.hashCode();
            result = result * 31 + this.fileFormat.hashCode();
            result = result * 31 + (this.limit == null ? 0 : ((Object)this.limit).hashCode());
            result = result * 31 + (this.header == null ? 0 : this.header.hashCode());
            result = result * 31 + (this.footer == null ? 0 : this.footer.hashCode());
            result = result * 31 + (this.timeFrom == null ? 0 : this.timeFrom.hashCode());
            result = result * 31 + (this.timeTo == null ? 0 : this.timeTo.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Format)) {
                return false;
            }
            Format format = (Format)other;
            if (!Intrinsics.areEqual((Object)this.duration, (Object)format.duration)) {
                return false;
            }
            if (this.fileFormat != format.fileFormat) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.limit, (Object)format.limit)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.header, (Object)format.header)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.footer, (Object)format.footer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeFrom, (Object)format.timeFrom)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeTo, (Object)format.timeTo);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format$Companion;", "", "<init>", "()V", "DURATION_TAG", "", "FILE_FORMAT_TAG", "LIMIT_TAG", "HEADER_TAG", "FOOTER_TAG", "TIME_FROM_TAG", "TIME_TO_TAG", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Format;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-reports-scheduler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Format parse(@NotNull XContentParser parser) {
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                Duration durationSeconds = null;
                FileFormat fileFormat = null;
                Integer limit = null;
                String header = null;
                String footer = null;
                String timeFrom = null;
                String timeTo = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                block18: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                    String fieldName;
                    block28: {
                        fieldName = parser.currentName();
                        parser.nextToken();
                        String string = fieldName;
                        if (string == null) break block28;
                        int n = -1;
                        switch (string.hashCode()) {
                            case -1992012396: {
                                if (string.equals(Format.DURATION_TAG)) {
                                    n = 1;
                                }
                                break;
                            }
                            case -2077773801: {
                                if (string.equals(Format.TIME_FROM_TAG)) {
                                    n = 2;
                                }
                                break;
                            }
                            case -873669080: {
                                if (string.equals(Format.TIME_TO_TAG)) {
                                    n = 3;
                                }
                                break;
                            }
                            case -1268861541: {
                                if (string.equals(Format.FOOTER_TAG)) {
                                    n = 4;
                                }
                                break;
                            }
                            case 102976443: {
                                if (string.equals(Format.LIMIT_TAG)) {
                                    n = 5;
                                }
                                break;
                            }
                            case -1221270899: {
                                if (string.equals(Format.HEADER_TAG)) {
                                    n = 6;
                                }
                                break;
                            }
                            case 1424870547: {
                                if (string.equals(Format.FILE_FORMAT_TAG)) {
                                    n = 7;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 1: {
                                durationSeconds = Duration.parse(parser.text());
                                continue block18;
                            }
                            case 7: {
                                String string2 = parser.text();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                                fileFormat = FileFormat.valueOf(string2);
                                continue block18;
                            }
                            case 5: {
                                limit = parser.intValue();
                                continue block18;
                            }
                            case 6: {
                                header = parser.textOrNull();
                                continue block18;
                            }
                            case 4: {
                                footer = parser.textOrNull();
                                continue block18;
                            }
                            case 2: {
                                timeFrom = parser.textOrNull();
                                continue block18;
                            }
                            case 3: {
                                timeTo = parser.textOrNull();
                                continue block18;
                            }
                        }
                    }
                    parser.skipChildren();
                    ReportDefinition.Companion.getLog().info("reports:Format Skipping Unknown field " + fieldName);
                }
                if (durationSeconds == null) {
                    throw new IllegalArgumentException("duration field absent");
                }
                if (fileFormat == null) {
                    throw new IllegalArgumentException("fileFormat field absent");
                }
                return new Format(durationSeconds, fileFormat, limit, header, footer, timeFrom, timeTo);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 !2\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Source;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "description", "", "type", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$SourceType;", "origin", "id", "<init>", "(Ljava/lang/String;Lorg/opensearch/reportsscheduler/model/ReportDefinition$SourceType;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getType", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$SourceType;", "getOrigin", "getId", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-reports-scheduler"})
    public static final class Source
    implements ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String description;
        @NotNull
        private final SourceType type;
        @NotNull
        private final String origin;
        @NotNull
        private final String id;
        @NotNull
        private static final String DESCRIPTION_TAG = "description";
        @NotNull
        private static final String TYPE_TAG = "type";
        @NotNull
        private static final String ORIGIN_TAG = "origin";
        @NotNull
        private static final String ID_TAG = "id";

        public Source(@NotNull String description, @NotNull SourceType type, @NotNull String origin, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_TAG);
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TYPE_TAG);
            Intrinsics.checkNotNullParameter((Object)origin, (String)ORIGIN_TAG);
            Intrinsics.checkNotNullParameter((Object)id, (String)ID_TAG);
            this.description = description;
            this.type = type;
            this.origin = origin;
            this.id = id;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final SourceType getType() {
            return this.type;
        }

        @NotNull
        public final String getOrigin() {
            return this.origin;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNull((Object)builder);
            builder.startObject().field(DESCRIPTION_TAG, this.description).field(TYPE_TAG, this.type.name()).field(ORIGIN_TAG, this.origin).field(ID_TAG, this.id).endObject();
            return builder;
        }

        @NotNull
        public final String component1() {
            return this.description;
        }

        @NotNull
        public final SourceType component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.origin;
        }

        @NotNull
        public final String component4() {
            return this.id;
        }

        @NotNull
        public final Source copy(@NotNull String description, @NotNull SourceType type, @NotNull String origin, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_TAG);
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TYPE_TAG);
            Intrinsics.checkNotNullParameter((Object)origin, (String)ORIGIN_TAG);
            Intrinsics.checkNotNullParameter((Object)id, (String)ID_TAG);
            return new Source(description, type, origin, id);
        }

        public static /* synthetic */ Source copy$default(Source source, String string, SourceType sourceType, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = source.description;
            }
            if ((n & 2) != 0) {
                sourceType = source.type;
            }
            if ((n & 4) != 0) {
                string2 = source.origin;
            }
            if ((n & 8) != 0) {
                string3 = source.id;
            }
            return source.copy(string, sourceType, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Source(description=" + this.description + ", type=" + this.type + ", origin=" + this.origin + ", id=" + this.id + ")";
        }

        public int hashCode() {
            int result = this.description.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.origin.hashCode();
            result = result * 31 + this.id.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Source)) {
                return false;
            }
            Source source = (Source)other;
            if (!Intrinsics.areEqual((Object)this.description, (Object)source.description)) {
                return false;
            }
            if (this.type != source.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.origin, (Object)source.origin)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)source.id);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Source$Companion;", "", "<init>", "()V", "DESCRIPTION_TAG", "", "TYPE_TAG", "ORIGIN_TAG", "ID_TAG", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Source;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-reports-scheduler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Source parse(@NotNull XContentParser parser) {
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                String description = null;
                SourceType type = null;
                String origin = null;
                String id = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                block12: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                    String fieldName;
                    block21: {
                        fieldName = parser.currentName();
                        parser.nextToken();
                        String string = fieldName;
                        if (string == null) break block21;
                        int n = -1;
                        switch (string.hashCode()) {
                            case -1008619738: {
                                if (string.equals(Source.ORIGIN_TAG)) {
                                    n = 1;
                                }
                                break;
                            }
                            case -1724546052: {
                                if (string.equals(Source.DESCRIPTION_TAG)) {
                                    n = 2;
                                }
                                break;
                            }
                            case 3355: {
                                if (string.equals(Source.ID_TAG)) {
                                    n = 3;
                                }
                                break;
                            }
                            case 3575610: {
                                if (string.equals(Source.TYPE_TAG)) {
                                    n = 4;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 2: {
                                description = parser.text();
                                continue block12;
                            }
                            case 4: {
                                String string2 = parser.text();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                                type = SourceType.valueOf(string2);
                                continue block12;
                            }
                            case 1: {
                                origin = parser.text();
                                continue block12;
                            }
                            case 3: {
                                id = parser.text();
                                continue block12;
                            }
                        }
                    }
                    parser.skipChildren();
                    ReportDefinition.Companion.getLog().info("reports:Source Skipping Unknown field " + fieldName);
                }
                if (description == null) {
                    throw new IllegalArgumentException("description field absent");
                }
                if (type == null) {
                    throw new IllegalArgumentException("type field absent");
                }
                if (origin == null) {
                    throw new IllegalArgumentException("origin field absent");
                }
                if (id == null) {
                    throw new IllegalArgumentException("id field absent");
                }
                return new Source(description, type, origin, id);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$SourceType;", "", "<init>", "(Ljava/lang/String;I)V", "Dashboard", "Visualization", "SavedSearch", "Notebook", "opensearch-reports-scheduler"})
    public static final class SourceType
    extends Enum<SourceType> {
        public static final /* enum */ SourceType Dashboard = new SourceType();
        public static final /* enum */ SourceType Visualization = new SourceType();
        public static final /* enum */ SourceType SavedSearch = new SourceType();
        public static final /* enum */ SourceType Notebook = new SourceType();
        private static final /* synthetic */ SourceType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SourceType[] values() {
            return (SourceType[])$VALUES.clone();
        }

        public static SourceType valueOf(String value) {
            return Enum.valueOf(SourceType.class, value);
        }

        @NotNull
        public static EnumEntries<SourceType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceTypeArray = new SourceType[]{SourceType.Dashboard, SourceType.Visualization, SourceType.SavedSearch, SourceType.Notebook};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "triggerType", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$TriggerType;", "schedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "<init>", "(Lorg/opensearch/reportsscheduler/model/ReportDefinition$TriggerType;Lorg/opensearch/jobscheduler/spi/schedule/Schedule;)V", "getTriggerType", "()Lorg/opensearch/reportsscheduler/model/ReportDefinition$TriggerType;", "getSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "opensearch-reports-scheduler"})
    public static final class Trigger
    implements ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final TriggerType triggerType;
        @Nullable
        private final Schedule schedule;
        @NotNull
        private static final String TRIGGER_TYPE_TAG = "triggerType";
        @NotNull
        private static final String SCHEDULE_TAG = "schedule";

        public Trigger(@NotNull TriggerType triggerType, @Nullable Schedule schedule) {
            Intrinsics.checkNotNullParameter((Object)((Object)triggerType), (String)TRIGGER_TYPE_TAG);
            this.triggerType = triggerType;
            this.schedule = schedule;
        }

        @NotNull
        public final TriggerType getTriggerType() {
            return this.triggerType;
        }

        @Nullable
        public final Schedule getSchedule() {
            return this.schedule;
        }

        @NotNull
        public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
            Intrinsics.checkNotNull((Object)builder);
            builder.startObject().field(TRIGGER_TYPE_TAG, (Object)this.triggerType);
            if (Companion.isScheduleType(this.triggerType)) {
                builder.field(SCHEDULE_TAG);
                Schedule schedule = this.schedule;
                Intrinsics.checkNotNull((Object)schedule);
                schedule.toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            return builder;
        }

        @NotNull
        public final TriggerType component1() {
            return this.triggerType;
        }

        @Nullable
        public final Schedule component2() {
            return this.schedule;
        }

        @NotNull
        public final Trigger copy(@NotNull TriggerType triggerType, @Nullable Schedule schedule) {
            Intrinsics.checkNotNullParameter((Object)((Object)triggerType), (String)TRIGGER_TYPE_TAG);
            return new Trigger(triggerType, schedule);
        }

        public static /* synthetic */ Trigger copy$default(Trigger trigger, TriggerType triggerType, Schedule schedule, int n, Object object) {
            if ((n & 1) != 0) {
                triggerType = trigger.triggerType;
            }
            if ((n & 2) != 0) {
                schedule = trigger.schedule;
            }
            return trigger.copy(triggerType, schedule);
        }

        @NotNull
        public String toString() {
            return "Trigger(triggerType=" + this.triggerType + ", schedule=" + this.schedule + ")";
        }

        public int hashCode() {
            int result = this.triggerType.hashCode();
            result = result * 31 + (this.schedule == null ? 0 : this.schedule.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trigger)) {
                return false;
            }
            Trigger trigger = (Trigger)other;
            if (this.triggerType != trigger.triggerType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.schedule, (Object)trigger.schedule);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger$Companion;", "", "<init>", "()V", "TRIGGER_TYPE_TAG", "", "SCHEDULE_TAG", "parse", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$Trigger;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "isScheduleType", "", "triggerType", "Lorg/opensearch/reportsscheduler/model/ReportDefinition$TriggerType;", "opensearch-reports-scheduler"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Trigger parse(@NotNull XContentParser parser) {
                Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
                TriggerType triggerType = null;
                Schedule schedule = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (Intrinsics.areEqual((Object)string, (Object)Trigger.TRIGGER_TYPE_TAG)) {
                        String string2 = parser.text();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text(...)");
                        triggerType = TriggerType.valueOf(string2);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)string, (Object)Trigger.SCHEDULE_TAG)) {
                        schedule = ScheduleParser.parse((XContentParser)parser);
                        continue;
                    }
                    ReportDefinition.Companion.getLog().info("reports: Trigger Skipping Unknown field " + fieldName);
                }
                if (triggerType == null) {
                    throw new IllegalArgumentException("triggerType field absent");
                }
                if (this.isScheduleType(triggerType) && schedule == null) {
                    throw new IllegalArgumentException("schedule field absent");
                }
                return new Trigger(triggerType, schedule);
            }

            public final boolean isScheduleType(@NotNull TriggerType triggerType) {
                Intrinsics.checkNotNullParameter((Object)((Object)triggerType), (String)Trigger.TRIGGER_TYPE_TAG);
                return triggerType == TriggerType.CronSchedule || triggerType == TriggerType.IntervalSchedule;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportDefinition$TriggerType;", "", "<init>", "(Ljava/lang/String;I)V", "Download", "OnDemand", "CronSchedule", "IntervalSchedule", "opensearch-reports-scheduler"})
    public static final class TriggerType
    extends Enum<TriggerType> {
        public static final /* enum */ TriggerType Download = new TriggerType();
        public static final /* enum */ TriggerType OnDemand = new TriggerType();
        public static final /* enum */ TriggerType CronSchedule = new TriggerType();
        public static final /* enum */ TriggerType IntervalSchedule = new TriggerType();
        private static final /* synthetic */ TriggerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TriggerType[] values() {
            return (TriggerType[])$VALUES.clone();
        }

        public static TriggerType valueOf(String value) {
            return Enum.valueOf(TriggerType.class, value);
        }

        @NotNull
        public static EnumEntries<TriggerType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = triggerTypeArray = new TriggerType[]{TriggerType.Download, TriggerType.OnDemand, TriggerType.CronSchedule, TriggerType.IntervalSchedule};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

