/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.env.Environment;
import org.opensearch.security.ssl.config.KeyStoreConfiguration;
import org.opensearch.security.ssl.config.TrustStoreConfiguration;

public class SslCertificatesLoader {
    private static final Logger LOGGER = LogManager.getLogger(SslCertificatesLoader.class);
    private final String sslConfigSuffix;
    private final String fullSslConfigSuffix;

    public SslCertificatesLoader(String sslConfigSuffix) {
        this(sslConfigSuffix, null);
    }

    public SslCertificatesLoader(String sslConfigSuffix, String extendedSslConfigSuffix) {
        this.sslConfigSuffix = sslConfigSuffix;
        this.fullSslConfigSuffix = extendedSslConfigSuffix != null ? sslConfigSuffix + extendedSslConfigSuffix : sslConfigSuffix;
    }

    public Tuple<TrustStoreConfiguration, KeyStoreConfiguration> loadConfiguration(Environment environment) {
        Settings settings = environment.settings();
        Settings sslConfigSettings = settings.getByPrefix(this.fullSslConfigSuffix);
        if (settings.hasValue(this.sslConfigSuffix + "keystore_filepath")) {
            char[] keyStorePassword = this.resolvePassword(this.sslConfigSuffix + "keystore_password", settings, "changeit");
            return Tuple.tuple((Object)(environment.settings().hasValue(this.sslConfigSuffix + "truststore_filepath") ? this.buildJdkTrustStoreConfiguration(sslConfigSettings, environment, this.resolvePassword(this.sslConfigSuffix + "truststore_password", settings, "changeit")) : TrustStoreConfiguration.EMPTY_CONFIGURATION), (Object)this.buildJdkKeyStoreConfiguration(sslConfigSettings, environment, keyStorePassword, this.resolvePassword(this.fullSslConfigSuffix + "keystore_keypassword", settings, keyStorePassword != null ? String.valueOf(keyStorePassword) : null)));
        }
        return Tuple.tuple((Object)(sslConfigSettings.hasValue("pemtrustedcas_filepath") ? new TrustStoreConfiguration.PemTrustStoreConfiguration(this.resolvePath(sslConfigSettings.get("pemtrustedcas_filepath"), environment)) : TrustStoreConfiguration.EMPTY_CONFIGURATION), (Object)this.buildPemKeyStoreConfiguration(sslConfigSettings, environment, this.resolvePassword(this.fullSslConfigSuffix + "pemkey_password", settings, null)));
    }

    private char[] resolvePassword(String legacyPasswordSettings, Settings settings, String defaultPassword) {
        String securePasswordSetting = String.format("%s%s", legacyPasswordSettings, "_secure");
        SecureString securePassword = (SecureString)SecureSetting.secureString((String)securePasswordSetting, null, (Setting.Property[])new Setting.Property[0]).get(settings);
        String legacyPassword = settings.get(legacyPasswordSettings, defaultPassword);
        if (!Strings.isEmpty((CharSequence)securePassword) && legacyPassword != null && !legacyPassword.equals(defaultPassword)) {
            throw new OpenSearchException("One of " + legacyPasswordSettings + " or " + securePasswordSetting + " must be set not both", new Object[0]);
        }
        if (!Strings.isEmpty((CharSequence)securePassword)) {
            return securePassword.getChars();
        }
        if (legacyPassword != null) {
            LOGGER.warn("Setting [{}] has a secure counterpart [{}] which should be used instead - allowing for legacy SSL setups", (Object)legacyPasswordSettings, (Object)securePasswordSetting);
            return legacyPassword.toCharArray();
        }
        return null;
    }

    private KeyStoreConfiguration.JdkKeyStoreConfiguration buildJdkKeyStoreConfiguration(Settings settings, Environment environment, char[] keyStorePassword, char[] keyPassword) {
        return new KeyStoreConfiguration.JdkKeyStoreConfiguration(this.resolvePath(environment.settings().get(this.sslConfigSuffix + "keystore_filepath"), environment), environment.settings().get(this.sslConfigSuffix + "keystore_type", "JKS"), settings.get("keystore_alias", null), keyStorePassword, keyPassword);
    }

    private TrustStoreConfiguration.JdkTrustStoreConfiguration buildJdkTrustStoreConfiguration(Settings settings, Environment environment, char[] trustStorePassword) {
        return new TrustStoreConfiguration.JdkTrustStoreConfiguration(this.resolvePath(environment.settings().get(this.sslConfigSuffix + "truststore_filepath"), environment), environment.settings().get(this.sslConfigSuffix + "truststore_type", "JKS"), settings.get("truststore_alias", null), trustStorePassword);
    }

    private KeyStoreConfiguration.PemKeyStoreConfiguration buildPemKeyStoreConfiguration(Settings settings, Environment environment, char[] pemKeyPassword) {
        return new KeyStoreConfiguration.PemKeyStoreConfiguration(this.resolvePath(settings.get("pemcert_filepath"), environment), this.resolvePath(settings.get("pemkey_filepath"), environment), pemKeyPassword);
    }

    private Path resolvePath(String filePath, Environment environment) {
        Path path = environment.configFile().resolve(Path.of(filePath, new String[0]));
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new OpenSearchException(filePath + " - is a directory", new Object[0]);
        }
        if (!Files.isReadable(path)) {
            throw new OpenSearchException("Unable to read the file " + filePath + ". Please make sure this files exists and is readable regarding to permissions", new Object[0]);
        }
        return path;
    }
}

