/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public abstract class SchemaFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaFactory.class);
    public static final URL SAML_SCHEMA_METADATA_2_0 = SchemaFactory.class.getResource("/schemas/saml-schema-metadata-2.0.xsd");
    public static final URL SAML_SCHEMA_PROTOCOL_2_0 = SchemaFactory.class.getResource("/schemas/saml-schema-protocol-2.0.xsd");

    private SchemaFactory() {
    }

    public static Schema loadFromUrl(URL schemaUrl) throws SAXException {
        javax.xml.validation.SchemaFactory factory = javax.xml.validation.SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new LSResourceResolver(){
            private DOMImplementationLS ls;

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                try {
                    if (namespaceURI != null) {
                        switch (namespaceURI) {
                            case "urn:oasis:names:tc:SAML:2.0:assertion": {
                                return this.getLocalResource("saml-schema-assertion-2.0.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:2.0:ac": {
                                return this.getLocalResource("saml-schema-authn-context-2.0.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:2.0:metadata": {
                                return this.getLocalResource("saml-schema-metadata-2.0.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:2.0:protocol": {
                                return this.getLocalResource("saml-schema-protocol-2.0.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:metadata:attribute": {
                                return this.getLocalResource("sstc-metadata-attr.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:attribute:ext": {
                                return this.getLocalResource("sstc-saml-attribute-ext.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:metadata:algsupport": {
                                return this.getLocalResource("sstc-saml-metadata-algsupport-v1.0.xsd");
                            }
                            case "urn:oasis:names:tc:SAML:metadata:ui": {
                                return this.getLocalResource("sstc-saml-metadata-ui-v1.0.xsd");
                            }
                            case "http://www.w3.org/2001/04/xmlenc#": {
                                return this.getLocalResource("xenc-schema.xsd");
                            }
                            case "http://www.w3.org/XML/1998/namespace": {
                                return this.getLocalResource("xml.xsd");
                            }
                            case "http://www.w3.org/2000/09/xmldsig#": {
                                return this.getLocalResource("xmldsig-core-schema.xsd");
                            }
                        }
                    }
                    if ("saml-schema-authn-context-types-2.0.xsd".equals(systemId)) {
                        return this.getLocalResource("saml-schema-authn-context-types-2.0.xsd");
                    }
                    if (publicId != null) {
                        switch (publicId.toUpperCase(Locale.ROOT)) {
                            case "-//W3C//DTD XMLSCHEMA 200102//EN": {
                                return this.getLocalResource("XMLSchema.dtd");
                            }
                            case "DATATYPES": {
                                return this.getLocalResource("datatypes.dtd");
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.warn("could not resolve schema or DTD locally, proceeding the standard way", e);
                    return null;
                }
                return null;
            }

            public LSInput getLocalResource(String name) throws Throwable {
                InputStream inputStream;
                if (this.ls == null) {
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    this.ls = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS 3.0"));
                }
                if ((inputStream = this.getClass().getResourceAsStream("/schemas/" + name)) == null) {
                    return null;
                }
                LSInput lsInput = this.ls.createLSInput();
                lsInput.setByteStream(inputStream);
                return lsInput;
            }
        });
        return factory.newSchema(schemaUrl);
    }
}

