/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseSelfArrow
extends AbstractComponentRoseArrow {
    private final double arrowWidth = 45.0;
    private final double xRight = 42.0;
    private final boolean niceArrow;

    public ComponentRoseSelfArrow(Style style, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, boolean niceArrow) {
        super(style, stringsToDisplay, arrowConfiguration, spriteContainer, maxMessageSize);
        this.niceArrow = niceArrow;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double textHeight = this.getTextHeight(stringBounder);
        double prefTextWidth = this.getPreferredWidth(stringBounder);
        double arrowHeight = this.getArrowOnlyHeight(stringBounder);
        ug = ug.apply(this.getForegroundColor());
        UGraphic ug2 = this.getArrowConfiguration().applyStroke(ug);
        if (this.getArrowConfiguration().isReverseDefine()) {
            this.drawLeftSide(ug, ug2, area, arrowHeight, textHeight, prefTextWidth);
        } else {
            this.drawRightSide(ug, ug2, area, arrowHeight, textHeight);
        }
        this.getTextBlock().drawU(ug.apply(UTranslate.dx(this.getMarginX1())));
    }

    private void drawRightSide(UGraphic ug, UGraphic ug2, Area area, double arrowHeight, double textHeight) {
        UPolygon polygon;
        boolean hasFinalCrossX;
        boolean hasStartingCrossX;
        double x1 = area.getDeltaX1() < 0.0 ? area.getDeltaX1() : 0.0;
        double x2 = area.getDeltaX1() > 0.0 ? -area.getDeltaX1() : 1.0;
        UEllipse circle = UEllipse.build(8.0, 8.0);
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE) {
            ug2.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor()).apply(this.getBackgroundColor().bg()).apply(new UTranslate(x1 + 1.0 - 4.0 - 1.5, textHeight - 4.0 - 0.75)).draw(circle);
            x1 += 6.5;
            x1 -= this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.NONE ? 2.5 : 0.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE) {
            ug2.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor()).apply(this.getBackgroundColor().bg()).apply(new UTranslate(x2 - 4.0 - 1.5, textHeight + arrowHeight - 4.0 - 0.75)).draw(circle);
            x2 += 5.5;
        }
        boolean bl = hasStartingCrossX = this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.CROSSX;
        if (hasStartingCrossX) {
            x1 += 12.0;
        }
        boolean bl2 = hasFinalCrossX = this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.CROSSX;
        if (hasFinalCrossX) {
            x2 += 12.0;
        }
        if (this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.ASYNC) {
            x2 -= 1.0;
        }
        ug2.apply(new UTranslate(x1, textHeight)).draw(ULine.hline(42.0 - x1));
        ug2.apply(new UTranslate(42.0, textHeight)).draw(ULine.vline(arrowHeight));
        ug2.apply(new UTranslate(x2, textHeight + arrowHeight)).draw(ULine.hline(42.0 - x2));
        if (this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.ASYNC) {
            x2 += 1.0;
        }
        if (hasStartingCrossX) {
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(6.0, textHeight - (double)this.getArrowDeltaX() / 2.0)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(6.0, textHeight + (double)this.getArrowDeltaX() / 2.0)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (this.getArrowConfiguration().isAsync1()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x1, textHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x1, textHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
        } else if (this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.NORMAL) {
            polygon = this.getPolygon().translate(0.0, textHeight);
            ug.apply(this.getForegroundColor().bg()).apply(UTranslate.dx(x1)).draw(polygon);
        }
        if (hasFinalCrossX) {
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(6.0, textHeight - (double)this.getArrowDeltaX() / 2.0 + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(6.0, textHeight + (double)this.getArrowDeltaX() / 2.0 + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (this.getArrowConfiguration().isAsync2()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x2, textHeight + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(x2, textHeight + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.NORMAL) {
            polygon = this.getPolygon().translate(0.0, textHeight + arrowHeight);
            ug.apply(this.getForegroundColor().bg()).apply(UTranslate.dx(x2)).draw(polygon);
        }
    }

    private void drawLeftSide(UGraphic ug, UGraphic ug2, Area area, double arrowHeight, double textHeight, double prefTextWidth) {
        UPolygon polygon;
        boolean hasFinalCrossX;
        boolean hasStartingCrossX;
        double deltaSize = area.getLiveDeltaSize();
        double dx = area.getDeltaX1();
        int level = area.getLevel();
        double x1 = 0.0;
        double x2 = 1.0;
        double extraLiveDeltaIndent = (double)level * deltaSize;
        if (dx < 0.0) {
            x1 += 0.0;
            x2 += level > 0 ? -extraLiveDeltaIndent : deltaSize;
        } else if (dx > 0.0) {
            x1 += level > 1 ? deltaSize - extraLiveDeltaIndent : 0.0;
            x2 += level == 1 ? -deltaSize : 0.0;
        } else if (level > 1) {
            x1 -= extraLiveDeltaIndent - deltaSize;
            x2 -= extraLiveDeltaIndent - deltaSize;
        }
        UEllipse circle = UEllipse.build(8.0, 8.0);
        if (this.getArrowConfiguration().getDecoration1() == ArrowDecoration.CIRCLE) {
            ug2.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor()).apply(this.getBackgroundColor().bg()).apply(new UTranslate(prefTextWidth - x1 + 1.0 - 4.0 - 1.5, textHeight - 4.0 - 0.75)).draw(circle);
            x1 += 2.5;
            x1 += this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.NONE ? 1.5 : 0.0;
        }
        if (this.getArrowConfiguration().getDecoration2() == ArrowDecoration.CIRCLE) {
            ug2.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor()).apply(this.getBackgroundColor().bg()).apply(new UTranslate(prefTextWidth - x2 + 2.0 - 4.0 - 1.5, textHeight + arrowHeight - 4.0 - 0.75)).draw(circle);
            x2 += 5.5;
        }
        boolean bl = hasStartingCrossX = this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.CROSSX;
        if (hasStartingCrossX) {
            x1 += 6.0 + (level > 0 ? extraLiveDeltaIndent : 6.0);
        }
        boolean bl2 = hasFinalCrossX = this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.CROSSX;
        if (hasFinalCrossX) {
            x2 += 6.0 + (level > 0 ? extraLiveDeltaIndent : 6.0);
        }
        double extraline = 0.0;
        if (this.getArrowConfiguration().getDressing2().getPart() == ArrowPart.FULL && this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.NORMAL) {
            extraline = 1.0;
        }
        ug2.apply(new UTranslate(prefTextWidth - 42.0, textHeight)).draw(ULine.hline(42.0 - (x1 += 1.0)));
        ug2.apply(new UTranslate(prefTextWidth - 42.0, textHeight)).draw(ULine.vline(arrowHeight));
        ug2.apply(new UTranslate(prefTextWidth - 42.0, textHeight + arrowHeight)).draw(ULine.hline(42.0 - x2 - extraline));
        if (this.getArrowConfiguration().getDressing2().getPart() == ArrowPart.FULL && this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.NORMAL) {
            x2 += 1.0;
        }
        if (this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.ASYNC) {
            x2 += 1.0;
        }
        if (hasStartingCrossX) {
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(prefTextWidth - x1 - 3.0, textHeight - (double)this.getArrowDeltaX() / 2.0)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(prefTextWidth - x1 - 3.0, textHeight + (double)this.getArrowDeltaX() / 2.0)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (this.getArrowConfiguration().getDressing1().getHead() == ArrowHead.NORMAL) {
            polygon = this.getPolygon().translate(prefTextWidth - x1, textHeight);
            ug.apply(this.getForegroundColor().bg()).apply(UTranslate.dx(x1)).draw(polygon);
        }
        if (hasFinalCrossX) {
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(prefTextWidth - x2 - 3.0, textHeight - (double)this.getArrowDeltaX() / 2.0 + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(UStroke.withThickness(2.0)).apply(new UTranslate(prefTextWidth - x2 - 3.0, textHeight + (double)this.getArrowDeltaX() / 2.0 + arrowHeight)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (this.getArrowConfiguration().isAsync2()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(prefTextWidth - x2, textHeight + arrowHeight)).draw(new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).apply(new UTranslate(prefTextWidth - x2, textHeight + arrowHeight)).draw(new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else if (this.getArrowConfiguration().getDressing2().getHead() == ArrowHead.NORMAL) {
            polygon = this.getPolygon().translate(0.0, textHeight + arrowHeight);
            ug.apply(this.getForegroundColor().bg()).apply(UTranslate.dx(prefTextWidth - x2)).draw(polygon);
        }
    }

    private UPolygon getPolygon() {
        UPolygon polygon = new UPolygon();
        double direction = this.getArrowConfiguration().isReverseDefine() ? -1.0 : 1.0;
        double x = direction * (double)this.getArrowDeltaX();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            polygon.addPoint(x - 1.0, -this.getArrowDeltaY());
            polygon.addPoint(-1.0, 0.0);
            polygon.addPoint(x - 1.0, 0.0);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(x - 1.0, 0.0);
            polygon.addPoint(-1.0, 0.0);
            polygon.addPoint(x - 1.0, this.getArrowDeltaY());
        } else {
            polygon.addPoint(x, -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(x, this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(x - direction * 4.0, 0.0);
            }
        }
        return polygon;
    }

    @Override
    public XPoint2D getStartPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        double textHeight = this.getTextHeight(stringBounder);
        return new XPoint2D(this.getPaddingX(), textHeight + this.getPaddingY());
    }

    @Override
    public XPoint2D getEndPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        double textHeight = this.getTextHeight(stringBounder);
        double textAndArrowHeight = textHeight + this.getArrowOnlyHeight(stringBounder);
        return new XPoint2D(this.getPaddingX(), textAndArrowHeight + this.getPaddingY());
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        double textHeight = this.getTextHeight(stringBounder);
        double textAndArrowHeight = textHeight + this.getArrowOnlyHeight(stringBounder);
        return (textHeight + textAndArrowHeight) / 2.0 + this.getPaddingX();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 50.0);
    }

    @Override
    public double getPosArrow(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

