/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;

public class LabelCleanupTransform
extends ContextTrackingVisitor<Void> {
    public LabelCleanupTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitLabeledStatement(LabeledStatement node, Void data) {
        BlockStatement block;
        super.visitLabeledStatement(node, data);
        if (node.getStatement() instanceof BlockStatement && (block = (BlockStatement)node.getStatement()).getStatements().hasSingleElement() && block.getStatements().firstOrNullObject() instanceof LabeledStatement) {
            LabeledStatement nestedLabeledStatement = (LabeledStatement)block.getStatements().firstOrNullObject();
            String nextLabel = nestedLabeledStatement.getChildByRole(Roles.LABEL).getName();
            this.redirectLabels(node, node.getLabel(), nextLabel);
            nestedLabeledStatement.remove();
            node.replaceWith(nestedLabeledStatement);
        }
        return null;
    }

    @Override
    public Void visitLabelStatement(LabelStatement node, Void data) {
        super.visitLabelStatement(node, data);
        Statement next = node.getNextStatement();
        if (next == null) {
            return null;
        }
        if (next instanceof LabelStatement || next instanceof LabeledStatement) {
            String nextLabel = next.getChildByRole(Roles.LABEL).getName();
            this.redirectLabels(node.getParent(), node.getLabel(), nextLabel);
            node.remove();
        } else {
            next.remove();
            node.replaceWith(new LabeledStatement(node.getLabel(), AstNode.isLoop(next) ? next : new BlockStatement(next)));
        }
        return null;
    }

    private void redirectLabels(AstNode node, String labelName, String nextLabel) {
        for (AstNode n : node.getDescendantsAndSelf()) {
            Identifier label;
            if (!AstNode.isUnconditionalBranch(n) || (label = n.getChildByRole(Roles.IDENTIFIER)).isNull() || !StringUtilities.equals(label.getName(), labelName)) continue;
            label.setName(nextLabel);
        }
    }
}

