/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.rename;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.protege.editor.core.ui.util.CheckTable;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityRenamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameEntitiesPanel
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 259808389697631045L;
    private final Logger logger = LoggerFactory.getLogger(RenameEntitiesPanel.class);
    private static final int SEARCH_PAUSE_MILLIS = 1000;
    private OWLEditorKit eKit;
    private Map<String, Set<OWLEntity>> nsMap = new HashMap<String, Set<OWLEntity>>();
    private JComboBox replaceWithCombo;
    private JComboBox findCombo;
    private CheckTable<OWLEntity> list;
    private Map<OWLEntity, IRI> entity2IRIMap = new HashMap<OWLEntity, IRI>();
    private Map<OWLEntity, String> errorMap = new HashMap<OWLEntity, String>();
    private ItemListener findListener = event -> {
        if (event.getStateChange() == 1) {
            this.reloadEntityListThreaded();
        }
    };
    private ItemListener replaceListener = event -> {
        if (event.getStateChange() == 1) {
            this.updateEntityMap();
            this.handleStateChanged();
        }
    };
    private ListSelectionListener listSelListener = event -> this.handleStateChanged();
    private List<InputVerificationStatusChangedListener> statusListeners = new ArrayList<InputVerificationStatusChangedListener>();
    private boolean currentStatus = false;
    private Thread reloadThread;
    private Runnable reloadProcess = new Runnable(){

        @Override
        public void run() {
            RenameEntitiesPanel.this.reloadEntityList();
            RenameEntitiesPanel.this.reloadThread = null;
        }
    };

    public RenameEntitiesPanel(OWLEditorKit eKit) {
        this.setLayout(new BorderLayout(6, 6));
        this.eKit = eKit;
        this.buildEntityNamespaceMap();
        JPanel subPanel = new JPanel();
        subPanel.setBorder(new TitledBorder("Find & Replace"));
        subPanel.setLayout(new BorderLayout());
        this.findCombo = this.createCombo("Find", this.findListener, subPanel, "North");
        this.replaceWithCombo = this.createCombo("Replace with", this.replaceListener, subPanel, "South");
        this.add((Component)subPanel, "North");
        this.list = new CheckTable("Matching entities");
        this.list.checkAll(true);
        this.list.setDefaultRenderer((TableCellRenderer)new ResultCellRenderer(eKit));
        this.list.addCheckSelectionListener(this.listSelListener);
        this.add((Component)new JScrollPane((Component)this.list), "Center");
    }

    private JComboBox createCombo(String title, ItemListener listener, JComponent parent, String constraints) {
        JComboBox<Object> combo = new JComboBox<Object>(this.nsMap.keySet().toArray());
        combo.addItem("");
        combo.setSelectedItem("");
        combo.setEditable(true);
        combo.addItemListener(listener);
        JTextComponent editor = (JTextComponent)combo.getEditor().getEditorComponent();
        ActionListener actionListener = actionEvent -> combo.setSelectedItem(editor.getText());
        final Timer timer = new Timer(1000, actionListener);
        editor.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ RenameEntitiesPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                timer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
            }
        });
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(new JLabel(title));
        panel.add(combo);
        parent.add((Component)panel, constraints);
        return combo;
    }

    private void buildEntityNamespaceMap() {
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLEntity entity : ont.getSignature()) {
                this.extractNSFromEntity(entity);
            }
        }
    }

    private void extractNSFromEntity(OWLEntity entity) {
        String ns = this.getBase(entity.getIRI());
        Set<OWLEntity> matchingEntities = this.nsMap.get(ns);
        if (matchingEntities == null) {
            matchingEntities = new HashSet<OWLEntity>();
        }
        matchingEntities.add(entity);
        this.nsMap.put(ns, matchingEntities);
    }

    public String getFindValue() {
        return (String)this.findCombo.getSelectedItem();
    }

    public String getReplaceWithValue() {
        return (String)this.replaceWithCombo.getSelectedItem();
    }

    public List<OWLEntity> getSelectedEntities() {
        return this.list.getFilteredValues();
    }

    public List<OWLOntologyChange> getChanges() {
        OWLOntologyManager mngr = this.eKit.getModelManager().getOWLOntologyManager();
        OWLEntityRenamer renamer = new OWLEntityRenamer(mngr, this.getOntologies());
        HashMap<OWLEntity, IRI> filteredIRIMap = new HashMap<OWLEntity, IRI>();
        for (OWLEntity e : this.list.getFilteredValues()) {
            filteredIRIMap.put(e, this.entity2IRIMap.get(e));
        }
        return renamer.changeIRI(filteredIRIMap);
    }

    private void reloadEntityList() {
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(this.getEntities());
        Collections.sort(sortedEntities, this.eKit.getModelManager().getOWLObjectComparator());
        this.list.getModel().setData(sortedEntities, true);
        this.updateEntityMap();
        this.handleStateChanged();
    }

    private Set<OWLEntity> getEntities() {
        Set<OWLEntity> matches = this.nsMap.get(this.getFindValue());
        if (matches == null) {
            matches = new HashSet<OWLEntity>();
            HashSet ents = new HashSet();
            for (OWLOntology ont : this.getOntologies()) {
                ents.addAll(ont.getSignature());
            }
            String matchingVal = ".*" + this.getFindValue() + ".*";
            Pattern p = Pattern.compile(matchingVal);
            for (OWLEntity ent : ents) {
                if (!p.matcher(ent.getIRI().toString()).matches()) continue;
                matches.add(ent);
            }
        }
        return matches;
    }

    private void updateEntityMap() {
        this.entity2IRIMap.clear();
        this.errorMap.clear();
        Set<OWLEntity> matches = this.nsMap.get(this.getFindValue());
        if (matches != null) {
            this.updateEntityMapUsingPrefixes(this.getFindValue(), matches);
        } else {
            this.updateEntityMapUsingRegexp();
        }
        this.list.repaint();
    }

    private void updateEntityMapUsingPrefixes(String prefix, Set<OWLEntity> matches) {
        int prefixLength = prefix.length();
        String replacementText = this.getReplaceWithValue();
        for (OWLEntity entity : matches) {
            String iriString = entity.getIRI().toString();
            this.addToEntityMap(entity, replacementText + iriString.substring(prefixLength));
        }
    }

    private void updateEntityMapUsingRegexp() {
        HashSet entities = new HashSet();
        for (OWLOntology includedOntology : this.getOntologies()) {
            entities.addAll(includedOntology.getSignature());
        }
        for (OWLEntity entity : entities) {
            String newURIStr = entity.getIRI().toString().replaceAll(this.getFindValue(), this.getReplaceWithValue());
            this.addToEntityMap(entity, newURIStr);
        }
    }

    private void addToEntityMap(OWLEntity entity, String newURIStr) {
        try {
            URI newURI = new URI(newURIStr);
            if (!newURI.isAbsolute()) {
                throw new URISyntaxException(newURIStr, "IRI must be absolute");
            }
            this.entity2IRIMap.put(entity, IRI.create((URI)newURI));
        }
        catch (URISyntaxException e) {
            this.errorMap.put(entity, newURIStr);
        }
    }

    private Set<OWLOntology> getOntologies() {
        return this.eKit.getModelManager().getOntologies();
    }

    private String getBase(IRI uri) {
        String frag = this.getShortForm(uri);
        String uriStr = uri.toString();
        return uriStr.substring(0, uriStr.lastIndexOf(frag));
    }

    private String getShortForm(IRI uri) {
        try {
            Optional rendering = uri.getRemainder();
            if (!rendering.isPresent()) {
                String path = uri.toURI().getPath();
                if (path == null) {
                    return uri.toString();
                }
                return uri.toURI().getPath().substring(path.lastIndexOf("/") + 1);
            }
            return (String)rendering.get();
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.statusListeners.add(listener);
        listener.verifiedStatusChanged(this.currentStatus);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.statusListeners.remove(listener);
    }

    private void handleStateChanged() {
        boolean valid = this.getStatus();
        if (this.currentStatus != valid) {
            this.currentStatus = valid;
            for (InputVerificationStatusChangedListener l : this.statusListeners) {
                l.verifiedStatusChanged(this.currentStatus);
            }
        }
    }

    private boolean getStatus() {
        return this.findCombo.getSelectedItem() != null && !this.findCombo.getSelectedItem().equals("") && this.replaceWithCombo.getSelectedItem() != null && !this.replaceWithCombo.getSelectedItem().equals("") && !this.list.getFilteredValues().isEmpty() && this.errorMap.isEmpty();
    }

    private void reloadEntityListThreaded() {
        if (this.reloadThread != null && this.reloadThread.isAlive()) {
            this.reloadThread.interrupt();
        }
        this.reloadThread = new Thread(this.reloadProcess);
        this.reloadThread.run();
    }

    public JComponent getFocusComponent() {
        return (JComponent)this.findCombo.getEditor().getEditorComponent();
    }

    class ResultCellRenderer
    extends OWLCellRenderer {
        private boolean inURI;
        private Style fadedStyle;
        private Style highlightedStyle;

        public ResultCellRenderer(OWLEditorKit owlEditorKit) {
            super(owlEditorKit);
            this.inURI = false;
            this.fadedStyle = null;
            this.highlightedStyle = null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (RenameEntitiesPanel.this.errorMap.containsKey(value)) {
                this.setStrikeThrough(true);
            } else {
                this.setStrikeThrough(false);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        protected String getRendering(Object object) {
            if (object instanceof OWLEntity) {
                return super.getRendering(object) + " (" + String.valueOf(((OWLEntity)object).getIRI()) + ")";
            }
            return super.getRendering(object);
        }

        protected void renderToken(String curToken, int tokenStartIndex, StyledDocument doc) {
            super.renderToken(curToken, tokenStartIndex, doc, false);
            RenameEntitiesPanel.this.logger.debug("CurrentToken: {}", (Object)curToken);
            if (curToken.startsWith("(")) {
                this.inURI = true;
            }
            if (curToken.equals(")")) {
                this.inURI = false;
            } else if (this.inURI) {
                if (this.fadedStyle == null) {
                    this.fadedStyle = doc.addStyle("MY_FADED_STYLE", null);
                    StyleConstants.setForeground(this.fadedStyle, Color.GRAY);
                }
                doc.setCharacterAttributes(tokenStartIndex, doc.getLength() - tokenStartIndex, this.fadedStyle, false);
                if (this.highlightedStyle == null) {
                    this.highlightedStyle = doc.addStyle("MY_HIGHLIGHTED_STYLE", null);
                    StyleConstants.setForeground(this.highlightedStyle, Color.darkGray);
                    StyleConstants.setBold(this.highlightedStyle, true);
                }
                String s = RenameEntitiesPanel.this.getFindValue().toLowerCase();
                curToken = curToken.toLowerCase();
                if (!s.isEmpty()) {
                    int cur = 0;
                    do {
                        if ((cur = curToken.indexOf(s, cur)) == -1) continue;
                        doc.setCharacterAttributes(tokenStartIndex + cur, s.length(), this.highlightedStyle, true);
                        ++cur;
                    } while (cur != -1);
                }
            }
        }
    }
}

