/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.util.MathUtil;
import info.monitorenter.util.Range;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisInverse
extends AAxis {
    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart, int dimension, int position) {
        AAxis.AChart2DDataAccessor result;
        if (dimension == 1) {
            if ((position & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(position);
            result = new XDataInverseAccessor(chart);
        } else if (dimension == 2) {
            if ((position & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(position);
            result = new YDataInverseAccessor(chart);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return result;
    }

    @Override
    protected List<LabeledValue> getLabels(double resolution) {
        List<LabeledValue> ret = super.getLabels(resolution);
        for (LabeledValue label : ret) {
            label.setValue(1.0 - label.getValue());
        }
        return ret;
    }

    @Override
    public double getScaledValue(double absolute) {
        Range range = this.getRange();
        double scalerX = range.getExtent();
        double result = 1.0 - (absolute - range.getMin()) / scalerX;
        if (!MathUtil.isDouble(result)) {
            result = 0.0;
        }
        return result;
    }

    protected class YDataInverseAccessor
    extends AAxis.YDataAccessor {
        public YDataInverseAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                double scaler = range.getExtent();
                Iterator<TracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    TracePoint2D point = itPoints.next();
                    double absolute = point.getY();
                    double result = 1.0 - (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledY(result);
                }
            }
        }

        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = this.m_chart.getYChartStart() - pixel;
            int rangeY = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (rangeY != 0) {
                double scaledY = 1.0 - px / (double)rangeY;
                Range valueRangeY = AxisInverse.this.getRange();
                result = scaledY * valueRangeY.getExtent() + valueRangeY.getMin();
            }
            return result;
        }
    }

    public class XDataInverseAccessor
    extends AAxis.XDataAccessor {
        public XDataInverseAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            double scaler = range.getExtent();
            if (trace.isVisible()) {
                Iterator<TracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    TracePoint2D point = itPoints.next();
                    double absolute = point.getX();
                    double result = 1.0 - (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledX(result);
                }
            }
        }

        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = pixel - this.m_chart.getXChartStart();
            int rangeX = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (rangeX != 0) {
                double scaledX = 1.0 - px / (double)rangeX;
                Range valueRangeX = AxisInverse.this.getRange();
                result = scaledX * valueRangeX.getExtent() + valueRangeX.getMin();
            }
            return result;
        }
    }
}

