/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler/src/chars", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.$EOF = 0;
    exports.$BSPACE = 8;
    exports.$TAB = 9;
    exports.$LF = 10;
    exports.$VTAB = 11;
    exports.$FF = 12;
    exports.$CR = 13;
    exports.$SPACE = 32;
    exports.$BANG = 33;
    exports.$DQ = 34;
    exports.$HASH = 35;
    exports.$$ = 36;
    exports.$PERCENT = 37;
    exports.$AMPERSAND = 38;
    exports.$SQ = 39;
    exports.$LPAREN = 40;
    exports.$RPAREN = 41;
    exports.$STAR = 42;
    exports.$PLUS = 43;
    exports.$COMMA = 44;
    exports.$MINUS = 45;
    exports.$PERIOD = 46;
    exports.$SLASH = 47;
    exports.$COLON = 58;
    exports.$SEMICOLON = 59;
    exports.$LT = 60;
    exports.$EQ = 61;
    exports.$GT = 62;
    exports.$QUESTION = 63;
    exports.$0 = 48;
    exports.$7 = 55;
    exports.$9 = 57;
    exports.$A = 65;
    exports.$E = 69;
    exports.$F = 70;
    exports.$X = 88;
    exports.$Z = 90;
    exports.$LBRACKET = 91;
    exports.$BACKSLASH = 92;
    exports.$RBRACKET = 93;
    exports.$CARET = 94;
    exports.$_ = 95;
    exports.$a = 97;
    exports.$b = 98;
    exports.$e = 101;
    exports.$f = 102;
    exports.$n = 110;
    exports.$r = 114;
    exports.$t = 116;
    exports.$u = 117;
    exports.$v = 118;
    exports.$x = 120;
    exports.$z = 122;
    exports.$LBRACE = 123;
    exports.$BAR = 124;
    exports.$RBRACE = 125;
    exports.$NBSP = 160;
    exports.$PIPE = 124;
    exports.$TILDA = 126;
    exports.$AT = 64;
    exports.$BT = 96;
    function isWhitespace(code) {
        return (code >= exports.$TAB && code <= exports.$SPACE) || (code == exports.$NBSP);
    }
    exports.isWhitespace = isWhitespace;
    function isDigit(code) {
        return exports.$0 <= code && code <= exports.$9;
    }
    exports.isDigit = isDigit;
    function isAsciiLetter(code) {
        return code >= exports.$a && code <= exports.$z || code >= exports.$A && code <= exports.$Z;
    }
    exports.isAsciiLetter = isAsciiLetter;
    function isAsciiHexDigit(code) {
        return code >= exports.$a && code <= exports.$f || code >= exports.$A && code <= exports.$F || isDigit(code);
    }
    exports.isAsciiHexDigit = isAsciiHexDigit;
    function isNewLine(code) {
        return code === exports.$LF || code === exports.$CR;
    }
    exports.isNewLine = isNewLine;
    function isOctalDigit(code) {
        return exports.$0 <= code && code <= exports.$7;
    }
    exports.isOctalDigit = isOctalDigit;
});
//# sourceMappingURL=data:application/json;base64,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