/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { UrlTree } from '../url_tree';
/**
 * Simple function check, but generic so type inference will flow. Example:
 *
 * function product(a: number, b: number) {
 *   return a * b;
 * }
 *
 * if (isFunction<product>(fn)) {
 *   return fn(1, 2);
 * } else {
 *   throw "Must provide the `product` function";
 * }
 */
export function isFunction(v) {
    return typeof v === 'function';
}
export function isBoolean(v) {
    return typeof v === 'boolean';
}
export function isUrlTree(v) {
    return v instanceof UrlTree;
}
export function isCanLoad(guard) {
    return guard && isFunction(guard.canLoad);
}
export function isCanActivate(guard) {
    return guard && isFunction(guard.canActivate);
}
export function isCanActivateChild(guard) {
    return guard && isFunction(guard.canActivateChild);
}
export function isCanDeactivate(guard) {
    return guard && isFunction(guard.canDeactivate);
}
//# sourceMappingURL=data:application/json;base64,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