/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** @enum {number} */
const TagContentType = {
    RAW_TEXT: 0,
    ESCAPABLE_RAW_TEXT: 1,
    PARSABLE_DATA: 2,
};
export { TagContentType };
TagContentType[TagContentType.RAW_TEXT] = "RAW_TEXT";
TagContentType[TagContentType.ESCAPABLE_RAW_TEXT] = "ESCAPABLE_RAW_TEXT";
TagContentType[TagContentType.PARSABLE_DATA] = "PARSABLE_DATA";
/**
 * @record
 */
export function TagDefinition() { }
function TagDefinition_tsickle_Closure_declarations() {
    /** @type {?} */
    TagDefinition.prototype.closedByParent;
    /** @type {?} */
    TagDefinition.prototype.requiredParents;
    /** @type {?} */
    TagDefinition.prototype.parentToAdd;
    /** @type {?} */
    TagDefinition.prototype.implicitNamespacePrefix;
    /** @type {?} */
    TagDefinition.prototype.contentType;
    /** @type {?} */
    TagDefinition.prototype.isVoid;
    /** @type {?} */
    TagDefinition.prototype.ignoreFirstLf;
    /** @type {?} */
    TagDefinition.prototype.canSelfClose;
    /** @type {?} */
    TagDefinition.prototype.requireExtraParent;
    /** @type {?} */
    TagDefinition.prototype.isClosedByChild;
}
/**
 * @param {?} elementName
 * @return {?}
 */
export function splitNsName(elementName) {
    if (elementName[0] !== ":") {
        return [null, elementName];
    }
    const /** @type {?} */ colonIndex = elementName.indexOf(":", 1);
    if (colonIndex === -1) {
        throw new Error(`Unsupported format "${elementName}" expecting ":namespace:name"`);
    }
    return [elementName.slice(1, colonIndex), elementName.slice(colonIndex + 1)];
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgContainer(tagName) {
    return splitNsName(tagName)[1] === "ng-container";
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgContent(tagName) {
    return splitNsName(tagName)[1] === "ng-content";
}
/**
 * @param {?} tagName
 * @return {?}
 */
export function isNgTemplate(tagName) {
    return splitNsName(tagName)[1] === "ng-template";
}
/**
 * @param {?} fullName
 * @return {?}
 */
export function getNsPrefix(fullName) {
    return fullName === null ? null : splitNsName(fullName)[0];
}
/**
 * @param {?} prefix
 * @param {?} localName
 * @return {?}
 */
export function mergeNsAndName(prefix, localName) {
    return prefix ? `:${prefix}:${localName}` : localName;
}
// see http://www.w3.org/TR/html51/syntax.html#named-character-references
// see https://html.spec.whatwg.org/multipage/entities.json
// This list is not exhaustive to keep the compiler footprint low.
// The `&#123;` / `&#x1ab;` syntax should be used when the named character reference does not
// exist.
export const /** @type {?} */ NAMED_ENTITIES = {
    Aacute: "\u00C1",
    aacute: "\u00E1",
    Acirc: "\u00C2",
    acirc: "\u00E2",
    acute: "\u00B4",
    AElig: "\u00C6",
    aelig: "\u00E6",
    Agrave: "\u00C0",
    agrave: "\u00E0",
    alefsym: "\u2135",
    Alpha: "\u0391",
    alpha: "\u03B1",
    amp: "&",
    and: "\u2227",
    ang: "\u2220",
    apos: "\u0027",
    Aring: "\u00C5",
    aring: "\u00E5",
    asymp: "\u2248",
    Atilde: "\u00C3",
    atilde: "\u00E3",
    Auml: "\u00C4",
    auml: "\u00E4",
    bdquo: "\u201E",
    Beta: "\u0392",
    beta: "\u03B2",
    brvbar: "\u00A6",
    bull: "\u2022",
    cap: "\u2229",
    Ccedil: "\u00C7",
    ccedil: "\u00E7",
    cedil: "\u00B8",
    cent: "\u00A2",
    Chi: "\u03A7",
    chi: "\u03C7",
    circ: "\u02C6",
    clubs: "\u2663",
    cong: "\u2245",
    copy: "\u00A9",
    crarr: "\u21B5",
    cup: "\u222A",
    curren: "\u00A4",
    dagger: "\u2020",
    Dagger: "\u2021",
    darr: "\u2193",
    dArr: "\u21D3",
    deg: "\u00B0",
    Delta: "\u0394",
    delta: "\u03B4",
    diams: "\u2666",
    divide: "\u00F7",
    Eacute: "\u00C9",
    eacute: "\u00E9",
    Ecirc: "\u00CA",
    ecirc: "\u00EA",
    Egrave: "\u00C8",
    egrave: "\u00E8",
    empty: "\u2205",
    emsp: "\u2003",
    ensp: "\u2002",
    Epsilon: "\u0395",
    epsilon: "\u03B5",
    equiv: "\u2261",
    Eta: "\u0397",
    eta: "\u03B7",
    ETH: "\u00D0",
    eth: "\u00F0",
    Euml: "\u00CB",
    euml: "\u00EB",
    euro: "\u20AC",
    exist: "\u2203",
    fnof: "\u0192",
    forall: "\u2200",
    frac12: "\u00BD",
    frac14: "\u00BC",
    frac34: "\u00BE",
    frasl: "\u2044",
    Gamma: "\u0393",
    gamma: "\u03B3",
    ge: "\u2265",
    gt: ">",
    harr: "\u2194",
    hArr: "\u21D4",
    hearts: "\u2665",
    hellip: "\u2026",
    Iacute: "\u00CD",
    iacute: "\u00ED",
    Icirc: "\u00CE",
    icirc: "\u00EE",
    iexcl: "\u00A1",
    Igrave: "\u00CC",
    igrave: "\u00EC",
    image: "\u2111",
    infin: "\u221E",
    int: "\u222B",
    Iota: "\u0399",
    iota: "\u03B9",
    iquest: "\u00BF",
    isin: "\u2208",
    Iuml: "\u00CF",
    iuml: "\u00EF",
    Kappa: "\u039A",
    kappa: "\u03BA",
    Lambda: "\u039B",
    lambda: "\u03BB",
    lang: "\u27E8",
    laquo: "\u00AB",
    larr: "\u2190",
    lArr: "\u21D0",
    lceil: "\u2308",
    ldquo: "\u201C",
    le: "\u2264",
    lfloor: "\u230A",
    lowast: "\u2217",
    loz: "\u25CA",
    lrm: "\u200E",
    lsaquo: "\u2039",
    lsquo: "\u2018",
    lt: "<",
    macr: "\u00AF",
    mdash: "\u2014",
    micro: "\u00B5",
    middot: "\u00B7",
    minus: "\u2212",
    Mu: "\u039C",
    mu: "\u03BC",
    nabla: "\u2207",
    nbsp: "\u00A0",
    ndash: "\u2013",
    ne: "\u2260",
    ni: "\u220B",
    not: "\u00AC",
    notin: "\u2209",
    nsub: "\u2284",
    Ntilde: "\u00D1",
    ntilde: "\u00F1",
    Nu: "\u039D",
    nu: "\u03BD",
    Oacute: "\u00D3",
    oacute: "\u00F3",
    Ocirc: "\u00D4",
    ocirc: "\u00F4",
    OElig: "\u0152",
    oelig: "\u0153",
    Ograve: "\u00D2",
    ograve: "\u00F2",
    oline: "\u203E",
    Omega: "\u03A9",
    omega: "\u03C9",
    Omicron: "\u039F",
    omicron: "\u03BF",
    oplus: "\u2295",
    or: "\u2228",
    ordf: "\u00AA",
    ordm: "\u00BA",
    Oslash: "\u00D8",
    oslash: "\u00F8",
    Otilde: "\u00D5",
    otilde: "\u00F5",
    otimes: "\u2297",
    Ouml: "\u00D6",
    ouml: "\u00F6",
    para: "\u00B6",
    permil: "\u2030",
    perp: "\u22A5",
    Phi: "\u03A6",
    phi: "\u03C6",
    Pi: "\u03A0",
    pi: "\u03C0",
    piv: "\u03D6",
    plusmn: "\u00B1",
    pound: "\u00A3",
    prime: "\u2032",
    Prime: "\u2033",
    prod: "\u220F",
    prop: "\u221D",
    Psi: "\u03A8",
    psi: "\u03C8",
    quot: "\u0022",
    radic: "\u221A",
    rang: "\u27E9",
    raquo: "\u00BB",
    rarr: "\u2192",
    rArr: "\u21D2",
    rceil: "\u2309",
    rdquo: "\u201D",
    real: "\u211C",
    reg: "\u00AE",
    rfloor: "\u230B",
    Rho: "\u03A1",
    rho: "\u03C1",
    rlm: "\u200F",
    rsaquo: "\u203A",
    rsquo: "\u2019",
    sbquo: "\u201A",
    Scaron: "\u0160",
    scaron: "\u0161",
    sdot: "\u22C5",
    sect: "\u00A7",
    shy: "\u00AD",
    Sigma: "\u03A3",
    sigma: "\u03C3",
    sigmaf: "\u03C2",
    sim: "\u223C",
    spades: "\u2660",
    sub: "\u2282",
    sube: "\u2286",
    sum: "\u2211",
    sup: "\u2283",
    sup1: "\u00B9",
    sup2: "\u00B2",
    sup3: "\u00B3",
    supe: "\u2287",
    szlig: "\u00DF",
    Tau: "\u03A4",
    tau: "\u03C4",
    there4: "\u2234",
    Theta: "\u0398",
    theta: "\u03B8",
    thetasym: "\u03D1",
    thinsp: "\u2009",
    THORN: "\u00DE",
    thorn: "\u00FE",
    tilde: "\u02DC",
    times: "\u00D7",
    trade: "\u2122",
    Uacute: "\u00DA",
    uacute: "\u00FA",
    uarr: "\u2191",
    uArr: "\u21D1",
    Ucirc: "\u00DB",
    ucirc: "\u00FB",
    Ugrave: "\u00D9",
    ugrave: "\u00F9",
    uml: "\u00A8",
    upsih: "\u03D2",
    Upsilon: "\u03A5",
    upsilon: "\u03C5",
    Uuml: "\u00DC",
    uuml: "\u00FC",
    weierp: "\u2118",
    Xi: "\u039E",
    xi: "\u03BE",
    Yacute: "\u00DD",
    yacute: "\u00FD",
    yen: "\u00A5",
    yuml: "\u00FF",
    Yuml: "\u0178",
    Zeta: "\u0396",
    zeta: "\u03B6",
    zwj: "\u200D",
    zwnj: "\u200C"
};
// The &ngsp; pseudo-entity is denoting a space. see:
// https://github.com/dart-lang/angular/blob/0bb611387d29d65b5af7f9d2515ab571fd3fbee4/_tests/test/compiler/preserve_whitespace_test.dart
export const /** @type {?} */ NGSP_UNICODE = "\uE500";
NAMED_ENTITIES["ngsp"] = NGSP_UNICODE;

//# sourceMappingURL=data:application/json;base64,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