/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @record
 */
export function IVisitor() { }
function IVisitor_tsickle_Closure_declarations() {
    /** @type {?} */
    IVisitor.prototype.visitTag;
    /** @type {?} */
    IVisitor.prototype.visitElement;
    /** @type {?} */
    IVisitor.prototype.visitText;
    /** @type {?} */
    IVisitor.prototype.visitDeclaration;
    /** @type {?} */
    IVisitor.prototype.visitDoctype;
}
class Visitor {
    /**
     * @param {?} tag
     * @return {?}
     */
    visitTag(tag) {
        const /** @type {?} */ strAttrs = this._serializeAttributes(tag.attrs);
        if (tag.children.length === 0) {
            return `<${tag.name}${strAttrs}/>`;
        }
        const /** @type {?} */ strChildren = tag.children.map(node => node.visit(this));
        return `<${tag.name}${strAttrs}>${strChildren.join("")}</${tag.name}>`;
    }
    /**
     * @param {?} text
     * @return {?}
     */
    visitText(text) {
        return _escapeXml(text.value);
    }
    /**
     * @param {?} element
     * @return {?}
     */
    visitElement(element) {
        const /** @type {?} */ attrs = {};
        element.attrs.forEach((attr) => {
            attrs[attr.name] = attr.value;
        });
        const /** @type {?} */ tag = new Tag(element.name, attrs, /** @type {?} */ (element.children));
        return this.visitTag(tag);
    }
    /**
     * @param {?} decl
     * @return {?}
     */
    visitDeclaration(decl) {
        return `<?xml${this._serializeAttributes(decl.attrs)} ?>`;
    }
    /**
     * @param {?} attrs
     * @return {?}
     */
    _serializeAttributes(attrs) {
        const /** @type {?} */ strAttrs = Object.keys(attrs)
            .map((name) => `${name}="${_escapeXml(attrs[name])}"`)
            .join(" ");
        return strAttrs.length > 0 ? " " + strAttrs : "";
    }
    /**
     * @param {?} doctype
     * @return {?}
     */
    visitDoctype(doctype) {
        return `<!DOCTYPE ${doctype.rootTag} [\n${doctype.dtd}\n]>`;
    }
}
const /** @type {?} */ _visitor = new Visitor();
/**
 * @param {?} nodes
 * @return {?}
 */
export function serialize(nodes) {
    return nodes.map((node) => node.visit(_visitor)).join("");
}
/**
 * @record
 */
export function Node() { }
function Node_tsickle_Closure_declarations() {
    /** @type {?} */
    Node.prototype.visit;
}
export class Declaration {
    /**
     * @param {?} attrs
     */
    constructor(attrs) {
        this.attrs = attrs;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    visit(visitor) {
        return visitor.visitDeclaration(this);
    }
}
function Declaration_tsickle_Closure_declarations() {
    /** @type {?} */
    Declaration.prototype.attrs;
}
export class Doctype {
    /**
     * @param {?} rootTag
     * @param {?} dtd
     */
    constructor(rootTag, dtd) {
        this.rootTag = rootTag;
        this.dtd = dtd;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    visit(visitor) {
        return visitor.visitDoctype(this);
    }
}
function Doctype_tsickle_Closure_declarations() {
    /** @type {?} */
    Doctype.prototype.rootTag;
    /** @type {?} */
    Doctype.prototype.dtd;
}
export class Tag {
    /**
     * @param {?} name
     * @param {?=} attrs
     * @param {?=} children
     */
    constructor(name, attrs = {}, children = []) {
        this.name = name;
        this.attrs = attrs;
        this.children = children;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    visit(visitor) {
        return visitor.visitTag(this);
    }
}
function Tag_tsickle_Closure_declarations() {
    /** @type {?} */
    Tag.prototype.name;
    /** @type {?} */
    Tag.prototype.attrs;
    /** @type {?} */
    Tag.prototype.children;
}
export class Text {
    /**
     * @param {?} value
     */
    constructor(value) {
        this.value = value;
    }
    /**
     * @param {?} visitor
     * @return {?}
     */
    visit(visitor) {
        return visitor.visitText(this);
    }
}
function Text_tsickle_Closure_declarations() {
    /** @type {?} */
    Text.prototype.value;
}
export class CR extends Text {
    /**
     * @param {?=} ws
     */
    constructor(ws = 0) {
        super(`\n${new Array(ws + 1).join(" ")}`);
    }
}
const /** @type {?} */ _ESCAPED_CHARS = [
    [/&/g, "&amp;"],
    [/"/g, "&quot;"],
    [/'/g, "&apos;"],
    [/</g, "&lt;"],
    [/>/g, "&gt;"]
];
/**
 * @param {?} text
 * @return {?}
 */
function _escapeXml(text) {
    return _ESCAPED_CHARS.reduce((str, entry) => str.replace(entry[0], entry[1]), text);
}

//# sourceMappingURL=data:application/json;base64,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