/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableFormatter {
    private final Function<Integer, String> rowPrefix;
    private final boolean escapeDelimiters;

    private DataTableFormatter(Function<Integer, String> rowPrefix, boolean escapeDelimiters) {
        this.rowPrefix = rowPrefix;
        this.escapeDelimiters = escapeDelimiters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String format(DataTable table) {
        StringBuilder result = new StringBuilder();
        this.formatTo(table, result);
        return result.toString();
    }

    public void formatTo(DataTable table, StringBuilder appendable) {
        try {
            this.formatTo(table, (Appendable)appendable);
        }
        catch (IOException e) {
            throw new CucumberDataTableException(e.getMessage(), e);
        }
    }

    public void formatTo(DataTable table, Appendable appendable) throws IOException {
        Objects.requireNonNull(table, "table may not be null");
        Objects.requireNonNull(appendable, "appendable may not be null");
        if (table.isEmpty()) {
            return;
        }
        int height = table.height();
        int width = table.width();
        String[][] renderedCells = new String[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                renderedCells[i][j] = this.renderCell(table.cell(i, j));
            }
        }
        int[] longestCellInColumnLength = new int[width];
        for (String[] row : renderedCells) {
            for (int colIndex = 0; colIndex < width; ++colIndex) {
                int current = longestCellInColumnLength[colIndex];
                int candidate = row[colIndex].length();
                longestCellInColumnLength[colIndex] = Math.max(current, candidate);
            }
        }
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            this.printRowPrefix(appendable, rowIndex);
            appendable.append("| ");
            for (int colIndex = 0; colIndex < width; ++colIndex) {
                String cellText = renderedCells[rowIndex][colIndex];
                appendable.append(cellText);
                int padding = longestCellInColumnLength[colIndex] - cellText.length();
                this.padSpace(appendable, padding);
                if (colIndex < width - 1) {
                    appendable.append(" | ");
                    continue;
                }
                appendable.append(" |");
            }
            appendable.append("\n");
        }
    }

    void printRowPrefix(Appendable buffer, int rowIndex) throws IOException {
        String prefix = this.rowPrefix.apply(rowIndex);
        if (prefix != null) {
            buffer.append(prefix);
        }
    }

    private String renderCell(String cell) {
        if (cell == null) {
            return "";
        }
        if (cell.isEmpty()) {
            return "[empty]";
        }
        if (!this.escapeDelimiters) {
            return cell;
        }
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    private void padSpace(Appendable buffer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }

    public static final class Builder {
        private Function<Integer, String> rowPrefix = rowIndex -> "";
        private boolean escapeDelimiters = true;

        public Builder prefixRow(Function<Integer, String> rowPrefix) {
            Objects.requireNonNull(rowPrefix, "rowPrefix may not be null");
            this.rowPrefix = rowPrefix;
            return this;
        }

        public Builder prefixRow(String rowPrefix) {
            Objects.requireNonNull(rowPrefix, "rowPrefix may not be null");
            return this.prefixRow((Integer rowIndex) -> rowPrefix);
        }

        public Builder escapeDelimiters(boolean escapeDelimiters) {
            this.escapeDelimiters = escapeDelimiters;
            return this;
        }

        public DataTableFormatter build() {
            return new DataTableFormatter(this.rowPrefix, this.escapeDelimiters);
        }
    }
}

