/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.CargoLabel;
import net.sf.freecol.client.gui.label.Draggable;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.client.gui.label.ProductionLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.InPortPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.StringUtils;

public final class UnitLabel
extends FreeColLabel
implements ActionListener,
CargoLabel,
Draggable {
    private static final Logger logger = Logger.getLogger(UnitLabel.class.getName());
    private final FreeColClient freeColClient;
    private final Unit unit;
    private boolean selected;
    private boolean isSmall;
    private boolean ignoreLocation;
    private final Font tinyFont;

    public UnitLabel(FreeColClient freeColClient, Unit unit) {
        this(freeColClient, unit, false);
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, boolean isSmall) {
        this(freeColClient, unit, isSmall, false);
    }

    public UnitLabel(FreeColClient freeColClient, Unit unit, boolean isSmall, boolean ignoreLocation) {
        this.freeColClient = freeColClient;
        this.unit = unit;
        this.selected = false;
        this.isSmall = isSmall;
        this.ignoreLocation = ignoreLocation;
        this.tinyFont = freeColClient.getGUI().getFixedImageLibrary().getScaledFont("normal-plain-tiny", null);
        this.setHorizontalAlignment(0);
        this.updateIcon();
    }

    private GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    private ImageLibrary getImageLibrary() {
        return this.getGUI().getFixedImageLibrary();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public void setSmall(boolean isSmall) {
        ImageLibrary lib = this.getImageLibrary();
        if (isSmall) {
            this.setPreferredSize(null);
            this.setIcon(new ImageIcon(lib.getSmallUnitImage(this.unit)));
            this.setBorder(Utility.blankBorder(0, 2, 0, 0));
        } else {
            ImageIcon imageIcon = new ImageIcon(lib.getScaledUnitImage(this.unit));
            if (this.unit.getLocation() instanceof ColonyTile) {
                this.setPreferredSize(new Dimension(lib.scale((Dimension)ImageLibrary.TILE_SIZE).width, imageIcon.getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setIcon(imageIcon);
            this.setBorder(this.unit.getLocation() instanceof ColonyTile ? Utility.blankBorder(0, 15, 0, 15) : Utility.blankBorder(0, 5, 0, 5));
        }
        this.isSmall = isSmall;
    }

    public void setDescriptionLabel(String label) {
        this.setToolTipText(label);
    }

    public void updateIcon() {
        this.setDescriptionLabel(this.getUnit().getDescription(Unit.UnitLabelType.FULL));
        this.setSmall(this.isSmall);
    }

    @Override
    public boolean addCargo(Component comp, Unit carrier, CargoPanel cargoPanel) {
        Unit u = ((UnitLabel)comp).getUnit();
        if (carrier.canAdd(u)) {
            Container oldParent = comp.getParent();
            if (cargoPanel.igc().boardShip(u, carrier)) {
                ((UnitLabel)comp).setSmall(false);
                if (oldParent != null) {
                    oldParent.remove(comp);
                }
                cargoPanel.update();
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeCargo(Component comp, CargoPanel cargoPanel) {
        Unit u = ((UnitLabel)comp).getUnit();
        cargoPanel.igc().leaveShip(u);
        cargoPanel.update();
    }

    @Override
    public boolean isOnCarrier() {
        return this.unit != null && this.unit.isOnCarrier();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        InGameController igc = this.freeColClient.getInGameController();
        String[] args = ae.getActionCommand().split("/");
        switch (Enum.valueOf(UnitAction.class, StringUtils.upCase(args[0]))) {
            case ASSIGN: {
                igc.assignTeacher(this.unit, game.getFreeColGameObject(args[1], Unit.class));
                break;
            }
            case WORK_COLONYTILE: {
                GoodsType gt;
                if (args.length < 3) break;
                ColonyTile colonyTile = game.getFreeColGameObject(args[1], ColonyTile.class);
                if (args.length >= 4 && "!".equals(args[3]) && !igc.claimTile(colonyTile.getWorkTile(), this.unit.getColony())) break;
                if (colonyTile != this.unit.getLocation()) {
                    igc.work(this.unit, colonyTile);
                }
                if ((gt = spec.getGoodsType(args[2])) == null || this.unit.getWorkType() == gt) break;
                igc.changeWorkType(this.unit, gt);
                break;
            }
            case WORK_BUILDING: {
                GoodsType gt;
                if (args.length < 3) break;
                Building building = game.getFreeColGameObject(args[1], Building.class);
                if (building != this.unit.getLocation()) {
                    igc.work(this.unit, building);
                }
                if ((gt = spec.getGoodsType(args[2])) == null || this.unit.getWorkType() == gt) break;
                igc.changeWorkType(this.unit, gt);
                break;
            }
            case ACTIVATE_UNIT: {
                igc.changeState(this.unit, Unit.UnitState.ACTIVE);
                this.getGUI().changeView(this.unit, false);
                break;
            }
            case FORTIFY: {
                igc.changeState(this.unit, Unit.UnitState.FORTIFYING);
                break;
            }
            case SENTRY: {
                igc.changeState(this.unit, Unit.UnitState.SENTRY);
                break;
            }
            case COLOPEDIA: {
                this.getGUI().showColopediaPanel(this.unit.getType().getId());
                break;
            }
            case LEAVE_TOWN: {
                igc.putOutsideColony(this.unit);
                break;
            }
            case CLEAR_SPECIALITY: {
                igc.clearSpeciality(this.unit);
                break;
            }
            case CLEAR_ORDERS: {
                igc.clearOrders(this.unit);
                break;
            }
            case ASSIGN_TRADE_ROUTE: {
                this.getGUI().showTradeRoutePanel(this.unit);
                break;
            }
            case LEAVE_SHIP: {
                igc.leaveShip(this.unit);
                break;
            }
            case UNLOAD: {
                igc.unload(this.unit);
            }
        }
        this.updateIcon();
    }

    @Override
    public void paintComponent(Graphics g) {
        Player player = this.freeColClient.getMyPlayer();
        ImageLibrary lib = this.getImageLibrary();
        super.paintComponent(g);
        if (this.ignoreLocation) {
            return;
        }
        if (this.unit.getLocation() instanceof ColonyTile) {
            int production;
            GoodsType workType = this.unit.getWorkType();
            if (workType != null && (production = ((ColonyTile)this.unit.getLocation()).getTotalProductionOf(workType)) > 0) {
                ProductionLabel pl = new ProductionLabel(this.freeColClient, new AbstractGoods(workType, production));
                int visualOffsetY = -lib.scaleInt(5);
                Dimension size = this.getSize();
                Dimension plSize = pl.getPreferredSize();
                int x = (size.width - plSize.width) / 2;
                int y = (size.height - plSize.height) / 2 + visualOffsetY;
                g.translate(x, y);
                pl.paintComponent(g);
                g.translate(-x, -y);
            }
        } else if (this.getParent() instanceof ColonyPanel.OutsideColonyPanel || this.getParent() instanceof InPortPanel || this.getParent() instanceof EuropePanel.EuropeanDocksPanel || this.getParent().getParent() instanceof ReportPanel) {
            String text = Messages.message(this.unit.getOccupationLabel(player, false));
            g.drawImage(lib.getOccupationIndicatorChip((Graphics2D)g, this.unit, text), 0, 0, null);
            if (this.unit.isDamaged()) {
                String underRepair = Messages.message(this.unit.getRepairLabel());
                int idx = underRepair.indexOf(40);
                String underRepair1 = underRepair.substring(0, idx).trim();
                String underRepair2 = underRepair.substring(idx).trim();
                BufferedImage repairImage1 = lib.getStringImage(g, underRepair1, Color.RED, this.tinyFont);
                BufferedImage repairImage2 = lib.getStringImage(g, underRepair2, Color.RED, this.tinyFont);
                int textHeight = ((Image)repairImage1).getHeight(null) + ((Image)repairImage2).getHeight(null);
                int leftIndent = Math.min(5, Math.min(this.getWidth() - ((Image)repairImage1).getWidth(null), this.getWidth() - ((Image)repairImage2).getWidth(null)));
                g.drawImage(repairImage1, leftIndent, (this.getHeight() - textHeight) / 2, null);
                g.drawImage(repairImage2, leftIndent, (this.getHeight() - textHeight) / 2 + ((Image)repairImage1).getHeight(null), null);
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b) {
            ImageLibrary lib = this.getImageLibrary();
            ImageIcon disabledImageIcon = this.isSmall ? new ImageIcon(lib.getSmallUnitImage(this.unit, true)) : new ImageIcon(lib.getScaledUnitImage(this.unit, true));
            this.setDisabledIcon(disabledImageIcon);
        }
        super.setEnabled(b);
    }

    public static enum UnitAction {
        ASSIGN,
        CLEAR_SPECIALITY,
        ACTIVATE_UNIT,
        FORTIFY,
        SENTRY,
        COLOPEDIA,
        LEAVE_TOWN,
        WORK_COLONYTILE,
        WORK_BUILDING,
        CLEAR_ORDERS,
        ASSIGN_TRADE_ROUTE,
        LEAVE_SHIP,
        UNLOAD;

    }
}

