/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class StringTemplate
extends FreeColObject {
    public static final String TAG = "stringTemplate";
    private static final List<AbstractMap.SimpleEntry<String, StringTemplate>> emptyList = Collections.emptyList();
    private TemplateType templateType = TemplateType.KEY;
    private String defaultId = null;
    private List<AbstractMap.SimpleEntry<String, StringTemplate>> kv = null;
    private static final String DEFAULT_ID_TAG = "defaultId";
    private static final String PAIR_TAG = "pair";
    private static final String TEMPLATE_TYPE_TAG = "templateType";
    private static final String OLD_KEY_TAG = "key";

    public StringTemplate() {
    }

    protected StringTemplate(String id, StringTemplate template) {
        this.setId(id);
        this.templateType = template.templateType;
        this.defaultId = template.defaultId;
        this.kv = template.kv;
    }

    protected StringTemplate(String id, String defaultId, TemplateType templateType) {
        this.setId(id);
        this.defaultId = defaultId;
        this.templateType = templateType;
        this.kv = null;
    }

    public StringTemplate(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public static StringTemplate copy(String id, StringTemplate template) {
        return new StringTemplate(id, template);
    }

    public static StringTemplate name(String value) {
        return new StringTemplate(value, null, TemplateType.NAME);
    }

    public static StringTemplate key(Named named) {
        return StringTemplate.key(named.getNameKey());
    }

    public static StringTemplate key(String value) {
        return new StringTemplate(value, null, TemplateType.KEY);
    }

    public static StringTemplate template(Named named) {
        return StringTemplate.template(named.getNameKey());
    }

    public static StringTemplate template(String value) {
        return new StringTemplate(value, null, TemplateType.TEMPLATE);
    }

    public static StringTemplate label(String value) {
        return new StringTemplate(value, null, TemplateType.LABEL);
    }

    public final TemplateType getTemplateType() {
        return this.templateType;
    }

    public final String getDefaultId() {
        return this.defaultId;
    }

    public final void setDefaultId(String id) {
        this.defaultId = id;
    }

    protected <T extends StringTemplate> T setDefaultId(String id, Class<T> returnClass) {
        this.setDefaultId(id);
        try {
            return (T)((StringTemplate)returnClass.cast(this));
        }
        catch (ClassCastException cce) {
            logger.log(Level.WARNING, "Invalid class " + this.getClass() + " referenced.", cce);
            return null;
        }
    }

    public boolean isEmpty() {
        return this.kv == null || this.kv.isEmpty();
    }

    public List<AbstractMap.SimpleEntry<String, StringTemplate>> entryList() {
        return this.kv != null ? this.kv : emptyList;
    }

    public StringTemplate getReplacement(String key) {
        if (this.kv == null) {
            return null;
        }
        AbstractMap.SimpleEntry val = CollectionUtils.find(this.kv, CollectionUtils.matchKeyEquals(key, AbstractMap.SimpleEntry::getKey));
        return val == null ? null : (StringTemplate)val.getValue();
    }

    private void addPair(String key, StringTemplate value) {
        if (key == null && value == null) {
            throw new RuntimeException("Null key and pair: " + this);
        }
        if (this.kv == null) {
            this.kv = new ArrayList<AbstractMap.SimpleEntry<String, StringTemplate>>();
        }
        this.kv.add(new AbstractMap.SimpleEntry<String, StringTemplate>(key, value));
    }

    private void addKey(String key) {
        this.addPair(key, null);
    }

    private void addReplacement(StringTemplate replacement) {
        if (this.kv == null) {
            this.kv = new ArrayList<AbstractMap.SimpleEntry<String, StringTemplate>>();
        }
        for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
            if (e.getValue() != null) continue;
            e.setValue(replacement);
            return;
        }
        this.addPair(null, replacement);
    }

    private final <T extends StringTemplate> T complete(String key, StringTemplate value) {
        this.addPair(key, value);
        return (T)this;
    }

    public <T extends StringTemplate> T add(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new RuntimeException("Cannot add key-value pair to StringTemplate." + this.templateType);
        }
        return this.complete(key, StringTemplate.key(value));
    }

    public <T extends StringTemplate> T add(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new RuntimeException("Cannot add a single string to StringTemplate." + this.templateType);
        }
        return this.complete(null, StringTemplate.key(value));
    }

    public <T extends StringTemplate> T addName(String key, String value) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new RuntimeException("Cannot add key-name pair to StringTemplate." + this.templateType);
        }
        return this.complete(key, StringTemplate.name(value));
    }

    public <T extends StringTemplate> T addName(String key, FreeColObject object) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new RuntimeException("Cannot add key-object pair to StringTemplate." + this.templateType);
        }
        return this.complete(key, StringTemplate.key(Messages.nameKey(object.getId())));
    }

    public <T extends StringTemplate> T addName(String value) {
        if (this.templateType != TemplateType.LABEL) {
            throw new RuntimeException("Cannot add a single string to StringTemplate." + this.templateType);
        }
        return this.complete(null, StringTemplate.name(value));
    }

    public <T extends StringTemplate> T addNamed(String key, Named named) {
        return this.add(key, named.getNameKey());
    }

    public <T extends StringTemplate> T addNamed(Named named) {
        return this.add(named.getNameKey());
    }

    public <T extends StringTemplate> T addAmount(String key, Number amount) {
        return this.addName(key, amount.toString());
    }

    public <T extends StringTemplate> T addStringTemplate(String key, StringTemplate template) {
        if (this.templateType != TemplateType.TEMPLATE) {
            throw new RuntimeException("Cannot add key-template pair to StringTemplate." + this.templateType);
        }
        return this.complete(key, template);
    }

    public <T extends StringTemplate> T addStringTemplate(StringTemplate template) {
        if (this.templateType != TemplateType.LABEL) {
            throw new RuntimeException("Cannot add a template to StringTemplate." + this.templateType);
        }
        return this.complete(null, template);
    }

    public <T extends StringTemplate> T addTagged(String key, String value) {
        return this.add(key, value);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        StringTemplate o = this.copyInCast(other, StringTemplate.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.templateType = o.getTemplateType();
        this.defaultId = o.getDefaultId();
        this.kv = o.kv;
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TEMPLATE_TYPE_TAG, this.templateType);
        if (this.defaultId != null) {
            xw.writeAttribute(DEFAULT_ID_TAG, this.defaultId);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.kv != null) {
            for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
                xw.writeStartElement(PAIR_TAG);
                String key = e.getKey();
                if (key != null) {
                    xw.writeAttribute("value", key);
                }
                e.getValue().toXML(xw);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.templateType = xr.getAttribute(TEMPLATE_TYPE_TAG, TemplateType.class, TemplateType.TEMPLATE);
        this.defaultId = xr.getAttribute(DEFAULT_ID_TAG, null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.kv != null) {
            this.kv.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (PAIR_TAG.equals(tag)) {
            String key = xr.getAttribute("value", null);
            StringTemplate val = null;
            while (xr.moreTags()) {
                String inner = xr.getLocalName();
                if (TAG.equals(inner)) {
                    if (val == null) {
                        val = new StringTemplate(xr);
                        continue;
                    }
                    xr.expectTag(PAIR_TAG);
                    continue;
                }
                xr.expectTag(TAG);
            }
            this.addPair(key, val);
        } else if (OLD_KEY_TAG.equals(tag)) {
            this.addKey(xr.getAttribute("value", null));
            xr.closeTag(OLD_KEY_TAG);
        } else if (TAG.equals(tag)) {
            this.addReplacement(new StringTemplate(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StringTemplate) {
            StringTemplate other = (StringTemplate)o;
            if (this.templateType != other.templateType || !Utils.equals(this.defaultId, other.defaultId)) {
                return false;
            }
            if (this.kv == null != (other.kv == null)) {
                return false;
            }
            if (this.kv != null) {
                if (this.kv.size() != other.kv.size()) {
                    return false;
                }
                int i = 0;
                for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
                    if (!e.getKey().equals(other.kv.get(i).getKey())) {
                        return false;
                    }
                    if (!e.getValue().equals(other.kv.get(i).getValue())) {
                        return false;
                    }
                    ++i;
                }
            }
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.templateType.ordinal();
        hash = 31 * hash + Utils.hashCode(this.defaultId);
        if (this.kv != null) {
            for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
                hash = 31 * hash + Utils.hashCode(e.getKey());
                hash = 31 * hash + Utils.hashCode(e.getValue());
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append((Object)this.templateType).append(':').append(this.getId());
        if (this.defaultId != null) {
            sb.append('(').append(this.defaultId).append(')');
        }
        switch (this.templateType) {
            case LABEL: {
                if (this.kv == null) break;
                int index = 0;
                String start = "[";
                for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
                    sb.append(start).append(index++).append(':').append(e.getValue());
                    start = " ";
                }
                sb.append(']');
                break;
            }
            case TEMPLATE: {
                sb.append('[');
                if (this.kv != null) {
                    String start = "";
                    for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.kv) {
                        sb.append(start).append(e.getKey()).append('=').append(e.getValue());
                        start = "";
                    }
                }
                sb.append(']');
                break;
            }
        }
        return sb.toString();
    }

    public static enum TemplateType {
        NAME,
        KEY,
        TEMPLATE,
        LABEL;

    }
}

