/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.Wish;

public final class GoodsWish
extends Wish {
    private static final Logger logger = Logger.getLogger(GoodsWish.class.getName());
    public static final String TAG = "goodsWish";
    private GoodsType goodsType;
    private int amountRequested;
    private static final String AMOUNT_REQUESTED_TAG = "amountRequested";
    private static final String GOODS_TYPE_TAG = "goodsType";
    private static final String TRANSPORTABLE_TAG = "transportable";

    public GoodsWish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.goodsType = null;
        this.amountRequested = -1;
        this.initialized = false;
    }

    public GoodsWish(AIMain aiMain, Location destination, int value, int amountRequested, GoodsType goodsType) {
        this(aiMain, "goodsWish:" + aiMain.getNextId());
        if (destination == null) {
            throw new NullPointerException("destination == null: " + this);
        }
        this.destination = destination;
        this.setValue(value);
        this.goodsType = goodsType;
        this.amountRequested = amountRequested;
        this.setInitialized();
    }

    public GoodsWish(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.setInitialized();
    }

    @Override
    public void setInitialized() {
        this.initialized = this.getGoodsType() != null && this.getGoodsAmount() > 0;
    }

    public void update(GoodsType goodsType, int amount, int value) {
        this.goodsType = goodsType;
        this.amountRequested = amount;
        this.setValue(value);
        if (this.transportable != null) {
            this.transportable.incrementTransportPriority();
        }
    }

    @Override
    public boolean shouldBeStored() {
        return true;
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public int getGoodsAmount() {
        return this.amountRequested;
    }

    public void setGoodsAmount(int amount) {
        this.amountRequested = amount;
    }

    @Override
    public boolean satisfiedBy(Unit unit) {
        return false;
    }

    @Override
    public <T extends AbstractGoods> boolean satisfiedBy(T goods) {
        return goods.getType() == this.goodsType && goods.getAmount() >= this.amountRequested;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.goodsType == null) {
            lb.add("\n  GoodsWish without type: ", this.getId());
            result = result.fail();
        } else if (this.amountRequested <= 0) {
            lb.add("\n  GoodsWish with non-positive requested: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(GOODS_TYPE_TAG, this.goodsType);
        xw.writeAttribute(AMOUNT_REQUESTED_TAG, this.amountRequested);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Specification spec = this.getSpecification();
        this.transportable = xr.hasAttribute(TRANSPORTABLE_TAG) ? (TransportableAIObject)xr.makeAIObject(aiMain, TRANSPORTABLE_TAG, AIGoods.class, null, true) : null;
        this.goodsType = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
        this.amountRequested = xr.getAttribute(AMOUNT_REQUESTED_TAG, 100);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GoodsWish)) {
            return false;
        }
        GoodsWish other = (GoodsWish)o;
        return this.amountRequested == other.amountRequested && Utils.equals(this.goodsType, other.goodsType) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.goodsType);
        return 37 * hash + this.amountRequested;
    }

    @Override
    public String toString() {
        LogBuilder lb = new LogBuilder(32);
        lb.add("[", this.getId(), " ", this.amountRequested, " ", this.goodsType == null ? "null" : this.goodsType.getSuffix(), " -> ", this.destination, " (", this.getValue(), ")]");
        return lb.toString();
    }
}

