/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComboBox;
import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.ImagePreview;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.SizeSelectorPanel;
import com.lightdev.app.shtm.Util;
import com.sun.demo.ExampleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

class ImageDialog
extends DialogShell
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private final KeyHandler keyHandler = new KeyHandler();
    private final FocusHandler focusHandler = new FocusHandler();
    private final SimpleAttributeSet originalAttributes = new SimpleAttributeSet();
    private boolean ignoreChangeEvents = false;
    private JList imgFileList;
    private JButton addImgBtn;
    private JButton delImgBtn;
    private JTextField scale;
    private SizeSelectorPanel imgWidth;
    private SizeSelectorPanel imgHeight;
    private JLabel oWidth;
    private JLabel oHeight;
    private ImagePreview preview;
    private JScrollPane scPrev;
    private final Vector attributeComponents = new Vector();
    private static final String helpTopicId = "item166";
    private final SHTMLDocument doc;

    public ImageDialog(Window parent, String title, SHTMLDocument sourceDoc) {
        super(parent, title, helpTopicId);
        this.doc = sourceDoc;
        this.initDialog(title);
    }

    private void initDialog(String title) {
        JPanel dirPanel = new JPanel(new BorderLayout());
        dirPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("imgDirPanelTitle")));
        this.imgFileList = new JList();
        Dimension dim = new Dimension(100, 100);
        this.imgFileList.setMinimumSize(dim);
        this.imgFileList.setPreferredSize(dim);
        this.imgFileList.addListSelectionListener(this);
        this.updateFileList();
        JPanel dirBtnPanel = new JPanel();
        this.addImgBtn = new JButton(Util.getResourceString("addImgBtnTitle"));
        this.addImgBtn.addActionListener(this);
        this.delImgBtn = new JButton(Util.getResourceString("delImgBtnTitle"));
        this.delImgBtn.addActionListener(this);
        dirBtnPanel.add(this.addImgBtn);
        dirBtnPanel.add(this.delImgBtn);
        dirPanel.add((Component)this.imgFileList, "Center");
        dirPanel.add((Component)dirBtnPanel, "South");
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("imgPreviewPanelTitle")));
        this.preview = new ImagePreview();
        dim = new Dimension(250, 250);
        this.preview.setMinimumSize(dim);
        this.preview.setPreferredSize(dim);
        this.scPrev = new JScrollPane(this.preview);
        previewPanel.add((Component)this.scPrev, "Center");
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel eastPanel = new JPanel(new BorderLayout());
        JPanel propertiesPanel = new JPanel(g);
        eastPanel.add((Component)propertiesPanel, "North");
        eastPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("imgPropertiesPanelTitle")));
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgScaleLabel")), g, c, 0, 0, 13);
        this.scale = new JTextField();
        this.scale.addKeyListener(this.keyHandler);
        this.scale.addFocusListener(this.focusHandler);
        dim = new Dimension(50, 20);
        this.scale.setMinimumSize(dim);
        this.scale.setPreferredSize(dim);
        JPanel helperPanel = new JPanel();
        helperPanel.add(this.scale);
        helperPanel.add(new JLabel("%", 2));
        Util.addGridBagComponent(propertiesPanel, helperPanel, g, c, 1, 0, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgWidthLabel")), g, c, 0, 1, 13);
        this.imgWidth = new SizeSelectorPanel(HTML.Attribute.WIDTH, null, false, 1);
        this.attributeComponents.addElement(this.imgWidth);
        this.imgWidth.getValueSelector().addChangeListener(this);
        Util.addGridBagComponent(propertiesPanel, this.imgWidth, g, c, 1, 1, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgHeightLabel")), g, c, 0, 2, 13);
        this.imgHeight = new SizeSelectorPanel(HTML.Attribute.HEIGHT, null, false, 1);
        this.attributeComponents.addElement(this.imgHeight);
        this.imgHeight.getValueSelector().addChangeListener(this);
        Util.addGridBagComponent(propertiesPanel, this.imgHeight, g, c, 1, 2, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgHSpaceLabel")), g, c, 0, 3, 13);
        SizeSelectorPanel hSpace = new SizeSelectorPanel(HTML.Attribute.HSPACE, null, false, 1);
        this.attributeComponents.addElement(hSpace);
        Util.addGridBagComponent(propertiesPanel, hSpace, g, c, 1, 3, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgVSpaceLabel")), g, c, 0, 4, 13);
        SizeSelectorPanel vSpace = new SizeSelectorPanel(HTML.Attribute.VSPACE, null, false, 1);
        this.attributeComponents.addElement(vSpace);
        Util.addGridBagComponent(propertiesPanel, vSpace, g, c, 1, 4, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgAlignLabel")), g, c, 0, 5, 13);
        String[] items = new String[]{Util.getResourceString("imgAlignTop"), Util.getResourceString("imgAlignMiddle"), Util.getResourceString("imgAlignBottom"), Util.getResourceString("imgAlignLeft"), Util.getResourceString("imgAlignCenter"), Util.getResourceString("imgAlignRight")};
        String[] names = new String[]{"top", "middle", "bottom", "left", "center", "right"};
        AttributeComboBox imgAlign = new AttributeComboBox(items, names, HTML.Attribute.ALIGN);
        this.attributeComponents.addElement(imgAlign);
        Util.addGridBagComponent(propertiesPanel, imgAlign, g, c, 1, 5, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("oWidthLabel")), g, c, 0, 6, 13);
        this.oWidth = new JLabel("");
        Util.addGridBagComponent(propertiesPanel, this.oWidth, g, c, 1, 6, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("oHeightLabel")), g, c, 0, 7, 13);
        this.oHeight = new JLabel("");
        Util.addGridBagComponent(propertiesPanel, this.oHeight, g, c, 1, 7, 17);
        Util.addGridBagComponent(propertiesPanel, new JLabel(Util.getResourceString("imgBorderLabel")), g, c, 0, 8, 13);
        SizeSelectorPanel imgBorder = new SizeSelectorPanel(HTML.Attribute.BORDER, null, false, 1);
        this.attributeComponents.addElement(imgBorder);
        Util.addGridBagComponent(propertiesPanel, imgBorder, g, c, 1, 8, 17);
        Container contentPane = super.getContentPane();
        contentPane.add((Component)dirPanel, "West");
        contentPane.add((Component)previewPanel, "Center");
        contentPane.add((Component)eastPanel, "East");
        this.pack();
        this.scPrev.addComponentListener(new ResizeListener());
    }

    public Integer getImgWidth() {
        return this.imgWidth.getIntValue();
    }

    public Integer getImgHeight() {
        return this.imgHeight.getIntValue();
    }

    public void setImageAttributes(AttributeSet a) {
        this.ignoreChangeEvents = true;
        this.originalAttributes.addAttributes(a);
        if (a.isDefined(HTML.Attribute.SRC)) {
            File imgFile = new File(Util.resolveRelativePath(this.doc.getBase(), a.getAttribute(HTML.Attribute.SRC).toString()).getPath());
            this.imgFileList.setSelectedValue(imgFile.getName().toLowerCase(), true);
        }
        for (int i = 0; i < this.attributeComponents.size(); ++i) {
            ((AttributeComponent)this.attributeComponents.get(i)).setValue(a);
        }
        if (a.isDefined(HTML.Attribute.WIDTH)) {
            this.preview.setPreviewWidth(Integer.parseInt(a.getAttribute(HTML.Attribute.WIDTH).toString()));
        }
        if (a.isDefined(HTML.Attribute.HEIGHT)) {
            this.preview.setPreviewHeight(Integer.parseInt(a.getAttribute(HTML.Attribute.HEIGHT).toString()));
        }
        int scalePct = this.preview.getScale();
        this.scale.setText(Integer.toString(scalePct));
        this.ignoreChangeEvents = false;
    }

    public void setImage(String fName, String w, String h) {
        this.imgFileList.setSelectedValue(new File(fName).getName(), true);
        this.preview.setImage(new ImageIcon(fName));
        try {
            if (w != null && !w.isEmpty()) {
                this.preview.setPreviewWidth(Integer.parseInt(w));
            }
            if (h != null && !h.isEmpty()) {
                this.preview.setPreviewHeight(Integer.parseInt(h));
            }
        }
        catch (Exception e) {
            Util.errMsg(this, null, e);
        }
    }

    public String getImageHTML() {
        SimpleAttributeSet set = new SimpleAttributeSet(this.originalAttributes);
        StringWriter sw = new StringWriter();
        SHTMLWriter w = new SHTMLWriter((Writer)sw, this.doc);
        for (int i = 0; i < this.attributeComponents.size(); ++i) {
            set.addAttributes(((AttributeComponent)this.attributeComponents.get(i)).getValue());
        }
        set.addAttribute(HTML.Attribute.SRC, this.getImageSrc());
        try {
            w.writeStartTag(HTML.Tag.IMG.toString(), set);
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
        return sw.getBuffer().toString();
    }

    public String getImageSrc() {
        StringBuilder buf = new StringBuilder();
        Object value = this.imgFileList.getSelectedValue();
        if (value != null) {
            buf.append(this.doc.getImageDirectoryName());
            buf.append("/");
            buf.append(value);
        }
        return buf.toString();
    }

    private void handleAddImage() {
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("gif");
            filter.addExtension("jpg");
            filter.addExtension("jpeg");
            filter.setDescription(Util.getResourceString("imageFileDesc"));
            chooser.setFileFilter(filter);
            if (chooser.showOpenDialog(this) == 0) {
                File[] sFiles = chooser.getSelectedFiles();
                File imgDir = this.doc.getImageDirectory();
                if (!imgDir.exists()) {
                    imgDir.mkdirs();
                }
                String imgDirName = imgDir.getAbsolutePath();
                for (int i = 0; i < sFiles.length; ++i) {
                    Util.copyFile(sFiles[i], new File(imgDirName + File.separator + sFiles[i].getName()));
                    this.updateFileList();
                }
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
    }

    private void handleDeleteImage() {
        String fName = this.imgFileList.getSelectedValue().toString();
        if (Util.msg(0, "confirmDelete", "deleteFileQuery", fName, "\r\n")) {
            File imgDir = this.doc.getImageDirectory();
            File delFile = new File(imgDir.getAbsolutePath() + File.separator + fName);
            delFile.delete();
            this.updateFileList();
        }
    }

    private void updateFileList() {
        String[] files;
        File imgDir = this.doc.getImageDirectory();
        if (this.imgFileList != null && (files = imgDir.list()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                files[i] = files[i].toLowerCase();
            }
            this.imgFileList.setListData(files);
        }
    }

    private void updateControls() {
        this.ignoreChangeEvents = true;
        int scalePct = this.preview.getScale();
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.oWidth.setText(Integer.toString(this.preview.getOriginalWidth()));
        this.oHeight.setText(Integer.toString(this.preview.getOriginalHeight()));
        set.addAttribute(HTML.Attribute.WIDTH, this.preview.getOriginalWidth() * scalePct / 100 + "pt");
        set.addAttribute(HTML.Attribute.HEIGHT, this.preview.getOriginalHeight() * scalePct / 100 + "pt");
        this.imgWidth.setValue(set);
        this.imgHeight.setValue(set);
        this.scale.setText(Integer.toString(scalePct));
        this.ignoreChangeEvents = false;
    }

    private void applyPreviewScale() {
        this.ignoreChangeEvents = true;
        try {
            this.preview.setScale(Integer.parseInt(this.scale.getText()));
            this.updateControls();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ignoreChangeEvents = false;
    }

    private void applyPreviewWidth() {
        this.ignoreChangeEvents = true;
        this.preview.setPreviewWidth(this.imgWidth.getIntValue());
        int scalePct = this.preview.getScale();
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.scale.setText(Integer.toString(scalePct));
        set.addAttribute(HTML.Attribute.HEIGHT, this.preview.getOriginalHeight() * scalePct / 100 + "pt");
        this.imgHeight.setValue(set);
        this.ignoreChangeEvents = false;
    }

    private void applyPreviewHeight() {
        this.ignoreChangeEvents = true;
        this.preview.setPreviewHeight(this.imgHeight.getIntValue());
        int scalePct = this.preview.getScale();
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.scale.setText(Integer.toString(scalePct));
        set.addAttribute(HTML.Attribute.WIDTH, this.preview.getOriginalWidth() * scalePct / 100 + "pt");
        this.imgWidth.setValue(set);
        this.ignoreChangeEvents = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addImgBtn) {
            this.handleAddImage();
        } else if (src == this.delImgBtn) {
            this.handleDeleteImage();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.imgFileList.isSelectionEmpty()) {
            File imgDir = this.doc.getImageDirectory();
            this.preview.setImage(new ImageIcon(imgDir.getAbsolutePath() + File.separator + this.imgFileList.getSelectedValue().toString()));
            this.updateControls();
        } else {
            this.preview.setImage(null);
            int vWidth = this.scPrev.getWidth() - 5;
            int vHeight = this.scPrev.getHeight() - 5;
            this.preview.setPreferredSize(new Dimension(vWidth, vHeight));
            this.preview.revalidate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.ignoreChangeEvents) {
            Object source = e.getSource();
            if (source.equals(this.imgWidth.getValueSelector())) {
                this.applyPreviewWidth();
            } else if (source.equals(this.imgHeight.getValueSelector())) {
                this.applyPreviewHeight();
            }
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source.equals(ImageDialog.this.scale)) {
                ImageDialog.this.applyPreviewScale();
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Object source = e.getSource();
            int keyCode = e.getKeyCode();
            if (source.equals(ImageDialog.this.scale) && keyCode == 10) {
                ImageDialog.this.applyPreviewScale();
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int vWidth = ImageDialog.this.scPrev.getWidth() - 5;
            int vHeight = ImageDialog.this.scPrev.getHeight() - 5;
            ImageDialog.this.preview.setPreferredSize(new Dimension(vWidth, vHeight));
            ImageDialog.this.preview.revalidate();
            ImageDialog.this.updateControls();
        }
    }
}

