/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.format.FormattedFormula;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;
import org.freeplane.plugin.formula.FormulaEditor;
import org.freeplane.plugin.script.FormulaUtils;

class FormulaTextTransformer
extends AbstractContentTransformer
implements IEditBaseCreator {
    FormulaTextTransformer(int priority) {
        super(priority);
    }

    public Object transformContent(NodeModel node, Object nodeProperty, Object obj, TextController textController, IContentTransformer.Mode mode) {
        if (obj instanceof FormattedFormula) {
            FormattedFormula formattedFormula = (FormattedFormula)obj;
            Object evaluationResult = this.transformContent(node, nodeProperty, formattedFormula.getObject(), textController, mode);
            return new FormattedObject(evaluationResult, formattedFormula.getPattern());
        }
        String text = this.getViewedText(node, nodeProperty, obj, textController);
        if (text == null || !FormulaUtils.containsFormula((String)text)) {
            return obj;
        }
        String plainText = HtmlUtils.htmlToPlain((String)text);
        Object result = textController.withNodeNumbering(true, () -> FormulaUtils.evalIfScript((NodeModel)node, (String)plainText));
        return result;
    }

    public boolean isFormula(Object obj) {
        if (obj instanceof FormattedFormula) {
            FormattedFormula formattedFormula = (FormattedFormula)obj;
            return this.isFormula(formattedFormula.getObject());
        }
        if (!(obj instanceof String)) {
            return false;
        }
        String text = obj.toString();
        return FormulaUtils.containsFormula((String)text);
    }

    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        JEditorPane textEditor = this.createTextEditorPane(this::createScrollPane, node, nodeProperty, content, !editLong);
        return textEditor == null ? null : this.createEditor(node, editControl, textEditor);
    }

    private JRestrictedSizeScrollPane createScrollPane() {
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(new Dimension(0, 60));
        return scrollPane;
    }

    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        String text = this.getEditedText(node, nodeProperty, content, MTextController.getController());
        if (text == null) {
            return null;
        }
        JEditorPane textEditor = new JEditorPane();
        scrollPaneSupplier.get().setViewportView(textEditor);
        textEditor.setContentType("text/groovy");
        textEditor.setText(text);
        SourceTextEditorUIConfigurator.configureColors((JTextComponent)textEditor);
        String fontName = ResourceController.getResourceController().getProperty("groovy_editor_font");
        int fontSize = ResourceController.getResourceController().getIntProperty("groovy_editor_font_size");
        Font font = UITools.scaleUI((Font)new Font(fontName, 0, fontSize));
        textEditor.setFont(font);
        return textEditor;
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, JEditorPane textEditor) {
        MapExplorerController explorer = (MapExplorerController)Controller.getCurrentModeController().getExtension(MapExplorerController.class);
        KeyEvent firstKeyEvent = MTextController.getController().getEventQueue().getFirstEvent();
        FormulaEditor editNodeDialog = new FormulaEditor(explorer, node, firstKeyEvent, editControl, false, textEditor);
        editNodeDialog.setTitle(TextUtils.getText((String)"formula_editor"));
        return editNodeDialog;
    }

    private String getEditedText(NodeModel node, Object nodeProperty, Object content, MTextController textController) {
        KeyEvent firstKeyEvent;
        if ((nodeProperty instanceof NodeModel || nodeProperty instanceof NodeAttributeTableModel) && !textController.isTextFormattingDisabled(node) && (firstKeyEvent = textController.getEventQueue().getFirstEvent()) != null && firstKeyEvent.getKeyChar() == '=') {
            return "=";
        }
        return this.getViewedText(node, nodeProperty, content, (TextController)textController);
    }

    private String getViewedText(NodeModel node, Object nodeProperty, Object content, TextController textController) {
        if (!(content instanceof String)) {
            return null;
        }
        MNoteController noteController = MNoteController.getController();
        if (nodeProperty instanceof NodeModel && textController.isTextFormattingDisabled(node) || nodeProperty instanceof DetailModel && "html".equals(textController.getDetailsContentType(node)) || nodeProperty instanceof NoteModel && "html".equals(noteController.getNoteContentType(node))) {
            return null;
        }
        String plainOrHtmlText = (String)content;
        String text = HtmlUtils.htmlToPlain((String)plainOrHtmlText);
        if (!FormulaUtils.containsFormula((String)text)) {
            return null;
        }
        return text;
    }

    public boolean markTransformation() {
        return true;
    }
}

